/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.extension;

import java.util.Collection;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.ide.extension.ElementContext;
import javax.ide.extension.ElementEndContext;
import javax.ide.extension.ElementStartContext;
import javax.ide.extension.ExtensionHook;
import javax.ide.extension.spi.ExtensionLogRecord;
import oracle.ide.extension.HashStructureElementVisitor;
import oracle.ide.extension.HashStructureHookEvent;
import oracle.ide.extension.HashStructureHookListener;
import oracle.ide.util.NameValuePair;
import oracle.javatools.data.HashStructure;

public class HashStructureHook
extends ExtensionHook {
    private HashStructureElementVisitor _combinedVisitor = new HashStructureElementVisitor();
    private Object _combinedVisitorLock = new Object();
    private CopyOnWriteArraySet<HashStructureHookListener> _listeners = new CopyOnWriteArraySet();
    private String _NEW_ELEMENT_VISITOR_KEY = "newElementVisitor";
    private String _HASH_STRUCTURE_HOOK_START_EXECUTED_KEY = "hashStructureHookStartExecuted";
    private static Logger _sLogger = Logger.getLogger("oracle.ide.extension.hash");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public final HashStructure getHashStructure() {
        Object object = this._combinedVisitorLock;
        synchronized (object) {
            return this._combinedVisitor.getHashStructure();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(ElementStartContext context) {
        HashStructureElementVisitor newElementVisitor = new HashStructureElementVisitor();
        Object object = this._combinedVisitorLock;
        synchronized (object) {
            if (this._combinedVisitor.isElementCounterOn()) {
                newElementVisitor.turnElementCounterOn();
                newElementVisitor.setElementCount(this._combinedVisitor.getElementCount());
            }
        }
        context.getScopeData().put(this._NEW_ELEMENT_VISITOR_KEY, newElementVisitor);
        newElementVisitor.start(context);
        context.getScopeData().put(this._HASH_STRUCTURE_HOOK_START_EXECUTED_KEY, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void end(ElementEndContext context) {
        Boolean startExecuted = (Boolean)context.getScopeData().get(this._HASH_STRUCTURE_HOOK_START_EXECUTED_KEY);
        if (startExecuted != null && startExecuted.booleanValue()) {
            HashStructureElementVisitor newElementVisitor = (HashStructureElementVisitor)((Object)context.getScopeData().get(this._NEW_ELEMENT_VISITOR_KEY));
            newElementVisitor.end(context);
            newElementVisitor.cleanup();
            Object object = this._combinedVisitorLock;
            synchronized (object) {
                if (this._combinedVisitor != null) {
                    this._combinedVisitor.merge(newElementVisitor);
                    if (newElementVisitor.isElementCounterOn()) {
                        this._combinedVisitor.setElementCount(newElementVisitor.getElementCount());
                    }
                    if (!this._listeners.isEmpty()) {
                        HashStructureHookEvent event = new HashStructureHookEvent(this, this._combinedVisitor.getHashStructure(), newElementVisitor.getHashStructure().asReadOnly(), this.getExtension((ElementContext)context));
                        this._fireElementVisitedEvent(event);
                    }
                }
            }
        } else {
            ExtensionLogRecord message = new ExtensionLogRecord((ElementContext)context, Level.WARNING, "HashStructureHook.end called without calling HashStructureHook.start().  Most likely cause is a misbehaving subclass: " + this);
            context.getLogger().log((LogRecord)message);
        }
    }

    public static final String getExtensionId(HashStructure context) {
        return context.getString("#__extension-id");
    }

    public static final String getText(HashStructure context) {
        return context.getString("#text");
    }

    @Deprecated
    public void dispose() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<NameValuePair<HashStructure>> getOrderedElements(HashStructure hash) {
        Object object = this._combinedVisitorLock;
        synchronized (object) {
            if (this._combinedVisitor == null) {
                throw new IllegalStateException("getOrderedElements() was called on a dispose()d HashStructureHook!");
            }
            return this._combinedVisitor.getOrderedElements(hash);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHashStructureHookListener(HashStructureHookListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("addHashStructureHookListener called with null argument");
        }
        Object object = this._combinedVisitorLock;
        synchronized (object) {
            boolean isNewListener = this._listeners.add(listener);
            if (isNewListener) {
                HashStructureHookEvent event = new HashStructureHookEvent(this, this._combinedVisitor.getHashStructure());
                this._fireListenerAttachedEvent(event, listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeHashStructureHookListener(HashStructureHookListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("removeHashStructureHookListener called with null argument");
        }
        Object object = this._combinedVisitorLock;
        synchronized (object) {
            this._listeners.remove(listener);
        }
    }

    protected HashStructureHook(boolean countElementOrder) {
        if (countElementOrder) {
            this._combinedVisitor.turnElementCounterOn();
        }
    }

    public HashStructureHook() {
    }

    public int getListenersCount() {
        return this._listeners.size();
    }

    private void _fireElementVisitedEvent(HashStructureHookEvent event) {
        for (HashStructureHookListener listener : this._listeners) {
            try {
                listener.elementVisited(event);
            }
            catch (RuntimeException e) {
                _sLogger.log(Level.SEVERE, "Unexpected runtime exception while delivering HashStructureHookEvent", e);
            }
        }
    }

    private void _fireListenerAttachedEvent(HashStructureHookEvent event, HashStructureHookListener listener) {
        try {
            listener.listenerAttached(event);
        }
        catch (RuntimeException e) {
            _sLogger.log(Level.SEVERE, "Unexpected runtime exception while delivering HashStructureHookEvent", e);
        }
    }
}

