/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.docking;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import oracle.ide.docking.DockStation;
import oracle.ide.docking.DockableWindow;
import oracle.ide.docking.Drawer;
import oracle.ide.docking.DrawerConfig;
import oracle.ide.docking.DrawerDecorator;
import oracle.ide.docking.DrawerUI;
import oracle.ide.docking.DrawerWindow;
import oracle.ide.view.View;
import oracle.ideimpl.docking.DockStationImpl;
import oracle.ideimpl.docking.ProxyDockable;

final class DrawerWindowModel {
    private final DrawerWindow drawerWindow;
    private final List<Drawer> drawers = new ArrayList<Drawer>();
    private final Map<Float, List<Drawer>> drawersByWeight = new HashMap<Float, List<Drawer>>();
    private final List<ListDataListener> listeners = new CopyOnWriteArrayList<ListDataListener>();

    DrawerWindowModel(DrawerWindow drawerWindow) {
        this.drawerWindow = drawerWindow;
    }

    Drawer addDrawer(View view, DrawerConfig config) {
        if (view instanceof ProxyDockable) {
            ProxyDockable proxy = (ProxyDockable)view;
            proxy.markAsDrawer(this.drawerWindow);
            if (proxy.isExtensionFullyLoaded()) {
                view = (View)((Object)DockStationImpl.getInstance().swapDockable((ProxyDockable)view));
            }
        }
        config.uniqueName(view.getId());
        DrawerDecorator decorator = DrawerDecorator.decorate(view, config, this.drawerWindow);
        Drawer drawer = new Drawer(decorator, config, this.drawerWindow);
        return this.add(drawer, config, decorator);
    }

    Drawer addDrawerThatCanHideHandle(DockableWindow view) {
        Drawer added = this.addDrawer(view);
        added.canHideHandle();
        return added;
    }

    Drawer addCloseableDrawer(DockableWindow view, int index) {
        Drawer drawer = this.addDrawer(view, index);
        drawer.beClosable();
        return drawer;
    }

    Drawer addDrawer(DockableWindow view) {
        return this.addDrawer(view, 0.0f);
    }

    Drawer addDrawer(DockableWindow view, float weight) {
        DrawerConfig config = new DrawerConfig(view, weight);
        Drawer drawer = new Drawer(view, config, this.drawerWindow);
        return this.add(drawer, config, view);
    }

    @Deprecated
    Drawer addDrawer(DockableWindow view, int index) {
        return this.addDrawer(view, (float)index);
    }

    private Drawer add(Drawer drawer, DrawerConfig config, DockableWindow view) {
        float weight = config.weight();
        List<Drawer> drawersForWeight = this.drawersByWeight.get(Float.valueOf(weight));
        Drawer removed = this.removeDrawerIfPresent(drawer.viewWithoutDecoration());
        if (removed != null) {
            this.drawerWindow.updateViewInHostedDrawerWindow(removed.viewWithoutDecoration(), drawer.viewWithoutDecoration());
        }
        if (drawersForWeight == null) {
            drawersForWeight = new ArrayList<Drawer>();
            this.drawersByWeight.put(Float.valueOf(weight), drawersForWeight);
        }
        drawersForWeight.add(drawer);
        this.updateDrawerList();
        DockStation.getDockStation().addToCache(view);
        int index = this.drawers.indexOf(drawer);
        this.fire(new ListDataEvent(this, 1, index, index));
        return drawer;
    }

    private void updateDrawerList() {
        this.drawers.clear();
        ArrayList<Float> allWeights = new ArrayList<Float>(this.drawersByWeight.keySet());
        Collections.sort(allWeights);
        Iterator iterator = allWeights.iterator();
        while (iterator.hasNext()) {
            float weight = ((Float)iterator.next()).floatValue();
            this.drawers.addAll((Collection<Drawer>)this.drawersByWeight.get(Float.valueOf(weight)));
        }
    }

    List<Drawer> drawers() {
        return new ArrayList<Drawer>(this.drawers);
    }

    void addListener(ListDataListener l) {
        this.listeners.add(l);
    }

    void removeListener(ListDataListener l) {
        this.listeners.remove(l);
    }

    int drawerCount() {
        return this.drawers.size();
    }

    boolean hasDrawers() {
        return !this.drawers.isEmpty();
    }

    Drawer drawerAt(int index) {
        return this.drawers.get(index);
    }

    int indexOf(DrawerUI drawerUI) {
        for (int i = 0; i < this.drawers.size(); ++i) {
            if (!drawerUI.equals(this.drawers.get(i).drawerUI())) continue;
            return i;
        }
        return -1;
    }

    public List<View> views() {
        ArrayList<View> views = new ArrayList<View>(this.drawerCount());
        for (Drawer drawer : this.drawers) {
            views.add(drawer.viewWithoutDecoration());
        }
        return views;
    }

    int indexOf(View view) {
        for (int i = 0; i < this.drawers.size(); ++i) {
            if (!this.drawers.get(i).hasView(view)) continue;
            return i;
        }
        return -1;
    }

    Drawer removeDrawerIfPresent(View view) {
        int index = this.indexOf(view);
        if (index >= 0) {
            return this.removeDrawer(index);
        }
        for (Drawer drawer : this.drawers) {
            if (!drawer.viewWithoutDecoration().getId().equals(view.getId()) || view instanceof DrawerWindow.ProxyDrawer && !(drawer.viewWithoutDecoration() instanceof DrawerWindow.ProxyDrawer) || (index = this.indexOf(drawer.view())) < 0) continue;
            return this.removeDrawer(index);
        }
        return null;
    }

    Drawer removeDrawer(View view) {
        return this.removeDrawer(this.indexOf(view));
    }

    private Drawer removeDrawer(int index) {
        ListDataEvent event = new ListDataEvent(this, 2, index, index);
        this.fire(event);
        Drawer toRemove = this.drawers.get(index);
        Drawer removed = this.remove(toRemove);
        if (removed != null) {
            DockStation.getDockStation().removeFromCache(removed.uniqueName());
        }
        return removed;
    }

    private Drawer remove(Drawer drawer) {
        for (List<Drawer> drawers : this.drawersByWeight.values()) {
            if (!drawers.remove(drawer)) continue;
            this.updateDrawerList();
            return drawer;
        }
        return null;
    }

    private void fire(ListDataEvent e) {
        for (ListDataListener l : this.listeners) {
            if (!this.contentsChangedEventFired(e, l) && !this.intervalAddedEventFired(e, l) && !this.intervalRemovedEventFired(e, l)) continue;
        }
    }

    private boolean contentsChangedEventFired(ListDataEvent e, ListDataListener l) {
        if (e.getType() != 0) {
            return false;
        }
        l.contentsChanged(e);
        return true;
    }

    private boolean intervalAddedEventFired(ListDataEvent e, ListDataListener l) {
        if (e.getType() != 1) {
            return false;
        }
        l.intervalAdded(e);
        return true;
    }

    private boolean intervalRemovedEventFired(ListDataEvent e, ListDataListener l) {
        if (e.getType() != 2) {
            return false;
        }
        l.intervalRemoved(e);
        return true;
    }

    void move(Drawer drawer, int newIndex) {
        int oldIndex = this.drawers.indexOf(drawer);
        this.drawers.remove(oldIndex);
        if (oldIndex < newIndex) {
            --newIndex;
        }
        this.drawers.add(newIndex, drawer);
    }

    boolean drawerExists(String viewId) {
        for (Drawer drawer : this.drawers) {
            if (!drawer.viewWithoutDecoration().getId().equals(viewId)) continue;
            return true;
        }
        return false;
    }

    int findIndexForView(View view) {
        for (int i = 0; i < this.drawers.size(); ++i) {
            if (this.drawers.get(i).view() == null || !this.drawers.get(i).view().getId().equals(view.getId()) && !this.drawers.get(i).viewWithoutDecoration().getId().equals(view.getId())) continue;
            return i;
        }
        return -1;
    }

    String printDrawersModelInfo() {
        StringBuffer info = new StringBuffer();
        info.append(">> Drawers Info << \n");
        int i = 0;
        for (Drawer drawer : this.drawers) {
            info.append("> Drawer index: " + i + ", drawer unique name: " + drawer.uniqueName() + "\n");
            ++i;
        }
        return info.toString();
    }
}

