/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.docking;

import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.SwingUtilities;

abstract class DrawerFocusListener
implements PropertyChangeListener {
    private static final String PERMANENT_FOCUS_OWNER = "permanentFocusOwner";
    private boolean hasFocus;
    private Component hostComponent;
    private KeyboardFocusManager focusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();

    public DrawerFocusListener(Component hostComponent) {
        this.hostComponent = hostComponent;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        boolean hasFocus = this.isChildHasFocus();
        if (this.hasFocus != hasFocus) {
            if (hasFocus) {
                this.focusGained();
            } else {
                this.focusLost();
            }
            this.hasFocus = hasFocus;
        }
    }

    private boolean isChildHasFocus() {
        for (Component focusOwner = this.focusManager.getPermanentFocusOwner(); focusOwner != null; focusOwner = focusOwner.getParent()) {
            if (focusOwner == this.hostComponent) {
                return true;
            }
            if (!(focusOwner instanceof Window) && focusOwner.getParent() != null) continue;
            if (focusOwner != SwingUtilities.getRoot(this.hostComponent)) break;
            return false;
        }
        return false;
    }

    public void start() {
        this.focusManager.addPropertyChangeListener(PERMANENT_FOCUS_OWNER, this);
        this.hasFocus = this.isChildHasFocus();
    }

    public void stop() {
        this.focusManager.removePropertyChangeListener(PERMANENT_FOCUS_OWNER, this);
    }

    public abstract void focusLost();

    public abstract void focusGained();
}

