/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.controls;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.StringTokenizer;
import javax.swing.JButton;
import javax.swing.JTextField;
import oracle.ide.component.URLPathEditPanel;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.ide.resource.ControlsArb;
import oracle.ide.util.Assert;
import oracle.ide.util.FastStringBuffer;
import oracle.ide.util.ModelUtil;

public class URLPathField
extends JTextField
implements ActionListener {
    private JButton _btn;
    private String _title;
    private boolean _browseToAnyURLAllowed = false;
    private String _helpContext = "f1_idededitpath_html";
    private boolean _passEnableActionOn = false;
    private HashMap<String, DynamicURL> _entryMap = new HashMap();
    private boolean _allowJars = true;
    private URL _baseFolderURL;
    private static final String DEFAULT_HELP_ID = "f1_idededitpath_html";
    private static final String DEFAULT_VIEW_HELP_ID = "f1_idedviewpath_html";

    public URLPathField() {
    }

    public URLPathField(URLPath path) {
        this();
        this.setURLPath(path);
    }

    public void setURLPath(URLPath path) {
        FastStringBuffer buf = new FastStringBuffer();
        this._entryMap.clear();
        if (path != null) {
            URL[] entries = path.getEntries();
            for (int i = 0; i < entries.length; ++i) {
                String entry = URLFileSystem.getPlatformPathName((URL)entries[i]);
                buf.append(entry);
                this._entryMap.put(entry, new DynamicURL(entries[i]));
                buf.append(';');
            }
        }
        if (buf.getLength() > 0) {
            buf.setLength(buf.getLength() - 1);
        }
        this.setText(buf.toString());
    }

    public URLPath getURLPath() throws BadEntryException {
        URLPath newPath = new URLPath();
        String text = this.getText();
        if (text != null) {
            text = text.trim();
            StringTokenizer tok = new StringTokenizer(text, ";");
            while (tok.hasMoreTokens()) {
                URL url;
                boolean isRelative = false;
                String entry = tok.nextToken().trim();
                if (this._entryMap.containsKey(entry)) {
                    url = this._entryMap.get((Object)entry)._url;
                } else {
                    String archiveEntry;
                    String base;
                    block11: {
                        Assert.check((!entry.startsWith("jar:") ? 1 : 0) != 0);
                        base = entry;
                        archiveEntry = null;
                        String delimiter = "!" + File.separator;
                        int idx = entry.indexOf(delimiter);
                        if (idx > 0) {
                            base = entry.substring(0, idx);
                            archiveEntry = entry.substring(idx + delimiter.length());
                            if (File.separatorChar != '/') {
                                archiveEntry = archiveEntry.replace(File.separatorChar, '/');
                            }
                        } else {
                            String ext;
                            idx = entry.lastIndexOf(46);
                            if (idx >= 0 && ("zip".equals(ext = entry.substring(idx + 1).toLowerCase()) || "jar".equals(ext))) {
                                archiveEntry = "";
                            }
                        }
                        try {
                            url = new URL(base);
                        }
                        catch (MalformedURLException mue) {
                            url = URLFactory.newFileURL((String)base);
                            if (!this.canConvertToQualifiedPath() || url.getPath().indexOf(58) != -1) break block11;
                            url = URLFactory.newDirURL((URL)this._baseFolderURL, (String)base);
                            isRelative = true;
                        }
                    }
                    url = archiveEntry != null ? URLFactory.newJarURL((URL)url, (String)archiveEntry) : URLFactory.newDirURL((URL)url, (String)"");
                    if (url == null) {
                        throw new BadEntryException(this, entry);
                    }
                    url = URLFileSystem.canonicalize((URL)url);
                    this._entryMap.put(base, new DynamicURL(url, isRelative));
                }
                newPath.add(url);
            }
        }
        return newPath;
    }

    private boolean canConvertToQualifiedPath() {
        return this._baseFolderURL != null;
    }

    public void setBaseFolderURL(URL folderURL) {
        if (!URLFileSystem.isDirectoryPath((URL)folderURL)) {
            throw new IllegalArgumentException("Not a valid folder URL.");
        }
        if (!folderURL.equals(this._baseFolderURL)) {
            if (this._baseFolderURL != null) {
                for (DynamicURL d : this._entryMap.values()) {
                    if (!d.isDerivedFromRelativePath()) continue;
                    String rel = URLFileSystem.toRelativeSpec((URL)d.getURL(), (URL)this._baseFolderURL);
                    d.setURL(URLFactory.newDirURL((URL)folderURL, (String)rel));
                }
            }
            this._baseFolderURL = folderURL;
        }
    }

    public void setButtonAssociation(JButton btn, boolean passEnableAction) {
        this._btn = btn;
        this._passEnableActionOn = passEnableAction;
    }

    public void setButton(JButton btn) {
        if (this._btn != null) {
            this._btn.removeActionListener(this);
        }
        this._btn = btn;
        if (this._btn != null) {
            this._btn.addActionListener(this);
        }
    }

    public void setEditTitle(String title) {
        this._title = title;
    }

    public void setHelpContext(String helpCtx) {
        this._helpContext = helpCtx;
    }

    public void setBrowseToAnyURLAllowed(boolean val) {
        this._browseToAnyURLAllowed = val;
    }

    public boolean isBrowseToAnyURLAllowed() {
        return this._browseToAnyURLAllowed;
    }

    public void setJarPathsAllowed(boolean val) {
        this._allowJars = val;
    }

    public boolean isJarPathsAllowed() {
        return this._allowJars;
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (this._btn != null && this._passEnableActionOn) {
            this._btn.setEnabled(enabled);
        }
    }

    @Override
    public final void actionPerformed(ActionEvent e) {
        try {
            if (this.isEditable()) {
                URLPath path = URLPathEditPanel.editPath(this, ControlsArb.format(8, this._title), this.getURLPath(), this._browseToAnyURLAllowed, this._allowJars, this._helpContext);
                if (path != null) {
                    this.setURLPath(path);
                }
            } else {
                URLPathEditPanel.viewPath(this, ControlsArb.format(9, this._title), this.getURLPath(), ModelUtil.areEqual((Object)this._helpContext, (Object)DEFAULT_HELP_ID) ? DEFAULT_VIEW_HELP_ID : this._helpContext);
            }
        }
        catch (BadEntryException badEntryException) {
            // empty catch block
        }
    }

    private static class DynamicURL {
        private URL _url;
        private boolean _derivedFromRelativePath;

        public DynamicURL(URL url) {
            this(url, false);
        }

        public DynamicURL(URL url, boolean dynamic) {
            this._url = url;
            this._derivedFromRelativePath = dynamic;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof DynamicURL)) {
                return false;
            }
            DynamicURL other = (DynamicURL)object;
            return this._url != null ? this._url.equals(other._url) : other._url == null;
        }

        public int hashCode() {
            int PRIME = 37;
            int result = 1;
            result = 37 * result + (this._url == null ? 0 : this._url.hashCode());
            return result;
        }

        void setURL(URL param) {
            this._url = param;
        }

        URL getURL() {
            return this._url;
        }

        void setDerivedFromRelativePath(boolean param) {
            this._derivedFromRelativePath = param;
        }

        boolean isDerivedFromRelativePath() {
            return this._derivedFromRelativePath;
        }
    }

    public static class BadEntryException
    extends Exception {
        private String _entry;
        private URLPathField _source;

        BadEntryException(URLPathField source, String entry) {
            this._source = source;
            this._entry = entry;
        }

        public String getBadEntry() {
            return this._entry;
        }

        public URLPathField getSource() {
            return this._source;
        }
    }
}

