/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.controls;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JViewport;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.ide.Context;
import oracle.ide.IdeConstants;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.DropDownMenuButton;
import oracle.ide.controls.SmallSquareButton;
import oracle.ide.controls.SmallSquareDropDownMenuButton;
import oracle.ide.controls.customtab.AutoRepeatButtonModel;
import oracle.ide.controls.customtab.CustomTab;
import oracle.ide.controls.customtab.CustomTabPage;
import oracle.ide.controls.customtab.DefaultCustomTabPage;
import oracle.ide.editor.EditorManager;
import oracle.ide.keyboard.KeyUtil;
import oracle.ide.log.LogPage;
import oracle.ide.util.ModelUtil;
import oracle.javatools.controls.MainWindow;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.themes.ThemeProperties;
import oracle.javatools.ui.themes.Themes;

public final class ScrollableTabBar
extends JComponent {
    private static final int GAP_BEFORE_BUTTONS = 4;
    private static final int MIN_BUTTON_HEIGHT = 3;
    private static final int GAP_BETWEEN_BUTTONS = 1;
    private static final int GAP_AFTER_BUTTONS = 3;
    private static final int GAP_ABOVE_BUTTONS = 1;
    private static final Dimension DIM_ZERO = new Dimension(0, 0);
    private static final Color SCROLL_BUTTON_FG_COLOR = new Color(102, 102, 102);
    private final CustomTab _tabs;
    private final JViewport _viewport;
    private final Box _buttonBox;
    private final AbstractButton _leftButton;
    private final AbstractButton _rightButton;
    private final AbstractButton _dropDownButton;
    private Component _customComponent;
    private ScrollMode _scrollMode = ScrollMode.SWITCH_TABS;
    private boolean _hideSingleTab = false;
    private boolean _hideButtonsWhenAllTabsVisible = true;
    private Controller _controller = new MyController();
    private boolean _controllerAdded;
    private AncestorListener _ancestorListener = new MyAncestorListener();

    public ScrollableTabBar() {
        this(3);
    }

    public ScrollableTabBar(int position) {
        this._tabs = this.createTabs(position);
        this._viewport = this.createViewport();
        this._viewport.setView(this._tabs);
        this._leftButton = this.createButton(7);
        this._rightButton = this.createButton(3);
        this._dropDownButton = this.createButton(5);
        this._buttonBox = this.createButtonBox();
        this.layoutButtonBox();
        this.updateButtonsAndTabVisibility();
        this.setLayout(null);
        this.add(this._buttonBox);
        this.add(this._viewport);
        this.createButtonListeners();
        this.createTabListeners();
    }

    public void removeScrollButtons() {
        this.remove(this._buttonBox);
    }

    public void setHideSingleTab(boolean hideSingleTab) {
        if (this._hideSingleTab != hideSingleTab) {
            this._hideSingleTab = hideSingleTab;
            this.updateButtonsAndTabVisibility();
            this.firePropertyChange("hideSingleTab", !hideSingleTab, hideSingleTab);
        }
    }

    public void setHideButtonsWhenAllTabsVisible(boolean hideButtons) {
        this._hideButtonsWhenAllTabsVisible = hideButtons;
        this.doLayout();
    }

    public boolean getHideSingleTab() {
        return this._hideSingleTab;
    }

    public void setCustomComponent(Component customComponent) {
        if (this._customComponent != null) {
            this.remove(this._customComponent);
            this._customComponent = null;
        }
        if (customComponent != null) {
            this.add(customComponent);
            this._customComponent = customComponent;
        }
        this.revalidate();
    }

    public Component getCustomComponent() {
        return this._customComponent;
    }

    public CustomTab getTabs() {
        return this._tabs;
    }

    public void setScrollMode(ScrollMode mode) {
        if (this._scrollMode != mode) {
            ScrollMode old = this._scrollMode;
            this._scrollMode = mode;
            this.firePropertyChange("scrollMode", (Object)old, (Object)mode);
        }
    }

    public ScrollMode getScrollMode() {
        return this._scrollMode;
    }

    public void showDropDownMenu() {
        this._dropDownButton.doClick();
    }

    private JViewport createViewport() {
        JViewport viewport = new JViewport();
        viewport.setOpaque(false);
        viewport.setFocusable(false);
        viewport.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent ce) {
                ScrollableTabBar.this.ensureSelectedTabVisible();
            }
        });
        return viewport;
    }

    private CustomTab createTabs(int position) {
        CustomTab tabs = new CustomTab(position);
        tabs.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        tabs.setGapBetweenTabs(-1);
        tabs.setOffsetSelected(0);
        tabs.setOpaque(false);
        tabs.setPreferredSize(null);
        tabs.setCtrlClickCloseEnabled(true);
        tabs.setCompressible(true);
        return tabs;
    }

    private AbstractButton createButton(int direction) {
        AbstractButton scrollButton = direction == 5 ? new SmallSquareDropDownMenuButton() : new SmallSquareButton();
        scrollButton.setFocusable(false);
        scrollButton.setRolloverEnabled(false);
        scrollButton.setOpaque(false);
        scrollButton.setAlignmentY(1.0f);
        scrollButton.setMargin(new Insets(0, 0, 0, 0));
        scrollButton.setForeground(SCROLL_BUTTON_FG_COLOR);
        String tooltip = null;
        if (Themes.isThemed()) {
            String dir = "";
            switch (direction) {
                case 7: {
                    dir = "scrollabletabbutton.west";
                    tooltip = KeyUtil.buildTooltip(70);
                    break;
                }
                case 3: {
                    dir = "scrollabletabbutton.east";
                    tooltip = KeyUtil.buildTooltip(71);
                    break;
                }
                case 5: {
                    dir = "scrollabletabbutton.south";
                    tooltip = KeyUtil.buildTooltip(EditorManager.SHOW_DROPDOWN_CMD_ID);
                }
            }
            ThemeProperties tp = Themes.getActiveTheme().getStateProperties(dir, "default");
            scrollButton.setIcon(tp.getIcon("icon"));
            tp = Themes.getActiveTheme().getStateProperties(dir, "disabled");
            scrollButton.setDisabledIcon(tp.getIcon("icon"));
            tp = Themes.getActiveTheme().getStateProperties(dir, "over");
            scrollButton.setRolloverIcon(tp.getIcon("icon"));
            tp = Themes.getActiveTheme().getStateProperties(dir, "pressed");
            scrollButton.setPressedIcon(tp.getIcon("icon"));
            scrollButton.setBorder(BorderFactory.createEmptyBorder());
            scrollButton.setToolTipText(tooltip);
        } else {
            Icon icon = null;
            switch (direction) {
                case 7: {
                    icon = OracleIcons.getIcon((String)"extras/left.gif");
                    tooltip = KeyUtil.buildTooltip(70);
                    break;
                }
                case 3: {
                    icon = OracleIcons.getIcon((String)"extras/right.gif");
                    tooltip = KeyUtil.buildTooltip(71);
                    break;
                }
                case 5: {
                    icon = OracleIcons.getIcon((String)"extras/down.gif");
                    tooltip = KeyUtil.buildTooltip(EditorManager.SHOW_DROPDOWN_CMD_ID);
                }
            }
            scrollButton.setIcon(icon);
            scrollButton.setToolTipText(tooltip);
        }
        if (direction == 3 || direction == 7) {
            scrollButton.setModel(new AutoRepeatButtonModel(400, 100));
        }
        this.addControllerToActions(true);
        this.addAncestorListener(this._ancestorListener);
        return scrollButton;
    }

    private void addControllerToActions(boolean add) {
        if (add && this._controllerAdded || !add && !this._controllerAdded) {
            return;
        }
        ArrayList<IdeAction> actions = new ArrayList<IdeAction>(3);
        IdeAction ideAction = IdeAction.find(70);
        if (ideAction != null) {
            actions.add(ideAction);
        }
        if ((ideAction = IdeAction.find(71)) != null) {
            actions.add(ideAction);
        }
        if ((ideAction = IdeAction.find(EditorManager.SHOW_DROPDOWN_CMD_ID)) != null) {
            actions.add(ideAction);
        }
        for (IdeAction a : actions) {
            if (add) {
                a.addController(this._controller);
                continue;
            }
            a.removeController(this._controller);
        }
        this._controllerAdded = add;
    }

    private Box createButtonBox() {
        Box buttonBox = new Box(0);
        buttonBox.setBorder(BorderFactory.createEmptyBorder(1, 0, 0, 0));
        buttonBox.setOpaque(false);
        buttonBox.setFocusable(false);
        return buttonBox;
    }

    private void layoutButtonBox() {
        this._buttonBox.add(Box.createHorizontalStrut(4));
        this._buttonBox.add(Box.createVerticalStrut(3));
        this._buttonBox.add(this._leftButton);
        this._buttonBox.add(Box.createHorizontalStrut(1));
        this._buttonBox.add(this._rightButton);
        this._buttonBox.add(Box.createHorizontalStrut(1));
        this._buttonBox.add(this._dropDownButton);
        this._buttonBox.add(Box.createHorizontalStrut(3));
    }

    public void ensureSelectedTabVisible() {
        int selectedPage = this._tabs.getSelectedPage();
        if (selectedPage != -1) {
            DefaultCustomTabPage page = (DefaultCustomTabPage)this._tabs.getPage(selectedPage);
            Dimension preferredSize = this._tabs.getPreferredSize();
            if (preferredSize != null) {
                Rectangle pageBounds = page.getBounds();
                Rectangle viewRect = this._viewport.getViewRect();
                if (pageBounds.x < viewRect.x) {
                    this._viewport.setViewPosition(new Point(Math.max(pageBounds.x, 0), 0));
                } else if (pageBounds.x + pageBounds.width > viewRect.x + viewRect.width) {
                    this._viewport.setViewPosition(new Point(pageBounds.x + pageBounds.width - viewRect.width, 0));
                }
            }
        }
    }

    private void updateButtonsAndTabVisibility() {
        boolean tabsVisible = this._tabs.getPageCount() >= (this._hideSingleTab ? 2 : 1);
        this._buttonBox.setVisible(tabsVisible);
        this._tabs.setVisible(tabsVisible);
        if (tabsVisible) {
            int selectedPage = this._tabs.getSelectedPage();
            if (selectedPage != -1) {
                this._leftButton.setEnabled(selectedPage > 0);
                this._rightButton.setEnabled(selectedPage < this._tabs.getPageCount() - 1);
            }
            this._dropDownButton.setEnabled(this._tabs.getPageCount() > 1);
        }
    }

    private void createButtonListeners() {
        this._leftButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                ScrollableTabBar.this.scroll(2);
            }
        });
        this._rightButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                ScrollableTabBar.this.scroll(4);
            }
        });
        this._dropDownButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ScrollableTabBar.this.setDropDownVisible(e.getStateChange() == 1);
            }
        });
    }

    private void createTabListeners() {
        this._tabs.addListDataListener(new ListDataListener(){

            @Override
            public void contentsChanged(ListDataEvent e) {
                ScrollableTabBar.this.updateButtonsAndTabVisibility();
            }

            @Override
            public void intervalRemoved(ListDataEvent e) {
                ScrollableTabBar.this.updateButtonsAndTabVisibility();
            }

            @Override
            public void intervalAdded(ListDataEvent e) {
                ScrollableTabBar.this.updateButtonsAndTabVisibility();
            }
        });
        this._tabs.addPropertyChangeListener("model", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                ScrollableTabBar.this.updateButtonsAndTabVisibility();
            }
        });
        this._tabs.addSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ScrollableTabBar.this.updateButtonsAndTabVisibility();
            }
        });
    }

    private void scroll(int direction) {
        if (this.getScrollMode() == ScrollMode.SCROLL) {
            this.scrollViewport(direction);
        } else {
            this.switchPage(direction);
        }
    }

    private void scrollViewport(int direction) {
        int pageAt;
        Point viewPosition = this._viewport.getViewPosition();
        int n = pageAt = direction == 2 ? this._tabs.getPageBefore(viewPosition.x) : this._tabs.getPageAfter(viewPosition.x);
        if (pageAt >= 0) {
            CustomTabPage page = this._tabs.getPage(pageAt);
            Rectangle pageBounds = page.getBounds();
            int newX = 0;
            if (direction == 2) {
                newX = pageBounds.x;
            } else {
                Dimension extentSize = this._viewport.getExtentSize();
                Dimension viewSize = this._viewport.getViewSize();
                newX = Math.min(pageBounds.x, viewSize.width - extentSize.width);
            }
            this._viewport.setViewPosition(new Point(newX, 0));
        }
    }

    private void switchPage(int direction) {
        int newPage = this._tabs.getSelectedPage() + (direction == 2 ? -1 : 1);
        if (newPage >= 0 && (direction == 2 || newPage < this._tabs.getPageCount())) {
            this._tabs.setSelectedPage(newPage);
            this.ensureSelectedTabVisible();
        }
    }

    private void setDropDownVisible(boolean visible) {
        block6: {
            DropDownMenuButton b = (DropDownMenuButton)this._dropDownButton;
            b.removeAllPopupItems();
            if (!visible) break block6;
            Dimension sizeScreen = this._dropDownButton.getToolkit().getScreenSize();
            List<JMenuItem> items = this.getTabPopupItems();
            int n = items.size();
            int nItemsMenuHeight = 0;
            for (JMenuItem item : items) {
                int nHeight = item.getPreferredSize().height;
                nItemsMenuHeight += nHeight;
            }
            if (nItemsMenuHeight < sizeScreen.height * 9 / 10) {
                n = items.size();
                for (int i = 0; i < n; ++i) {
                    JMenuItem item;
                    item = items.get(i);
                    b.addPopupItem(item);
                }
            } else {
                n = items.size();
                int nAvailableHeight = sizeScreen.height * 9 / 10;
                int nNbrSubMenus = nItemsMenuHeight / nAvailableHeight + 1;
                int nNbrElementsPerMenu = items.size() / nNbrSubMenus + 1;
                int nElementsInThisMenu = nNbrElementsPerMenu + 1;
                JMenu subMenu = null;
                for (int i = 0; i < n; ++i) {
                    JMenuItem item = items.get(i);
                    if (nElementsInThisMenu >= nNbrElementsPerMenu) {
                        String sFrom = item.getText();
                        int nTo = Math.min(i + nNbrElementsPerMenu, n) - 1;
                        JMenuItem itemTo = items.get(nTo);
                        String sTo = itemTo.getText();
                        subMenu = new JMenu(sFrom + " - " + sTo);
                        b.addPopupItem(subMenu);
                        nElementsInThisMenu = 0;
                    }
                    subMenu.add(item);
                    ++nElementsInThisMenu;
                }
            }
        }
    }

    private List<JMenuItem> getTabPopupItems() {
        ArrayList<JMenuItem> list = new ArrayList<JMenuItem>();
        int tabCount = this._tabs.getPageCount();
        for (int i = 0; i < tabCount; ++i) {
            CustomTabPage tabPage = this._tabs.getPage(i);
            String text = tabPage.getLongLabel();
            if (!ModelUtil.hasLength((String)text)) {
                text = tabPage.getLabel();
            }
            AbstractAction action = new AbstractAction(text, tabPage.getIcon()){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JMenuItem mItem = (JMenuItem)e.getSource();
                    AbstractAction aAction = (AbstractAction)mItem.getAction();
                    int selPageNum = (Integer)aAction.getValue("pageNum");
                    ScrollableTabBar.this._tabs.setSelectedPage(selPageNum);
                    ScrollableTabBar.this.ensureSelectedTabVisible();
                }
            };
            action.putValue("pageNum", i);
            JMenuItem item = new JMenuItem(action);
            list.add(item);
        }
        Collections.sort(list, new Comparator<JMenuItem>(){

            @Override
            public int compare(JMenuItem item1, JMenuItem item2) {
                return String.CASE_INSENSITIVE_ORDER.compare(item1.getText(), item2.getText());
            }
        });
        return list;
    }

    @Override
    public void doLayout() {
        Dimension size = this.getSize();
        Insets insets = this.getInsets();
        int w = size.width - (insets.left + insets.right);
        int h = size.height - (insets.top + insets.bottom);
        Dimension psTabs = this._tabs.isVisible() ? this._tabs.getPreferredSize() : DIM_ZERO;
        Dimension psButtons = this._buttonBox.isVisible() ? this._buttonBox.getPreferredSize() : DIM_ZERO;
        Dimension psCustom = this._customComponent == null || !this._customComponent.isVisible() ? DIM_ZERO : this._customComponent.getPreferredSize();
        Dimension msCustom = this._customComponent == null || !this._customComponent.isVisible() ? DIM_ZERO : this._customComponent.minimumSize();
        int wTabsViewport = psTabs.width;
        int wCustomComponent = psCustom.width;
        if (psTabs.width + psButtons.width + psCustom.width > w) {
            int wForCustom = w - psTabs.width - psButtons.width;
            if (wForCustom < msCustom.width) {
                wForCustom = msCustom.width;
            }
            wCustomComponent = wForCustom;
            wTabsViewport = w - psButtons.width - wCustomComponent;
        } else {
            wCustomComponent = w - psTabs.width - psButtons.width;
        }
        int y = insets.top;
        this._viewport.setBounds(insets.left, y, wTabsViewport, h);
        this._buttonBox.setBounds(this.getWidth() - insets.right - psButtons.width, y, psButtons.width, psButtons.height);
        if (this._customComponent != null) {
            this._customComponent.setBounds(insets.left + wTabsViewport, y, wCustomComponent, psCustom.height);
        }
        if (this._hideButtonsWhenAllTabsVisible && this._viewport != null && this._viewport.getView() != null) {
            boolean showButtons;
            int viewportWidth = this._viewport.getWidth();
            int viewWidth = this._viewport.getView().getWidth();
            boolean bl = showButtons = viewWidth > viewportWidth;
            if (this._leftButton != null) {
                this._leftButton.setVisible(showButtons);
            }
            if (this._rightButton != null) {
                this._rightButton.setVisible(showButtons);
            }
        }
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension ps = new Dimension();
        Insets insets = this.getInsets();
        Dimension psTabs = this._tabs.isVisible() ? this._tabs.getPreferredSize() : DIM_ZERO;
        Dimension psButtons = this._buttonBox.isVisible() ? this._buttonBox.getPreferredSize() : DIM_ZERO;
        Dimension psCustom = this._customComponent == null || !this._customComponent.isVisible() ? DIM_ZERO : this._customComponent.getPreferredSize();
        ps.width = insets.left + psTabs.width + psCustom.width + psButtons.width + insets.right;
        ps.height = insets.top + insets.bottom + Math.max(psTabs.height, Math.max(psCustom.height, psButtons.height));
        return ps;
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Color c = IdeConstants.COLOR_IDE_LINES;
        if (Themes.isThemed()) {
            c = this._tabs.isFocused() ? Themes.getActiveTheme().getStateProperties("view", "active").getColor("bordercolor") : Themes.getActiveTheme().getStateProperties("view", "inactive").getColor("bordercolor");
        }
        Insets insets = this.getInsets();
        int y = insets.top;
        if (this._tabs.getPosition() == 1) {
            y = this._viewport.getHeight() - 1;
        }
        int x = insets.left + this._viewport.getWidth();
        if (this._customComponent != null) {
            x += this._customComponent.getWidth();
        }
        int x2 = this.getWidth() - insets.right;
        int y2 = y;
        g.setColor(c);
        g.drawLine(x, y, x2, y2);
    }

    public static enum ScrollMode {
        SWITCH_TABS,
        SCROLL;

    }

    private class MyController
    implements Controller {
        private MyController() {
        }

        @Override
        public boolean handleEvent(IdeAction action, Context context) {
            if (!this.isRightContext(context)) {
                return false;
            }
            int cmdId = action.getCommandId();
            if (cmdId == 70) {
                if (ScrollableTabBar.this._leftButton.isEnabled()) {
                    ScrollableTabBar.this.scroll(2);
                }
                return true;
            }
            if (cmdId == 71) {
                if (ScrollableTabBar.this._rightButton.isEnabled()) {
                    ScrollableTabBar.this.scroll(4);
                }
                return true;
            }
            if (cmdId == EditorManager.SHOW_DROPDOWN_CMD_ID && ScrollableTabBar.this._dropDownButton.isEnabled()) {
                ScrollableTabBar.this.showDropDownMenu();
                return true;
            }
            return false;
        }

        @Override
        public boolean update(IdeAction action, Context context) {
            if (!this.isRightContext(context)) {
                return false;
            }
            int cmdId = action.getCommandId();
            if (cmdId == 70) {
                if (ScrollableTabBar.this._leftButton.isEnabled()) {
                    action.setEnabled(true);
                    return true;
                }
            } else if (cmdId == 71) {
                if (ScrollableTabBar.this._rightButton.isEnabled()) {
                    action.setEnabled(true);
                    return true;
                }
            } else if (cmdId == EditorManager.SHOW_DROPDOWN_CMD_ID && ScrollableTabBar.this._dropDownButton.isEnabled()) {
                action.setEnabled(true);
                return true;
            }
            return false;
        }

        private boolean isRightContext(Context context) {
            boolean isChild;
            block2: {
                block3: {
                    isChild = false;
                    if (context.getView() == null) break block2;
                    if (!(context.getView() instanceof LogPage)) break block3;
                    for (Container comp = ScrollableTabBar.this._buttonBox.getParent(); comp != null; comp = comp.getParent()) {
                        if (comp.getClass().getName().indexOf("oracle.ideimpl.log.TabbedPage") == -1) continue;
                        isChild = true;
                        break block2;
                    }
                    break block2;
                }
                if (context.getView().getGUI() == null || ScrollableTabBar.this._buttonBox == null) break block2;
                Component viewComp = context.getView().getGUI();
                for (Container parent = ScrollableTabBar.this._buttonBox.getParent(); parent != null && !(parent instanceof MainWindow); parent = parent.getParent()) {
                    if (parent != viewComp) continue;
                    isChild = true;
                    break;
                }
            }
            return isChild;
        }
    }

    private class MyAncestorListener
    implements AncestorListener {
        private MyAncestorListener() {
        }

        @Override
        public void ancestorAdded(AncestorEvent event) {
            ScrollableTabBar.this.addControllerToActions(true);
        }

        @Override
        public void ancestorRemoved(AncestorEvent event) {
            ScrollableTabBar.this.addControllerToActions(false);
        }

        @Override
        public void ancestorMoved(AncestorEvent event) {
        }
    }
}

