/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.controls;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager2;
import java.awt.Rectangle;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.SwingConstants;

public class ButtonsLayoutManager
implements LayoutManager2,
SwingConstants {
    public static final boolean DIRECTION_RTL = true;
    public static final boolean DIRECTION_LTR = false;
    private static int DEFAULTGAP = 0;
    private int _nGap = DEFAULTGAP;
    private ArrayList _buttons = new ArrayList(2);
    private int _nOrient = 0;
    private boolean _rtl = true;
    private Rectangle _rSpaceLeft = new Rectangle();

    public ButtonsLayoutManager() {
        this(0);
    }

    public ButtonsLayoutManager(int nGap) {
        this.setGap(nGap);
    }

    public void setGap(int nGap) {
        this._nGap = nGap;
    }

    public int getGap() {
        return this._nGap;
    }

    public void setDirection(boolean rtl) {
        this._rtl = rtl;
    }

    public boolean getDirection() {
        return this._rtl;
    }

    public Rectangle getSpaceLeft() {
        return this._rSpaceLeft;
    }

    public void setOrientation(int nOrient) {
        this._nOrient = nOrient;
    }

    public int getOrientation() {
        return this._nOrient;
    }

    private Dimension getOrientedDimension(int nWidth, int nHeight) {
        if (this._nOrient == 1) {
            return new Dimension(nHeight, nWidth);
        }
        return new Dimension(nWidth, nHeight);
    }

    public final int getButtonCount() {
        return this._buttons.size();
    }

    public final Component getButton(int i) {
        Component button = i >= 0 && i < this._buttons.size() ? (Component)this._buttons.get(i) : null;
        return button;
    }

    protected final void addButton(Component c, int nConstraint) {
        for (int i = this._buttons.size(); i < nConstraint; ++i) {
            this._buttons.add(null);
        }
        this._buttons.add(nConstraint, c);
    }

    protected final void removeButton(int nConstraint) {
        if (nConstraint >= 0 && nConstraint < this._buttons.size()) {
            this._buttons.remove(nConstraint);
        }
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
        Integer constraint = Integer.valueOf(name);
        this.addLayoutComponent(comp, constraint);
    }

    @Override
    public void removeLayoutComponent(Component comp) {
        this._buttons.remove(comp);
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        int nWidth = 0;
        int nHeight = 0;
        int n = this._buttons.size();
        for (int i = n - 1; i >= 0; --i) {
            JComponent c = (JComponent)this._buttons.get(i);
            if (c == null || !c.isVisible()) continue;
            Dimension dc = c.getPreferredSize();
            if (this._nOrient == 1) {
                nHeight += dc.height + this._nGap;
                if (dc.width <= nWidth) continue;
                nWidth = dc.width;
                continue;
            }
            nWidth += dc.width + this._nGap;
            if (dc.height <= nHeight) continue;
            nHeight = dc.height;
        }
        return new Dimension(nWidth, nHeight);
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        return this.preferredLayoutSize(parent);
    }

    @Override
    public void layoutContainer(Container parent) {
        Dimension dParent = parent.getSize();
        this.layoutContainer(parent, dParent);
    }

    protected int layoutContainer(Container parent, Dimension dParent) {
        int n = this._buttons.size();
        int i = 0;
        this._rSpaceLeft.setBounds(0, 0, dParent.width, dParent.height);
        if (this._nOrient == 1) {
            nxPos = dParent.width / 2;
            nyPos = 0;
            for (i = 0; i < n; ++i) {
                c = (JComponent)this._buttons.get(i);
                if (c == null || !c.isVisible()) continue;
                dc = c.getPreferredSize();
                if (nyPos + dc.height > dParent.height) break;
                c.setBounds(nxPos - dc.width / 2, nyPos, dc.width, dc.height);
                nyPos += dc.height + this._nGap;
            }
            this._rSpaceLeft.y = nyPos;
            this._rSpaceLeft.height = dParent.height - nyPos;
        } else if (this._rtl) {
            nxPos = dParent.width;
            nyPos = dParent.height / 2;
            for (i = 0; i < n; ++i) {
                c = (JComponent)this._buttons.get(i);
                if (c == null || !c.isVisible()) continue;
                dc = c.getPreferredSize();
                if (nxPos - dc.width < 0) break;
                c.setBounds(nxPos - dc.width, nyPos - dc.height / 2, dc.width, dc.height);
                nxPos -= dc.width + this._nGap;
            }
            this._rSpaceLeft.width = nxPos;
        } else {
            nxPos = 0;
            nyPos = dParent.height / 2;
            for (i = 0; i < n; ++i) {
                c = (JComponent)this._buttons.get(i);
                if (c == null || !c.isVisible()) continue;
                dc = c.getPreferredSize();
                if (nxPos + dc.width > dParent.width) break;
                c.setBounds(nxPos, nyPos - dc.height / 2, dc.width, dc.height);
                nxPos += dc.width + this._nGap;
            }
            this._rSpaceLeft.x = nxPos;
            this._rSpaceLeft.width = dParent.width - nxPos;
        }
        for (int nHide = i; nHide < n; ++nHide) {
            JComponent c = (JComponent)this._buttons.get(nHide);
            if (c == null) continue;
            c.setBounds(0, 0, 0, 0);
        }
        if (parent instanceof JComponent) {
            JComponent jcParent = (JComponent)parent;
            jcParent.repaint();
        }
        return i;
    }

    @Override
    public void addLayoutComponent(Component comp, Object constraints) {
        if (!(constraints instanceof Integer)) {
            throw new IllegalArgumentException("ButtonsLayoutManager must be used with Integer constraints");
        }
        int nConstraint = (Integer)constraints;
        this.addButton(comp, nConstraint);
    }

    @Override
    public Dimension maximumLayoutSize(Container target) {
        return this.preferredLayoutSize(target);
    }

    @Override
    public float getLayoutAlignmentX(Container target) {
        return 1.0f;
    }

    @Override
    public float getLayoutAlignmentY(Container target) {
        return 0.5f;
    }

    @Override
    public void invalidateLayout(Container target) {
    }
}

