/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.composite;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.ide.util.MetaClass;
import oracle.ide.composite.BaseCompositeFileElementProxy;
import oracle.ide.composite.CompositeFileElementEvent;
import oracle.ide.composite.CompositeFileElementListener;
import oracle.ide.composite.CompositeFileElementProxy;
import oracle.ide.composite.Depth;
import oracle.ide.model.Element;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.ide.net.URLKey;
import oracle.ide.util.ClassUtils;

public class CompositeFileElementRegistry {
    static final String APPLICATION_NAVIGATOR_WINDOW_ID = "ApplicationNavigatorWindow";
    private static final Collection<CompositeFileElementListener> _compositeListeners = Collections.synchronizedList(new ArrayList());
    private static final CopyOnWriteArrayList<CompositeFileElementProxy> _compositeProxies = new CopyOnWriteArrayList();
    private static final Map<Element, Collection<URL>> _compositeStateCache = Collections.synchronizedMap(new WeakHashMap());

    private CompositeFileElementRegistry() {
    }

    @Deprecated
    public static final void registerCompositeProxy(CompositeFileElementProxy compositeProxy) {
        _compositeProxies.addIfAbsent(compositeProxy);
        if (compositeProxy instanceof BaseCompositeFileElementProxy) {
            CompositeFileElementRegistry.fireCompositeStateChanged(((BaseCompositeFileElementProxy)compositeProxy).getCompositeElementMetaClass());
            return;
        }
        CompositeFileElementRegistry.fireCompositeStateChanged(compositeProxy.getCompositeElementClass());
    }

    @Deprecated
    public static final void deregisterCompositeProxy(CompositeFileElementProxy compositeProxy) {
        _compositeProxies.remove(compositeProxy);
        if (compositeProxy instanceof BaseCompositeFileElementProxy) {
            CompositeFileElementRegistry.fireCompositeStateChanged(((BaseCompositeFileElementProxy)compositeProxy).getCompositeElementMetaClass());
            return;
        }
        CompositeFileElementRegistry.fireCompositeStateChanged(compositeProxy.getCompositeElementClass());
    }

    public static final void fireCompositeStateChanged(Element compositeElement) {
        CompositeFileElementRegistry.fireCompositeStateChanged(new Element[]{compositeElement});
    }

    public static final void fireCompositeStateChanged(Class compositeElementClass) {
        if (!Element.class.isAssignableFrom(compositeElementClass)) {
            throw new IllegalArgumentException();
        }
        Element[] compositeElements = CompositeFileElementRegistry.getCachedCompositeElements(compositeElementClass);
        if (compositeElements.length > 0) {
            CompositeFileElementRegistry.fireCompositeStateChanged(compositeElements);
        }
    }

    public static final void fireCompositeStateChanged(MetaClass<? extends Element> compositeElementClass) {
        Element[] compositeElements = CompositeFileElementRegistry.getCachedCompositeElements(compositeElementClass);
        if (compositeElements.length > 0) {
            CompositeFileElementRegistry.fireCompositeStateChanged(compositeElements);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void fireCompositeStateChanged(Element[] compositeElements) {
        CompositeFileElementListener[] l;
        for (Element compositeElement : compositeElements) {
            _compositeStateCache.remove(compositeElement);
        }
        if (_compositeListeners.isEmpty()) {
            return;
        }
        Collection<CompositeFileElementListener> collection = _compositeListeners;
        synchronized (collection) {
            l = _compositeListeners.toArray(new CompositeFileElementListener[0]);
        }
        CompositeFileElementEvent e = new CompositeFileElementEvent(compositeElements, 1);
        for (int i = l.length - 1; i >= 0; --i) {
            l[i].compositeStateChanged(e);
        }
    }

    public static final void addCompositeListener(CompositeFileElementListener l) {
        _compositeListeners.add(l);
    }

    public static final void removeCompositeListener(CompositeFileElementListener l) {
        _compositeListeners.remove(l);
    }

    public static final boolean isCompositeElement(Element element) {
        return CompositeFileElementRegistry.isCompositeElement(element, APPLICATION_NAVIGATOR_WINDOW_ID);
    }

    public static final boolean isCompositeElement(Element element, String viewType) {
        for (CompositeFileElementProxy compositeProxy : _compositeProxies.toArray(new CompositeFileElementProxy[0])) {
            if (!CompositeFileElementRegistry.isCompositeProxyForView(compositeProxy, viewType) || !CompositeFileElementRegistry.isCompositeProxyForElement(compositeProxy, element)) continue;
            return true;
        }
        return false;
    }

    public static final URL[] getCompositeFileURLs(Element compositeElement) {
        return CompositeFileElementRegistry.getCompositeFileURLs(compositeElement, APPLICATION_NAVIGATOR_WINDOW_ID);
    }

    public static final URL[] getCompositeFileURLs(Element compositeElement, String viewType) {
        if (_compositeStateCache.containsKey(compositeElement)) {
            return _compositeStateCache.get(compositeElement).toArray(new URL[0]);
        }
        LinkedHashSet<URLKey> compositeFileUrls = new LinkedHashSet<URLKey>();
        for (CompositeFileElementProxy compositeProxy : _compositeProxies.toArray(new CompositeFileElementProxy[0])) {
            URL[] urls;
            if (!CompositeFileElementRegistry.isCompositeProxyForView(compositeProxy, viewType) || !CompositeFileElementRegistry.isCompositeProxyForElement(compositeProxy, compositeElement) || (urls = compositeProxy.getCompositeFileURLs(compositeElement)) == null) continue;
            for (URL url : urls) {
                if (url == null) continue;
                compositeFileUrls.add(URLKey.getInstance((URL)url).intern());
            }
        }
        ArrayList compositeFileUrlList = new ArrayList(URLKey.asURLs(compositeFileUrls));
        Collections.sort(compositeFileUrlList, new SystemOrderComparator());
        _compositeStateCache.put(compositeElement, compositeFileUrlList);
        return compositeFileUrlList.toArray(new URL[0]);
    }

    public static final Element[] getCachedCompositeElements(URL[] urls) {
        return CompositeFileElementRegistry.getCachedCompositeElements(urls, Depth.EMPTY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final Element[] getCachedCompositeElements(URL[] urls, Depth depth) {
        LinkedHashSet<Element> compositeElements = new LinkedHashSet<Element>();
        URLFilter filter = DepthUtil.createDepthFilter(urls, depth);
        Map<Element, Collection<URL>> map = _compositeStateCache;
        synchronized (map) {
            for (Element compositeElement : _compositeStateCache.keySet()) {
                if (!CompositeFileElementRegistry.isCompositeElementOwner(compositeElement, filter)) continue;
                compositeElements.add(compositeElement);
            }
        }
        return compositeElements.toArray(new Element[0]);
    }

    static final boolean isRegisteredCompositeProxy(CompositeFileElementProxy compositeProxy) {
        return Arrays.asList(_compositeProxies.toArray()).contains(compositeProxy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Element[] getCachedCompositeElements(Class compositeElementClass) {
        ArrayList<Element> compositeElements = new ArrayList<Element>();
        Map<Element, Collection<URL>> map = _compositeStateCache;
        synchronized (map) {
            for (Element compositeElement : _compositeStateCache.keySet()) {
                if (!compositeElementClass.isInstance(compositeElement)) continue;
                compositeElements.add(compositeElement);
            }
        }
        return compositeElements.toArray(new Element[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Element[] getCachedCompositeElements(MetaClass<? extends Element> compositeElementClass) {
        ArrayList<Element> compositeElements = new ArrayList<Element>();
        Map<Element, Collection<URL>> map = _compositeStateCache;
        synchronized (map) {
            for (Element compositeElement : _compositeStateCache.keySet()) {
                if (compositeElement == null || compositeElementClass == null || !ClassUtils.isInstanceOf(compositeElement.getClass(), (String)compositeElementClass.getClassName())) continue;
                compositeElements.add(compositeElement);
            }
        }
        return compositeElements.toArray(new Element[0]);
    }

    private static final boolean isCompositeProxyForView(CompositeFileElementProxy compositeProxy, String viewType) {
        if (viewType == null) {
            return true;
        }
        String viewType0 = APPLICATION_NAVIGATOR_WINDOW_ID;
        if (compositeProxy instanceof BaseCompositeFileElementProxy) {
            BaseCompositeFileElementProxy compositeProxy0 = (BaseCompositeFileElementProxy)compositeProxy;
            viewType0 = compositeProxy0.getViewType();
        }
        return viewType0 == null || viewType.equals(viewType0);
    }

    private static final boolean isCompositeProxyForElement(CompositeFileElementProxy compositeProxy, Element element) {
        if (compositeProxy instanceof BaseCompositeFileElementProxy) {
            return element != null && ClassUtils.isInstanceOf(element.getClass(), (String)((BaseCompositeFileElementProxy)compositeProxy).getCompositeElementMetaClass().getClassName());
        }
        return compositeProxy.getCompositeElementClass().isInstance(element);
    }

    private static final boolean isCompositeElementOwner(Element compositeElement, URLFilter filter) {
        Collection<URL> compositeFileUrls = _compositeStateCache.get(compositeElement);
        for (URL url : compositeFileUrls) {
            if (!filter.accept(url)) continue;
            return true;
        }
        return false;
    }

    private static class SystemOrderComparator
    implements Comparator<URL> {
        private SystemOrderComparator() {
        }

        @Override
        public int compare(URL url1, URL url2) {
            return this.getWeight(url1) - this.getWeight(url2);
        }

        private int getWeight(URL url) {
            String suffix = URLFileSystem.getSuffix((URL)url);
            if (suffix.equals(".jpr")) {
                return -1;
            }
            if (suffix.equals(".jws")) {
                return -2;
            }
            return 0;
        }
    }

    private static final class DepthUtil {
        private DepthUtil() {
        }

        public static final URLFilter createDepthFilter(URL[] urls, Depth depth) {
            if (urls == null) {
                return DepthUtil.createNullFilter();
            }
            if (depth == null || depth == Depth.EMPTY) {
                return DepthUtil.createSpecificURLFilter(urls);
            }
            if (depth == Depth.IMMEDIATES) {
                return DepthUtil.createDirectoryContentsFilter(urls);
            }
            if (depth == Depth.INFINITY) {
                return DepthUtil.createBaseURLContentsFilter(urls);
            }
            throw new IllegalArgumentException();
        }

        private static final URLFilter createNullFilter() {
            return new URLFilter(){

                public boolean accept(URL url) {
                    return true;
                }
            };
        }

        private static final URLFilter createSpecificURLFilter(URL[] urls) {
            final URL[] urls2 = urls;
            return new URLFilter(){

                public boolean accept(URL url) {
                    for (URL url2 : urls2) {
                        if (!URLFileSystem.equals((URL)url, (URL)url2)) continue;
                        return true;
                    }
                    return false;
                }
            };
        }

        private static final URLFilter createDirectoryContentsFilter(URL[] directoryUrls) {
            final URL[] directoryUrls2 = directoryUrls;
            return new URLFilter(){

                public boolean accept(URL url) {
                    URL parent = URLFileSystem.getParent((URL)url);
                    for (int i = 0; i < directoryUrls2.length; ++i) {
                        if (!URLFileSystem.equals((URL)directoryUrls2[i], (URL)parent)) continue;
                        return true;
                    }
                    return false;
                }
            };
        }

        private static final URLFilter createBaseURLContentsFilter(URL[] baseUrls) {
            final URL[] baseUrls2 = baseUrls;
            return new URLFilter(){

                public boolean accept(URL url) {
                    for (int i = 0; i < baseUrls2.length; ++i) {
                        if (!DepthUtil.isBaseURLFor(baseUrls2[i], url)) continue;
                        return true;
                    }
                    return false;
                }
            };
        }

        private static final boolean isBaseURLFor(URL url1, URL url2) {
            if (URLFileSystem.isDirectoryPath((URL)url1)) {
                return URLFileSystem.isBaseURLFor((URL)url1, (URL)url2);
            }
            return url1.toString().equals(url2.toString());
        }
    }
}

