/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.composite;

import java.net.URL;
import javax.ide.extension.ElementContext;
import javax.ide.extension.ElementEndContext;
import javax.ide.extension.ElementName;
import javax.ide.extension.ElementStartContext;
import javax.ide.extension.ElementVisitor;
import javax.ide.extension.ExtensionHook;
import javax.ide.extension.MetaClassVisitor;
import javax.ide.util.MetaClass;
import oracle.ide.composite.BaseCompositeFileElementProxy;
import oracle.ide.composite.CompositeFileElementProxy;
import oracle.ide.composite.CompositeFileElementRegistry;
import oracle.ide.javaxide.Util;
import oracle.ide.model.Element;

public final class CompositeFileElementHook
extends ExtensionHook {
    private static final String NS = "http://xmlns.oracle.com/ide/extension";
    private static final ElementName VIEW_TYPE = new ElementName("http://xmlns.oracle.com/ide/extension", "view-type");
    private static final ElementName ELEMENT_CLASS = new ElementName("http://xmlns.oracle.com/ide/extension", "element-class");
    private static final ElementName PROXY_CLASS = new ElementName("http://xmlns.oracle.com/ide/extension", "proxy-class");
    private final ElementVisitor _viewTypeHandler = new ViewTypeHandler();
    private final ElementVisitor _elementClassHandler = new ElementClassHandler();
    private final ElementVisitor _proxyClassHandler = new ProxyClassHandler();
    private static final String KEY_SCOPE_COMPOSITE_FILE_ELEMENT_REGISTRATION = "oide_compositefilelement_registration";

    public void start(ElementStartContext context) {
        context.registerChildVisitor(VIEW_TYPE, this._viewTypeHandler);
        context.registerChildVisitor(ELEMENT_CLASS, this._elementClassHandler);
        context.registerChildVisitor(PROXY_CLASS, this._proxyClassHandler);
        context.getScopeData().put(KEY_SCOPE_COMPOSITE_FILE_ELEMENT_REGISTRATION, new CompositeFileElementRegistration());
    }

    public void end(ElementEndContext context) {
        CompositeFileElementRegistration registration = (CompositeFileElementRegistration)context.getScopeData().get(KEY_SCOPE_COMPOSITE_FILE_ELEMENT_REGISTRATION);
        if (registration.getElementClass() == null) {
            throw new NullPointerException();
        }
        if (registration.getProxyClass() == null) {
            throw new NullPointerException();
        }
        CompositeFileElementRegistry.registerCompositeProxy(new MetaClassCompositeFileElementProxy(registration));
    }

    private final class ViewTypeHandler
    extends ElementVisitor {
        private ViewTypeHandler() {
        }

        public void end(ElementEndContext context) {
            ((CompositeFileElementRegistration)context.getScopeData().get(CompositeFileElementHook.KEY_SCOPE_COMPOSITE_FILE_ELEMENT_REGISTRATION)).setViewType(context.getText());
        }
    }

    private final class ElementClassHandler
    extends MetaClassVisitor {
        private ElementClassHandler() {
        }

        protected void metaClass(ElementContext context, MetaClass mc) {
            ((CompositeFileElementRegistration)context.getScopeData().get(CompositeFileElementHook.KEY_SCOPE_COMPOSITE_FILE_ELEMENT_REGISTRATION)).setElementClass((MetaClass<? extends Element>)mc);
        }
    }

    private final class ProxyClassHandler
    extends MetaClassVisitor {
        private ProxyClassHandler() {
        }

        protected void metaClass(ElementContext context, MetaClass mc) {
            ((CompositeFileElementRegistration)context.getScopeData().get(CompositeFileElementHook.KEY_SCOPE_COMPOSITE_FILE_ELEMENT_REGISTRATION)).setProxyClass((MetaClass<? extends CompositeFileElementProxy>)mc);
        }
    }

    private final class CompositeFileElementRegistration {
        private String _viewType;
        private MetaClass<? extends Element> _elementClass;
        private MetaClass<? extends CompositeFileElementProxy> _proxyClass;

        private CompositeFileElementRegistration() {
        }

        final void setViewType(String _viewType) {
            this._viewType = _viewType;
        }

        final String getViewType() {
            return this._viewType;
        }

        final void setElementClass(MetaClass<? extends Element> _elementClass) {
            this._elementClass = _elementClass;
        }

        final MetaClass<? extends Element> getElementClass() {
            return this._elementClass;
        }

        final void setProxyClass(MetaClass<? extends CompositeFileElementProxy> _proxyClass) {
            this._proxyClass = _proxyClass;
        }

        final MetaClass<? extends CompositeFileElementProxy> getProxyClass() {
            return this._proxyClass;
        }
    }

    private final class MetaClassCompositeFileElementProxy
    extends BaseCompositeFileElementProxy {
        private CompositeFileElementRegistration _registration;
        private CompositeFileElementProxy _delegate;

        MetaClassCompositeFileElementProxy(CompositeFileElementRegistration registration) {
            this._registration = registration;
        }

        @Override
        final MetaClass<? extends Element> getCompositeElementMetaClass() {
            return this._registration.getElementClass();
        }

        @Override
        public String getViewType() {
            return this._registration.getViewType();
        }

        @Override
        public final URL[] getCompositeFileURLs(Element compositeElement) {
            this.createDelegate();
            return this._delegate.getCompositeFileURLs(compositeElement);
        }

        private final void createDelegate() {
            if (this._delegate != null) {
                return;
            }
            this._delegate = Util.createInstance(this._registration.getProxyClass(), CompositeFileElementProxy.class);
            if (this._delegate == null) {
                this._delegate = new BaseCompositeFileElementProxy(){

                    @Override
                    public final URL[] getCompositeFileURLs(Element compositeElement) {
                        return null;
                    }
                };
            }
        }
    }
}

