/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide;

import java.awt.Component;
import java.awt.Container;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.MouseEvent;
import java.io.File;
import java.net.URL;
import java.util.Map;
import javax.swing.JList;
import javax.swing.JTree;
import javax.swing.JViewport;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeClipboard;
import oracle.ide.IdeMainWindow;
import oracle.ide.NotImplementedCommandException;
import oracle.ide.controller.AsynchronousController;
import oracle.ide.controller.Command;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.JFastTreeTable;
import oracle.ide.controls.StatusBar;
import oracle.ide.controls.Toolbar;
import oracle.ide.editor.EditorManager;
import oracle.ide.explorer.ExplorerManager;
import oracle.ide.feedback.FeedbackManager;
import oracle.ide.log.LogManager;
import oracle.ide.log.LogPage;
import oracle.ide.log.LogWindow;
import oracle.ide.model.Attributes;
import oracle.ide.model.Element;
import oracle.ide.model.ElementAttributes;
import oracle.ide.model.Locatable;
import oracle.ide.model.Node;
import oracle.ide.model.NodeUtil;
import oracle.ide.model.RelativeDirectoryContextFolder;
import oracle.ide.navigation.NavigationManager;
import oracle.ide.navigator.NavigatorManager;
import oracle.ide.navigator.NavigatorWindow;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.ide.resource.CloseApplicationArb;
import oracle.ide.resource.IdeArb;
import oracle.ide.util.Assert;
import oracle.ide.view.View;
import oracle.javatools.clipboard.ClipboardStack;
import oracle.javatools.data.Dirtyable;
import oracle.javatools.util.SwingClosure;
import org.netbeans.api.progress.ProgressHandle;

final class IdeController
extends AsynchronousController {
    private int _recursiveControllerCheck;
    private static final int RECURSIVE_DETECT_BOUND = 4;

    IdeController() {
        super(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean update(IdeAction action, Context context) {
        try {
            ++this._recursiveControllerCheck;
            Assert.check((this._recursiveControllerCheck < 4 ? 1 : 0) != 0, (String)"infinite recursion detected");
            int cmdId = action.getCommandId();
            if (cmdId == 5) {
                CommandProcessor cmdProc = CommandProcessor.getInstance();
                boolean canUndo = cmdProc.canUndo(context);
                action.setEnabled(canUndo);
                String whatToUndo = canUndo ? cmdProc.getUndoLabel(context) : "";
                action.putValue("Name", StringUtils.stripMnemonic((String)IdeArb.format(80, whatToUndo)));
                boolean bl = true;
                return bl;
            }
            if (cmdId == 6) {
                CommandProcessor cmdProc = CommandProcessor.getInstance();
                boolean canRedo = cmdProc.canRedo(context);
                action.setEnabled(canRedo);
                String whatToRedo = canRedo ? cmdProc.getRedoLabel(context) : "";
                action.putValue("Name", StringUtils.stripMnemonic((String)IdeArb.format(83, whatToRedo)));
                boolean bl = true;
                return bl;
            }
            if (cmdId == 73) {
                NavigationManager mgr = NavigationManager.getNavigationManager();
                boolean canGoBack = mgr != null && mgr.canNavigateBack();
                action.setEnabled(canGoBack);
                boolean whatToRedo = true;
                return whatToRedo;
            }
            if (cmdId == 74) {
                NavigationManager mgr = NavigationManager.getNavigationManager();
                boolean canGoForward = mgr != null && mgr.canNavigateForward();
                action.setEnabled(canGoForward);
                boolean whatToRedo = true;
                return whatToRedo;
            }
            if (cmdId == 75) {
                NavigationManager mgr = NavigationManager.getNavigationManager();
                boolean canGotoLastEdit = mgr != null && mgr.canNavigateToLastEdit();
                action.setEnabled(canGotoLastEdit);
                boolean whatToRedo = true;
                return whatToRedo;
            }
            if (cmdId == 49) {
                action.setEnabled(ExplorerManager.getExplorerManager() != null);
                boolean mgr = true;
                return mgr;
            }
            if (cmdId == 34) {
                action.setEnabled(LogManager.getLogManager() != null);
                boolean mgr = true;
                return mgr;
            }
            if (cmdId == 67) {
                action.setEnabled(false);
                boolean mgr = true;
                return mgr;
            }
            if (cmdId == 68) {
                action.setEnabled(false);
                action.setState(false);
                boolean mgr = true;
                return mgr;
            }
            if (cmdId == 0) {
                action.setEnabled(true);
                boolean mgr = true;
                return mgr;
            }
            if (cmdId == 11) {
                boolean canSave = IdeController.canSave(context);
                action.setEnabled(canSave);
                boolean canGotoLastEdit = true;
                return canGotoLastEdit;
            }
            if (cmdId == 12) {
                boolean canSaveAs = IdeController.canSaveAs(context);
                action.setEnabled(canSaveAs);
                boolean canGotoLastEdit = true;
                return canGotoLastEdit;
            }
            if (cmdId == 14) {
                boolean canRename = IdeController.canRename(context);
                action.setEnabled(canRename);
                boolean canGotoLastEdit = true;
                return canGotoLastEdit;
            }
            if (cmdId == 57) {
                boolean canNavigate = IdeController.isLocatableInNavigator(context);
                action.setEnabled(canNavigate);
                boolean canGotoLastEdit = true;
                return canGotoLastEdit;
            }
            if (cmdId == 13) {
                action.setEnabled(true);
                boolean canNavigate = true;
                return canNavigate;
            }
            if (cmdId == 2 || cmdId == 3) {
                boolean enabled = context != null && context.getWorkspace() != null;
                action.setEnabled(enabled);
                boolean canGotoLastEdit = true;
                return canGotoLastEdit;
            }
            if (cmdId == 8) {
                boolean enabled = context != null && context.getProject() != null;
                action.setEnabled(enabled);
                boolean canGotoLastEdit = true;
                return canGotoLastEdit;
            }
            if (cmdId == 48) {
                boolean enabled = this.updateCloseNode(context, action);
                return enabled;
            }
            if (cmdId == 21 || cmdId == 47) {
                action.setEnabled(false);
                boolean enabled = true;
                return enabled;
            }
            if (cmdId == 51) {
                action.setEnabled(false);
            } else {
                if (cmdId == 9 || cmdId == 10 || cmdId == 15 || cmdId == 4 || cmdId == 37 || cmdId == 38) {
                    action.setEnabled(true);
                    boolean enabled = true;
                    return enabled;
                }
                if (cmdId == 36) {
                    IdeMainWindow mainWindow = Ide.getMainWindow();
                    View mainWindowView = mainWindow.getIdeMainWindowView();
                    Toolbar toolbar = mainWindowView.getToolbar();
                    action.setState(toolbar.isVisible());
                    action.setEnabled(true);
                    boolean bl = true;
                    return bl;
                }
                if (cmdId == 69) {
                    IdeMainWindow mainWindow = Ide.getMainWindow();
                    StatusBar statusbar = mainWindow.getStatusBar();
                    action.setEnabled(true);
                    action.setState(statusbar.getGUI().isVisible());
                    boolean toolbar = true;
                    return toolbar;
                }
                if (cmdId == 30 || cmdId == 31) {
                    Controller ctrl;
                    View logPageView;
                    LogPage logPage;
                    LogWindow logWindow = LogManager.getIdeLogWindow();
                    if (logWindow != null && (logPage = logWindow.getPage()) != null && (logPageView = logPage.getLogPageView()) != null && (ctrl = logPageView.getController()) != null && ctrl != this && ctrl.update(action, context)) {
                        boolean bl = true;
                        return bl;
                    }
                    action.setEnabled(false);
                    boolean bl = true;
                    return bl;
                }
                if (cmdId == 17 || cmdId == 18 || cmdId == 19 || cmdId == 78 || cmdId == 81 || cmdId == 82 || cmdId == 22 || cmdId == 35 || cmdId == 40 || cmdId == 41 || cmdId == 42 || cmdId == 43 || cmdId == 54 || cmdId == 55 || cmdId == 84 || cmdId == 85 || cmdId == 86 || cmdId == 87 || cmdId == 88 || cmdId == 89) {
                    action.setEnabled(false);
                    boolean logWindow = true;
                    return logWindow;
                }
                if (cmdId == 20) {
                    if (EditorManager.getEditorManager().getCurrentEditor() != null && EditorManager.getEditorManager().update(action, context)) {
                        boolean logWindow = true;
                        return logWindow;
                    }
                    action.setEnabled(false);
                    boolean logWindow = true;
                    return logWindow;
                }
                if (cmdId == 77) {
                    boolean isEnabled = this.canCopyPath(context);
                    action.setEnabled(isEnabled);
                    boolean bl = true;
                    return bl;
                }
                if (cmdId == 39) {
                    EditorManager editorManager = EditorManager.getEditorManager();
                    boolean bl = editorManager.update(action, context);
                    return bl;
                }
                if (cmdId == 72) {
                    IdeMainWindow mainwindow = Ide.getMainWindow();
                    if (mainwindow.getTimestampMap() == null) {
                        action.setEnabled(false);
                    } else {
                        action.setEnabled(true);
                    }
                    boolean bl = true;
                    return bl;
                }
            }
            if (cmdId == 23 || cmdId == 24 || cmdId == 25 || cmdId == 53 || cmdId == 26 || cmdId == 27 || cmdId == 28 || cmdId == 29 || cmdId == 32 || cmdId == 83 || cmdId == ExplorerManager.SELECT_IN_STRUCTURE_CMD_ID || cmdId == 56 || cmdId == 57 || cmdId == 16) {
                action.setEnabled(false);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            --this._recursiveControllerCheck;
        }
    }

    @AsynchronousController.Handler(ids={13})
    public boolean handleSaveAll(IdeAction action, Context context, AsynchronousController.TaskInfo taskInfo) {
        if (action != null && context != null && taskInfo != null) {
            try {
                CommandProcessor cmdProc = CommandProcessor.getInstance();
                Command command = CommandProcessor.createCommandFromAction(action, context);
                String displayName = StringUtils.stripMnemonic((String)IdeArb.getString(64));
                ProgressHandle handle = taskInfo.createHandle(displayName, false, false);
                handle.start();
                command.setTaskInfo(taskInfo);
                cmdProc.invoke(command);
            }
            catch (Exception e) {
                Assert.printStackTrace((Throwable)e);
            }
            return true;
        }
        return false;
    }

    @AsynchronousController.Handler(ids={11})
    public boolean handleSaveCommand(IdeAction action, Context context, AsynchronousController.TaskInfo taskInfo) {
        if (action != null && context != null && taskInfo != null) {
            try {
                CommandProcessor cmdProc = CommandProcessor.getInstance();
                Command command = CommandProcessor.createCommandFromAction(action, context);
                String displayName = StringUtils.stripMnemonic((String)IdeArb.getString(58));
                ProgressHandle handle = taskInfo.createHandle(displayName, false, false);
                handle.start();
                command.setTaskInfo(taskInfo);
                cmdProc.invoke(command);
            }
            catch (Exception e) {
                Assert.printStackTrace((Throwable)e);
            }
            return true;
        }
        return false;
    }

    @AsynchronousController.Handler(ids={57})
    public boolean handleNavigate(IdeAction action, Context context, AsynchronousController.TaskInfo taskInfo) {
        if (action != null && context != null && taskInfo != null) {
            context.setBoolean("REFRESH_CMD_ID.promptUserWhenNotFound", true);
            context.setBoolean("REFRESH_CMD_ID.expandAndActivateOnFind", true);
            NavigatorManager.getWorkspaceNavigatorManager().getNavigatorWindow().openContext(context);
            return true;
        }
        return false;
    }

    @AsynchronousController.Handler(ids={47})
    public boolean handleRemoveFromDisk(IdeAction action, Context context, AsynchronousController.TaskInfo taskInfo) {
        if (action != null && context != null && taskInfo != null) {
            try {
                CommandProcessor cmdProc = CommandProcessor.getInstance();
                Command command = CommandProcessor.createCommandFromAction(action, context);
                taskInfo.showWaitCursor();
                command.setTaskInfo(taskInfo);
                cmdProc.invoke(command);
            }
            catch (Exception e) {
                Assert.printStackTrace((Throwable)e);
            }
            return true;
        }
        return false;
    }

    @AsynchronousController.Handler(ids={48})
    public boolean handleCloseNodeCommand(IdeAction action, Context context, AsynchronousController.TaskInfo taskInfo) {
        if (action != null && context != null && taskInfo != null) {
            ProgressHandle handle = null;
            try {
                CommandProcessor cmdProc = CommandProcessor.getInstance();
                Command command = CommandProcessor.createCommandFromAction(action, context);
                handle = taskInfo.createHandle(CloseApplicationArb.getString(4), false, false);
                taskInfo.showWaitCursor();
                handle.start();
                command.setTaskInfo(taskInfo);
                cmdProc.invoke(command);
            }
            catch (Exception e) {
                Assert.printStackTrace((Throwable)e);
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean handleEvent(IdeAction action, Context context) {
        if (super.handleEvent(action, context)) {
            return true;
        }
        try {
            ++this._recursiveControllerCheck;
            Assert.check((this._recursiveControllerCheck < 4 ? 1 : 0) != 0, (String)"Infinite recursion detected");
            if (action == null) {
                boolean bl = false;
                return bl;
            }
            CommandProcessor cmdProc = CommandProcessor.getInstance();
            Command command = null;
            int cmdId = action.getCommandId();
            if (cmdId == 5) {
                try {
                    cmdProc.undo(context);
                }
                catch (Exception e) {
                    Assert.printStackTrace((Throwable)e);
                }
                boolean e = true;
                return e;
            }
            if (cmdId == 6) {
                try {
                    cmdProc.redo(context);
                }
                catch (Exception e) {
                    Assert.printStackTrace((Throwable)e);
                }
                boolean e = true;
                return e;
            }
            if (cmdId == 0 || cmdId == 2 || cmdId == 3 || cmdId == 8 || cmdId == 13 || cmdId == 11 || cmdId == 12 || cmdId == 14 || cmdId == 47 || cmdId == 21 || cmdId == 34 || cmdId == 48) {
                command = CommandProcessor.createCommandFromAction(action, context);
            } else {
                if (cmdId == 73) {
                    NavigationManager mgr = NavigationManager.getNavigationManager();
                    if (mgr != null) {
                        try {
                            mgr.navigateBack();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    boolean e = true;
                    return e;
                }
                if (cmdId == 74) {
                    NavigationManager mgr = NavigationManager.getNavigationManager();
                    if (mgr != null) {
                        try {
                            mgr.navigateForward();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    boolean e = true;
                    return e;
                }
                if (cmdId == 75) {
                    NavigationManager mgr = NavigationManager.getNavigationManager();
                    if (mgr != null) {
                        try {
                            mgr.navigateToLastEdit();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    boolean e = true;
                    return e;
                }
                if (cmdId == 49) {
                    ExplorerManager.getExplorerManager().showLastView(context);
                    boolean mgr = true;
                    return mgr;
                }
                if (cmdId == 9) {
                    command = CommandProcessor.createCommandFromAction(action, context);
                    command.setData(action.getValue("UserData"));
                    try {
                        command.doit();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    boolean e = true;
                    return e;
                }
                if (cmdId == 30 || cmdId == 31) {
                    Controller ctrl;
                    View logPageView;
                    LogPage logPage2;
                    LogWindow logWindow = LogManager.getIdeLogWindow();
                    if (logWindow != null && (logPage2 = logWindow.getPage()) != null && (logPageView = logPage2.getLogPageView()) != null && (ctrl = logPageView.getController()) != null && ctrl != this && ctrl.handleEvent(action, context)) {
                        boolean bl = true;
                        return bl;
                    }
                    boolean logPage2 = false;
                    return logPage2;
                }
                if (cmdId == 4) {
                    Ide.quit(action, context);
                    boolean logWindow = true;
                    return logWindow;
                }
                if (cmdId == 36) {
                    View mainWindowView;
                    IdeMainWindow mainWindow = Ide.getMainWindow();
                    Toolbar toolbar = (mainWindowView = mainWindow.getIdeMainWindowView()).getToolbar();
                    mainWindowView.setToolbarVisible(!toolbar.isVisible());
                    boolean ctrl = true;
                    return ctrl;
                }
                if (cmdId == 69) {
                    IdeMainWindow mainWindow;
                    StatusBar statusbar = (mainWindow = Ide.getMainWindow()).getStatusBar();
                    mainWindow.setStatusBarVisible(!statusbar.getGUI().isVisible());
                    boolean toolbar = true;
                    return toolbar;
                }
                if (cmdId == 77) {
                    this.whenCopyPath(context);
                    boolean mainWindow = true;
                    return mainWindow;
                }
                if (cmdId == 39) {
                    EditorManager editorManager = EditorManager.getEditorManager();
                    boolean statusbar = editorManager.handleEvent(action, context);
                    return statusbar;
                }
                if (cmdId == 72) {
                    try {
                        SwingClosure closure = new SwingClosure(true){

                            protected void runImpl() throws Exception {
                                IdeMainWindow mainWindow = Ide.getMainWindow();
                                IdeController.reloadNodes(mainWindow.getTimestampMap(), false, true);
                            }
                        };
                        closure.run();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    boolean e = true;
                    return e;
                }
                if (cmdId == 50) {
                    View active;
                    IdeMainWindow mainWindow = Ide.getMainWindow();
                    View view = active = mainWindow != null ? mainWindow.getLastActiveView() : null;
                    if (active == null) {
                        boolean toolbar = true;
                        return toolbar;
                    }
                    ContextMenu menu = active.getContextMenu();
                    if (menu == null) {
                        Assert.println((String)"Active View returned null for getContextMenu");
                        boolean ctrl = true;
                        return ctrl;
                    }
                    Component comp = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
                    if (comp == null && (comp = active.getGUI()) == null) {
                        Assert.println((String)"Active View returned null for GUI");
                        boolean bl = true;
                        return bl;
                    }
                    int xPos = 0;
                    int yPos = 0;
                    if (comp instanceof JTree) {
                        JTree tree = (JTree)comp;
                        selectionRows = tree.getSelectionRows();
                        if (selectionRows != null) {
                            Rectangle viewRect;
                            Container parent = tree.getParent();
                            if (parent instanceof JViewport) {
                                JViewport viewport = (JViewport)parent;
                                viewRect = viewport.getViewRect();
                            } else {
                                viewRect = tree.getVisibleRect();
                            }
                            for (int i = selectionRows.length - 1; i >= 0; --i) {
                                int selectionRow = selectionRows[i];
                                Rectangle rowBounds = tree.getRowBounds(selectionRow);
                                if (!viewRect.contains(rowBounds.x, rowBounds.y)) continue;
                                xPos = rowBounds.x + rowBounds.height;
                                yPos = rowBounds.y + rowBounds.height;
                                break;
                            }
                        }
                    } else if (comp instanceof JList) {
                        JList list = (JList)comp;
                        selectionRows = list.getSelectedIndices();
                        if (selectionRows != null) {
                            Rectangle viewRect;
                            Container parent = list.getParent();
                            if (parent instanceof JViewport) {
                                JViewport viewport = (JViewport)parent;
                                viewRect = viewport.getViewRect();
                            } else {
                                viewRect = list.getVisibleRect();
                            }
                            for (int i = selectionRows.length - 1; i >= 0; --i) {
                                int selectionRow = selectionRows[i];
                                Rectangle rowBounds = list.getCellBounds(selectionRow, selectionRow);
                                if (!viewRect.contains(rowBounds.x, rowBounds.y)) continue;
                                xPos = rowBounds.x + rowBounds.height;
                                yPos = rowBounds.y + rowBounds.height;
                                break;
                            }
                        }
                    } else if (comp instanceof JFastTreeTable) {
                        JFastTreeTable treeTable = (JFastTreeTable)comp;
                        selectionRows = treeTable.getSelectedRows();
                        if (selectionRows != null) {
                            Rectangle viewRect;
                            int selectedColumn = treeTable.getSelectedColumn();
                            Container parent = treeTable.getParent();
                            if (parent instanceof JViewport) {
                                JViewport viewport = (JViewport)parent;
                                viewRect = viewport.getViewRect();
                            } else {
                                viewRect = treeTable.getVisibleRect();
                            }
                            for (int i = selectionRows.length - 1; i >= 0; --i) {
                                int selectionRow = selectionRows[i];
                                Rectangle rowBounds = treeTable.getCellRect(selectionRow, selectedColumn, true);
                                if (!viewRect.contains(rowBounds.x, rowBounds.y)) continue;
                                xPos = rowBounds.x;
                                yPos = rowBounds.y + rowBounds.height;
                                break;
                            }
                        }
                    } else {
                        Container parent = comp.getParent();
                        if (comp.getParent() instanceof JViewport) {
                            JViewport viewport = (JViewport)parent;
                            Point ptViewPosition = viewport.getViewPosition();
                            xPos += ptViewPosition.x;
                            yPos += ptViewPosition.y;
                        } else {
                            xPos += comp.getX();
                            yPos += comp.getY();
                        }
                    }
                    xPos = Math.max(xPos, 0);
                    yPos = Math.max(yPos, 0);
                    MouseEvent event = new MouseEvent(comp, 502, System.currentTimeMillis(), 0, xPos, yPos, 1, true);
                    Context ctxMenuContext = active.getContext(event);
                    ctxMenuContext.setEvent(event);
                    menu.show(ctxMenuContext);
                    boolean bl = true;
                    return bl;
                }
            }
            if (command != null) {
                try {
                    cmdProc.invoke(command);
                }
                catch (NotImplementedCommandException nice) {
                    String msg = "Command ID " + cmdId + " not implemented";
                    FeedbackManager.reportException(msg, msg, nice);
                }
                catch (Exception e) {
                    Assert.printStackTrace((Throwable)e);
                }
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            --this._recursiveControllerCheck;
        }
    }

    static void reloadNodes(Map<Node, Long> timestampMap, boolean silentReload, boolean manualReload) {
        NodeUtil.reloadBuffers(timestampMap, silentReload, manualReload);
    }

    private boolean updateCloseNode(Context context, IdeAction action) {
        if (context != null) {
            boolean enabled = false;
            Node document = context.getNode();
            if (document == null) {
                Element elem = context.getElement();
                if (elem != null) {
                    if (elem.mayHaveChildren()) {
                        action.putValue("Name", StringUtils.stripMnemonic((String)IdeArb.format(281, IdeArb.getString(288))));
                    } else {
                        action.putValue("Name", StringUtils.stripMnemonic((String)IdeArb.format(281, IdeArb.getString(287))));
                    }
                    if (elem.getAttributes().isSet(ElementAttributes.CLOSEABLE) && elem instanceof Node && ((Node)elem).isOpen()) {
                        enabled = true;
                    }
                }
            } else if (document.getAttributes().isSet(ElementAttributes.CLOSEABLE) && document.isOpen()) {
                enabled = true;
            }
            action.setEnabled(enabled);
        }
        return true;
    }

    private static boolean isLocatableInNavigator(Context context) {
        if (context != null) {
            Node document;
            if (context.getView() instanceof NavigatorWindow) {
                return false;
            }
            NavigatorManager navigatorManager = IdeController.findNavigatorManager();
            if (navigatorManager != null && (document = context.getNode()) != null) {
                return true;
            }
        }
        return false;
    }

    private static boolean canSave(Context context) {
        if (context != null) {
            return IdeController.canSave(context.getElement()) || IdeController.canSave(context.getNode());
        }
        return false;
    }

    private static boolean canSave(Element element) {
        Dirtyable node;
        return element != null && element.getAttributes().isSet(ElementAttributes.SAVEABLE) && element instanceof Dirtyable && (node = (Dirtyable)element).isDirty();
    }

    private static boolean canSaveAs(Context context) {
        boolean ret = false;
        if (context != null) {
            Element[] selection;
            Element element;
            Node document = context.getNode();
            if (document != null && document.getAttributes().isSet(ElementAttributes.EDITOR_SAVEABLE_AS)) {
                ret = true;
            }
            if (!ret && (element = context.getElement()) != null && element.getAttributes().isSet(ElementAttributes.SAVEABLE) && (selection = context.getSelection()) != null && selection.length == 1 && element.getAttributes().isSet(ElementAttributes.SAVEABLE_AS)) {
                ret = true;
            }
        }
        return ret;
    }

    private static boolean canRename(Context context) {
        Element[] selection;
        Element element;
        boolean ret = false;
        if (context != null && (element = context.getElement()) != null && element.getAttributes().isSet(ElementAttributes.SAVEABLE) && (selection = context.getSelection()) != null && selection.length == 1 && element.getAttributes().isSet(ElementAttributes.RENAMEABLE)) {
            ret = true;
        }
        return ret;
    }

    private static boolean isRevertable(Context context) {
        Attributes attributes;
        Node document;
        boolean ret = false;
        if (context != null && (document = context.getNode()) != null && !(attributes = document.getAttributes()).isSet(ElementAttributes.NON_RELOADABLE)) {
            if (document.isDirty()) {
                if (!document.isNew()) {
                    ret = true;
                }
            } else if (URLFileSystem.lastModified((URL)document.getURL()) != document.getUnmodifiedTimestamp()) {
                ret = true;
            }
        }
        return ret;
    }

    private static NavigatorManager findNavigatorManager() {
        NavigatorWindow nw = Ide.getLastActiveNavigator();
        if (nw != null) {
            return nw.getManager();
        }
        return NavigatorManager.getWorkspaceNavigatorManager();
    }

    private boolean canCopyPath(Context context) {
        boolean isEnabled = false;
        if (context != null) {
            Node document = context.getNode();
            if (document != null) {
                isEnabled = true;
            } else {
                Element[] selection = context.getSelection();
                if (selection.length > 0) {
                    isEnabled = true;
                    for (int i = 0; isEnabled && i < selection.length; ++i) {
                        Element element = selection[i];
                        isEnabled = element instanceof Locatable || element instanceof RelativeDirectoryContextFolder;
                    }
                }
            }
        }
        return isEnabled;
    }

    private void whenCopyPath(Context context) {
        String text;
        Node document = context.getNode();
        if (document != null) {
            URL url = document.getURL();
            text = URLFileSystem.getPlatformPathName((URL)url);
        } else {
            StringBuffer stringBuffer = new StringBuffer();
            Element[] selection = context.getSelection();
            if (selection.length > 0) {
                for (int i = 0; i < selection.length; ++i) {
                    Element element = selection[i];
                    if (element instanceof Locatable) {
                        Locatable locatable = (Locatable)((Object)element);
                        URL url = locatable.getURL();
                        String platformPathName = URLFileSystem.getPlatformPathName((URL)url);
                        stringBuffer.append(platformPathName);
                        stringBuffer.append('\n');
                        continue;
                    }
                    if (!(element instanceof RelativeDirectoryContextFolder)) continue;
                    RelativeDirectoryContextFolder folder = (RelativeDirectoryContextFolder)element;
                    URLPath roots = folder.getRootDirectories();
                    String path = folder.getRelativePath();
                    for (URL root : roots) {
                        URL url = URLFactory.newDirURL((URL)root, (String)path);
                        String platformPathName = URLFileSystem.getPlatformPathName((URL)url);
                        if (stringBuffer.length() > 0) {
                            stringBuffer.append(File.pathSeparatorChar);
                        }
                        stringBuffer.append(platformPathName);
                    }
                }
            }
            text = stringBuffer.toString();
        }
        StringSelection ss = new StringSelection(text);
        Clipboard systemClipboard = IdeClipboard.getClipboard();
        ClipboardStack.pushCurrentClipboard();
        systemClipboard.setContents(ss, null);
    }
}

