/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.token;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.javatools.db.token.Token;
import oracle.javatools.db.token.TokenClause;
import oracle.javatools.db.token.TokenClauseInverter;
import oracle.javatools.db.token.TokenClauseOptions;
import oracle.javatools.db.token.TokenClauseParentheses;
import oracle.javatools.db.token.TokenClauseRepeater;
import oracle.javatools.db.token.TokenClauseSequence;
import oracle.javatools.db.token.TokenClauseSingleToken;
import oracle.javatools.db.token.Tokenizer;

public class TokenPattern<T extends Token> {
    private static final String ROOT_CLAUSE_NAME = " ";
    private final List<String> m_names = new ArrayList<String>();
    private TokenClause m_rootClause;
    private TokenClauseRepeater m_repeater;
    private int m_repeaterCount = 0;

    public TokenPattern(String string) {
        Token token;
        if (string == null || string.trim().length() == 0) {
            throw new IllegalArgumentException("empty expression");
        }
        string = string.replaceAll("\\?\\.", "{?[.?]...}");
        string = string.replaceAll("\\(\\.\\.\\.\\)", "(--)");
        Tokenizer.Config config = this.getConfig(string);
        Tokenizer tokenizer = new Tokenizer(config);
        Token token2 = token = tokenizer.getFirst();
        ArrayList<String> arrayList = new ArrayList<String>();
        while (!token2.isEndMarker()) {
            String string2 = token2.getSource();
            Object t = token2.getPrevCodeToken();
            if (((Token)t).matches("<") && !this.isEscapedSingleCharToken((Token)t)) {
                if (this.m_names.contains(string2)) {
                    throw new IllegalArgumentException("repeated name " + string2);
                }
                this.m_names.add(string2);
            }
            if (!this.isEscapedSingleCharToken(token2)) {
                if (string2.equals("{") || string2.equals("[") || string2.equals("<")) {
                    arrayList.add(string2);
                } else if (string2.equals("|")) {
                    if (arrayList.size() == 0 || !((String)arrayList.get(arrayList.size() - 1)).equals("{")) {
                        throw new IllegalArgumentException("| not within {}");
                    }
                } else {
                    if (string2.equals("^") && !((Token)t).matches("{")) {
                        throw new IllegalArgumentException("^ not following {");
                    }
                    if (string2.equals("}")) {
                        if (arrayList.size() == 0 || !((String)arrayList.get(arrayList.size() - 1)).equals("{")) {
                            throw new IllegalArgumentException("{ } mismatch");
                        }
                        arrayList.remove(arrayList.size() - 1);
                    } else if (string2.equals("]")) {
                        if (arrayList.size() == 0 || !((String)arrayList.get(arrayList.size() - 1)).equals("[")) {
                            throw new IllegalArgumentException("[ ] mismatch");
                        }
                        arrayList.remove(arrayList.size() - 1);
                    } else if (string2.equals(">")) {
                        if (arrayList.size() == 0 || !((String)arrayList.get(arrayList.size() - 1)).equals("<")) {
                            throw new IllegalArgumentException("< > mismatch");
                        }
                        arrayList.remove(arrayList.size() - 1);
                    }
                }
            }
            token2 = token2.getNextCodeToken();
        }
        if (arrayList.size() != 0) {
            throw new IllegalArgumentException("ran out of brackets");
        }
        this.m_rootClause = new TokenClauseSequence();
        this.build(this.m_rootClause, token);
    }

    private boolean isEscapedSingleCharToken(Token token) {
        Object t;
        boolean bl = false;
        if (token != null && token.getType() != Token.Type.END_MARKER && token.getStart() == token.getEnd() && this.isEscapeChar((Token)(t = token.getPrevToken()))) {
            bl = true;
        }
        return bl;
    }

    private boolean isEscapeChar(Token token) {
        return token != null & token.isPunctuation() && token.getStart() == token.getEnd() && token.getSource().equals(String.valueOf('\\'));
    }

    protected Tokenizer.Config getConfig(String string) {
        Tokenizer.Config config = new Tokenizer.Config();
        config.setSource(string);
        config.addTokens(Token.Type.USER_TOKEN, Arrays.asList("--", "..."));
        return config;
    }

    public String[] getNames() {
        return this.m_names.toArray(new String[this.m_names.size()]);
    }

    private Token build(TokenClause tokenClause, Token token) {
        Token token2 = token;
        while (token2.getType() != Token.Type.END_MARKER) {
            boolean bl = this.isEscapedSingleCharToken(token2);
            if (!bl && (token2.matches("}") || token2.matches(">") || token2.matches("]") || token2.matches("|"))) {
                return token2;
            }
            if (!bl && (token2.matches("{") || token2.matches("["))) {
                TokenClauseSequence tokenClauseSequence;
                boolean bl2 = false;
                if (((Token)token2.getNextCodeToken()).matches("^")) {
                    bl2 = true;
                    token2 = token2.getNextCodeToken();
                }
                var6_8 = new TokenClauseOptions();
                while (!token2.matches("}") && !token2.matches("]")) {
                    tokenClauseSequence = new TokenClauseSequence();
                    ((TokenClause)var6_8).addChildClause(tokenClauseSequence);
                    token2 = this.build(tokenClauseSequence, (Token)token2.getNextCodeToken());
                }
                if (token2.matches("]")) {
                    tokenClauseSequence = new TokenClauseSequence();
                    ((TokenClause)var6_8).addChildClause(tokenClauseSequence);
                    var6_8.setOptional(true);
                }
                if (bl2) {
                    var6_8 = new TokenClauseInverter(var6_8);
                }
                if (((Token)token2.getNextCodeToken()).matches("...")) {
                    this.m_repeater = new TokenClauseRepeater(var6_8);
                    ++this.m_repeaterCount;
                    var6_8 = this.m_repeater;
                    token2 = token2.getNextCodeToken();
                }
                tokenClause.addChildClause(var6_8);
            } else if (!bl && token2.matches("<")) {
                TokenClauseSequence tokenClauseSequence = new TokenClauseSequence();
                tokenClause.addChildClause(tokenClauseSequence);
                tokenClauseSequence.setKnownAs(((Token)token2.getNextCodeToken()).getSource());
                token2 = this.build(tokenClauseSequence, (Token)token2.getNextCodeToken(2));
            } else if (token2.getType() == Token.Type.PUNCTUATION && ((Token)token2.getNextCodeToken()).matches("--") && ((Token)token2.getNextCodeToken(2)).getType() == Token.Type.PUNCTUATION) {
                Object t = token2.getNextCodeToken(2);
                if (this.isEscapeChar((Token)t)) {
                    t = ((Token)t).getNextCodeToken();
                }
                var6_8 = new TokenClauseParentheses(token2.getSource(), ((Token)t).getSource());
                tokenClause.addChildClause(var6_8);
                token2 = t;
            } else if (!this.isEscapedSingleCharToken((Token)token2.getNextToken())) {
                tokenClause.addChildClause(new TokenClauseSingleToken(token2));
            }
            token2 = token2.getNextCodeToken();
        }
        return token2;
    }

    public PatternResult getResult(String string) {
        return this.getResult(string, true);
    }

    public PatternResult getResult(String string, boolean bl) {
        Tokenizer.Config config = new Tokenizer.Config();
        config.setSource(string);
        Tokenizer tokenizer = new Tokenizer(config);
        Token token = tokenizer.getFirst();
        return this.getResult((T)token, (T)bl);
    }

    public PatternResult getResult(T t) {
        return this.getResult(t, (T)true);
    }

    public PatternResult getResult(T t, boolean bl) {
        return this.getResult(t, null, bl);
    }

    public PatternResult getResult(T t, T t2) {
        return this.getResult(t, t2, true);
    }

    public PatternResult getResult(T t, T t2, boolean bl) {
        PatternResult patternResult = null;
        TokenClause.ClauseResult clauseResult = null;
        T t3 = t;
        Integer n = null;
        while (!(t3 == null || ((Token)t3).isEndMarker() || t2 != null && ((Token)t2).getEnd() < ((Token)t3).getStart())) {
            patternResult = new PatternResult((Token)t2);
            patternResult.setMaxRepeats(n);
            clauseResult = this.m_rootClause.matches(patternResult, (Token)t3);
            if (clauseResult.isMatch()) {
                patternResult.recordResult(ROOT_CLAUSE_NAME, clauseResult);
                break;
            }
            if (this.m_repeaterCount == 1 && patternResult.getNumRepeats() != null && patternResult.getNumRepeats() > 1) {
                n = patternResult.getNumRepeats() - 1;
                continue;
            }
            patternResult = null;
            n = null;
            if (bl) break;
            t3 = ((Token)t3).getNextCodeToken();
        }
        return patternResult;
    }

    public class PatternResult {
        private final Token m_endToken;
        private Token m_lastOKToken = null;
        private final Map<String, TokenClause.ClauseResult> m_namedResults = new HashMap<String, TokenClause.ClauseResult>();
        private Integer m_numRepeats;
        private Integer m_maxRepeats;

        void setNumRepeats(Integer n) {
            this.m_numRepeats = n;
        }

        Integer getNumRepeats() {
            return this.m_numRepeats;
        }

        void setMaxRepeats(Integer n) {
            this.m_maxRepeats = n;
        }

        Integer getMaxRepeats() {
            return this.m_maxRepeats;
        }

        PatternResult(Token token) {
            this.m_endToken = token;
        }

        void recordResult(String string, TokenClause.ClauseResult clauseResult) {
            this.m_namedResults.put(string, clauseResult);
        }

        public final String getNamedMatch(String string) {
            return this.getNamedMatch(string, true);
        }

        public final String getNamedMatch(String string, boolean bl) {
            TokenClause.ClauseResult clauseResult = this.m_namedResults.get(string);
            if (clauseResult != null) {
                Token token = clauseResult.getStartToken();
                Token token2 = clauseResult.getEndToken();
                return token.getSource(bl, token2);
            }
            return null;
        }

        public final T getNamedMatchStartToken(String string) {
            TokenClause.ClauseResult clauseResult = this.m_namedResults.get(string);
            if (clauseResult != null) {
                return clauseResult.getStartToken();
            }
            return null;
        }

        public final T getNamedMatchEndToken(String string) {
            TokenClause.ClauseResult clauseResult = this.m_namedResults.get(string);
            if (clauseResult != null) {
                return clauseResult.getEndToken();
            }
            return null;
        }

        public T getStartToken() {
            return this.getNamedMatchStartToken(TokenPattern.ROOT_CLAUSE_NAME);
        }

        public T getEndToken() {
            return this.getNamedMatchEndToken(TokenPattern.ROOT_CLAUSE_NAME);
        }

        void setLastOKToken(Token token) {
            if (token != null && (this.m_lastOKToken == null || this.m_lastOKToken.getStart() < token.getStart())) {
                this.m_lastOKToken = token;
            }
        }

        public int getTokenCount() {
            Object t = this.getStartToken();
            int n = 0;
            if (this.m_lastOKToken != null && t != null) {
                n = 1;
                while (t != this.m_lastOKToken) {
                    t = ((Token)t).getNextCodeToken();
                    ++n;
                }
            }
            return n;
        }

        boolean isWithinRange(Token token) {
            if (token == null) {
                return false;
            }
            if (token.getType() == Token.Type.END_MARKER) {
                return false;
            }
            return this.m_endToken == null || this.m_endToken.getStart() >= token.getStart();
        }
    }
}

