/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.migration.applications.rules;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import oracle.dbtools.raptor.migration.applications.cmdline.ScannerDetails;
import oracle.dbtools.raptor.migration.applications.rules.RulesRegistry;
import oracle.dbtools.raptor.migration.applications.rules.parser.Regex;
import oracle.dbtools.raptor.migration.applications.rules.parser.RuleSet;

public class Rules {
    public static final String UNKNOWN = "UNKNOWN";
    public static final String ANY = "ANY";
    private HashMap<String, HashMap<String, ArrayList<RuleSet>>> m_rules = new HashMap();
    private static Rules _instance;

    Rules() {
    }

    public static Rules getInstance() {
        if (_instance == null) {
            _instance = new Rules();
        }
        return _instance;
    }

    public void addRule(String string, RuleSet ruleSet) {
        if (this.m_rules.containsKey(string)) {
            HashMap<String, ArrayList<RuleSet>> hashMap = this.m_rules.get(string);
            if (!hashMap.containsKey(ruleSet.getSource().toLowerCase())) {
                ArrayList<RuleSet> arrayList = new ArrayList<RuleSet>();
                arrayList.add(ruleSet);
                hashMap.put(ruleSet.getSource().toLowerCase(), arrayList);
            } else {
                ArrayList<RuleSet> arrayList = hashMap.get(ruleSet.getSource().toLowerCase());
                arrayList.add(ruleSet);
            }
        } else {
            HashMap hashMap = new HashMap();
            ArrayList<RuleSet> arrayList = new ArrayList<RuleSet>();
            arrayList.add(ruleSet);
            hashMap.put(ruleSet.getSource().toLowerCase(), arrayList);
            this.m_rules.put(string, hashMap);
        }
    }

    public HashMap<String, ArrayList<RuleSet>> getRules4Type(String string) {
        if (this.m_rules != null) {
            return this.m_rules.get(string);
        }
        return null;
    }

    public ArrayList<Regex> getRecognizers(String string) {
        ArrayList<Regex> arrayList = new ArrayList<Regex>();
        Set<Map.Entry<String, ArrayList<RuleSet>>> set = this.getRules4Type(string).entrySet();
        Iterator<Map.Entry<String, ArrayList<RuleSet>>> iterator = set.iterator();
        while (iterator.hasNext()) {
            ArrayList<RuleSet> arrayList2 = iterator.next().getValue();
            for (RuleSet ruleSet : arrayList2) {
                if (!ruleSet.isRecognizer()) continue;
                arrayList.addAll(ruleSet.getExpressions());
            }
        }
        return arrayList;
    }

    public ArrayList<RuleSet> getRulesByType(String string, String string2) {
        if (this.getRules4Type(string) != null && this.getRules4Type(string).get(string2) != null) {
            return this.getRules4Type(string).get(string2);
        }
        return null;
    }

    public ArrayList<RuleSet> getRule(String string, String string2) {
        ArrayList<RuleSet> arrayList = null;
        if (this.m_rules == null) {
            return null;
        }
        if (this.m_rules.get(string) != null && this.m_rules.get(string).get(string2) != null) {
            arrayList = this.m_rules.get(string).get(string2);
        }
        return arrayList;
    }

    public String[] getDBTypes() {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.m_rules.isEmpty()) {
            RulesRegistry.getInstance().loadXML(ScannerDetails.getInstance());
        }
        Set<String> set = this.m_rules.keySet();
        Iterator<String> iterator = set.iterator();
        while (iterator.hasNext()) {
            arrayList.add(iterator.next());
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }
}

