/*
 * Decompiled with CFR 0.152.
 */
package oracle.core.ojdl.weblogic;

import java.util.logging.Handler;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import oracle.core.ojdl.logging.impl.MessageIdSupport;
import oracle.core.ojdl.weblogic.LogRecordMapper;
import weblogic.logging.LoggingHelper;

public class DomainLogHandler
extends Handler {
    private static final String TARGET_HANDLER_NAME = "weblogic.logging.DomainLogBroadcastHandler";
    private Handler m_targetHandler;
    private MessageIdSupport m_msgIdSupport = new MessageIdSupport();
    private LogRecordMapper m_mapper = new LogRecordMapper();

    public DomainLogHandler() {
        Logger serverLogger = LoggingHelper.getServerLogger();
        if (serverLogger != null) {
            for (Handler h : serverLogger.getHandlers()) {
                if (!TARGET_HANDLER_NAME.equals(h.getClass().getName())) continue;
                this.m_targetHandler = h;
                break;
            }
        }
        if (this.m_targetHandler == null) {
            this.reportError(DomainLogHandler.class.getName() + " ERROR: unable to find instance of " + TARGET_HANDLER_NAME, null, 0);
        }
    }

    @Override
    public void close() {
        this.flush();
    }

    @Override
    public void flush() {
        if (this.m_targetHandler != null) {
            this.m_targetHandler.flush();
        }
    }

    @Override
    public void publish(LogRecord rec) {
        if (this.m_targetHandler == null || !this.isLoggable(rec)) {
            return;
        }
        try {
            this.m_targetHandler.publish((LogRecord)this.m_mapper.toWLLogRecord(rec));
        }
        catch (Exception e) {
            this.reportError("", e, 1);
        }
    }
}

