/*
 * Decompiled with CFR 0.152.
 */
package oracle.core.ojdl.logging.jmx;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import oracle.core.ojdl.logging.ODLLevel;
import oracle.core.ojdl.logging.jmx.LogRuntimeMBean;

public class LogRuntime
implements LogRuntimeMBean {
    private boolean m_createLoggers;

    public LogRuntime() {
        try {
            this.m_createLoggers = System.getProperty(this.getClass().getName() + ".createLoggers", "true").equals("true");
        }
        catch (Exception e) {
            this.m_createLoggers = true;
        }
    }

    @Override
    public List<String> getLoggerNames() {
        return this.getLoggerNames(null);
    }

    @Override
    public List<String> getLoggerNames(String pattern) {
        TreeSet<String> loggerNames = new TreeSet<String>();
        Pattern p = pattern != null ? Pattern.compile(pattern) : null;
        Enumeration<String> e = LogManager.getLogManager().getLoggerNames();
        while (e.hasMoreElements()) {
            String loggerName = e.nextElement();
            if (p == null) {
                loggerNames.add(loggerName);
                continue;
            }
            if (!p.matcher(loggerName).matches()) continue;
            loggerNames.add(loggerName);
        }
        return this.createLoggers(loggerNames, p);
    }

    @Override
    public Map<String, String> getLoggerLevels(String pattern) {
        List<String> loggerNames = this.getLoggerNames(pattern);
        TreeMap<String, String> map = new TreeMap<String, String>();
        for (String loggerName : loggerNames) {
            String level = this.getLoggerLevel(loggerName);
            if (level == null) continue;
            map.put(loggerName, level);
        }
        return map;
    }

    @Override
    public String getLoggerLevel(String loggerName) {
        Logger logger = LogManager.getLogManager().getLogger(loggerName);
        if (logger == null) {
            return null;
        }
        Level l = logger.getLevel();
        if (l != null) {
            return ODLLevel.toString(l);
        }
        return "";
    }

    @Override
    public void setLoggerLevel(String loggerName, String levelName) {
        if (levelName == null || levelName.length() == 0 || "null".equalsIgnoreCase(levelName)) {
            Logger.getLogger(loggerName).setLevel(null);
        } else {
            Logger.getLogger(loggerName).setLevel(ODLLevel.parse(levelName));
        }
    }

    @Override
    public void setLoggerLevel(String[] loggerNames, String[] levelNames) {
        if (loggerNames == null || levelNames == null || loggerNames.length != levelNames.length) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < loggerNames.length; ++i) {
            this.setLoggerLevel(loggerNames[i], levelNames[i]);
        }
    }

    @Override
    public String getParentLoggerName(String loggerName) {
        Logger logger = Logger.getLogger(loggerName);
        Logger parent = logger.getParent();
        if (parent != null) {
            return parent.getName();
        }
        return null;
    }

    private List<String> createLoggers(Set<String> loggerNames, Pattern pattern) {
        if (!this.m_createLoggers) {
            return new ArrayList<String>(loggerNames);
        }
        ArrayList<String> list = new ArrayList<String>(loggerNames.size());
        for (String loggerName : loggerNames) {
            String s;
            List<String> names = this.parseName(loggerName);
            if (names.size() > 0 && !loggerNames.contains(s = names.get(0)) && (pattern == null || pattern.matcher(s).matches())) {
                Logger.getLogger(s);
                list.add(s);
            }
            if (names.size() > 1 && "oracle".equals(names.get(0)) && !loggerNames.contains(s = names.get(0) + "." + names.get(1)) && (pattern == null || pattern.matcher(s).matches())) {
                Logger.getLogger(s);
                list.add(s);
            }
            list.add(loggerName);
        }
        return list;
    }

    private List<String> parseName(String name) {
        ArrayList<String> list = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(name, ".");
        while (st.hasMoreTokens()) {
            list.add(st.nextToken());
        }
        return list;
    }
}

