/*
 * Decompiled with CFR 0.152.
 */
package oracle.core.ojdl.logging;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import oracle.core.ojdl.LogFormatter;
import oracle.core.ojdl.LogMessage;
import oracle.core.ojdl.MessageType;
import oracle.core.ojdl.logging.ODLHandler;
import oracle.core.ojdl.logging.ODLLevel;
import oracle.core.ojdl.logging.ODLLogRecord;
import oracle.core.ojdl.logging.QuickTraceBuffer;
import oracle.core.ojdl.logging.QuickTraceHandler;
import oracle.core.ojdl.logging.QuickTraceHandlerFactory;
import oracle.core.ojdl.logging.context.LoggingContext;
import oracle.core.ojdl.logging.context.LoggingContextManager;
import oracle.core.ojdl.logging.impl.MessageIdSupport;
import oracle.dms.instrument.Noun;

class QuickTraceCacheByValHandler
extends QuickTraceHandler {
    public static final String DEFAULT_ENCODING = "UTF-8";
    public static final int BOOLEAN_LEN = 1;
    public static final int UNSIGNEDINT_LEN = 4;
    public static final int UNSIGNEDLONG_LEN = 8;
    private static final byte[] QUICKTRACE_RECORD_SIGNATURE = new byte[]{0, 1, 2, 3, 4, 6, 7, 8};
    private static final int DISK_IO_BUFFER_SIZE = 65536;
    private MessageIdSupport msgIdSupport_ = new MessageIdSupport();
    private QuickTraceBuffer defBuf_;
    private Hashtable<String, QuickTraceBuffer> userBufs_ = new Hashtable();

    QuickTraceCacheByValHandler(LogFormatter formatter, long bufferSize, int fieldLength, boolean useLoggingContext, QuickTraceHandler.Mode mode, boolean enableDMSMetrics, Noun nounRoot, boolean bufferPerUser, boolean flushOnDump) {
        super(formatter, bufferSize, fieldLength, null, useLoggingContext, mode, enableDMSMetrics, nounRoot, bufferPerUser, flushOnDump);
        this.createDefaulfBuffer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        this.m_rwLock.writeLock().lock();
        try {
            this.closed_ = true;
        }
        finally {
            this.m_rwLock.writeLock().unlock();
        }
        QuickTraceHandlerFactory.removeHandler(this);
    }

    private QuickTraceBuffer createDefaulfBuffer() {
        this.defBuf_ = new QuickTraceBuffer("COMMON", this.bufferSize_);
        return this.defBuf_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private QuickTraceBuffer createUserBuffer(String name) {
        QuickTraceBuffer buffer = new QuickTraceBuffer(name, this.bufferSize_);
        Hashtable<String, QuickTraceBuffer> hashtable = this.userBufs_;
        synchronized (hashtable) {
            this.userBufs_.put(name, buffer);
            super.createDMSSensors(name);
        }
        return buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private QuickTraceBuffer getUserBuffer(String name, boolean createAsNeed) {
        QuickTraceBuffer buffer = null;
        Hashtable<String, QuickTraceBuffer> hashtable = this.userBufs_;
        synchronized (hashtable) {
            if (name == null || name.length() == 0 || createAsNeed && this.reserveBufferIDs_ == null) {
                return null;
            }
            if (createAsNeed) {
                boolean found = false;
                for (String id : this.reserveBufferIDs_) {
                    if (!name.equals(id)) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    return null;
                }
            }
            if ((buffer = this.userBufs_.get(name)) == null && createAsNeed) {
                buffer = this.createUserBuffer(name);
                this.userBufs_.put(name, buffer);
            }
        }
        return buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void setReserveBufferIDs(String[] ids) {
        if (ids == null || ids.length == 0) {
            return;
        }
        Hashtable<String, QuickTraceBuffer> hashtable = this.userBufs_;
        synchronized (hashtable) {
            String[] oldIds = this.reserveBufferIDs_;
            super.setReserveBufferIDs(ids);
            if (oldIds != null) {
                for (String oldId : oldIds) {
                    boolean found = false;
                    for (String id : ids) {
                        if (!oldId.equals(id)) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    this.destroyDMSSensor(oldId);
                    this.userBufs_.remove(oldId);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void publish(LogRecord rec, ODLHandler.RecursionCounter recursionCounter) {
        Object[] keys;
        String messageProblemKey;
        String[] supplAttrValues;
        String[] supplAttrNames;
        String messageDetailLoc;
        String errorId;
        String ecidRid;
        String ecid;
        String appName;
        String userId;
        String[] messageArgs;
        String supplDet;
        String messageId;
        String messageText;
        String sourceMethodName;
        String sourceClassName;
        long sequenceNumber;
        String loggerName;
        String recLevelStr;
        long millis;
        QuickTraceBuffer buffer;
        HashMap<Object, String> supplAttrs;
        ODLLogRecord orec;
        String threadId;
        int len;
        int size;
        block97: {
            size = 0;
            len = 0;
            int recLevelValue = rec.getLevel().intValue();
            threadId = null;
            orec = null;
            supplAttrs = null;
            Map recSupplAttrs = null;
            buffer = null;
            if (this.levelValue_ == OFF || recLevelValue < this.levelValue_ || this.closed_) {
                return;
            }
            if (rec instanceof ODLLogRecord) {
                orec = (ODLLogRecord)rec;
                recSupplAttrs = orec.getSupplAttributes();
            }
            size += QUICKTRACE_RECORD_SIGNATURE.length;
            size += 4;
            millis = rec.getMillis();
            size += 8;
            recLevelStr = rec.getLevel().getName();
            if (recLevelStr != null) {
                len = recLevelStr.length();
                size += len;
            }
            size += 4;
            loggerName = rec.getLoggerName();
            if (loggerName != null) {
                len = loggerName.length();
                size += len;
            }
            size += 4;
            sequenceNumber = rec.getSequenceNumber();
            size += 8;
            sourceClassName = null;
            sourceMethodName = null;
            if (recLevelValue <= this.sourceClassAndMethodLevelValue_) {
                sourceClassName = rec.getSourceClassName();
                if (sourceClassName != null) {
                    len = sourceClassName.length();
                    if (this.fieldLen_ >= 0 && len > this.fieldLen_) {
                        sourceClassName = sourceClassName.substring(0, this.fieldLen_);
                        len = this.fieldLen_;
                    }
                    size += len;
                }
                if ((sourceMethodName = rec.getSourceMethodName()) != null) {
                    len = sourceMethodName.length();
                    if (this.fieldLen_ >= 0 && len > this.fieldLen_) {
                        sourceMethodName = sourceMethodName.substring(0, this.fieldLen_);
                        len = this.fieldLen_;
                    }
                    size += len;
                }
            }
            size += 4;
            size += 4;
            threadId = this.useThreadName_ ? Thread.currentThread().getName() : (this.useRealThreadId_ ? Long.toString(Thread.currentThread().getId()) : Integer.toString(rec.getThreadID()));
            len = threadId.length();
            if (this.fieldLen_ >= 0 && len > this.fieldLen_) {
                threadId = threadId.substring(0, this.fieldLen_);
                len = this.fieldLen_;
            }
            size += len;
            size += 4;
            messageText = null;
            messageId = null;
            String s = rec.getMessage();
            ResourceBundle bundle = rec.getResourceBundle();
            if (bundle != null) {
                try {
                    Locale locale = super.getLocale();
                    if (locale != null && !Locale.getDefault().equals(locale)) {
                        try {
                            bundle = this.getResourceBundle(rec.getResourceBundleName(), bundle, locale);
                        }
                        catch (Exception e) {
                            locale = null;
                        }
                    }
                    if (bundle.containsKey(s)) {
                        messageText = bundle.getString(s);
                        if (orec != null && orec.getMessageId() == null) {
                            messageId = this.msgIdSupport_.getMessageId(bundle, s);
                        }
                    } else {
                        messageText = s;
                    }
                    if (messageId == null && orec != null) {
                        messageId = orec.getMessageId();
                    }
                }
                catch (Exception e) {
                    messageText = s;
                }
            } else {
                if (orec != null) {
                    messageId = orec.getMessageId();
                }
                messageText = s;
            }
            if (messageId != null) {
                len = messageId.length();
                if (this.fieldLen_ >= 0 && len > this.fieldLen_) {
                    messageId = messageId.substring(0, this.fieldLen_);
                    len = this.fieldLen_;
                }
                size += len;
            }
            size += 4;
            supplDet = null;
            Throwable th = rec.getThrown();
            if (th != null) {
                supplDet = super.getODLFormatter().writeStackTrace(th);
            }
            if (supplDet != null) {
                len = supplDet.length();
                size += len;
            }
            size += 4;
            messageArgs = null;
            Object[] parameters = rec.getParameters();
            if (parameters != null && parameters.length > 0) {
                if (messageText != null && messageText.indexOf("{") >= 0) {
                    try {
                        messageText = MessageFormat.format(messageText, parameters);
                    }
                    catch (Exception e) {
                        messageText = messageText + e.getMessage();
                    }
                }
                if (super.getIncludeMessageArguments() && messageId != null) {
                    messageArgs = new String[parameters.length];
                    for (int k = 0; k < parameters.length; ++k) {
                        String string = messageArgs[k] = parameters[k] != null ? parameters[k].toString() : null;
                        if (messageArgs[k] != null) {
                            len = messageArgs[k].length();
                            if (this.fieldLen_ >= 0 && len > this.fieldLen_) {
                                messageArgs[k] = messageArgs[k].substring(0, this.fieldLen_);
                                len = this.fieldLen_;
                            }
                            size += len;
                        }
                        size += 4;
                    }
                }
            }
            size += 4;
            if (messageText != null) {
                len = messageText.length();
                if (this.fieldLen_ >= 0 && len > this.fieldLen_) {
                    messageText = messageText.substring(0, this.fieldLen_);
                    len = this.fieldLen_;
                }
                size += len;
            }
            size += 4;
            boolean isInternalCtx = false;
            isInternalCtx = this.useLoggingContext_ && recursionCounter != null ? recursionCounter.enterInternalCtx() : false;
            userId = null;
            size += 4;
            appName = null;
            size += 4;
            ecid = null;
            size += 4;
            ecidRid = null;
            size += 4;
            errorId = null;
            size += 4;
            messageDetailLoc = null;
            size += 4;
            supplAttrNames = null;
            size += 4;
            supplAttrValues = null;
            size += 4;
            messageProblemKey = null;
            size += 4;
            try {
                if (this.userContext_ != null && !isInternalCtx && (userId = this.userContext_.getUserName()) != null) {
                    len = userId.length();
                    if (this.fieldLen_ >= 0 && len > this.fieldLen_) {
                        userId = userId.substring(0, this.fieldLen_);
                        len = this.fieldLen_;
                    }
                    size += len;
                }
                if (this.appContext_ != null && this.useLoggingContext_ && !isInternalCtx && (appName = this.appContext_.getApplicationName()) != null) {
                    len = appName.length();
                    if (this.fieldLen_ >= 0 && len > this.fieldLen_) {
                        appName = appName.substring(0, this.fieldLen_);
                        len = this.fieldLen_;
                    }
                    size += len;
                }
                LoggingContext ctx = null;
                if (!this.useLoggingContext_ || isInternalCtx) break block97;
                if (orec != null) {
                    ctx = orec.getLoggingContext();
                }
                if (ctx == null) {
                    try {
                        ctx = LoggingContextManager.getLoggingContext(loggerName);
                    }
                    catch (Exception e) {
                        ctx = null;
                    }
                }
                if (ctx != null) {
                    Set<String> logKeys;
                    String[] configSupplAttrNames;
                    ecid = ctx.getECID();
                    if (ecid != null) {
                        len = ecid.length();
                        size += len;
                    }
                    if ((ecidRid = ctx.getRID()) != null) {
                        len = ecidRid.length();
                        size += len;
                    }
                    if ((configSupplAttrNames = super.getODLFormatter().getSupplementalAttributes()) != null) {
                        if (supplAttrs == null) {
                            supplAttrs = new HashMap<Object, String>();
                        }
                        for (int k = 0; k < configSupplAttrNames.length; ++k) {
                            String attrValue;
                            String attrName = configSupplAttrNames[k];
                            if (recSupplAttrs != null && recSupplAttrs.containsKey(attrName) || (attrValue = ctx.getAttributeValue(attrName)) == null) continue;
                            if (supplAttrs == null) {
                                supplAttrs = new HashMap();
                            }
                            supplAttrs.put(attrName, attrValue);
                        }
                    }
                    if ((logKeys = ctx.getLoggableAttributes()) != null && logKeys.size() > 0) {
                        if (supplAttrs == null) {
                            supplAttrs = new HashMap();
                        }
                        for (String logKey : logKeys) {
                            String val = ctx.getAttributeValue(logKey);
                            if (val == null) continue;
                            supplAttrs.put(logKey, val);
                        }
                    }
                }
            }
            finally {
                if (this.useLoggingContext_ && recursionCounter != null) {
                    recursionCounter.exitInternalCtx();
                }
            }
        }
        if (orec != null) {
            int attrSize;
            Map attrs;
            errorId = orec.getErrorInstanceId();
            if (errorId != null) {
                size += errorId.length();
            }
            if ((messageDetailLoc = orec.getDetailLocation()) != null) {
                len = messageDetailLoc.length();
                if (this.fieldLen_ >= 0 && len > this.fieldLen_) {
                    messageDetailLoc = messageDetailLoc.substring(0, this.fieldLen_);
                    len = this.fieldLen_;
                }
                size += len;
            }
            if ((messageProblemKey = orec.getProblemKey()) != null) {
                len = messageProblemKey.length();
                if (this.fieldLen_ >= 0 && len > this.fieldLen_) {
                    messageProblemKey = messageProblemKey.substring(0, this.fieldLen_);
                    len = this.fieldLen_;
                }
                size += len;
            }
            if ((attrs = orec.getSupplAttributes()) != null) {
                if (supplAttrs == null) {
                    supplAttrs = new HashMap();
                }
                supplAttrs.putAll(attrs);
            }
            keys = orec.getSupplAttributeKeys();
            String[] values = orec.getSupplAttributeValues();
            if (keys != null && values != null && (attrSize = Math.min(keys.length, values.length)) > 0) {
                if (supplAttrs == null) {
                    supplAttrs = new HashMap();
                }
                for (int i = 0; i < attrSize; ++i) {
                    if (keys[i] == null || values[i] == null) continue;
                    supplAttrs.put(keys[i], values[i]);
                    if (!this.enableUserBuffer_ || buffer != null || !"APPS_USER_NAME".equals(keys[i])) continue;
                    buffer = this.getUserBuffer(values[i], true);
                }
            }
            if (supplAttrs != null && supplAttrs.size() > 0) {
                int num = supplAttrs.size();
                supplAttrNames = new String[num];
                supplAttrValues = new String[num];
                int i = 0;
                for (Map.Entry entry : supplAttrs.entrySet()) {
                    if (entry == null) continue;
                    Object key = entry.getKey();
                    Object val = entry.getValue();
                    if (key != null) {
                        supplAttrNames[i] = !(key instanceof String) ? key.toString() : (String)key;
                        len = supplAttrNames[i].length();
                        if (this.fieldLen_ >= 0 && len > this.fieldLen_) {
                            supplAttrNames[i] = supplAttrNames[i].substring(0, this.fieldLen_);
                            len = this.fieldLen_;
                        }
                        size += len;
                    }
                    size += 4;
                    if (val != null) {
                        supplAttrValues[i] = !(val instanceof String) ? val.toString() : (String)val;
                        if (this.enableUserBuffer_ && buffer == null && supplAttrNames[i] != null && supplAttrValues[i] != null && "APPS_USER_NAME".equals(supplAttrNames[i])) {
                            buffer = this.getUserBuffer(supplAttrValues[i], true);
                        }
                        len = supplAttrValues[i].length();
                        if (this.fieldLen_ >= 0 && len > this.fieldLen_) {
                            supplAttrValues[i] = supplAttrValues[i].substring(0, this.fieldLen_);
                            len = this.fieldLen_;
                        }
                        size += len;
                    }
                    size += 4;
                    ++i;
                }
            }
        }
        if (buffer == null) {
            if (this.enableUserBuffer_ && userId != null) {
                buffer = this.getUserBuffer(userId, true);
            }
            if (buffer == null) {
                buffer = this.defBuf_;
            }
        }
        int pos = 0;
        keys = buffer.bufferLock_;
        synchronized (buffer.bufferLock_) {
            pos = buffer.currPos_;
            buffer.currPos_ += size;
            if (buffer.currPos_ >= buffer.buffer_.length) {
                buffer.currPos_ = size;
                pos = 0;
            }
            if (buffer.recPosList_.size() > 0) {
                int head = buffer.recPosList_.getFirst();
                boolean done = false;
                while (!done) {
                    if (head == 0) {
                        if (pos == 0) {
                            buffer.recPosList_.removeFirst();
                            if (buffer.recPosList_.size() > 0) {
                                head = buffer.recPosList_.getFirst();
                                continue;
                            }
                            done = true;
                            continue;
                        }
                        done = true;
                        continue;
                    }
                    if (head <= buffer.currPos_) {
                        buffer.recPosList_.removeFirst();
                        if (buffer.recPosList_.size() > 0) {
                            head = buffer.recPosList_.getFirst();
                            continue;
                        }
                        done = true;
                        continue;
                    }
                    if (head > buffer.recPosList_.getLast() && pos == 0) {
                        buffer.recPosList_.removeFirst();
                        if (buffer.recPosList_.size() > 0) {
                            head = buffer.recPosList_.getFirst();
                            continue;
                        }
                        done = true;
                        continue;
                    }
                    done = true;
                }
            }
            buffer.recPosList_.addLast(pos);
            // ** MonitorExit[keys /* !! */ ] (shouldn't be in output)
            QuickTraceBuffer.LockRegion region = null;
            try {
                region = buffer.lockRegion(pos, size);
                int checksum = pos;
                pos = this.writeToBuffer(buffer.buffer_, QUICKTRACE_RECORD_SIGNATURE, pos);
                pos = this.writeToBuffer(buffer.buffer_, size, pos);
                pos = this.writeToBuffer(buffer.buffer_, millis, pos);
                pos = this.writeToBuffer(buffer.buffer_, recLevelStr, pos);
                pos = this.writeToBuffer(buffer.buffer_, loggerName, pos);
                pos = this.writeToBuffer(buffer.buffer_, sequenceNumber, pos);
                pos = this.writeToBuffer(buffer.buffer_, appName, pos);
                pos = this.writeToBuffer(buffer.buffer_, sourceClassName, pos);
                pos = this.writeToBuffer(buffer.buffer_, sourceMethodName, pos);
                pos = this.writeToBuffer(buffer.buffer_, threadId, pos);
                pos = this.writeToBuffer(buffer.buffer_, messageText, pos);
                pos = this.writeToBuffer(buffer.buffer_, messageId, pos);
                pos = this.writeToBuffer(buffer.buffer_, supplDet, pos);
                pos = this.writeToBuffer(buffer.buffer_, messageArgs, pos);
                pos = this.writeToBuffer(buffer.buffer_, userId, pos);
                pos = this.writeToBuffer(buffer.buffer_, ecid, pos);
                pos = this.writeToBuffer(buffer.buffer_, ecidRid, pos);
                pos = this.writeToBuffer(buffer.buffer_, errorId, pos);
                pos = this.writeToBuffer(buffer.buffer_, messageDetailLoc, pos);
                pos = this.writeToBuffer(buffer.buffer_, supplAttrNames, pos);
                pos = this.writeToBuffer(buffer.buffer_, supplAttrValues, pos);
                pos = this.writeToBuffer(buffer.buffer_, messageProblemKey, pos);
                checksum = pos - checksum;
            }
            finally {
                if (region != null) {
                    buffer.unlockRegion(region);
                }
            }
            return;
        }
    }

    @Override
    public void dump(File destination) {
        super.internalDump(null, destination, this.flushOnDump_);
    }

    @Override
    public void dump(String name, File destination) {
        super.internalDump(name, destination, this.flushOnDump_);
    }

    @Override
    public void dump(FileOutputStream fos) {
        this.dump(null, fos, this.flushOnDump_);
    }

    @Override
    public void dump(File destination, boolean flushBuffer) {
        super.internalDump(null, destination, flushBuffer);
    }

    @Override
    public void dump(String name, File destination, boolean flushBuffer) {
        super.internalDump(name, destination, flushBuffer);
    }

    @Override
    public void dump(FileOutputStream fos, boolean flushBuffer) {
        this.dump(null, fos, flushBuffer);
    }

    @Override
    public void dump(String name, FileOutputStream fos) {
        this.dump(name, fos, this.flushOnDump_);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dump(String name, FileOutputStream fos, boolean flushBuffer) {
        try {
            BufferedOutputStream bos = new BufferedOutputStream(fos, 65536);
            String enc = this.getEncoding();
            LogMessage msg = null;
            byte[] dumpBuffer = null;
            LinkedList<Integer> dumpRecPosList = null;
            QuickTraceBuffer buffer = null;
            if (name == null) {
                buffer = this.defBuf_;
            } else if (this.enableUserBuffer_) {
                buffer = this.getUserBuffer(name, false);
            }
            if (buffer == null) {
                return;
            }
            byte[] byArray = buffer.bufferLock_;
            synchronized (buffer.bufferLock_) {
                LinkedList<QuickTraceBuffer.LockRegion> linkedList = buffer.regions_;
                synchronized (linkedList) {
                    while (buffer.regions_.size() != 0) {
                        try {
                            buffer.regions_.wait(100L);
                        }
                        catch (InterruptedException inex) {}
                    }
                    if (flushBuffer) {
                        dumpBuffer = buffer.buffer_;
                        dumpRecPosList = buffer.recPosList_;
                        buffer.buffer_ = new byte[dumpBuffer.length];
                        buffer.recPosList_ = new LinkedList();
                        buffer.currPos_ = 0;
                    } else {
                        dumpBuffer = new byte[buffer.buffer_.length];
                        System.arraycopy(buffer.buffer_, 0, dumpBuffer, 0, dumpBuffer.length);
                        dumpRecPosList = new LinkedList();
                        dumpRecPosList.addAll(buffer.recPosList_);
                    }
                }
                // ** MonitorExit[var11_11] (shouldn't be in output)
                int pos = 0;
                int nextRecordPos = 0;
                int len = dumpRecPosList.size();
                for (int i = 0; i < len; ++i) {
                    byte[] bytes;
                    pos = dumpRecPosList.get(i);
                    if (i != len - 1) {
                        nextRecordPos = dumpRecPosList.get(i + 1);
                        if (nextRecordPos == 0) {
                            nextRecordPos = dumpBuffer.length + 1;
                        }
                    } else {
                        nextRecordPos = dumpRecPosList.get(0);
                        if (nextRecordPos == 0) {
                            nextRecordPos = dumpBuffer.length + 1;
                        }
                    }
                    if ((msg = this.parseLogMessage(dumpBuffer, pos, nextRecordPos)) == null) continue;
                    String data = this.formatter_.format(msg);
                    try {
                        bytes = enc == null ? data.getBytes() : data.getBytes(enc);
                    }
                    catch (Exception e) {
                        bytes = new byte[]{};
                    }
                    bos.write(bytes);
                }
                bos.flush();
            }
        }
        catch (IOException ioex) {
            this.reportError("", ioex, 1);
        }
    }

    @Override
    long getOldestRecordTime() {
        return this.getOldestRecordTime(this.defBuf_);
    }

    @Override
    long getOldestRecordTime(String bufferName) {
        QuickTraceBuffer buffer = this.getUserBuffer(bufferName, false);
        return this.getOldestRecordTime(buffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long getOldestRecordTime(QuickTraceBuffer buffer) {
        if (buffer == null) {
            return 0L;
        }
        long time = 0L;
        byte[] byArray = buffer.bufferLock_;
        synchronized (buffer.bufferLock_) {
            if (buffer.recPosList_.size() > 0) {
                byte[] sig = new byte[QUICKTRACE_RECORD_SIGNATURE.length];
                int recordSize = 0;
                int i = 0;
                for (i = 0; i < buffer.recPosList_.size() && time == 0L; ++i) {
                    Offset offset = new Offset(buffer.recPosList_.get(i));
                    System.arraycopy(buffer.buffer_, offset.value, sig, 0, sig.length);
                    if (!Arrays.equals(sig, QUICKTRACE_RECORD_SIGNATURE)) continue;
                    offset.value += QUICKTRACE_RECORD_SIGNATURE.length;
                    recordSize = this.readIntFromBuffer(buffer.buffer_, offset);
                    time = this.readLongFromBuffer(buffer.buffer_, offset);
                }
            }
            // ** MonitorExit[var4_3] (shouldn't be in output)
            if (time < 0L) {
                time = 0L;
            }
            return time;
        }
    }

    @Override
    int getNumberOfRecords() {
        return this.getNumberOfRecords(this.defBuf_);
    }

    @Override
    int getNumberOfRecords(String bufferName) {
        QuickTraceBuffer buffer = this.getUserBuffer(bufferName, false);
        return this.getNumberOfRecords(buffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getNumberOfRecords(QuickTraceBuffer buffer) {
        int count = 0;
        if (buffer == null) {
            return 0;
        }
        byte[] byArray = buffer.bufferLock_;
        synchronized (buffer.bufferLock_) {
            count = buffer.recPosList_.size();
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return count;
        }
    }

    @Override
    int getBufferUsedPercentage() {
        return this.getBufferUsedPercentage(this.defBuf_);
    }

    @Override
    int getBufferUsedPercentage(String bufferName) {
        QuickTraceBuffer buffer = this.getUserBuffer(bufferName, false);
        return this.getBufferUsedPercentage(buffer);
    }

    int getBufferUsedPercentage(QuickTraceBuffer buffer) {
        if (buffer == null || buffer.recPosList_.size() == 0) {
            return 0;
        }
        int head = buffer.recPosList_.getFirst();
        int tail = buffer.recPosList_.getLast();
        long size = 0L;
        size = head > tail ? (long)tail + buffer.maxSize_ - (long)head : (tail > head ? (long)(tail - head) : (tail == 0 ? 0L : buffer.maxSize_));
        return (int)Math.round(1.0 * (double)size / (double)buffer.maxSize_ * 100.0);
    }

    private int writeToBuffer(byte[] buffer, byte[] data, int pos) {
        int len = data.length;
        System.arraycopy(data, 0, buffer, pos, len);
        return pos + len;
    }

    private int writeToBuffer(byte[] buffer, String[] strArr, int pos) {
        int destPos = pos;
        if (strArr != null && strArr.length > 0) {
            int len = strArr.length;
            destPos = this.writeToBuffer(buffer, len, pos);
            for (int i = 0; i < len; ++i) {
                destPos = this.writeToBuffer(buffer, strArr[i], destPos);
            }
        } else {
            Arrays.fill(buffer, destPos, destPos + 4, (byte)0);
            destPos += 4;
        }
        return destPos;
    }

    private int writeToBuffer(byte[] buffer, String strValue, int pos) {
        int destPos = pos;
        if (strValue == null || strValue.length() == 0) {
            Arrays.fill(buffer, destPos, destPos + 4, (byte)0);
            destPos += 4;
        } else {
            byte[] strField = strValue.getBytes();
            int strLenField = strValue.length();
            for (int i = 0; i < 4; ++i) {
                int shiftPos = destPos + 4 - 1;
                buffer[shiftPos - i] = (byte)((strLenField >> 8 * i) % 256);
            }
            System.arraycopy(strField, 0, buffer, destPos += 4, strField.length);
            destPos += strField.length;
        }
        return destPos;
    }

    private int writeToBuffer(byte[] buffer, long longVlue, int pos) {
        if (longVlue <= 0L) {
            Arrays.fill(buffer, pos, pos + 8, (byte)0);
        } else {
            int shiftPos = pos + 8 - 1;
            for (int i = 0; i < 8; ++i) {
                buffer[shiftPos - i] = (byte)((longVlue >> 8 * i) % 256L);
            }
        }
        return pos + 8;
    }

    private int writeToBuffer(byte[] buffer, int intValue, int pos) {
        if (intValue <= 0) {
            Arrays.fill(buffer, pos, pos + 4, (byte)0);
        } else {
            int shiftPos = pos + 4 - 1;
            for (int i = 0; i < 4; ++i) {
                buffer[shiftPos - i] = (byte)((intValue >> 8 * i) % 256);
            }
        }
        return pos + 4;
    }

    private int readIntFromBuffer(byte[] buffer, Offset offset) {
        int intValue = 0;
        int bytePos = offset.value + 4 - 1;
        for (int i = 0; i < 4; ++i) {
            int byteValue = buffer[bytePos - i];
            if (byteValue < 0) {
                byteValue += 256;
            }
            intValue += byteValue << 8 * i;
        }
        offset.value += 4;
        return intValue;
    }

    private long readLongFromBuffer(byte[] buffer, Offset offset) {
        long longValue = 0L;
        int bytePos = offset.value + 8 - 1;
        for (int i = 0; i < 8; ++i) {
            long byteValue = buffer[bytePos - i];
            if (byteValue < 0L) {
                byteValue += 256L;
            }
            longValue += byteValue << 8 * i;
        }
        offset.value += 8;
        return longValue;
    }

    private String readStringFromBuffer(byte[] buffer, Offset offset) {
        String str = null;
        int len = this.readIntFromBuffer(buffer, offset);
        if (len > 0) {
            str = new String(buffer, offset.value, len);
            offset.value += len;
        }
        return str;
    }

    private String[] readStringArrayFromBuffer(byte[] buffer, Offset offset) {
        String[] strs = null;
        int arraySize = this.readIntFromBuffer(buffer, offset);
        if (arraySize > 0) {
            strs = new String[arraySize];
            for (int i = 0; i < arraySize; ++i) {
                strs[i] = this.readStringFromBuffer(buffer, offset);
            }
        }
        return strs;
    }

    private LogMessage parseLogMessage(byte[] buffer, int pos, int nextRecordPos) {
        int j;
        int i;
        byte[] sig = new byte[QUICKTRACE_RECORD_SIGNATURE.length];
        int recordSize = 0;
        long millis = 0L;
        String loggerName = null;
        String appName = null;
        String sourceClassName = null;
        String sourceMethodName = null;
        String threadId = null;
        String messageText = null;
        String messageId = null;
        String supplDet = null;
        String[] messageArgs = null;
        String userId = null;
        String ecid = null;
        String ecidRid = null;
        String errorId = null;
        String messageDetailLoc = null;
        String[] supplAttrNames = null;
        String[] supplAttrValues = null;
        String messageProblemKey = null;
        Offset offset = new Offset(pos);
        System.arraycopy(buffer, offset.value, sig, 0, sig.length);
        if (!Arrays.equals(sig, QUICKTRACE_RECORD_SIGNATURE)) {
            return null;
        }
        offset.value += QUICKTRACE_RECORD_SIGNATURE.length;
        recordSize = this.readIntFromBuffer(buffer, offset);
        if (recordSize + pos > nextRecordPos) {
            return null;
        }
        millis = this.readLongFromBuffer(buffer, offset);
        Level recLevel = Level.parse(this.readStringFromBuffer(buffer, offset));
        loggerName = this.readStringFromBuffer(buffer, offset);
        offset.value += 8;
        appName = this.readStringFromBuffer(buffer, offset);
        sourceClassName = this.readStringFromBuffer(buffer, offset);
        sourceMethodName = this.readStringFromBuffer(buffer, offset);
        threadId = this.readStringFromBuffer(buffer, offset);
        messageText = this.readStringFromBuffer(buffer, offset);
        messageId = this.readStringFromBuffer(buffer, offset);
        supplDet = this.readStringFromBuffer(buffer, offset);
        messageArgs = this.readStringArrayFromBuffer(buffer, offset);
        userId = this.readStringFromBuffer(buffer, offset);
        ecid = this.readStringFromBuffer(buffer, offset);
        ecidRid = this.readStringFromBuffer(buffer, offset);
        errorId = this.readStringFromBuffer(buffer, offset);
        messageDetailLoc = this.readStringFromBuffer(buffer, offset);
        supplAttrNames = this.readStringArrayFromBuffer(buffer, offset);
        supplAttrValues = this.readStringArrayFromBuffer(buffer, offset);
        messageProblemKey = this.readStringFromBuffer(buffer, offset);
        String componentId = null;
        String moduleId = null;
        if (loggerName == null) {
            loggerName = "";
        }
        String defaultComponentId = super.getODLFormatter().getDefaultComponentId();
        moduleId = loggerName;
        componentId = defaultComponentId == null ? ((i = loggerName.indexOf(46)) >= 0 ? ((j = loggerName.indexOf(46, i + 1)) >= 0 ? loggerName.substring(i + 1, j) : loggerName.substring(i + 1)) : loggerName) : defaultComponentId;
        MessageType msgType = MessageType.UNKNOWN;
        int[] arbLevel = new int[]{16};
        if (recLevel != null) {
            msgType = ODLLevel.getMsgTypeAndLevel(recLevel, arbLevel);
        }
        LogMessage.InstanceId ecidObj = null;
        if (ecid != null && ecid.length() > 0) {
            if (ecidRid == null || ecidRid.length() == 0) {
                ecidRid = "0";
            }
            ecidObj = new LogMessage.InstanceId(ecid, ecidRid);
        }
        LogMessage.InstanceId errorIdObj = null;
        if (errorId != null) {
            errorIdObj = new LogMessage.InstanceId(errorId, null);
        }
        LogMessage.MessageArgument[] msgArgs = null;
        if (super.getIncludeMessageArguments() && messageId != null && messageArgs != null && messageArgs.length > 0) {
            msgArgs = new LogMessage.MessageArgument[messageArgs.length];
            for (int k = 0; k < messageArgs.length; ++k) {
                String v = messageArgs[k] != null ? messageArgs[k] : null;
                msgArgs[k] = new LogMessage.MessageArgument(null, v);
            }
        }
        HashMap<String, String> supplAttrs = null;
        if (appName != null) {
            supplAttrs = new HashMap<String, String>();
            supplAttrs.put("APP", appName);
        }
        if (supplAttrNames != null && supplAttrValues != null) {
            int attrLen = Math.min(supplAttrNames.length, supplAttrValues.length);
            if (supplAttrs == null && attrLen > 0) {
                supplAttrs = new HashMap();
            }
            for (int i2 = 0; i2 < attrLen; ++i2) {
                supplAttrs.put(supplAttrNames[i2], supplAttrValues[i2]);
            }
        }
        if (sourceClassName != null) {
            if (supplAttrs == null) {
                supplAttrs = new HashMap();
            }
            supplAttrs.put("SRC_CLASS", sourceClassName);
        }
        if (sourceMethodName != null) {
            if (supplAttrs == null) {
                supplAttrs = new HashMap();
            }
            supplAttrs.put("SRC_METHOD", sourceMethodName);
        }
        LogMessage msg = new LogMessage(null, componentId, messageId, null, msgType, null, arbLevel[0], moduleId, null, userId, null, null, ecidObj, errorIdObj, messageText, msgArgs, messageDetailLoc, supplDet);
        msg.setTimestamp(millis);
        msg.setThreadId(threadId);
        if (supplAttrs != null) {
            msg.setSupplAttrs(supplAttrs);
        }
        if (messageProblemKey != null) {
            msg.setProblemKey(messageProblemKey);
        }
        if (!super.getUseDefaultAttributes()) {
            msg.setHostId(null);
            msg.setHostNwAddr(null);
            msg.setUserId(userId);
        }
        return msg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getBufferNames() {
        String[] names = null;
        Hashtable<String, QuickTraceBuffer> hashtable = this.userBufs_;
        synchronized (hashtable) {
            if (this.userBufs_.size() > 0) {
                names = this.userBufs_.keySet().toArray(new String[0]);
            }
        }
        return names;
    }

    static class Offset {
        int value = 0;

        Offset(int initValue) {
            this.value = initValue;
        }
    }
}

