/*
 * Decompiled with CFR 0.152.
 */
package oracle.core.ojdl.jrf;

import java.io.File;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.core.ojdl.logging.LogUtil;
import oracle.core.ojdl.logging.config.ServerLoggingConfiguration;
import oracle.core.ojdl.messages.Messages;
import oracle.jrf.PortabilityLayerException;
import oracle.jrf.ServerPlatformSupport;
import oracle.jrf.ServerPlatformSupportFactory;
import oracle.jrf.ServerStartupShutdownProvider;

public class ODLStartupShutdown
extends ServerStartupShutdownProvider {
    private static Logger s_logger = Logger.getLogger("oracle.odl", Messages.class.getName());
    private static final String CONFIG_FILE = "logging.xml";

    public void startup() {
        try {
            ServerPlatformSupport sps = ServerPlatformSupportFactory.getInstance();
            final String serverName = sps.getServerName();
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    String APP_CTX_PROVIDER;
                    if (serverName != null && serverName.length() > 0) {
                        System.setProperty("oracle.core.ojdl.logging.componentId", serverName);
                    }
                    if (System.getProperty(APP_CTX_PROVIDER = "oracle.core.ojdl.logging.applicationcontextprovider") == null) {
                        System.setProperty(APP_CTX_PROVIDER, "oracle.core.ojdl.logging.ApplicationContextImpl");
                    }
                    return null;
                }
            });
            Properties env = new Properties();
            env.setProperty("SERVER_LOG_ROOT", sps.getServerLogPath());
            env.setProperty("SERVER_NAME", sps.getServerName());
            File f = this.getConfigFile(sps);
            String path = f.getAbsolutePath();
            s_logger.log(Level.INFO, "ODL-52080", path);
            try {
                ServerLoggingConfiguration.readConfiguration(path, env);
            }
            catch (Exception e) {
                LogUtil.log(s_logger, Level.SEVERE, "ODL-52081", new Object[]{path, e}, (Throwable)e);
            }
            try {
                Class<?> logDump = Class.forName("oracle.as.management.logging.tools.JRFLogDump");
                logDump.getDeclaredMethod("init", new Class[0]).invoke(null, new Object[0]);
                Class<?> activeLogConfigDump = Class.forName("oracle.as.management.logging.tools.ActiveLogConfigDump");
                activeLogConfigDump.getDeclaredMethod("init", new Class[0]).invoke(null, new Object[0]);
                Class<?> quickTraceDump = Class.forName("oracle.as.management.logging.tools.QuickTraceDump");
                quickTraceDump.getDeclaredMethod("init", new Class[0]).invoke(null, new Object[0]);
            }
            catch (Exception e) {
                LogUtil.log(s_logger, Level.WARNING, "ODL-52083", new Object[]{e.toString()}, (Throwable)e);
            }
        }
        catch (PortabilityLayerException e) {
            LogUtil.log(s_logger, Level.SEVERE, "ODL-52084", e.getMessage(), (Throwable)e);
        }
    }

    public void shutdown() {
    }

    public int getStartupOrder() {
        return 145;
    }

    public int getShutdownOrder() {
        return 155;
    }

    public String[] getTargets() {
        return new String[]{"%AdminServer%", "%ALLManagedServers%", "%DmgrServer%"};
    }

    private File getConfigFile(ServerPlatformSupport sps) throws PortabilityLayerException {
        return new File(sps.getServerConfigDirectory(), CONFIG_FILE);
    }
}

