/*
 * Decompiled with CFR 0.152.
 */
package oracle.as.management.tracing.impl;

import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import oracle.as.jmx.framework.annotations.Inject;
import oracle.as.jmx.framework.services.JMXSupport;
import oracle.as.management.tracing.TraceInfo;
import oracle.as.management.tracing.TraceProviderInfo;
import oracle.as.management.tracing.TracingControllerMXBean;
import oracle.as.management.tracing.impl.TracingController;
import oracle.core.ojdl.logging.ODLLevel;

public class TracingControllerMXBeanImpl
implements TracingControllerMXBean {
    private JMXSupport m_jmxSupport;

    @Inject
    public void setJMXSupport(JMXSupport jmxSupport) throws Exception {
        this.m_jmxSupport = jmxSupport;
    }

    @Override
    public void startTracing(String traceId, String attrName, String attrValue, String level, long duration, String desc) throws Exception {
        this.startTracing(traceId, attrName, attrValue, level, duration, desc, null);
    }

    @Override
    public void startTracing(String traceId, String attrName, String attrValue, String level, long duration, String desc, Map<String, Map<String, String>> params) throws Exception {
        Level lev;
        try {
            lev = ODLLevel.parse(level);
        }
        catch (Exception e) {
            throw new Exception("Invalid level: " + level);
        }
        TracingController.getInstance().startTracing(traceId, attrName, attrValue, lev, duration, desc, params);
    }

    @Override
    public void stopTracing(String traceId) {
        TracingController.getInstance().stopTracing(traceId);
    }

    @Override
    public void stopTracing(String traceId, boolean createIncident) {
        TracingController.getInstance().stopTracing(traceId, createIncident);
    }

    @Override
    public void stopTracing() {
        TracingController.getInstance().stopTracing();
    }

    @Override
    public Map<String, Boolean> getODLLoggers() {
        return TracingController.getInstance().getODLLoggers();
    }

    @Override
    public void configureODLLoggers(Map<String, Boolean> loggers) {
        TracingController.getInstance().configureODLLoggers(loggers);
    }

    @Override
    public List<TraceInfo> getActiveTraces() {
        return TracingController.getInstance().getActiveTraces();
    }

    @Override
    public List<TraceInfo> getHistory() {
        return TracingController.getInstance().getHistory();
    }

    @Override
    public void clearHistory() {
        TracingController.getInstance().clearHistory();
    }

    @Override
    public Set<String> getAvailableProviders() {
        return TracingController.getInstance().getAvailableProviders();
    }

    @Override
    public Set<String> getEnabledProviders() {
        return TracingController.getInstance().getEnabledProviders();
    }

    @Override
    public void setEnabledProviders(Set<String> enabledProviders) throws Exception {
        TracingController.getInstance().setEnabledProviders(enabledProviders);
    }

    @Override
    public List<TraceProviderInfo> getTraceProviderInfo() {
        return TracingController.getInstance().getTraceProviderInfo(this.m_jmxSupport.getLocale());
    }

    @Override
    public List<TraceProviderInfo> getLocalizedTraceProviderInfo(String locale) {
        return TracingController.getInstance().getTraceProviderInfo(this.parseLocale(locale));
    }

    @Override
    public TraceProviderInfo getTraceProviderInfo(String providerName) {
        return TracingController.getInstance().getTraceProviderInfo(providerName, this.m_jmxSupport.getLocale());
    }

    @Override
    public TraceProviderInfo getTraceProviderInfo(String providerName, String locale) {
        return TracingController.getInstance().getTraceProviderInfo(providerName, this.parseLocale(locale));
    }

    private Locale parseLocale(String locStr) {
        if (locStr == null) {
            return Locale.getDefault();
        }
        StringTokenizer st = new StringTokenizer(locStr, "_");
        if (!st.hasMoreTokens()) {
            return Locale.getDefault();
        }
        String lang = st.nextToken();
        if (!st.hasMoreTokens()) {
            return new Locale(lang);
        }
        String country = st.nextToken();
        if (!st.hasMoreTokens()) {
            return new Locale(lang, country);
        }
        String variant = st.nextToken();
        if (!st.hasMoreTokens()) {
            return new Locale(lang, country, variant);
        }
        return Locale.getDefault();
    }
}

