/*
 * Decompiled with CFR 0.152.
 */
package oracle.as.management.tracing.impl;

import java.io.File;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import oracle.as.management.logging.impl.Msgs;
import oracle.as.management.tracing.TraceInfo;
import oracle.as.management.tracing.TraceProvider;
import oracle.as.management.tracing.TraceProviderInfo;
import oracle.as.management.tracing.impl.TraceDump;
import oracle.core.ojdl.logging.ODLLogger;
import oracle.core.ojdl.logging.impl.LoggingListener;
import oracle.core.ojdl.logging.impl.LoggingNotificationHandler;
import oracle.dfw.framework.DiagnosticsFramework;
import oracle.dfw.incident.Incident;
import oracle.dms.context.ExecutionContext;

public class ODLTraceProvider
implements TraceProvider,
LoggingListener {
    private TraceDump m_traceDump = new TraceDump();
    private DiagnosticsFramework m_dfw;
    private Logger m_logger = Logger.getLogger("oracle.odl.tracing");
    private LoggingNotificationHandler m_loggingNotificationHandler = LoggingNotificationHandler.getInstance();
    private Map<String, AtomicBoolean> m_traces = new ConcurrentHashMap<String, AtomicBoolean>();
    private static final String NAME = "ODL";

    public ODLTraceProvider() {
        try {
            this.m_dfw = new DiagnosticsFramework();
        }
        catch (Exception e) {
            this.m_logger.log(Level.WARNING, "Unable to instantiate DiagnosticsFramework. The ODLTraceProvider will not be able to add data to incidents");
        }
    }

    @Override
    public int startTracing(String traceId, String attrName, String attrValue, Level level, Map<String, String> params) throws Exception {
        if (this.m_traces.size() == 0) {
            this.m_loggingNotificationHandler.addListener(this);
        }
        this.m_traces.put(traceId, new AtomicBoolean(false));
        return 0;
    }

    @Override
    public int stopTracing(String traceId) {
        this.m_traces.remove(traceId);
        if (this.m_traces.size() == 0) {
            this.m_loggingNotificationHandler.removeListener(this);
        }
        return 0;
    }

    @Override
    public int stopTracing(TraceInfo traceInfo, Incident incident) throws Exception {
        this.m_traces.remove(traceInfo.getTraceId());
        if (this.m_traces.size() == 0) {
            this.m_loggingNotificationHandler.removeListener(this);
        }
        if (this.m_dfw == null) {
            return -1;
        }
        String incidentDir = incident.getIncidentDirectory();
        File f = new File(incidentDir, "odl_trace.dmp");
        int index = 0;
        while (f.exists()) {
            f = new File(incidentDir, "odl_trace_" + ++index + ".dmp");
        }
        String path = f.getPath();
        this.m_traceDump.writeDump(path, traceInfo.getTraceId(), traceInfo.getStartTime(), traceInfo.getStopTime());
        this.m_dfw.getIncidentManager().addIncidentFile(incident.getIncidentId(), new String[]{f.getName()});
        return 0;
    }

    @Override
    public boolean hasTraceData(String traceId) {
        AtomicBoolean b = this.m_traces.get(traceId);
        return b != null && b.get();
    }

    @Override
    public boolean isEnabled() {
        return ODLLogger.isGlobalContextLevelEnabled();
    }

    @Override
    public void setEnabled(boolean enabled) {
        ODLLogger.setGlobalContextLevelEnabled(enabled);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public TraceProviderInfo getTraceProviderInfo(Locale loc) {
        TraceProviderInfo loggingInfo = new TraceProviderInfo();
        loggingInfo.setName(NAME);
        loggingInfo.setUserVisibleName(NAME);
        loggingInfo.setDescription(Msgs.getMsg((String)"ODL_TP_DESC", (Object[])new Object[0]));
        return loggingInfo;
    }

    public Map<String, Boolean> getODLLoggers() {
        TreeMap<String, Boolean> odlLoggers = new TreeMap<String, Boolean>();
        LogManager lm = LogManager.getLogManager();
        Enumeration<String> e = lm.getLoggerNames();
        while (e.hasMoreElements()) {
            String name = e.nextElement();
            Logger logger = lm.getLogger(name);
            if (logger == null || !(logger instanceof ODLLogger)) continue;
            ODLLogger odlLogger = (ODLLogger)logger;
            odlLoggers.put(odlLogger.getName(), odlLogger.isContextLevelEnabled());
        }
        return odlLoggers;
    }

    public void configureODLLoggers(Map<String, Boolean> loggers) {
        LogManager lm = LogManager.getLogManager();
        Enumeration<String> e = lm.getLoggerNames();
        while (e.hasMoreElements()) {
            Logger logger;
            String name = e.nextElement();
            if (!loggers.containsKey(name) || (logger = lm.getLogger(name)) == null || !(logger instanceof ODLLogger)) continue;
            ((ODLLogger)logger).setContextLevelEnabled(loggers.get(name));
        }
    }

    @Override
    public void recordLogged(LogRecord rec) {
        AtomicBoolean v;
        ExecutionContext ctx = ExecutionContext.get();
        String traceId = ctx.getValue("ODL_TRACE_ID");
        if (traceId != null && (v = this.m_traces.get(traceId)) != null) {
            v.set(true);
        }
    }
}

