/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.sybase;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.javatools.db.BaseDatabaseCreator;
import oracle.javatools.db.Database;
import oracle.javatools.db.DatabaseDescriptor;
import oracle.javatools.db.jdbc.JdbcDatabaseDescriptor;
import oracle.javatools.db.sybase.AdaptiveServerDatabaseImpl;
import oracle.javatools.db.sybase.AdaptiveServerEnterprise15DatabaseImpl;
import oracle.javatools.db.sybase.AdaptiveServerEnterprise15Descriptor;
import oracle.javatools.db.sybase.AdaptiveServerEnterpriseDatabaseImpl;
import oracle.javatools.db.sybase.AdaptiveServerEnterpriseDescriptor;
import oracle.javatools.db.sybase.anywhere.AdaptiveServerAnywhereDatabase;
import oracle.javatools.db.sybase.anywhere.AdaptiveServerAnywhereDatabaseImpl;
import oracle.javatools.db.sybase.anywhere.AdaptiveServerAnywhereDescriptor;

public class AdaptiveServerDatabaseFactory
extends BaseDatabaseCreator {
    protected Database createDatabaseImpl(String string, String string2, Connection connection) {
        AdaptiveServerDatabaseImpl adaptiveServerDatabaseImpl = null;
        if (this.isAnywhere(connection)) {
            adaptiveServerDatabaseImpl = new AdaptiveServerAnywhereDatabaseImpl(string, string2, connection);
        } else {
            int n = this.getEnterpriseVersion(connection);
            switch (n) {
                case 150: {
                    adaptiveServerDatabaseImpl = new AdaptiveServerEnterprise15DatabaseImpl(string, string2, connection);
                    break;
                }
                case 120: {
                    adaptiveServerDatabaseImpl = new AdaptiveServerEnterpriseDatabaseImpl(string, string2, connection);
                }
            }
        }
        return adaptiveServerDatabaseImpl;
    }

    private boolean isAnywhere(Connection connection) {
        if (connection != null) {
            try {
                DatabaseMetaData databaseMetaData = connection.getMetaData();
                String string = databaseMetaData.getDriverName();
                String string2 = databaseMetaData.getDatabaseProductName();
                if (string.indexOf("Sybase") > -1 && string2.indexOf("Anywhere") > -1) {
                    return true;
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return false;
    }

    private int getEnterpriseVersion(Connection connection) {
        int n;
        block7: {
            n = -1;
            if (connection != null) {
                try {
                    DatabaseMetaData databaseMetaData = connection.getMetaData();
                    String string = databaseMetaData.getDriverName();
                    String string2 = databaseMetaData.getDatabaseProductName();
                    if (string.indexOf("Sybase") > -1) {
                        int n2 = databaseMetaData.getDatabaseMajorVersion();
                        n = n2 >= 15 ? 150 : 120;
                        break block7;
                    }
                    if (string2.indexOf("Adaptive Server Enterprise") <= -1) break block7;
                    n = 120;
                    try {
                        String string3;
                        int n3;
                        String string4 = databaseMetaData.getDatabaseProductVersion();
                        Pattern pattern = Pattern.compile("Adaptive Server Enterprise/(\\d+).*");
                        Matcher matcher = pattern.matcher(string4);
                        if (matcher.matches() && (n3 = Integer.parseInt(string3 = matcher.group(1))) >= 15) {
                            n = 150;
                        }
                    }
                    catch (Exception exception) {}
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
        }
        return n;
    }

    protected DatabaseDescriptor getDatabaseDescriptorImpl(Class clazz) {
        JdbcDatabaseDescriptor jdbcDatabaseDescriptor = null;
        if (AdaptiveServerAnywhereDatabase.class.isAssignableFrom(clazz)) {
            jdbcDatabaseDescriptor = new AdaptiveServerAnywhereDescriptor(clazz);
        } else if (AdaptiveServerEnterprise15DatabaseImpl.class.isAssignableFrom(clazz)) {
            jdbcDatabaseDescriptor = new AdaptiveServerEnterprise15Descriptor(clazz);
        } else if (AdaptiveServerEnterpriseDatabaseImpl.class.isAssignableFrom(clazz)) {
            jdbcDatabaseDescriptor = new AdaptiveServerEnterpriseDescriptor(clazz);
        }
        return jdbcDatabaseDescriptor;
    }
}

