/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.sqlite;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.ddl.TokenContext;
import oracle.javatools.db.ddl.TokenGenerator;
import oracle.javatools.db.internal.DBCore;
import oracle.javatools.db.plsql.PlSqlSearch;
import oracle.javatools.db.plsql.PlSqlToken;
import oracle.javatools.db.plsql.PlSqlTokenizer;
import oracle.javatools.db.plsql.Trigger;
import oracle.javatools.db.token.Token;

public class SQLiteDDLSupport {
    private final Map<String, TokenGenerator> m_globals = new TreeMap<String, TokenGenerator>();

    public SQLiteDDLSupport() {
        this.m_globals.put("handleTrgEvents", new TriggerEventsListGenerator());
        this.m_globals.put("getSyntaxFromSource", new SyntaxFromSourceGenerator());
        this.m_globals.put("codeExists", new CodeExistsTokenGenerator());
    }

    public Map<String, TokenGenerator> getGlobalTokenGenerators() {
        return Collections.unmodifiableMap(this.m_globals);
    }

    public static SQLiteDDLSupport getInstance() {
        DBCore dBCore = DBCore.getInstance();
        SQLiteDDLSupport sQLiteDDLSupport = (SQLiteDDLSupport)dBCore.get(SQLiteDDLSupport.class);
        if (sQLiteDDLSupport == null) {
            sQLiteDDLSupport = new SQLiteDDLSupport();
            dBCore.put((Object)sQLiteDDLSupport);
        }
        return sQLiteDDLSupport;
    }

    private static final class TriggerEventsListGenerator
    extends TokenGenerator {
        public static final String TOKEN = "handleTrgEvents";

        private TriggerEventsListGenerator() {
        }

        public void generateToken(TokenContext tokenContext) {
            Trigger trigger;
            boolean bl = true;
            if (tokenContext.getObject() instanceof Trigger && (trigger = (Trigger)tokenContext.getObject()).getEvents() != null && trigger.getEvents().length > 0) {
                for (String string : trigger.getEvents()) {
                    if (!bl) {
                        tokenContext.append((Object)" OR ");
                    }
                    tokenContext.append((Object)string);
                    DBObjectID[] dBObjectIDArray = trigger.getColumnIDs();
                    if ("UPDATE".equals(string) && dBObjectIDArray != null) {
                        for (int i = 0; i < dBObjectIDArray.length; ++i) {
                            tokenContext.append((Object)(i == 0 ? " OF " : ","));
                            tokenContext.append((Object)DBUtil.getDBObjectName((DBObjectID)dBObjectIDArray[i]));
                        }
                    }
                    bl = false;
                }
            }
        }

        public Object evaluateToken(TokenContext tokenContext) {
            return true;
        }

        public Collection<String> getPropertiesProcessed(String string, DBObjectProvider dBObjectProvider) {
            return Arrays.asList("events".toString());
        }
    }

    private static final class SyntaxFromSourceGenerator
    extends TokenGenerator {
        public static final String TOKEN = "getSyntaxFromSource";
        public static final String ALTER = "ALTER";

        private SyntaxFromSourceGenerator() {
        }

        public void generateToken(TokenContext tokenContext) {
            PlSqlToken plSqlToken;
            PlSqlSearch plSqlSearch;
            String string;
            if (tokenContext.getObject() instanceof Trigger && (string = this.getSource(tokenContext)) != null && !string.equals("") && (plSqlSearch = new PlSqlSearch("[create [or replace]] ? [body] ?. <sourceAfterName {?}...>")).matches(plSqlToken = PlSqlTokenizer.tokenize((String)string, (String[])new String[0]))) {
                PlSqlToken plSqlToken2 = plSqlSearch.getNamedMatchStartToken("sourceAfterName");
                PlSqlToken plSqlToken3 = plSqlSearch.getNamedMatchEndToken("sourceAfterName");
                String string2 = (plSqlToken2 = (PlSqlToken)((PlSqlToken)plSqlToken2.getPrevCodeToken()).getNextToken()).getSource(false, (Token)plSqlToken3);
                if (string2.startsWith(" ")) {
                    string2 = string2.substring(1);
                }
                tokenContext.append((Object)string2);
            }
        }

        public Object evaluateToken(TokenContext tokenContext) {
            if (tokenContext.getObject() instanceof Trigger) {
                String string = this.getSource(tokenContext);
                return string != null && !string.equals("");
            }
            return false;
        }

        private String getSource(TokenContext tokenContext) {
            String string = null;
            Trigger trigger = (Trigger)tokenContext.getObject();
            string = trigger.getSource();
            return string;
        }

        public Collection<String> getPropertiesProcessed(String string, DBObjectProvider dBObjectProvider) {
            return Collections.singleton("source");
        }
    }

    private static final class CodeExistsTokenGenerator
    extends TokenGenerator {
        public static final String TOKEN = "codeExists";

        private CodeExistsTokenGenerator() {
        }

        public void generateToken(TokenContext tokenContext) {
        }

        public Object evaluateToken(TokenContext tokenContext) {
            if (tokenContext.getObject() instanceof Trigger) {
                Trigger trigger = (Trigger)tokenContext.getObject();
                String string = trigger.getCode();
                return string != null && !string.equals("");
            }
            return false;
        }
    }
}

