/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.plsql.parser;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import oracle.javatools.db.CancelledException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.SourceObject;
import oracle.javatools.db.plsql.DBObjectPlSqlFragment;
import oracle.javatools.db.plsql.PlSqlBlock;
import oracle.javatools.db.plsql.PlSqlDatatype;
import oracle.javatools.db.plsql.PlSqlFragment;
import oracle.javatools.db.plsql.PlSqlInterrogator;
import oracle.javatools.db.plsql.PlSqlInterrogatorFactory;
import oracle.javatools.db.plsql.PlSqlParameter;
import oracle.javatools.db.plsql.PlSqlSourceObject;
import oracle.javatools.db.plsql.PlSqlStatement;
import oracle.javatools.db.plsql.PlSqlToken;
import oracle.javatools.db.plsql.PlSqlVariable;
import oracle.javatools.db.plsql.Trigger;
import oracle.javatools.db.plsql.Type;
import oracle.javatools.db.plsql.parser.AbstractPlSqlBuilder;
import oracle.javatools.db.plsql.parser.PlSqlParser;
import oracle.javatools.db.plsql.parser.PlSqlParserHelper;
import oracle.javatools.util.Tuple;

class LegacyPlSqlParserImpl
extends PlSqlParser {
    private PlSqlInterrogator m_pi;

    protected LegacyPlSqlParserImpl(DBObjectProvider dBObjectProvider, PlSqlSourceObject plSqlSourceObject, String string) {
        super(dBObjectProvider, plSqlSourceObject, string);
        this.m_pi = plSqlSourceObject != null ? PlSqlInterrogatorFactory.getInterrogator((SourceObject)plSqlSourceObject) : PlSqlInterrogator.findOrCreate((String)string);
    }

    public PlSqlToken getTokenAtOffset(int n) {
        return this.m_pi.getTokenAtOffset(n);
    }

    public boolean isWrapped() {
        return this.m_pi.isWrapped();
    }

    public Object getParseNode(DBObjectPlSqlFragment dBObjectPlSqlFragment) {
        PlSqlFragment plSqlFragment = null;
        if (dBObjectPlSqlFragment instanceof PlSqlSourceObject) {
            plSqlFragment = this.m_pi.getRoot();
        } else if (dBObjectPlSqlFragment != null) {
            Integer n;
            Integer n2 = dBObjectPlSqlFragment.getStartOffset();
            if (n2 == null) {
                n2 = 0;
            }
            if ((n = dBObjectPlSqlFragment.getEndOffset()) == null) {
                n = this.getSource().length() - 1;
            }
            plSqlFragment = this.findPlSqlFragment(this.m_pi.getRoot(), n2, n);
        }
        return plSqlFragment;
    }

    private PlSqlFragment findPlSqlFragment(PlSqlFragment plSqlFragment, int n, int n2) {
        if (plSqlFragment == null) {
            return null;
        }
        int n3 = plSqlFragment.getStartOffset();
        int n4 = plSqlFragment.getEndOffset();
        if (n3 <= n && n4 >= n2) {
            for (PlSqlFragment plSqlFragment2 : plSqlFragment.getChildren()) {
                PlSqlFragment plSqlFragment3 = this.findPlSqlFragment(plSqlFragment2, n, n2);
                if (plSqlFragment3 == null) continue;
                return plSqlFragment3;
            }
            return plSqlFragment;
        }
        return null;
    }

    public List getChildParseNodes(DBObjectPlSqlFragment dBObjectPlSqlFragment, Object object) {
        this.checkParseNode(object);
        return Arrays.asList(((PlSqlFragment)object).getChildren());
    }

    public DBObjectPlSqlFragment createFragment(DBObjectPlSqlFragment dBObjectPlSqlFragment, Object object, Object object2) throws CancelledException {
        PlSqlFragment plSqlFragment = this.checkParseNode(object2);
        PlSqlBlock plSqlBlock = null;
        PlSqlFragment plSqlFragment2 = plSqlFragment.getParent();
        PlSqlFragment.Type type = plSqlFragment.getFragmentType();
        if (type == PlSqlFragment.Type.BEGIN && (plSqlFragment.getParent().getFragmentType() == PlSqlFragment.Type.PROCEDURE || plSqlFragment.getParent().getFragmentType() == PlSqlFragment.Type.FUNCTION)) {
            type = PlSqlFragment.Type.PLSQL_BLOCK;
        }
        switch (type) {
            case PROCEDURE: 
            case FUNCTION: 
            case PROCEDURE_FD: 
            case FUNCTION_FD: {
                if (plSqlFragment2.getFragmentType() == PlSqlFragment.Type.ROOT) break;
                plSqlBlock = AbstractPlSqlBuilder.createPlSqlSubProgram(this.getRoot());
                break;
            }
            case PLSQL_BLOCK: 
            case FOR_LOOP: {
                plSqlBlock = AbstractPlSqlBuilder.createFragment(PlSqlBlock.class);
                break;
            }
            case DECLARATION: {
                if (plSqlFragment.getFirstToken().matches("TYPE") || plSqlFragment.getFirstToken().matches("SUBTYPE")) {
                    plSqlBlock = AbstractPlSqlBuilder.createFragment(PlSqlDatatype.class);
                    break;
                }
                plSqlBlock = AbstractPlSqlBuilder.createFragment(PlSqlVariable.class);
                break;
            }
            case PARAMETER: {
                plSqlBlock = AbstractPlSqlBuilder.createFragment(PlSqlParameter.class);
                break;
            }
            case CURSOR: {
                plSqlBlock = AbstractPlSqlBuilder.createPlSqlSubProgram(this.getRoot());
                break;
            }
            case IF: 
            case ELSIF: 
            case ELSE: 
            case LOOP: 
            case WHILE_LOOP: 
            case STATEMENT: {
                plSqlBlock = AbstractPlSqlBuilder.createFragment(PlSqlStatement.class);
                break;
            }
        }
        if (plSqlBlock != null) {
            plSqlBlock.setStartOffset(Integer.valueOf(plSqlFragment.getStartOffset()));
            plSqlBlock.setEndOffset(Integer.valueOf(plSqlFragment.getEndOffset()));
            if (plSqlBlock instanceof PlSqlStatement) {
                try {
                    ((PlSqlStatement)plSqlBlock).setStatementType(PlSqlStatement.Type.valueOf((String)plSqlFragment.getFragmentType().toString()));
                }
                catch (Throwable throwable) {
                    DBLog.getLogger((Object)((Object)this)).finest("failed to convert fragment type to statement type");
                }
            }
        }
        return plSqlBlock;
    }

    protected Object[] getPropertyNodesImpl(DBObjectPlSqlFragment dBObjectPlSqlFragment, String string) throws CancelledException {
        PlSqlFragment plSqlFragment;
        PlSqlFragment plSqlFragment2;
        Object object = this.getParseNode(dBObjectPlSqlFragment);
        PlSqlFragment plSqlFragment3 = this.checkParseNode(object);
        if (dBObjectPlSqlFragment instanceof Trigger) {
            Object[] objectArray;
            PlSqlFragment.Type type = null;
            PlSqlFragment plSqlFragment4 = null;
            if ("baseObjectID".equals(string)) {
                type = PlSqlFragment.Type.TRIGGER_TABLE;
            } else if ("code".equals(string)) {
                type = PlSqlFragment.Type.PLSQL_BLOCK;
            } else if ("columnIDs".equals(string)) {
                type = PlSqlFragment.Type.TRIGGER_COLUMNS;
            } else if ("events".equals(string)) {
                type = PlSqlFragment.Type.TRIGGER_EVENTS;
            } else if ("referencingNewAs".equals(string) || "referencingOldAs".equals(string)) {
                type = PlSqlFragment.Type.TRIGGER_REFERENCING;
            } else if ("statementLevel".equals(string)) {
                type = PlSqlFragment.Type.TRIGGER_ROW_LEVEL;
            } else if ("timing".equals(string)) {
                type = PlSqlFragment.Type.TRIGGER_TIMING;
            } else if ("whenClause".equals(string)) {
                type = PlSqlFragment.Type.TRIGGER_WHEN;
            }
            if (type != null) {
                plSqlFragment4 = plSqlFragment3.findChild(type, true);
            }
            if (plSqlFragment4 == null) {
                objectArray = null;
            } else {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = plSqlFragment4;
            }
            return objectArray;
        }
        if (dBObjectPlSqlFragment instanceof Type) {
            PlSqlFragment plSqlFragment5 = plSqlFragment3.findChild(PlSqlFragment.Type.TYPE_SPEC, false);
            ArrayList<PlSqlFragment> arrayList = new ArrayList<PlSqlFragment>();
            for (PlSqlFragment plSqlFragment6 : plSqlFragment5.getChildren()) {
                PlSqlFragment.Type type = plSqlFragment6.getFragmentType();
                if ((type == PlSqlFragment.Type.PROCEDURE_FD || type == PlSqlFragment.Type.FUNCTION_FD) && "methods".equals(string)) {
                    arrayList.add(plSqlFragment6);
                    continue;
                }
                if (type != PlSqlFragment.Type.DECLARATION || plSqlFragment6.getFirstToken().matches("PRAGMA") || !"attributes".equals(string)) continue;
                arrayList.add(plSqlFragment6);
            }
            return arrayList.toArray(new PlSqlFragment[arrayList.size()]);
        }
        if ("parameters".equals(string) && (plSqlFragment2 = (plSqlFragment = this.checkParseNode(object)).findChild(PlSqlFragment.Type.PARAMETER_LIST, false)) != null) {
            return plSqlFragment2.getChildren();
        }
        return new Object[0];
    }

    public PlSqlToken getTypeToken() {
        return this.m_pi.getRoot().getFirstToken();
    }

    public PlSqlToken getSchemaToken() {
        PlSqlToken plSqlToken = this.getNameToken();
        PlSqlToken plSqlToken2 = null;
        while (plSqlToken != null && plSqlToken.getPrevCodeToken() != null && ((PlSqlToken)plSqlToken.getPrevCodeToken()).matches(".")) {
            plSqlToken = (PlSqlToken)plSqlToken.getPrevCodeToken();
            plSqlToken2 = plSqlToken = (PlSqlToken)plSqlToken.getPrevCodeToken();
        }
        return plSqlToken2;
    }

    public PlSqlToken getNameToken() {
        return this.m_pi.getTokenAtOffset(this.m_pi.getNameOffset());
    }

    public int getStartOffsetOfObject() {
        return this.m_pi.getRoot().getStartOffset();
    }

    public int getEndOffsetOfObject() {
        int n = 0;
        PlSqlFragment plSqlFragment = this.m_pi.getRoot();
        if (plSqlFragment != null) {
            PlSqlFragment[] plSqlFragmentArray = plSqlFragment.getChildren();
            n = plSqlFragmentArray.length > 1 ? plSqlFragmentArray[0].getEndOffset() : plSqlFragment.getEndOffset();
        }
        return n;
    }

    public List<Tuple<PlSqlToken, PlSqlToken>> getAlterStatements() {
        ArrayList<Tuple<PlSqlToken, PlSqlToken>> arrayList = new ArrayList<Tuple<PlSqlToken, PlSqlToken>>();
        PlSqlFragment plSqlFragment = this.m_pi.getRoot();
        if (plSqlFragment != null) {
            PlSqlFragment[] plSqlFragmentArray = plSqlFragment.getChildren();
            for (int i = 1; i < plSqlFragmentArray.length; ++i) {
                arrayList.add((Tuple<PlSqlToken, PlSqlToken>)new Tuple((Object)plSqlFragmentArray[i].getFirstToken(), (Object)plSqlFragmentArray[i].getLastToken()));
            }
        }
        return arrayList;
    }

    public Object getParseNode(int n) {
        return this.m_pi.getFragmentAtOffset(n);
    }

    public int getStartOffset(Object object) throws IllegalArgumentException {
        this.checkParseNode(object);
        return object != null ? ((PlSqlFragment)object).getStartOffset() : 0;
    }

    public int getEndOffset(Object object) throws IllegalArgumentException {
        this.checkParseNode(object);
        return object != null ? ((PlSqlFragment)object).getEndOffset() : 0;
    }

    public List<PlSqlParser.Issue> getIssues() throws CancelledException {
        PlSqlSourceObject plSqlSourceObject = this.getRoot();
        if (plSqlSourceObject != null) {
            return PlSqlParserHelper.getIssues(plSqlSourceObject, this.getProvider());
        }
        return Collections.emptyList();
    }

    public List<PlSqlParser.Issue> getIssues(String string) {
        return PlSqlParserHelper.getIssues(this.getSource());
    }

    private PlSqlFragment checkParseNode(Object object) throws IllegalArgumentException {
        if (!(object instanceof PlSqlFragment)) {
            throw new IllegalArgumentException("parse node must be a PlSqlFragment");
        }
        return (PlSqlFragment)object;
    }
}

