/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.plsql;

import java.util.Collection;
import java.util.HashSet;
import oracle.javatools.db.BaseObjectID;
import oracle.javatools.db.CascadeManager;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObjectCriteria;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectLister;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.Table;
import oracle.javatools.db.View;
import oracle.javatools.db.plsql.Trigger;
import oracle.javatools.util.ModelUtil;

public class CascadeTriggerLister
extends DBObjectLister {
    public CascadeTriggerLister(DBObjectProvider dBObjectProvider) {
        super(dBObjectProvider);
    }

    public Collection<DBObjectLister.ObjectInfo> listObjects(DBObjectCriteria dBObjectCriteria) throws DBException {
        HashSet<DBObjectLister.ObjectInfo> hashSet = new HashSet<DBObjectLister.ObjectInfo>();
        try {
            for (SystemObject systemObject : this.getProvider().listObjects(dBObjectCriteria)) {
                hashSet.addAll(this.getRelatedObjectInfos(systemObject));
            }
        }
        catch (DBException dBException) {
            DBLog.getLogger((Object)((Object)this)).warning(dBException.getMessage());
        }
        return hashSet;
    }

    /*
     * WARNING - void declaration
     */
    private Collection<DBObjectLister.ObjectInfo> getRelatedObjectInfos(SystemObject systemObject) throws DBException {
        CascadeManager.LookupCriteria lookupCriteria;
        DBObjectID dBObjectID;
        HashSet<DBObjectLister.ObjectInfo> hashSet = new HashSet<DBObjectLister.ObjectInfo>();
        HashSet<Object> hashSet2 = new HashSet<Object>();
        if (systemObject != null) {
            dBObjectID = systemObject.getID();
            lookupCriteria = new CascadeManager.LookupCriteria();
            lookupCriteria.setTypes(new String[]{"TRIGGER"});
            for (DBObjectID dBObjectID2 : this.getProvider().getCascadeManager().listTopLevelReferers(systemObject, lookupCriteria)) {
                if (!(dBObjectID2 instanceof BaseObjectID) || !"TRIGGER".equals((var8_12 = (BaseObjectID)dBObjectID2).getType()) || (var9_13 = (Trigger)var8_12.resolveID()) == null) continue;
                hashSet2.add(var9_13);
            }
        } else {
            void trigger;
            dBObjectID = null;
            lookupCriteria = this.getProvider().listSchemas();
            int n = ((CascadeManager.LookupCriteria)lookupCriteria).length;
            boolean bl = false;
            while (trigger < n) {
                var8_12 = lookupCriteria[trigger];
                var9_13 = DBObjectCriteria.createCriteria((String)"TRIGGER", (Schema)var8_12, (String)"%");
                for (SystemObject systemObject2 : this.getProvider().listObjects(var9_13)) {
                    if (!(systemObject2 instanceof Trigger)) continue;
                    hashSet2.add((Trigger)systemObject2);
                }
                ++trigger;
            }
        }
        lookupCriteria = systemObject instanceof Table ? Trigger.BaseType.TABLE : (systemObject instanceof View ? Trigger.BaseType.VIEW : (systemObject instanceof Schema ? Trigger.BaseType.SCHEMA : Trigger.BaseType.DATABASE));
        for (Trigger trigger : hashSet2) {
            if (!ModelUtil.areEqual((Object)trigger.getBaseType(), (Object)lookupCriteria) || !ModelUtil.areEqual((Object)trigger.getBaseObjectID(), (Object)dBObjectID)) continue;
            hashSet.add(new DBObjectLister.ObjectInfo(trigger.getType(), trigger.getSchema(), trigger.getName(), (Object)trigger.getID()));
        }
        return hashSet;
    }
}

