/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.validators;

import java.util.Collection;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Tablespace;
import oracle.javatools.db.resource.APIBundle;
import oracle.javatools.db.validators.DBObjectValidator;
import oracle.javatools.db.validators.ValidationException;
import oracle.javatools.db.validators.ValidationLevel;

public class OracleTablespaceValidator
extends DBObjectValidator<Tablespace> {
    public OracleTablespaceValidator(DBObjectProvider dBObjectProvider) {
        super(dBObjectProvider);
    }

    @DBObjectValidator.PropertyValidator(value={"fileSpecifications"}, level=ValidationLevel.FULL)
    @DBObjectValidator.PropertyDependency(value={"fileType"})
    public void validateFileSpecifications(Tablespace tablespace, Tablespace tablespace2) throws ValidationException {
        if (tablespace2.getFileType() == Tablespace.FileType.BIGFILE && tablespace2.getFileSpecifications() != null && tablespace2.getFileSpecifications().length > 1) {
            throw new ValidationException((DBObject)tablespace2, APIBundle.get((String)"TABLESPACE_ERROR_FILE_TYPE"));
        }
    }

    public DBObjectValidator.NamespaceType getNamespaceType() {
        return DBObjectValidator.NamespaceType.TYPE;
    }

    protected Collection<String> listAlwaysValidProperties() {
        Collection collection = super.listAlwaysValidProperties();
        collection.add("TablespaceType");
        collection.add("fileType");
        return collection;
    }
}

