/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.validators;

import java.util.Collection;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.NameInUseException;
import oracle.javatools.db.ora.IndexPartition;
import oracle.javatools.db.ora.LocalIndexPartitionHelper;
import oracle.javatools.db.ora.OracleIndexPartitions;
import oracle.javatools.db.resource.APIBundle;
import oracle.javatools.db.validators.AbstractChildDBObjectValidator;
import oracle.javatools.db.validators.DBObjectValidator;
import oracle.javatools.db.validators.ValidationException;
import oracle.javatools.db.validators.ValidationLevel;
import oracle.javatools.util.ModelUtil;

public class IndexPartitionValidator
extends AbstractChildDBObjectValidator<IndexPartition> {
    public IndexPartitionValidator(DBObjectProvider dBObjectProvider) {
        super(dBObjectProvider);
    }

    protected boolean canHaveEmptyName() {
        return true;
    }

    protected Collection<String> listAlwaysValidProperties() {
        Collection collection = super.listAlwaysValidProperties();
        collection.add("domainParameters");
        collection.add("useKeyCompression");
        collection.add("valuesLessThan");
        return collection;
    }

    @Override
    public DBObjectValidator.NamespaceType getNamespaceType() {
        return DBObjectValidator.NamespaceType.TYPE_PARENT;
    }

    protected void validateNameInUse(IndexPartition indexPartition) throws NameInUseException {
        if (LocalIndexPartitionHelper.getBaseTablePartition(indexPartition) == null) {
            super.validateNameInUse((DBObject)indexPartition);
        }
    }

    @DBObjectValidator.PropertyValidator(value={"globalPartitionColumns"}, level=ValidationLevel.FULL)
    public void validateGlobalRangePartition(IndexPartition indexPartition, IndexPartition indexPartition2) throws ValidationException {
        OracleIndexPartitions oracleIndexPartitions = (OracleIndexPartitions)indexPartition2.getParent();
        if (oracleIndexPartitions != null && oracleIndexPartitions.getPartitionType() == OracleIndexPartitions.PartitionType.GLOBAL_RANGE) {
            Object[] objectArray;
            DBObjectID[] dBObjectIDArray = oracleIndexPartitions.getGlobalPartitionColumns();
            if (dBObjectIDArray.length != (objectArray = indexPartition2.getValuesLessThan()).length) {
                String string = indexPartition2.getName();
                throw new ValidationException((DBObject)indexPartition2, APIBundle.format((String)"INDEX_PARTITION_ERROR_INVALID_VALUES_COUNT", (Object[])new Object[]{ModelUtil.hasLength((String)string) ? string : APIBundle.get((String)"INDEX_PARTITION_VALUE_UNNAMED")}));
            }
            for (Object object : objectArray) {
                if (!"NULL".equalsIgnoreCase(object.toString())) continue;
                String string = indexPartition2.getName();
                throw new ValidationException((DBObject)indexPartition2, APIBundle.format((String)"INDEX_PARTITION_ERROR_INVALID_VALUES_COUNT", (Object[])new Object[]{ModelUtil.hasLength((String)string) ? string : APIBundle.get((String)"INDEX_PARTITION_ERROR_INVALID_NULL_VALUE")}));
            }
        }
    }
}

