/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.validators;

import java.util.Collection;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Table;
import oracle.javatools.db.ora.OracleInMemoryColumnProperties;
import oracle.javatools.db.resource.APIBundle;
import oracle.javatools.db.validators.AbstractChildDBObjectValidator;
import oracle.javatools.db.validators.DBObjectValidator;
import oracle.javatools.db.validators.ValidationContext;
import oracle.javatools.db.validators.ValidationException;
import oracle.javatools.db.validators.ValidationLevel;

public class InMemoryColumnPropertiesValidator
extends AbstractChildDBObjectValidator<OracleInMemoryColumnProperties> {
    public InMemoryColumnPropertiesValidator(DBObjectProvider dBObjectProvider) {
        super(dBObjectProvider);
    }

    protected boolean canHaveEmptyName() {
        return true;
    }

    protected Collection<String> listAlwaysValidProperties() {
        Collection collection = super.listAlwaysValidProperties();
        collection.add("inMemory");
        collection.add("inMemoryCompression");
        return collection;
    }

    @DBObjectValidator.PropertyValidator(value={"columnIDs"})
    public void validateColumnIDs(ValidationContext<OracleInMemoryColumnProperties> validationContext) throws ValidationException {
        if (validationContext.getLevel() == ValidationLevel.FULL) {
            OracleInMemoryColumnProperties[] oracleInMemoryColumnPropertiesArray;
            OracleInMemoryColumnProperties oracleInMemoryColumnProperties = (OracleInMemoryColumnProperties)validationContext.getUpdatedObject();
            DBObjectID[] dBObjectIDArray = oracleInMemoryColumnProperties.getColumnIDs();
            if (dBObjectIDArray == null || dBObjectIDArray.length == 0) {
                throw new ValidationException((DBObject)oracleInMemoryColumnProperties, "columnIDs", APIBundle.get((String)"IM_PROPERTY_COLUMNIDS"));
            }
            DBObject dBObject = oracleInMemoryColumnProperties.getParent();
            for (OracleInMemoryColumnProperties oracleInMemoryColumnProperties2 : oracleInMemoryColumnPropertiesArray = (OracleInMemoryColumnProperties[])((Table)dBObject).getProperty("OracleInMemoryColumnProperties")) {
                DBObjectID[] dBObjectIDArray2;
                if (oracleInMemoryColumnProperties2 == oracleInMemoryColumnProperties || (dBObjectIDArray2 = oracleInMemoryColumnProperties2.getColumnIDs()) == null) continue;
                for (DBObjectID dBObjectID : dBObjectIDArray2) {
                    for (DBObjectID dBObjectID2 : dBObjectIDArray) {
                        if (dBObjectID2 == null || !dBObjectID2.equals(dBObjectID, true)) continue;
                        throw new ValidationException((DBObject)oracleInMemoryColumnProperties, "columnIDs", APIBundle.format((String)"IM_PROPERTY_COLUMNIDS_DUP", (Object[])new Object[]{DBUtil.getDBObjectName((DBObjectID)dBObjectID2)}));
                    }
                }
            }
        }
    }
}

