/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.sxml;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.NameBasedID;
import oracle.javatools.db.Table;
import oracle.javatools.db.ora.MaterializedView;
import oracle.javatools.db.ora.OracleTablePartitions;
import oracle.javatools.db.ora.TablePartition;
import oracle.javatools.db.ora.sxml.SXMLFragmentGenerator;
import oracle.javatools.db.ora.sxml.SXMLGenerator;
import oracle.javatools.db.ora.sxml.SXMLReader;
import oracle.javatools.db.ora.sxml.SXMLReaderException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

class PartitionSXMLGenerator
extends SXMLFragmentGenerator {
    static final String SUBPART_TYPE = "PARTITION_SUB";
    static final String HASHPART_TYPE = "PARTITION_HASH";

    PartitionSXMLGenerator() {
    }

    @Override
    protected void populateNode(Node node, Document document, Object object) {
        DBObject dBObject = (DBObject)object;
        if (dBObject instanceof TablePartition) {
            OracleTablePartitions oracleTablePartitions = ((TablePartition)dBObject).getPartitionLevelSubpartitions();
            if (oracleTablePartitions != null) {
                this.createSubpartitionList(oracleTablePartitions, document, node, "SUBPARTITION_LIST");
            }
        } else if (dBObject instanceof OracleTablePartitions) {
            OracleTablePartitions oracleTablePartitions = ((OracleTablePartitions)dBObject).getSubpartitionModel();
            if (oracleTablePartitions != null) {
                OracleTablePartitions.PartitionType partitionType = oracleTablePartitions.getPartitionType();
                Node node2 = this.findOrCreateNodeAfter(document, node, partitionType + "_SUBPARTITIONING", "COL_LIST");
                this.processPropertyMapping(node2, document, oracleTablePartitions, "COL_LIST//COL_LIST_ITEM/NAME", "partitionColumns");
                Integer n = oracleTablePartitions.getHashQuantity();
                if (partitionType == OracleTablePartitions.PartitionType.HASH && n != null && n > 0) {
                    Node node3 = this.findOrCreateNode(document, node2, "SUBPARTITION_COUNT");
                    node3.appendChild(document.createTextNode(n.toString()));
                } else {
                    this.createSubpartitionList(oracleTablePartitions, document, node2, "SUBPARTITION_TEMPLATE/SUBPARTITION_LIST");
                }
            }
        } else {
            OracleTablePartitions oracleTablePartitions = (OracleTablePartitions)dBObject.getProperty("OracleTablePartitions");
            if (oracleTablePartitions != null) {
                Node node4;
                Object object2;
                Serializable serializable;
                OracleTablePartitions.PartitionType partitionType = oracleTablePartitions.getPartitionType();
                if (object instanceof MaterializedView) {
                    var7_11 = partitionType + "_PARTITIONING";
                    serializable = new HashSet<String>();
                    serializable.add("SCHEMA");
                    serializable.add("NAME");
                    serializable.add("OF_TYPE");
                    serializable.add("SCOPE_CONSTRAINT_LIST");
                    serializable.add("ON_PREBUILT_TABLE");
                    serializable.add("PHYSICAL_PROPERTIES");
                    serializable.add("COLUMN_PROPERTIES");
                    object2 = null;
                    for (int i = 0; i < node.getChildNodes().getLength(); ++i) {
                        if (serializable.contains(node.getChildNodes().item(i).getNodeName())) continue;
                        object2 = node.getChildNodes().item(i).getNodeName();
                        break;
                    }
                    node4 = this.findOrCreateNodeBefore(document, node, var7_11, (String)object2);
                } else {
                    var7_11 = "RELATIONAL_TABLE/TABLE_PROPERTIES/" + partitionType + "_PARTITIONING";
                    node4 = this.findOrCreateNodeBefore(document, node, var7_11, "PARALLEL");
                }
                if (partitionType == OracleTablePartitions.PartitionType.HASH) {
                    this.processPropertyMapping(node4, document, oracleTablePartitions, "COL_LIST//COL_LIST_ITEM/NAME", "partitionColumns");
                    serializable = oracleTablePartitions.getHashQuantity();
                    if (serializable != null && (Integer)serializable > 0) {
                        object2 = this.findOrCreateNode(document, node4, "PARTITIONS_BY_QUANTITY/QUANTITY");
                        object2.appendChild(document.createTextNode(((Integer)serializable).toString()));
                        DBObjectID[] dBObjectIDArray = oracleTablePartitions.getHashQuantityTablespaceIds();
                        if (dBObjectIDArray != null && dBObjectIDArray.length > 0) {
                            Node node5 = this.findOrCreateNode(document, node4, "PARTITIONS_BY_QUANTITY/TABLESPACE_LIST");
                            for (int i = 0; i < dBObjectIDArray.length; ++i) {
                                Node node6 = this.createNode(document, node5, "TABLESPACE");
                                node6.appendChild(document.createTextNode(DBUtil.getDBObjectName((DBObjectID)dBObjectIDArray[i])));
                            }
                        }
                    } else {
                        object2 = this.findOrCreateNode(document, node4, "PARTITION_LIST");
                        TablePartition[] tablePartitionArray = oracleTablePartitions.getPartitions();
                        for (int i = 0; i < tablePartitionArray.length; ++i) {
                            Node node7 = this.createNode(document, (Node)object2, "PARTITION_LIST_ITEM");
                            ((SXMLGenerator)this.getParentGenerator()).populateNodeImpl(node7, document, tablePartitionArray[i], HASHPART_TYPE);
                        }
                    }
                } else {
                    this.getParentGenerator().populateNode(node4, document, oracleTablePartitions);
                }
            }
        }
    }

    private void createSubpartitionList(OracleTablePartitions oracleTablePartitions, Document document, Node node, String string) {
        Node node2 = this.findOrCreateNode(document, node, string);
        TablePartition[] tablePartitionArray = oracleTablePartitions.getPartitions();
        for (int i = 0; i < tablePartitionArray.length; ++i) {
            Node node3 = this.createNode(document, node2, "SUBPARTITION_LIST_ITEM");
            ((SXMLGenerator)this.getParentGenerator()).populateNodeImpl(node3, document, tablePartitionArray[i], SUBPART_TYPE);
        }
    }

    @Override
    protected void readNode(Node node, Object object) throws SXMLReaderException {
        SXMLReader sXMLReader = (SXMLReader)this.getParentGenerator();
        if (object instanceof Table) {
            Table table = (Table)object;
            NameBasedID nameBasedID = new NameBasedID("TABLE", table.getSchema().getName(), table.getName());
            Node node2 = node;
            if (!(object instanceof MaterializedView) && (node2 = this.findNode(node, "RELATIONAL_TABLE/TABLE_PROPERTIES")) == null) {
                return;
            }
            boolean bl = false;
            boolean bl2 = false;
            OracleTablePartitions oracleTablePartitions = new OracleTablePartitions();
            oracleTablePartitions.setObjectType(OracleTablePartitions.ObjectType.PARTITION);
            if (this.nodeExists(node2, "RANGE_PARTITIONING")) {
                bl = true;
                oracleTablePartitions.setPartitionType(OracleTablePartitions.PartitionType.RANGE);
                node2 = this.findNode(node2, "RANGE_PARTITIONING");
            } else if (this.nodeExists(node2, "LIST_PARTITIONING")) {
                bl = true;
                oracleTablePartitions.setPartitionType(OracleTablePartitions.PartitionType.LIST);
                node2 = this.findNode(node2, "LIST_PARTITIONING");
            } else if (this.nodeExists(node2, "HASH_PARTITIONING")) {
                bl = true;
                bl2 = true;
                oracleTablePartitions.setPartitionType(OracleTablePartitions.PartitionType.HASH);
                node2 = this.findNode(node2, "HASH_PARTITIONING");
            } else if (this.nodeExists(node2, "REFERENCE_PARTITIONING")) {
                bl = true;
                oracleTablePartitions.setPartitionType(OracleTablePartitions.PartitionType.REFERENCE);
                node2 = this.findNode(node2, "REFERENCE_PARTITIONING");
            }
            if (bl) {
                table.setProperty("OracleTablePartitions", (Object)oracleTablePartitions);
                if (bl2) {
                    Object object2;
                    Object object3;
                    ArrayList<Object> arrayList;
                    Object object4;
                    ArrayList<NameBasedID> arrayList2 = new ArrayList<NameBasedID>();
                    Node node3 = this.findNode(node2, "COL_LIST");
                    if (node3 != null) {
                        object4 = new SXMLFragmentGenerator.childXMLElementIterator(node3);
                        while (object4.hasNext()) {
                            arrayList = (Node)object4.next();
                            object3 = this.nodeText((Node)((Object)arrayList), "NAME");
                            object2 = new NameBasedID("COLUMN", (String)object3, (DBObjectID)nameBasedID);
                            arrayList2.add((NameBasedID)object2);
                        }
                    }
                    oracleTablePartitions.setPartitionColumns(arrayList2.toArray(new DBObjectID[arrayList2.size()]));
                    if (this.nodeExists(node2, "PARTITIONS_BY_QUANTITY/QUANTITY")) {
                        oracleTablePartitions.setHashQuantity(Integer.valueOf(this.nodeText(node2, "PARTITIONS_BY_QUANTITY/QUANTITY")));
                        object4 = this.findNode(node2, "PARTITIONS_BY_QUANTITY/TABLESPACE_LIST");
                        if (object4 != null) {
                            arrayList = new ArrayList<Object>();
                            object3 = new SXMLFragmentGenerator.childXMLElementIterator((Node)object4);
                            while (object3.hasNext()) {
                                object2 = (Node)object3.next();
                                NameBasedID nameBasedID2 = new NameBasedID("TABLESPACE", null, object2.getTextContent());
                                arrayList.add(nameBasedID2);
                            }
                            oracleTablePartitions.setHashQuantityTablespaceIds(arrayList.toArray(new DBObjectID[arrayList.size()]));
                        }
                    } else {
                        object4 = this.findNode(node2, "PARTITION_LIST");
                        if (object4 != null) {
                            arrayList = new ArrayList();
                            object3 = new SXMLFragmentGenerator.childXMLElementIterator((Node)object4);
                            while (object3.hasNext()) {
                                object2 = (Node)object3.next();
                                TablePartition tablePartition = new TablePartition();
                                ((SXMLReader)this.getParentGenerator()).fillInObject(tablePartition, (Node)object2, null, HASHPART_TYPE);
                                arrayList.add(tablePartition);
                            }
                            oracleTablePartitions.setPartitions(arrayList.toArray(new TablePartition[arrayList.size()]));
                        }
                    }
                } else {
                    sXMLReader.fillInObject(oracleTablePartitions, node2, null);
                }
            }
        } else if (object instanceof TablePartition) {
            TablePartition tablePartition = (TablePartition)object;
            Node node4 = this.findNode(node, "SUBPARTITION_LIST");
            if (node4 != null) {
                OracleTablePartitions oracleTablePartitions = new OracleTablePartitions();
                tablePartition.setPartitionLevelSubpartitions(oracleTablePartitions);
                oracleTablePartitions.setObjectType(OracleTablePartitions.ObjectType.PARTITION_LEVEL_SUBPARTITION);
                this.readSubpartitionList(node4, oracleTablePartitions);
            }
        } else if (object instanceof OracleTablePartitions) {
            Object object5;
            Node node5 = null;
            boolean bl = false;
            OracleTablePartitions oracleTablePartitions = (OracleTablePartitions)object;
            OracleTablePartitions oracleTablePartitions2 = new OracleTablePartitions();
            oracleTablePartitions2.setObjectType(OracleTablePartitions.ObjectType.SUBPARTITION_TEMPLATE);
            if (this.nodeExists(node, "RANGE_SUBPARTITIONING")) {
                bl = true;
                oracleTablePartitions2.setPartitionType(OracleTablePartitions.PartitionType.RANGE);
                node5 = this.findNode(node, "RANGE_SUBPARTITIONING");
            } else if (this.nodeExists(node, "LIST_SUBPARTITIONING")) {
                bl = true;
                oracleTablePartitions2.setPartitionType(OracleTablePartitions.PartitionType.LIST);
                node5 = this.findNode(node, "LIST_SUBPARTITIONING");
            } else if (this.nodeExists(node, "HASH_SUBPARTITIONING")) {
                bl = true;
                oracleTablePartitions2.setPartitionType(OracleTablePartitions.PartitionType.HASH);
                node5 = this.findNode(node, "HASH_SUBPARTITIONING");
                object5 = this.nodeText(node5, "SUBPARTITION_COUNT");
                if (object5 != null) {
                    oracleTablePartitions2.setHashQuantity(Integer.valueOf((String)object5));
                }
            }
            if (bl) {
                Object object6;
                oracleTablePartitions.setSubpartitionModel(oracleTablePartitions2);
                object5 = (Table)oracleTablePartitions.getParent();
                NameBasedID nameBasedID = new NameBasedID("TABLE", object5.getSchema().getName(), object5.getName());
                Node node6 = this.findNode(node5, "COL_LIST");
                if (node6 != null) {
                    object6 = new ArrayList();
                    SXMLFragmentGenerator.childXMLElementIterator childXMLElementIterator2 = new SXMLFragmentGenerator.childXMLElementIterator(node6);
                    while (childXMLElementIterator2.hasNext()) {
                        Node node7 = (Node)childXMLElementIterator2.next();
                        String string = this.nodeText(node7, "NAME");
                        NameBasedID nameBasedID3 = new NameBasedID("COLUMN", string, (DBObjectID)nameBasedID);
                        ((ArrayList)object6).add(nameBasedID3);
                    }
                    oracleTablePartitions2.setPartitionColumns(((ArrayList)object6).toArray(new DBObjectID[((ArrayList)object6).size()]));
                }
                if ((object6 = this.findNode(node5, "SUBPARTITION_TEMPLATE/SUBPARTITION_LIST")) != null) {
                    this.readSubpartitionList((Node)object6, oracleTablePartitions2);
                }
            }
        }
    }

    private void readSubpartitionList(Node node, OracleTablePartitions oracleTablePartitions) throws SXMLReaderException {
        ArrayList<TablePartition> arrayList = new ArrayList<TablePartition>();
        SXMLFragmentGenerator.childXMLElementIterator childXMLElementIterator2 = new SXMLFragmentGenerator.childXMLElementIterator(node);
        while (childXMLElementIterator2.hasNext()) {
            Node node2 = (Node)childXMLElementIterator2.next();
            TablePartition tablePartition = new TablePartition();
            ((SXMLReader)this.getParentGenerator()).fillInObject(tablePartition, node2, null, SUBPART_TYPE);
            arrayList.add(tablePartition);
        }
        oracleTablePartitions.setPartitions(arrayList.toArray(new TablePartition[arrayList.size()]));
    }
}

