/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.sxml;

import oracle.javatools.db.ora.MaterializedView;
import oracle.javatools.db.ora.sxml.SXMLFragmentGenerator;
import oracle.javatools.db.ora.sxml.SXMLReader;
import oracle.javatools.util.ModelUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

class MatViewSXMLGenerator
extends SXMLFragmentGenerator {
    MatViewSXMLGenerator() {
    }

    @Override
    protected void populateNode(Node node, Document document, Object object) {
        MaterializedView materializedView = (MaterializedView)object;
        String string = materializedView.getRollbackSegmentName();
        MaterializedView.RollbackSegmentType rollbackSegmentType = materializedView.getRollbackSegmentType();
        String string2 = null;
        if (rollbackSegmentType == MaterializedView.RollbackSegmentType.LOCAL) {
            string2 = "REFRESH/LOCAL_ROLLBACK_SEGMENT";
        } else if (rollbackSegmentType == MaterializedView.RollbackSegmentType.MASTER) {
            string2 = "REFRESH/MASTER_ROLLBACK_SEGMENT";
        }
        if (string2 != null) {
            Node node2 = this.findOrCreateNodeBefore(document, node, string2, "CONSTRAINTS");
            if (ModelUtil.hasLength((String)string)) {
                Node node3 = this.findOrCreateNode(document, node, string2 + "/NAME");
                node3.appendChild(document.createTextNode(string));
            } else {
                Node node4 = this.findOrCreateNode(document, node, string2 + "/DEFAULT");
            }
        }
    }

    @Override
    protected void readNode(Node node, Object object) {
        SXMLReader sXMLReader = (SXMLReader)this.getParentGenerator();
        MaterializedView materializedView = (MaterializedView)object;
        if (this.nodeExists(node, "REFRESH/LOCAL_ROLLBACK_SEGMENT")) {
            materializedView.setRollbackSegmentType(MaterializedView.RollbackSegmentType.LOCAL);
            materializedView.setRollbackSegmentName(this.nodeText(node, "REFRESH/LOCAL_ROLLBACK_SEGMENT/NAME"));
        } else if (this.nodeExists(node, "REFRESH/MASTER_ROLLBACK_SEGMENT")) {
            materializedView.setRollbackSegmentType(MaterializedView.RollbackSegmentType.MASTER);
            materializedView.setRollbackSegmentName(this.nodeText(node, "REFRESH/MASTER_ROLLBACK_SEGMENT/NAME"));
        }
    }
}

