/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.sxml;

import oracle.javatools.db.BaseObjectID;
import oracle.javatools.db.Column;
import oracle.javatools.db.IdentityColumnProperties;
import oracle.javatools.db.NameBasedID;
import oracle.javatools.db.ora.sxml.SXMLFragmentGenerator;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

class ColumnSequenceSXMLGenerator
extends SXMLFragmentGenerator {
    private static final String BASE = "CUSTOMER_AREA/ODB_PROPERTY_LIST";
    private static final String COLSEQ_TRIGGER_SCHEMA = "COLSEQ_TRIGGER_SCHEMA";
    private static final String COLSEQ_TRIGGER_NAME = "COLSEQ_TRIGGER_NAME";
    private static final String COLSEQ_SEQUENCE_SCHEMA = "COLSEQ_SEQUENCE_SCHEMA";
    private static final String COLSEQ_SEQUENCE_NAME = "COLSEQ_SEQUENCE_NAME";
    private static final String COLSEQ_REUSE = "COLSEQ_REUSE";
    private static final String COLSEQ_CHECKNULL = "COLSEQ_CHECKNULL";
    private static final String YES = "Y";
    private static final String NO = "N";

    ColumnSequenceSXMLGenerator() {
    }

    @Override
    protected void populateNode(Node node, Document document, Object object) {
        if (object instanceof Column) {
            Column column = (Column)object;
            if (column.getIdentityProperties() != null) {
                IdentityColumnProperties.GeneratedType generatedType = column.getIdentityProperties().getGenerated();
                Node node2 = this.findNode(node, "IDENTITY_COLUMN");
                Node node3 = node2.getFirstChild();
                Node node4 = this.findOrCreateNodeBefore(document, node2, "GENERATION", node3.getNodeName());
                String string = generatedType == null || generatedType == IdentityColumnProperties.GeneratedType.ALWAYS ? "ALWAYS" : "DEFAULT";
                node4.appendChild(document.createTextNode(string));
                if (generatedType == IdentityColumnProperties.GeneratedType.BY_DEFAULT_ON_NULL) {
                    this.findOrCreateNodeAfter(document, node2, "ON_NULL", "GENERATION");
                }
            } else if (column.getProperty("AUTO_GENERATED_SEQUENCE_TRIGGER") != null) {
                Boolean bl;
                BaseObjectID baseObjectID;
                BaseObjectID baseObjectID2 = (BaseObjectID)column.getProperty("AUTO_GENERATED_SEQUENCE_TRIGGER");
                if (baseObjectID2 != null) {
                    this.add(node, document, COLSEQ_TRIGGER_SCHEMA, baseObjectID2.getSchemaName());
                    this.add(node, document, COLSEQ_TRIGGER_NAME, baseObjectID2.getName());
                }
                if ((baseObjectID = (BaseObjectID)column.getProperty("AUTO_GENERATED_SEQUENCE")) != null) {
                    this.add(node, document, COLSEQ_SEQUENCE_SCHEMA, baseObjectID.getSchemaName());
                    this.add(node, document, COLSEQ_SEQUENCE_NAME, baseObjectID.getName());
                }
                this.add(node, document, COLSEQ_REUSE, Boolean.TRUE.equals(bl = (Boolean)column.getProperty("ColumnSequenceExpander.ReuseSequence")) ? YES : NO);
                Boolean bl2 = (Boolean)column.getProperty("ColumnSequenceExpander.TriggerNullCheck");
                this.add(node, document, COLSEQ_CHECKNULL, Boolean.TRUE.equals(bl2) ? YES : NO);
            }
        }
    }

    @Override
    protected void readNode(Node node, Object object) {
        if (object instanceof Column) {
            Column column = (Column)object;
            if (this.nodeExists(node, "IDENTITY_COLUMN")) {
                IdentityColumnProperties identityColumnProperties = column.getIdentityProperties();
                if (identityColumnProperties == null) {
                    identityColumnProperties = new IdentityColumnProperties();
                    column.setIdentityProperties(identityColumnProperties);
                }
                String string = this.nodeText(node, "IDENTITY_COLUMN/GENERATION");
                boolean bl = this.nodeExists(node, "IDENTITY_COLUMN/ON_NULL");
                if ("DEFAULT".equals(string)) {
                    identityColumnProperties.setGenerated(bl ? IdentityColumnProperties.GeneratedType.BY_DEFAULT_ON_NULL : IdentityColumnProperties.GeneratedType.BY_DEFAULT);
                } else {
                    identityColumnProperties.setGenerated(IdentityColumnProperties.GeneratedType.ALWAYS);
                }
                if (Boolean.FALSE.equals(identityColumnProperties.getCacheFlag())) {
                    identityColumnProperties.setCacheSize(null);
                }
            } else if (this.nodeExists(node, "CUSTOMER_AREA/ODB_PROPERTY_LIST/COLSEQ_SEQUENCE_NAME")) {
                NameBasedID nameBasedID = new NameBasedID();
                nameBasedID.setType("SEQUENCE");
                nameBasedID.setSchemaName(this.nodeText(node, "CUSTOMER_AREA/ODB_PROPERTY_LIST/COLSEQ_SEQUENCE_SCHEMA"));
                nameBasedID.setName(this.nodeText(node, "CUSTOMER_AREA/ODB_PROPERTY_LIST/COLSEQ_SEQUENCE_NAME"));
                NameBasedID nameBasedID2 = new NameBasedID();
                nameBasedID2.setType("TRIGGER");
                nameBasedID2.setSchemaName(this.nodeText(node, "CUSTOMER_AREA/ODB_PROPERTY_LIST/COLSEQ_TRIGGER_SCHEMA"));
                nameBasedID2.setName(this.nodeText(node, "CUSTOMER_AREA/ODB_PROPERTY_LIST/COLSEQ_TRIGGER_NAME"));
                Boolean bl = YES.equals(this.nodeText(node, "CUSTOMER_AREA/ODB_PROPERTY_LIST/COLSEQ_REUSE"));
                Boolean bl2 = YES.equals(this.nodeText(node, "CUSTOMER_AREA/ODB_PROPERTY_LIST/COLSEQ_CHECKNULL"));
                column.setProperty("AUTO_GENERATED_SEQUENCE", (Object)nameBasedID);
                column.setProperty("AUTO_GENERATED_SEQUENCE_TRIGGER", (Object)nameBasedID2);
                column.setProperty("ColumnSequenceExpander.ReuseSequence", (Object)bl);
                column.setProperty("ColumnSequenceExpander.TriggerNullCheck", (Object)bl2);
            }
        }
    }

    private void add(Node node, Document document, String string, String string2) {
        Node node2 = this.findOrCreateNode(document, node, BASE);
        Node node3 = this.createNode(document, node2, string);
        node3.appendChild(document.createTextNode(string2));
    }
}

