/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.sql;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import oracle.dbtools.parser.ParseNode;
import oracle.javatools.db.DatabaseDescriptor;
import oracle.javatools.db.ora.sql.ExpressionContext;
import oracle.javatools.db.ora.sql.ExpressionFactory;
import oracle.javatools.db.ora.sql.OracleSQLQueryBuilderHelper;
import oracle.javatools.db.sql.ExpressionList;
import oracle.javatools.db.sql.OrderByObject;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.db.sql.SQLQueryException;
import oracle.javatools.db.sql.WindowFunction;

public class WindowFunctionBuilder
extends ExpressionFactory {
    @Override
    public SQLFragment createFragment(ExpressionContext expressionContext, ParseNode parseNode) throws SQLQueryException {
        WindowFunction windowFunction = null;
        OracleSQLQueryBuilderHelper oracleSQLQueryBuilderHelper = expressionContext.getHelper();
        if (oracleSQLQueryBuilderHelper.isRule(parseNode, "analytic_function")) {
            SQLFragment[] sQLFragmentArray;
            List<ParseNode> list = oracleSQLQueryBuilderHelper.getOrderedChildren(parseNode);
            String string = oracleSQLQueryBuilderHelper.getContent(list.get(0));
            string = string.toUpperCase();
            ParseNode parseNode2 = parseNode;
            if (oracleSQLQueryBuilderHelper.isRule(list.get(0), "count")) {
                parseNode2 = list.get(0);
                sQLFragmentArray = new ArrayList();
                for (ParseNode databaseDescriptor2 : list) {
                    sQLFragmentArray.addAll(oracleSQLQueryBuilderHelper.getOrderedChildren(databaseDescriptor2));
                }
                list.clear();
                list.addAll((Collection<ParseNode>)sQLFragmentArray);
                string = oracleSQLQueryBuilderHelper.getContent(list.get(0));
                string = string.toUpperCase();
            }
            sQLFragmentArray = null;
            boolean bl = false;
            DatabaseDescriptor databaseDescriptor = expressionContext.getProvider().getDescriptor();
            for (SQLFragment[] sQLFragmentArray2 : databaseDescriptor.listBuiltInFunctions(string)) {
                if (sQLFragmentArray == null) {
                    sQLFragmentArray = sQLFragmentArray2;
                }
                if (!sQLFragmentArray2.isAggregate()) continue;
                bl = true;
            }
            if (sQLFragmentArray != null) {
                SQLFragment[] sQLFragmentArray2;
                WindowFunction windowFunction2 = new WindowFunction();
                windowFunction2.setFunction(sQLFragmentArray.getName());
                windowFunction2.setGrouping(bl);
                if (oracleSQLQueryBuilderHelper.isKeyword(list.get(2), "DISTINCT")) {
                    windowFunction2.setGrouping(true);
                    windowFunction2.setDistinct(true);
                    windowFunction2.setDistinctSource(oracleSQLQueryBuilderHelper.getContent(list.get(2)));
                } else if (oracleSQLQueryBuilderHelper.isKeyword(list.get(2), "ALL")) {
                    windowFunction2.setGrouping(true);
                    windowFunction2.setDistinct(false);
                    windowFunction2.setDistinctSource(oracleSQLQueryBuilderHelper.getContent(list.get(2)));
                }
                sQLFragmentArray2 = expressionContext.getArgList(windowFunction2, parseNode2);
                windowFunction2.setArguments(sQLFragmentArray2);
                int n = oracleSQLQueryBuilderHelper.getKeywordIndex(list, "WITHIN");
                if (n >= 0) {
                    this.processWithinGroup(list, n, windowFunction2, expressionContext);
                }
                if ((n = oracleSQLQueryBuilderHelper.getKeywordIndex(list, "FROM")) >= 0) {
                    this.processFrom(list, n, windowFunction2, expressionContext);
                }
                if ((n = oracleSQLQueryBuilderHelper.getKeywordIndex(list, "NULLS")) >= 0) {
                    this.processNulls(list, n - 1, windowFunction2, expressionContext);
                }
                if ((n = oracleSQLQueryBuilderHelper.getKeywordIndex(list, "OVER")) >= 0) {
                    this.processOver(list, n + 2, windowFunction2, expressionContext);
                }
                if ((n = oracleSQLQueryBuilderHelper.getRuleIndex(list, "over_clause")) >= 0) {
                    this.processOver(list.get(n), windowFunction2, expressionContext);
                }
                windowFunction = windowFunction2;
            }
        }
        return windowFunction;
    }

    private void processOver(ParseNode parseNode, WindowFunction windowFunction, ExpressionContext expressionContext) throws SQLQueryException {
        List<ParseNode> list = expressionContext.getHelper().getOrderedChildren(parseNode);
        this.processOver(list, 2, windowFunction, expressionContext);
    }

    private void processOver(List<ParseNode> list, int n, WindowFunction windowFunction, ExpressionContext expressionContext) throws SQLQueryException {
        ParseNode parseNode = null;
        OracleSQLQueryBuilderHelper oracleSQLQueryBuilderHelper = expressionContext.getHelper();
        if (oracleSQLQueryBuilderHelper.isRule(list.get(n), "analytic_clause", "query_partition_clause")) {
            ParseNode parseNode2 = null;
            ParseNode parseNode3 = null;
            if (oracleSQLQueryBuilderHelper.isRule(list.get(n), "query_partition_clause")) {
                parseNode2 = list.get(n);
            } else if (oracleSQLQueryBuilderHelper.isRule(list.get(n), "order_by_clause")) {
                parseNode3 = list.get(n);
            } else if (oracleSQLQueryBuilderHelper.isRule(list.get(n), "windowing_clause")) {
                parseNode = list.get(n);
            } else {
                List<ParseNode> list2 = oracleSQLQueryBuilderHelper.getOrderedChildren(list.get(n));
                for (ParseNode parseNode4 : list2) {
                    if (oracleSQLQueryBuilderHelper.isRule(parseNode4, "query_partition_clause")) {
                        parseNode2 = parseNode4;
                        continue;
                    }
                    if (oracleSQLQueryBuilderHelper.isRule(parseNode4, "order_by_clause")) {
                        parseNode3 = parseNode4;
                        continue;
                    }
                    if (!oracleSQLQueryBuilderHelper.isRule(parseNode4, "windowing_clause")) continue;
                    parseNode = parseNode4;
                }
            }
            if (parseNode2 != null) {
                this.processQueryPartitionClause(windowFunction, parseNode2, expressionContext);
            }
            if (parseNode3 != null) {
                this.processOrderBy(windowFunction, parseNode3, expressionContext);
            }
            ++n;
        }
        if (parseNode != null) {
            this.buildBounds(parseNode, windowFunction, expressionContext);
        }
    }

    private void processQueryPartitionClause(WindowFunction windowFunction, ParseNode parseNode, ExpressionContext expressionContext) throws SQLQueryException {
        ExpressionList expressionList = (ExpressionList)expressionContext.createFragment(parseNode, (SQLFragment)windowFunction);
        windowFunction.setPartitionBy(expressionList.getArguments());
    }

    private void processOrderBy(WindowFunction windowFunction, ParseNode parseNode, ExpressionContext expressionContext) throws SQLQueryException {
        ExpressionList expressionList = (ExpressionList)expressionContext.createFragment(parseNode, (SQLFragment)windowFunction);
        SQLFragment[] sQLFragmentArray = expressionList.getArguments();
        OrderByObject[] orderByObjectArray = new OrderByObject[sQLFragmentArray.length];
        for (int i = 0; i < sQLFragmentArray.length; ++i) {
            orderByObjectArray[i] = (OrderByObject)sQLFragmentArray[i];
        }
        windowFunction.setOrderBy(orderByObjectArray);
    }

    private void buildBounds(ParseNode parseNode, WindowFunction windowFunction, ExpressionContext expressionContext) throws SQLQueryException {
        int n;
        List<ParseNode> list;
        WindowFunction.WindowFunctionBound[] windowFunctionBoundArray = null;
        OracleSQLQueryBuilderHelper oracleSQLQueryBuilderHelper = expressionContext.getHelper();
        if (oracleSQLQueryBuilderHelper.isKeyword((list = oracleSQLQueryBuilderHelper.getOrderedChildren(parseNode)).get(n = 0), "ROWS")) {
            windowFunction.setClauseType(WindowFunction.ClauseType.ROWS);
        } else if (oracleSQLQueryBuilderHelper.isKeyword(list.get(n), "RANGE")) {
            windowFunction.setClauseType(WindowFunction.ClauseType.RANGE);
        }
        int n2 = 1;
        if (oracleSQLQueryBuilderHelper.isKeyword(list.get(++n), "BETWEEN")) {
            n2 = 2;
            ++n;
        }
        windowFunctionBoundArray = new WindowFunction.WindowFunctionBound[n2];
        for (int i = 0; i < n2; ++i) {
            windowFunctionBoundArray[i] = new WindowFunction.WindowFunctionBound();
            if (oracleSQLQueryBuilderHelper.isKeyword(list.get(n), "UNBOUNDED") && oracleSQLQueryBuilderHelper.isKeyword(list.get(n + 1), "PRECEDING")) {
                n += 2;
                windowFunctionBoundArray[i].setBoundType(WindowFunction.BoundType.PRECEDING);
            } else if (oracleSQLQueryBuilderHelper.isKeyword(list.get(n), "UNBOUNDED") && oracleSQLQueryBuilderHelper.isKeyword(list.get(n + 1), "FOLLOWING")) {
                n += 2;
                windowFunctionBoundArray[i].setBoundType(WindowFunction.BoundType.FOLLOWING);
            } else if (oracleSQLQueryBuilderHelper.isKeyword(list.get(n), "CURRENT") && oracleSQLQueryBuilderHelper.isKeyword(list.get(n + 1), "ROW")) {
                n += 2;
                windowFunctionBoundArray[i].setBoundType(WindowFunction.BoundType.CURRENT_ROW);
            } else {
                SQLFragment sQLFragment = expressionContext.createFragment(list.get(n), (SQLFragment)windowFunction);
                windowFunctionBoundArray[i].setBoundExpr(new SQLFragment[]{sQLFragment});
                if (oracleSQLQueryBuilderHelper.isKeyword(list.get(++n), "PRECEDING")) {
                    windowFunctionBoundArray[i].setBoundType(WindowFunction.BoundType.PRECEDING);
                } else if (oracleSQLQueryBuilderHelper.isKeyword(list.get(n), "FOLLOWING")) {
                    windowFunctionBoundArray[i].setBoundType(WindowFunction.BoundType.FOLLOWING);
                }
                ++n;
            }
            if (n >= list.size() || !oracleSQLQueryBuilderHelper.isKeyword(list.get(n), "and")) continue;
            ++n;
        }
        windowFunction.setBounds((SQLFragment[])windowFunctionBoundArray);
    }

    private void processWithinGroup(List<ParseNode> list, int n, WindowFunction windowFunction, ExpressionContext expressionContext) throws SQLQueryException {
        int n2 = n + 3;
        this.processOrderBy(windowFunction, list.get(n2), expressionContext);
    }

    private void processNulls(List<ParseNode> list, int n, WindowFunction windowFunction, ExpressionContext expressionContext) {
        OracleSQLQueryBuilderHelper oracleSQLQueryBuilderHelper = expressionContext.getHelper();
        if (oracleSQLQueryBuilderHelper.isKeyword(list.get(n), "RESPECT")) {
            windowFunction.setNullPolicy(WindowFunction.NullPolicy.RESPECT);
        } else if (oracleSQLQueryBuilderHelper.isKeyword(list.get(n), "IGNORE")) {
            windowFunction.setNullPolicy(WindowFunction.NullPolicy.IGNORE);
        }
    }

    private void processFrom(List<ParseNode> list, int n, WindowFunction windowFunction, ExpressionContext expressionContext) {
        OracleSQLQueryBuilderHelper oracleSQLQueryBuilderHelper = expressionContext.getHelper();
        if (oracleSQLQueryBuilderHelper.isKeyword(list.get(n + 1), "FIRST")) {
            windowFunction.setFromPolicy(WindowFunction.FromPolicy.FIRST);
        } else if (oracleSQLQueryBuilderHelper.isKeyword(list.get(n + 1), "LAST")) {
            windowFunction.setFromPolicy(WindowFunction.FromPolicy.LAST);
        }
    }
}

