/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.sql;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.ParseNode;
import oracle.javatools.db.AbstractDBObjectProvider;
import oracle.javatools.db.BaseObjectID;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectFactory;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Database;
import oracle.javatools.db.DatabaseDescriptor;
import oracle.javatools.db.Relation;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.Synonym;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.ViewColumn;
import oracle.javatools.db.datatypes.DataTypeHelper;
import oracle.javatools.db.datatypes.DataTypeID;
import oracle.javatools.db.datatypes.DataTypeUsage;
import oracle.javatools.db.event.DBObjectChange;
import oracle.javatools.db.ora.sql.ArithmeticOperationBuilder;
import oracle.javatools.db.ora.sql.BuiltInFunctionBuilder;
import oracle.javatools.db.ora.sql.CaseBuilder;
import oracle.javatools.db.ora.sql.ColumnBuilder;
import oracle.javatools.db.ora.sql.CompoundExpressionBuilder;
import oracle.javatools.db.ora.sql.ConditionBuilder;
import oracle.javatools.db.ora.sql.DataMiningFunctionBuilder;
import oracle.javatools.db.ora.sql.ExpressionContext;
import oracle.javatools.db.ora.sql.ExpressionFactory;
import oracle.javatools.db.ora.sql.GroupByExpressionBuilder;
import oracle.javatools.db.ora.sql.Keywords;
import oracle.javatools.db.ora.sql.LiteralBuilder;
import oracle.javatools.db.ora.sql.ModelBuilder;
import oracle.javatools.db.ora.sql.ModelExpressionBuilder;
import oracle.javatools.db.ora.sql.MultiColumnForLoopBuilder;
import oracle.javatools.db.ora.sql.OracleSQLQueryBuilderHelper;
import oracle.javatools.db.ora.sql.OrderByBuilder;
import oracle.javatools.db.ora.sql.ParenthesisBuilder;
import oracle.javatools.db.ora.sql.ParserRules;
import oracle.javatools.db.ora.sql.PartitionByBuilder;
import oracle.javatools.db.ora.sql.QueryBlockBuilder;
import oracle.javatools.db.ora.sql.RelationalPropertiesBuilder;
import oracle.javatools.db.ora.sql.SetOperationBuilder;
import oracle.javatools.db.ora.sql.SingleColumnForLoopBuilder;
import oracle.javatools.db.ora.sql.UnrecognizedFragmentException;
import oracle.javatools.db.ora.sql.UserFunctionBuilder;
import oracle.javatools.db.ora.sql.WhereObjectBuilder;
import oracle.javatools.db.ora.sql.WindowFunctionBuilder;
import oracle.javatools.db.property.DerivedPropertyBuilder;
import oracle.javatools.db.resource.APIBundle;
import oracle.javatools.db.sql.AbstractSQLFragment;
import oracle.javatools.db.sql.AbstractSQLQueryBuilder;
import oracle.javatools.db.sql.AbstractSchemaObjectUsage;
import oracle.javatools.db.sql.AliasFragment;
import oracle.javatools.db.sql.BuiltInFunction;
import oracle.javatools.db.sql.ColumnKeywordUsage;
import oracle.javatools.db.sql.ColumnUsage;
import oracle.javatools.db.sql.ConnectByRoot;
import oracle.javatools.db.sql.DBObjectUsage;
import oracle.javatools.db.sql.ExpressionList;
import oracle.javatools.db.sql.FromObject;
import oracle.javatools.db.sql.FromObjectUsage;
import oracle.javatools.db.sql.Function;
import oracle.javatools.db.sql.FunctionUsage;
import oracle.javatools.db.sql.GroupByObject;
import oracle.javatools.db.sql.HierarchicalQueryObject;
import oracle.javatools.db.sql.InvalidAliasException;
import oracle.javatools.db.sql.JoinCondition;
import oracle.javatools.db.sql.JoinObject;
import oracle.javatools.db.sql.ModelObject;
import oracle.javatools.db.sql.OnJoinCondition;
import oracle.javatools.db.sql.OrderByObject;
import oracle.javatools.db.sql.RelationUsage;
import oracle.javatools.db.sql.SQLCallable;
import oracle.javatools.db.sql.SQLDerivedPropertySupport;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.db.sql.SQLFragmentWithDatatype;
import oracle.javatools.db.sql.SQLParseException;
import oracle.javatools.db.sql.SQLQuery;
import oracle.javatools.db.sql.SQLQueryCancelledException;
import oracle.javatools.db.sql.SQLQueryClauseException;
import oracle.javatools.db.sql.SQLQueryException;
import oracle.javatools.db.sql.SQLQueryOwner;
import oracle.javatools.db.sql.SelectObject;
import oracle.javatools.db.sql.SetOperator;
import oracle.javatools.db.sql.SimpleSQLFragment;
import oracle.javatools.db.sql.SynonymUsage;
import oracle.javatools.db.sql.UsingJoinCondition;
import oracle.javatools.db.sql.WhereObject;
import oracle.javatools.db.sql.WithClauseUsage;
import oracle.javatools.db.sql.XMLFunctionUsage;
import oracle.javatools.util.Holder;
import oracle.javatools.util.ModelUtil;
import oracle.javatools.util.Tuple;

public class OracleSQLQueryBuilder
extends AbstractSQLQueryBuilder
implements Keywords,
ParserRules {
    private static final String DUAL = "DUAL";
    private static final String SELECT_ = "SELECT ";
    private static final String ORDER_BY_ = "ORDER BY ";
    private static final Collection<String> s_joinKeywords = Arrays.asList("FULL", "LEFT", "RIGHT", "INNER", "CROSS", "NATURAL", "JOIN", "OUTER");
    private final OracleSQLQueryBuilder m_parentBuilder;
    private final List<Tuple<String, DataTypeUsage>> m_columnInfos = new ArrayList<Tuple<String, DataTypeUsage>>();
    private final Holder<OracleSQLQueryBuilderHelper> m_helper = new Holder();
    private final List<ExpressionFactory> m_expressionFactories = new ArrayList<ExpressionFactory>();

    public OracleSQLQueryBuilder(DBObjectProvider dBObjectProvider, Schema schema) {
        this(dBObjectProvider, schema, null, null);
    }

    private OracleSQLQueryBuilder(DBObjectProvider dBObjectProvider, Schema schema, OracleSQLQueryBuilderHelper oracleSQLQueryBuilderHelper, OracleSQLQueryBuilder oracleSQLQueryBuilder) {
        super(dBObjectProvider, schema);
        this.m_helper.set((Object)oracleSQLQueryBuilderHelper);
        this.m_parentBuilder = oracleSQLQueryBuilder;
        this.m_expressionFactories.add(new LiteralBuilder());
        this.m_expressionFactories.add(new ColumnBuilder());
        this.m_expressionFactories.add(new ConditionBuilder());
        this.m_expressionFactories.add(new ArithmeticOperationBuilder());
        this.m_expressionFactories.add(new DataMiningFunctionBuilder());
        this.m_expressionFactories.add(new WindowFunctionBuilder());
        this.m_expressionFactories.add(new BuiltInFunctionBuilder());
        this.m_expressionFactories.add(new UserFunctionBuilder());
        this.m_expressionFactories.add(new GroupByExpressionBuilder());
        this.m_expressionFactories.add(new CaseBuilder());
        this.m_expressionFactories.add(new QueryBlockBuilder());
        this.m_expressionFactories.add(new RelationalPropertiesBuilder());
        this.m_expressionFactories.add(new WhereObjectBuilder());
        this.m_expressionFactories.add(new PartitionByBuilder());
        this.m_expressionFactories.add(new OrderByBuilder());
        this.m_expressionFactories.add(new SetOperationBuilder());
        this.m_expressionFactories.add(new ModelBuilder());
        this.m_expressionFactories.add(new SingleColumnForLoopBuilder());
        this.m_expressionFactories.add(new MultiColumnForLoopBuilder());
        this.m_expressionFactories.add(new ModelExpressionBuilder());
        this.m_expressionFactories.add(new CompoundExpressionBuilder());
        this.m_expressionFactories.add(new ParenthesisBuilder());
    }

    public boolean matchesProvider() {
        String string = this.getProvider().getDescriptor().getDatabaseType();
        return ModelUtil.areEqual((Object)string, (Object)"Oracle Database");
    }

    private OracleSQLQueryBuilderHelper getHelper() {
        OracleSQLQueryBuilderHelper oracleSQLQueryBuilderHelper = (OracleSQLQueryBuilderHelper)this.m_helper.get();
        if (oracleSQLQueryBuilderHelper == null) {
            throw new IllegalStateException("Cannot get helper outside of a call to the parseSQL method");
        }
        return oracleSQLQueryBuilderHelper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T, E extends Exception> T parseSQL(String string, HelperCallable<T, E> helperCallable) throws E {
        Holder<OracleSQLQueryBuilderHelper> holder = this.m_helper;
        synchronized (holder) {
            if (this.m_helper.get() != null) {
                throw new IllegalStateException("Already have a helper");
            }
            OracleSQLQueryBuilderHelper oracleSQLQueryBuilderHelper = OracleSQLQueryBuilderHelper.getHelper(string);
            this.m_helper.set((Object)oracleSQLQueryBuilderHelper);
            T t = helperCallable.process(oracleSQLQueryBuilderHelper);
            return t;
            finally {
                this.m_helper.set(null);
            }
        }
    }

    protected void buildQueryImpl(String string, final SQLQuery sQLQuery, final SQLQueryOwner sQLQueryOwner) throws SQLQueryException {
        if (ModelUtil.hasLength((String)string)) {
            final String string2 = OracleSQLQueryBuilder.fixEmptySelectClause(string);
            final boolean bl = string2.length() > string.length();
            this.parseSQL(string2, new HelperCallable<Object, SQLQueryException>(){

                @Override
                public Object process(OracleSQLQueryBuilderHelper oracleSQLQueryBuilderHelper) throws SQLQueryException {
                    List<LexerToken> list = oracleSQLQueryBuilderHelper.getLexerTokens();
                    if (list.size() > 0) {
                        ParseNode parseNode = oracleSQLQueryBuilderHelper.getRaptorRoot();
                        oracleSQLQueryBuilderHelper.checkErrors(parseNode, string2);
                        OracleSQLQueryBuilder.this.buildQuery(parseNode, sQLQuery, (DBObject)sQLQueryOwner);
                        if (bl && sQLQuery.getSelectObjects().length == 1) {
                            SelectObject selectObject = sQLQuery.getSelectObjects()[0];
                            if ("*".equals(selectObject.getUsableAlias())) {
                                sQLQuery.removeSelectObject(sQLQuery.getSelectObjects()[0]);
                            } else {
                                OracleSQLQueryBuilder.this.getLogger().warning("Expected a single select object \"*\".");
                            }
                            OracleSQLQueryBuilder.this.throwException((SQLQueryException)new SQLQueryClauseException((SQLFragment)sQLQuery, APIBundle.get((String)"SQL_EMPTY_SELECT")));
                        }
                    }
                    return null;
                }
            });
        }
    }

    private void buildQuery(ParseNode parseNode, SQLQuery sQLQuery, DBObject dBObject) throws SQLQueryException {
        if (dBObject != null && !(dBObject instanceof SQLQueryOwner) && !(dBObject instanceof SQLQuery)) {
            throw new IllegalArgumentException("The parent of a SQLQuery must be a SQLQuery or SQLQueryOwner");
        }
        if (this.getSQLQuery() == null) {
            this.setSQLQuery(sQLQuery);
        }
        sQLQuery.setParent((DBObject)(dBObject == null ? this.getDefaultSchema() : dBObject));
        this.checkCancelled();
        OracleSQLQueryBuilderHelper oracleSQLQueryBuilderHelper = this.getHelper();
        if (oracleSQLQueryBuilderHelper.isRule(parseNode, "query_block")) {
            this.buildQueryBlock(parseNode, sQLQuery, dBObject);
        } else if (oracleSQLQueryBuilderHelper.isRule(parseNode, "subquery")) {
            try {
                this.buildSubQuery(parseNode, sQLQuery, dBObject);
            }
            catch (UnrecognizedFragmentException unrecognizedFragmentException) {
                this.throwException(new SQLQueryException(APIBundle.get((String)"SQL_CANT_BUILD_SUBQUERY")));
            }
        } else {
            this.throwException(new UnrecognizedFragmentException(oracleSQLQueryBuilderHelper.getSourceFragment(parseNode)));
        }
        sQLQuery.setDeclarative(true);
    }

    public void buildSubQuery(ParseNode parseNode, SQLQuery sQLQuery, DBObject dBObject) throws SQLQueryException {
        OracleSQLQueryBuilderHelper oracleSQLQueryBuilderHelper;
        boolean bl;
        block15: {
            List<ParseNode> list;
            ParseNode parseNode2;
            Schema schema;
            AbstractDBObjectProvider abstractDBObjectProvider;
            block14: {
                bl = false;
                abstractDBObjectProvider = this.getProvider();
                schema = this.getDefaultSchema();
                parseNode2 = null;
                oracleSQLQueryBuilderHelper = this.getHelper();
                if (!oracleSQLQueryBuilderHelper.isRule((list = oracleSQLQueryBuilderHelper.getOrderedChildren(parseNode)).get(0), "subquery_factoring_clause")) break block14;
                List<ParseNode> list2 = oracleSQLQueryBuilderHelper.getOrderedChildren(list.get(0));
                if (list2.size() % 4 != 0) break block15;
                int n = list2.size() / 4;
                for (int i = 0; i < n; ++i) {
                    int n2 = i * 4;
                    String string = oracleSQLQueryBuilderHelper.getContent(list2.get(n2 + 1));
                    List<ParseNode> list3 = oracleSQLQueryBuilderHelper.getOrderedChildren(list2.get(n2 + 3));
                    SQLQuery sQLQuery2 = new SQLQuery();
                    OracleSQLQueryBuilder oracleSQLQueryBuilder = new OracleSQLQueryBuilder((DBObjectProvider)abstractDBObjectProvider, schema, oracleSQLQueryBuilderHelper, this);
                    oracleSQLQueryBuilder.buildQuery(list3.get(1), sQLQuery2, (DBObject)sQLQuery);
                    FromObject fromObject = new FromObject((SQLFragment)sQLQuery2, string);
                    fromObject.setWith(true);
                    this.addFromObject(fromObject);
                }
                OracleSQLQueryBuilder oracleSQLQueryBuilder = new OracleSQLQueryBuilder((DBObjectProvider)abstractDBObjectProvider, schema, oracleSQLQueryBuilderHelper, this);
                oracleSQLQueryBuilder.buildSubQuery(list.get(1), sQLQuery, dBObject);
                bl = true;
                break block15;
            }
            if (oracleSQLQueryBuilderHelper.isRule(parseNode, "query_block")) {
                list = new ArrayList<ParseNode>();
                list.add(parseNode);
            }
            int n = 0;
            while (n < list.size()) {
                SQLQuery sQLQuery3;
                Object object;
                Object object2;
                if (oracleSQLQueryBuilderHelper.isKeyword(list.get(n), "(")) {
                    ++n;
                }
                OracleSQLQueryBuilder oracleSQLQueryBuilder = new OracleSQLQueryBuilder((DBObjectProvider)abstractDBObjectProvider, schema, oracleSQLQueryBuilderHelper, this);
                ParseNode parseNode3 = list.get(n);
                if (++n == list.size()) {
                    oracleSQLQueryBuilder.buildQuery(parseNode3, sQLQuery, dBObject);
                    bl = true;
                    break;
                }
                if (oracleSQLQueryBuilderHelper.isRule(list.get(n), "SET_OPER") || oracleSQLQueryBuilderHelper.isLeaf(list.get(n))) {
                    if (oracleSQLQueryBuilderHelper.isKeyword(list.get(n), ")")) {
                        oracleSQLQueryBuilder.buildQuery(parseNode3, sQLQuery, dBObject);
                        bl = true;
                        ++n;
                        continue;
                    }
                    if (!oracleSQLQueryBuilderHelper.isKeyword(list.get(n), "UNION", "ALL", "INTERSECT", "MINUS") && !oracleSQLQueryBuilderHelper.isRule(list.get(n), "SET_OPER")) continue;
                    SetOperator.Operator operator = null;
                    if (oracleSQLQueryBuilderHelper.isRule(list.get(n), "SET_OPER")) {
                        object2 = oracleSQLQueryBuilderHelper.getOrderedChildren(list.get(n));
                        operator = this.isUnionAll((List<ParseNode>)object2, 0) ? SetOperator.Operator.UNION_ALL : SetOperator.getSetOperator((String)oracleSQLQueryBuilderHelper.getContent((ParseNode)object2.get(0)));
                    } else if (this.isUnionAll(list, n)) {
                        ++n;
                        operator = SetOperator.Operator.UNION_ALL;
                    } else {
                        operator = SetOperator.getSetOperator((String)oracleSQLQueryBuilderHelper.getContent(list.get(n)));
                    }
                    if (operator == null) {
                        throw new SQLQueryException(APIBundle.get((String)"SQL_UNION_SUPPORT"));
                    }
                    object2 = new SQLQuery();
                    oracleSQLQueryBuilder.buildQuery(parseNode3, (SQLQuery)object2, dBObject);
                    object = new OracleSQLQueryBuilder((DBObjectProvider)abstractDBObjectProvider, schema, oracleSQLQueryBuilderHelper, this);
                    sQLQuery3 = new SQLQuery();
                    ((OracleSQLQueryBuilder)object).buildQuery(list.get(n + 1), sQLQuery3, dBObject);
                    OrderByObject[] orderByObjectArray = sQLQuery3.getOrderByObjects();
                    boolean bl2 = sQLQuery3.isOrderSiblings();
                    sQLQuery3.setOrderByObjects(null);
                    sQLQuery3.setOrderSiblings(false);
                    n += 2;
                    SetOperator setOperator = new SetOperator(operator, new SQLFragment[]{object2, sQLQuery3});
                    bl = true;
                    sQLQuery.setSetOperator(setOperator);
                    if (orderByObjectArray == null) continue;
                    sQLQuery.setOrderByObjects(orderByObjectArray);
                    sQLQuery.setOrderSiblings(bl2);
                    continue;
                }
                if (!oracleSQLQueryBuilderHelper.isRule(list.get(n), "order_by_clause")) break;
                oracleSQLQueryBuilder.buildQuery(parseNode3, sQLQuery, dBObject);
                parseNode2 = list.get(n);
                boolean bl3 = oracleSQLQueryBuilderHelper.isKeyword(oracleSQLQueryBuilderHelper.getOrderedChildren(parseNode2).get(1), "SIBLINGS");
                object2 = (ExpressionList)oracleSQLQueryBuilder.createFragment(parseNode2, (SQLFragment)sQLQuery, null);
                object = object2.getArguments();
                sQLQuery3 = new OrderByObject[((SQLFragment[])object).length];
                for (int i = 0; i < ((SQLFragment[])object).length; ++i) {
                    sQLQuery3[i] = (OrderByObject)object[i];
                }
                bl = true;
                sQLQuery.setOrderByObjects((OrderByObject[])sQLQuery3);
                sQLQuery.setOrderSiblings(bl3);
                break;
            }
        }
        if (!bl) {
            throw new UnrecognizedFragmentException(oracleSQLQueryBuilderHelper.getSourceFragment(parseNode));
        }
    }

    private boolean isUnionAll(List<ParseNode> list, int n) {
        OracleSQLQueryBuilderHelper oracleSQLQueryBuilderHelper = this.getHelper();
        return list.size() > n + 1 && oracleSQLQueryBuilderHelper.isKeyword(list.get(n), "UNION") && oracleSQLQueryBuilderHelper.isKeyword(list.get(n + 1), "ALL");
    }

    private void buildQueryBlock(ParseNode parseNode, SQLQuery sQLQuery, DBObject dBObject) throws SQLQueryException {
        Object object;
        ParseNode parseNode2;
        Object object2;
        Object object3;
        ParseNode parseNode3;
        OracleSQLQueryBuilderHelper oracleSQLQueryBuilderHelper = this.getHelper();
        List<ParseNode> list = oracleSQLQueryBuilderHelper.getOrderedChildren(parseNode);
        if (list.size() == 3 && oracleSQLQueryBuilderHelper.isKeyword(list.get(0), "(")) {
            parseNode = list.get(1);
            list = oracleSQLQueryBuilderHelper.getOrderedChildren(parseNode);
        }
        if (!oracleSQLQueryBuilderHelper.isRule(parseNode, "select", "query_block")) {
            throw new SQLQueryException(APIBundle.get((String)"SQL_SELECT_EXPECTED"));
        }
        ParseNode parseNode4 = oracleSQLQueryBuilderHelper.getRuleNode(list, "from_clause");
        if (parseNode4 == null) {
            throw new SQLQueryException(this.buildErrorMessage(list.get(list.size() - 1), APIBundle.get((String)"SQL_RQB_INVALID_FROM_CLAUSE")));
        }
        Object object4 = null;
        List<ParseNode> list2 = oracleSQLQueryBuilderHelper.getOrderedChildren(parseNode4);
        int n = 0;
        try {
            parseNode3 = list2.get(n + 1);
            if (oracleSQLQueryBuilderHelper.isRule(parseNode3, "cartesian_product", "join_clause")) {
                this.buildFrom(parseNode3, sQLQuery, dBObject);
            } else {
                object3 = list2.subList(n + 1, list.size());
                if (!oracleSQLQueryBuilderHelper.isRule((ParseNode)object3.get(0), "table_reference")) {
                    var12_16 = this.createFromx((List<ParseNode>)object3);
                    this.addFromObject(var12_16);
                } else {
                    var12_16 = object3.iterator();
                    while (var12_16.hasNext()) {
                        object2 = (ParseNode)var12_16.next();
                        if (oracleSQLQueryBuilderHelper.isKeyword((ParseNode)object2, new String[]{","})) continue;
                        parseNode2 = this.createFromx((ParseNode)object2);
                        this.addFromObject((FromObject)parseNode2);
                    }
                }
            }
        }
        catch (SQLQueryCancelledException sQLQueryCancelledException) {
            throw sQLQueryCancelledException;
        }
        catch (SQLQueryException sQLQueryException) {
            object4 = sQLQueryException;
        }
        parseNode3 = oracleSQLQueryBuilderHelper.getRuleNode(list, "select_clause");
        if (parseNode3 == null) {
            object3 = new SQLQueryException(this.buildErrorMessage(parseNode3, APIBundle.get((String)"SQL_RQB_SELECT_LIST_OR_STAR_EXPECTED")));
            if (object4 == null) {
                object4 = object3;
            } else {
                object4.setNextException(object3);
            }
            throw object4;
        }
        try {
            object3 = oracleSQLQueryBuilderHelper.getOrderedChildren(parseNode3);
            int n2 = oracleSQLQueryBuilderHelper.getKeywordIndex((List<ParseNode>)object3, "DISTINCT", "UNIQUE", "ALL");
            if (n2 > 0) {
                object2 = oracleSQLQueryBuilderHelper.getContent((ParseNode)object3.get(n2));
                sQLQuery.setDistinctSource((String)object2);
                if (!oracleSQLQueryBuilderHelper.isKeyword((ParseNode)object3.get(n2), "ALL")) {
                    sQLQuery.setDistinct(true);
                }
            }
            object2 = oracleSQLQueryBuilderHelper.getRuleNode((List<ParseNode>)object3, "select_list");
            this.buildSelectList((ParseNode)object2, dBObject);
        }
        catch (SQLQueryCancelledException sQLQueryCancelledException) {
            throw sQLQueryCancelledException;
        }
        catch (SQLQueryException sQLQueryException) {
            if (object4 == null) {
                object4 = sQLQueryException;
            }
            object4.setNextException((DBException)((Object)sQLQueryException));
        }
        object3 = null;
        ParseNode parseNode5 = null;
        object2 = null;
        parseNode2 = null;
        ParseNode parseNode6 = null;
        ParseNode parseNode7 = oracleSQLQueryBuilderHelper.getRuleNode(list, "restrictions");
        if (parseNode7 == null) {
            object3 = oracleSQLQueryBuilderHelper.getRuleNode(list, "where_clause");
            parseNode5 = oracleSQLQueryBuilderHelper.getRuleNode(list, "hierarchical_query_clause");
            object2 = oracleSQLQueryBuilderHelper.getRuleNode(list, "group_by_clause");
            parseNode2 = oracleSQLQueryBuilderHelper.getRuleNode(list, "having_clause");
            parseNode6 = oracleSQLQueryBuilderHelper.getRuleNode(list, "model_clause");
        } else if (oracleSQLQueryBuilderHelper.isRule(parseNode7, "where_clause")) {
            object3 = parseNode7;
        } else if (oracleSQLQueryBuilderHelper.isRule(parseNode7, "hierarchical_query_clause")) {
            parseNode5 = parseNode7;
        } else if (oracleSQLQueryBuilderHelper.isRule(parseNode7, "group_by_clause")) {
            object2 = parseNode7;
        } else if (oracleSQLQueryBuilderHelper.isRule(parseNode7, "having_clause")) {
            parseNode2 = parseNode7;
        } else if (oracleSQLQueryBuilderHelper.isRule(parseNode7, "model_clause")) {
            parseNode6 = parseNode7;
        } else {
            object = oracleSQLQueryBuilderHelper.getOrderedChildren(parseNode7);
            object3 = oracleSQLQueryBuilderHelper.getRuleNode((List<ParseNode>)object, "where_clause");
            object2 = oracleSQLQueryBuilderHelper.getRuleNode((List<ParseNode>)object, "group_by_clause");
            parseNode2 = oracleSQLQueryBuilderHelper.getRuleNode((List<ParseNode>)object, "having_clause");
            parseNode6 = oracleSQLQueryBuilderHelper.getRuleNode((List<ParseNode>)object, "model_clause");
            parseNode5 = oracleSQLQueryBuilderHelper.getRuleNode((List<ParseNode>)object, "hierarchical_query_clause");
        }
        try {
            if (object3 != null) {
                object = this.createWhere((ParseNode)object3);
                this.ensureID((DBObject)object);
                this.setWhereObject((WhereObject)object);
            }
            if (parseNode5 != null) {
                object = this.createHierarchicalQuery(parseNode5);
                this.setHierarchicalQueryObject((HierarchicalQueryObject)object);
            }
            if (object2 != null) {
                object = this.createGroupBy((ParseNode)object2);
                this.setGroupByObject((GroupByObject)object);
                if (parseNode2 != null) {
                    List<ParseNode> list3 = oracleSQLQueryBuilderHelper.getOrderedChildren(parseNode2);
                    ParseNode parseNode8 = oracleSQLQueryBuilderHelper.getRuleNode(list3, "condition");
                    WhereObject whereObject = this.createWhere(parseNode8);
                    object.setHaving(whereObject);
                }
            }
            if (parseNode6 != null) {
                object = this.createModel(parseNode6);
                sQLQuery.setModelObject((ModelObject)object);
            }
        }
        catch (SQLQueryException sQLQueryException) {
            if (object4 != null) {
                object4.setNextException((DBException)((Object)sQLQueryException));
            }
            object4 = sQLQueryException;
        }
        if (object4 != null) {
            throw object4;
        }
    }

    private void buildFrom(ParseNode parseNode, SQLQuery sQLQuery, DBObject dBObject) throws SQLQueryException {
        SQLQueryException sQLQueryException = null;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        OracleSQLQueryBuilderHelper oracleSQLQueryBuilderHelper = this.getHelper();
        List<ParseNode> list = oracleSQLQueryBuilderHelper.getOrderedChildren(parseNode);
        if (oracleSQLQueryBuilderHelper.isRule(parseNode, "xmltable")) {
            var8_8 = new ArrayList();
            var8_8.add(parseNode);
            FromObject object = this.createXMLTable((List<ParseNode>)var8_8);
            this.addFromObject(object);
        } else if (oracleSQLQueryBuilderHelper.isRule(parseNode, "table_reference")) {
            var8_8 = this.createFromx(parseNode);
            this.addFromObject((FromObject)var8_8);
        } else if (oracleSQLQueryBuilderHelper.isRule(parseNode, "cartesian_product") && list.size() == 3 && oracleSQLQueryBuilderHelper.isKeyword(list.get(1), ",")) {
            this.buildFrom(list.get(0), sQLQuery, dBObject);
            this.buildFrom(list.get(2), sQLQuery, dBObject);
        } else {
            var8_8 = new ArrayList();
            var8_8.add(parseNode);
            arrayList.add(var8_8);
        }
        if (arrayList != null && arrayList.size() > 0) {
            for (List list2 : arrayList) {
                try {
                    FromObject sQLQueryException2 = this.createFrom(parseNode, list2);
                    this.checkForCircularView(dBObject, sQLQueryException2);
                    this.addFromObject(sQLQueryException2);
                }
                catch (SQLQueryCancelledException sQLQueryCancelledException) {
                    throw sQLQueryCancelledException;
                }
                catch (SQLQueryException sQLQueryException2) {
                    if (sQLQueryException == null) {
                        sQLQueryException = sQLQueryException2;
                        continue;
                    }
                    sQLQueryException.setNextException((DBException)((Object)sQLQueryException2));
                }
            }
        }
        if (sQLQueryException != null) {
            this.removeTemporaryObjectIDs((SQLFragment)sQLQuery);
            throw sQLQueryException;
        }
    }

    private void checkForCircularView(DBObject dBObject, FromObject fromObject) throws SQLQueryException {
        if (dBObject instanceof Relation) {
            for (RelationUsage relationUsage : DBUtil.findChildren((DBObject)fromObject, RelationUsage.class)) {
                this.checkCancelled();
                DBObjectID dBObjectID = relationUsage.getObjectID();
                if (dBObjectID == null) continue;
                DBObject dBObject2 = null;
                try {
                    dBObject2 = dBObjectID.resolveID();
                }
                catch (DBException dBException) {
                    this.getLogger().fine(dBException.getMessage());
                }
                if (dBObject2 == null || !DBUtil.areNamesAndTypesEqual((DBObject)dBObject, (DBObject)dBObject2)) continue;
                this.throwException((SQLQueryException)new SQLQueryClauseException((SQLFragment)relationUsage, APIBundle.get((String)"SQL_CIRCULAR_VIEW")));
            }
        }
    }

    private void buildSelectList(ParseNode parseNode, DBObject dBObject) throws SQLQueryException {
        SelectObject selectObject;
        SQLQueryException sQLQueryException = null;
        List<Object> list = null;
        OracleSQLQueryBuilderHelper oracleSQLQueryBuilderHelper = this.getHelper();
        if (oracleSQLQueryBuilderHelper.isKeyword(parseNode, "*")) {
            ColumnKeywordUsage columnKeywordUsage = new ColumnKeywordUsage("*", null);
            selectObject = new SelectObject();
            selectObject.setExpression((SQLFragment)columnKeywordUsage);
            this.addSelectObject(selectObject);
            list = Collections.emptyList();
        } else if (oracleSQLQueryBuilderHelper.isRule(parseNode, "select_term")) {
            list = new ArrayList<ParseNode>();
            list.add(parseNode);
        } else {
            list = oracleSQLQueryBuilderHelper.flattenListTree("select_list", parseNode);
        }
        for (int i = 0; i < list.size(); ++i) {
            selectObject = (ParseNode)list.get(i);
            try {
                if (!oracleSQLQueryBuilderHelper.isRule((ParseNode)selectObject, "select_term")) continue;
                this.buildSelectListItem(i, (ParseNode)selectObject, dBObject);
                continue;
            }
            catch (SQLQueryCancelledException sQLQueryCancelledException) {
                throw sQLQueryCancelledException;
            }
            catch (SQLQueryException sQLQueryException2) {
                if (sQLQueryException == null) {
                    sQLQueryException = sQLQueryException2;
                    continue;
                }
                sQLQueryException.setNextException((DBException)((Object)sQLQueryException2));
            }
        }
        if (sQLQueryException != null) {
            throw sQLQueryException;
        }
    }

    private void buildSelectListItem(int n, ParseNode parseNode, DBObject dBObject) throws SQLQueryException {
        SQLFragment sQLFragment;
        int n2;
        SelectObject selectObject;
        SQLQueryException sQLQueryException;
        String string;
        List<ParseNode> list;
        OracleSQLQueryBuilderHelper oracleSQLQueryBuilderHelper;
        block12: {
            oracleSQLQueryBuilderHelper = this.getHelper();
            list = oracleSQLQueryBuilderHelper.getOrderedChildren(parseNode);
            ParseNode parseNode2 = null;
            boolean bl = false;
            string = null;
            sQLQueryException = null;
            if (list.size() == 2 && oracleSQLQueryBuilderHelper.isRule(list.get(1), "as_alias")) {
                ParseNode parseNode3 = list.get(1);
                selectObject = oracleSQLQueryBuilderHelper.getOrderedChildren(parseNode3);
                bl = selectObject.size() == 2;
                string = oracleSQLQueryBuilderHelper.getContent((ParseNode)selectObject.get(bl ? 1 : 0));
                parseNode = list.get(0);
                list = oracleSQLQueryBuilderHelper.getOrderedChildren(parseNode);
            }
            n2 = oracleSQLQueryBuilderHelper.isRule(list.get(0), "'CONNECT_BY_ROOT'") ? 1 : 0;
            parseNode2 = list.size() == n2 + 2 && oracleSQLQueryBuilderHelper.isLeaf(list.get(n2 + 1)) ? (oracleSQLQueryBuilderHelper.isRule(parseNode, "expr") ? parseNode : list.get(n2)) : (n2 == 1 ? list.get(1) : parseNode);
            selectObject = new SelectObject();
            selectObject.setAlias(string);
            selectObject.setUseAs(bl);
            sQLFragment = null;
            try {
                sQLFragment = this.createFragment(parseNode2, (SQLFragment)selectObject, null);
            }
            catch (SQLQueryCancelledException sQLQueryCancelledException) {
                throw sQLQueryCancelledException;
            }
            catch (SQLQueryException sQLQueryException2) {
                sQLQueryException = sQLQueryException2;
                if (!(dBObject instanceof Relation)) break block12;
                if (!ModelUtil.hasLength((String)selectObject.getAlias())) {
                    Object object = null;
                    String[] stringArray = oracleSQLQueryBuilderHelper.getContent(parseNode2).split("\\.");
                    if (stringArray.length > 0) {
                        object = stringArray[stringArray.length - 1];
                    }
                    if (!ModelUtil.hasLength(object)) {
                        int n3 = n + 1;
                        object = "\"<column " + n3 + ">\"";
                    }
                    if (!((String)object).startsWith("\"")) {
                        object = ((String)object).toUpperCase();
                    }
                    selectObject.setAlias((String)object);
                }
                sQLFragment = new SimpleSQLFragment("null");
                selectObject.setExpression(sQLFragment);
                this.addSelectObject(selectObject);
                this.throwException(sQLQueryException2);
            }
        }
        if (sQLFragment != null) {
            if (n2 == 1) {
                sQLFragment = new ConnectByRoot(sQLFragment);
            }
        } else {
            if (sQLQueryException != null) {
                throw sQLQueryException;
            }
            String string2 = oracleSQLQueryBuilderHelper.getContent(list.get(0));
            throw new SQLQueryException(APIBundle.format((String)"SQL_CANT_CREATE_SELECT_ITEM", (Object[])new Object[]{string2}));
        }
        selectObject.setExpression(sQLFragment);
        this.addSelectObject(selectObject);
        this.checkAlias((AliasFragment)selectObject, string);
    }

    protected SQLFragment parseFromExpression(String string, FromObject fromObject) throws SQLQueryException {
        this.checkLength(string);
        int n = string.indexOf(".");
        String string2 = null;
        String string3 = null;
        if (n > 0) {
            string2 = string.substring(0, n);
            string3 = string.substring(n + 1);
        } else {
            string3 = string;
        }
        DBObjectUsage dBObjectUsage = this.createRelationUsage(string2, string3, null);
        if (dBObjectUsage == null) {
            this.throwException(new SQLQueryException(APIBundle.format((String)"SQL_CANT_FIND_REL", (Object[])new Object[]{string})));
        }
        return dBObjectUsage;
    }

    protected boolean containsAsterisk() throws SQLQueryException {
        boolean bl = false;
        String string = this.getQuery().getSQLText();
        if (string != null) {
            bl = this.parseSQL(string, new HelperCallable<Boolean, SQLQueryException>(){

                @Override
                public Boolean process(OracleSQLQueryBuilderHelper oracleSQLQueryBuilderHelper) throws SQLQueryException {
                    boolean bl = false;
                    List<ParseNode> list = oracleSQLQueryBuilderHelper.getQueryRootKids();
                    List<ParseNode> list2 = oracleSQLQueryBuilderHelper.getSelectItemNodes(list);
                    for (ParseNode parseNode : list2) {
                        if (oracleSQLQueryBuilderHelper.isKeyword(parseNode, "*")) {
                            bl = true;
                            break;
                        }
                        if (!oracleSQLQueryBuilderHelper.isDotSeperatedList(parseNode)) continue;
                        List<ParseNode> list3 = oracleSQLQueryBuilderHelper.getLeftAndRight(parseNode);
                        if (!oracleSQLQueryBuilderHelper.isKeyword(list3.get(list3.size() - 1), "*")) continue;
                        bl = true;
                        break;
                    }
                    return bl;
                }
            });
        }
        return bl;
    }

    protected DerivedPropertyBuilder getDTUBuilder(int n) {
        return new SQLDerivedPropertySupport.SQLQueryViewColumnDTUBuilder(this.getProvider(), this.getQuery(), n, this.m_columnInfos);
    }

    protected SQLFragment parseSelectExpression(String string, final SelectObject selectObject) throws SQLQueryException {
        this.checkLength(string);
        return this.checkExpression(SELECT_, string, " FROM DUMMY", new HelperCallable<SQLFragment, SQLQueryException>(){

            @Override
            public SQLFragment process(OracleSQLQueryBuilderHelper oracleSQLQueryBuilderHelper) throws SQLQueryException {
                ParseNode parseNode = oracleSQLQueryBuilderHelper.getRaptorRoot();
                List<ParseNode> list = oracleSQLQueryBuilderHelper.getOrderedChildren(parseNode);
                ParseNode parseNode2 = oracleSQLQueryBuilderHelper.getRuleNode(list, "select_clause");
                List<ParseNode> list2 = oracleSQLQueryBuilderHelper.getOrderedChildren(parseNode2);
                ParseNode parseNode3 = list2.get(1);
                return OracleSQLQueryBuilder.this.createFragment(parseNode3, (SQLFragment)selectObject, null, oracleSQLQueryBuilderHelper);
            }
        });
    }

    private void adjustErrorOffset(SQLParseException sQLParseException, String string) {
        if (ModelUtil.hasLength((String)string)) {
            int n = sQLParseException.getOffset();
            if (string.length() < n) {
                sQLParseException.adjustOffset(string.length());
            }
        }
    }

    private <T> T checkExpression(String string, String string2, String string3, final HelperCallable<T, SQLQueryException> helperCallable) throws SQLQueryException {
        string = string.replace('\n', ' ');
        final String string4 = string3.replace('\n', ' ');
        String string5 = string + string2 + string4;
        HelperCallable helperCallable2 = new HelperCallable<T, SQLQueryException>(){

            @Override
            public T process(OracleSQLQueryBuilderHelper oracleSQLQueryBuilderHelper) throws SQLQueryException {
                ParseNode parseNode = oracleSQLQueryBuilderHelper.getRaptorRoot();
                oracleSQLQueryBuilderHelper.checkErrors(parseNode, string4);
                return helperCallable.process(oracleSQLQueryBuilderHelper);
            }
        };
        try {
            return this.parseSQL(string5, helperCallable2);
        }
        catch (SQLParseException sQLParseException) {
            this.adjustErrorOffset(sQLParseException, string);
            throw sQLParseException;
        }
    }

    public SQLFragment parseOrderByExpression(String string, final OrderByObject orderByObject) throws SQLQueryException {
        this.checkLength(string);
        String string2 = "SELECT  1 FROM DUMMY";
        return this.checkExpression(string2, " ORDER BY ", string, new HelperCallable<SQLFragment, SQLQueryException>(){

            @Override
            public SQLFragment process(OracleSQLQueryBuilderHelper oracleSQLQueryBuilderHelper) throws SQLQueryException {
                ParseNode parseNode = oracleSQLQueryBuilderHelper.getRaptorRoot();
                List<ParseNode> list = oracleSQLQueryBuilderHelper.getOrderedChildren(parseNode);
                ParseNode parseNode2 = list.get(1);
                return OracleSQLQueryBuilder.this.createFragment(parseNode2, (SQLFragment)orderByObject, null, oracleSQLQueryBuilderHelper);
            }
        });
    }

    public SQLFragment parseWhereExpression(String string, final WhereObject whereObject) throws SQLQueryException {
        this.checkLength(string);
        String string2 = "SELECT  '1' FROM DUAL WHERE";
        return this.checkExpression(string2, " ", string, new HelperCallable<SQLFragment, SQLQueryException>(){

            @Override
            public SQLFragment process(OracleSQLQueryBuilderHelper oracleSQLQueryBuilderHelper) throws SQLQueryException {
                ParseNode parseNode = oracleSQLQueryBuilderHelper.getRaptorRoot();
                List<ParseNode> list = oracleSQLQueryBuilderHelper.getOrderedChildren(parseNode);
                ParseNode parseNode2 = oracleSQLQueryBuilderHelper.getRuleNode(list, "where_clause");
                List<ParseNode> list2 = oracleSQLQueryBuilderHelper.getOrderedChildren(parseNode2);
                ParseNode parseNode3 = list2.get(1);
                return OracleSQLQueryBuilder.this.createFragment(parseNode3, (SQLFragment)whereObject, null, oracleSQLQueryBuilderHelper);
            }
        });
    }

    public OnJoinCondition parseOnExpression(String string, final JoinObject joinObject) throws SQLQueryException {
        this.checkLength(string);
        String string2 = "SELECT  '1' FROM " + joinObject.getSQLText();
        return this.checkExpression(string2, " ON ", string, new HelperCallable<OnJoinCondition, SQLQueryException>(){

            @Override
            public OnJoinCondition process(OracleSQLQueryBuilderHelper oracleSQLQueryBuilderHelper) throws SQLQueryException {
                ParseNode parseNode = oracleSQLQueryBuilderHelper.getRaptorRoot();
                List<ParseNode> list = oracleSQLQueryBuilderHelper.getOrderedChildren(parseNode);
                ParseNode parseNode2 = oracleSQLQueryBuilderHelper.getRuleNode(list, "from_clause");
                List<ParseNode> list2 = oracleSQLQueryBuilderHelper.getOrderedChildren(parseNode2);
                ParseNode parseNode3 = oracleSQLQueryBuilderHelper.getRuleNode(list2, "join_clause");
                List<ParseNode> list3 = oracleSQLQueryBuilderHelper.getOrderedChildren(parseNode3);
                List<ParseNode> list4 = oracleSQLQueryBuilderHelper.getOrderedChildren(list3.get(1));
                ParseNode parseNode4 = oracleSQLQueryBuilderHelper.getRuleNode(list4, "on_using_condition");
                List<ParseNode> list5 = oracleSQLQueryBuilderHelper.getOrderedChildren(parseNode4);
                if (list5.size() > 0) {
                    ParseNode parseNode5 = list5.get(1);
                    SQLFragment sQLFragment = OracleSQLQueryBuilder.this.createFragment(parseNode5, (SQLFragment)joinObject, null, oracleSQLQueryBuilderHelper);
                    if (sQLFragment instanceof WhereObject) {
                        return (OnJoinCondition)sQLFragment.copyTo((Object)new OnJoinCondition());
                    }
                    return new OnJoinCondition(sQLFragment);
                }
                throw new SQLQueryException(APIBundle.get((String)"SQL_QUERY_PARSE_NONE"));
            }
        });
    }

    public boolean supportsConnectBy() {
        return true;
    }

    public boolean supportsGroupBy() {
        return true;
    }

    public boolean supportsOrderBy() {
        return true;
    }

    public Collection<String> clearDerivedProperties(SQLQuery sQLQuery, String string, DBObjectChange dBObjectChange) {
        Collection collection = super.clearDerivedProperties(sQLQuery, string, dBObjectChange);
        if (!collection.isEmpty()) {
            this.m_columnInfos.clear();
        }
        return collection;
    }

    protected Column[] getColumnsFromResultSet() throws DBException {
        List<Tuple<String, DataTypeUsage>> list = SQLDerivedPropertySupport.SQLQueryViewColumnDTUBuilder.getColumnInfo((Database)this.getProvider(), this.getSQLQuery().getQueryString());
        int n = list == null ? 0 : list.size();
        Column[] columnArray = new Column[n];
        if (n > 0) {
            DBObjectFactory dBObjectFactory = this.getProvider().getObjectFactory();
            for (int i = 0; i < n; ++i) {
                columnArray[i] = (Column)dBObjectFactory.newObject(Column.class);
                columnArray[i].setName((String)list.get(i).getFirst());
                columnArray[i].setDataTypeUsage((DataTypeUsage)list.get(i).getSecond());
            }
        }
        return columnArray;
    }

    private FromObject createFrom(ParseNode parseNode, List<ParseNode> list) throws SQLQueryException {
        FromObject fromObject = null;
        OracleSQLQueryBuilderHelper oracleSQLQueryBuilderHelper = this.getHelper();
        if (oracleSQLQueryBuilderHelper.isRule(parseNode, "pivot_clause", "unpivot_clause")) {
            fromObject = this.createPivot84(parseNode, null);
        } else if (list.size() == 1 && oracleSQLQueryBuilderHelper.isRule(list.get(0), "join_clause")) {
            List<ParseNode> list2 = oracleSQLQueryBuilderHelper.getOrderedChildren(list.get(0));
            fromObject = this.createAnsiJoin(list2);
        } else {
            fromObject = list.size() > 1 && (oracleSQLQueryBuilderHelper.isRule(parseNode, "join_clause") || oracleSQLQueryBuilderHelper.isRule(list.get(1), "outer_join_clause") || oracleSQLQueryBuilderHelper.isRule(list.get(1), "\"inner_cross_join_clause\"") || oracleSQLQueryBuilderHelper.isRule(list.get(1), "inner_cross_join_clause")) ? this.createAnsiJoin(list) : (list.size() == 2 && (oracleSQLQueryBuilderHelper.isRule(list.get(1), "pivot_clause") || oracleSQLQueryBuilderHelper.isRule(list.get(1), "unpivot_clause")) ? this.createPivot88(list, null) : (oracleSQLQueryBuilderHelper.isRule(parseNode, "pivot_clause") || oracleSQLQueryBuilderHelper.isRule(parseNode, "unpivot_clause") ? this.createPivot84(parseNode, null) : this.createFromx(list)));
        }
        fromObject.setStartOffset(Integer.valueOf(oracleSQLQueryBuilderHelper.getNodeStartOffset(list.get(0))));
        return fromObject;
    }

    private FromObject createAnsiJoin(List<ParseNode> list) throws SQLQueryException {
        FromObject fromObject = null;
        int n = 1;
        OracleSQLQueryBuilderHelper oracleSQLQueryBuilderHelper = this.getHelper();
        if (list.size() == 3 && oracleSQLQueryBuilderHelper.isKeyword(list.get(0), "(")) {
            var5_5 = oracleSQLQueryBuilderHelper.getOrderedChildren(list.get(1));
            fromObject = this.createAnsiJoin(var5_5);
            n = 3;
        } else if (oracleSQLQueryBuilderHelper.isRule(list.get(0), "join_clause")) {
            var5_5 = oracleSQLQueryBuilderHelper.getOrderedChildren(list.get(0));
            fromObject = this.createAnsiJoin(var5_5);
        } else {
            fromObject = this.createFromx(list.get(0));
        }
        boolean bl = false;
        for (ParseNode parseNode : list.subList(n, list.size())) {
            bl = oracleSQLQueryBuilderHelper.isRule(parseNode, "outer_join_clause");
            if (!oracleSQLQueryBuilderHelper.isRule(parseNode, "\"inner_cross_join_clause\"") && !oracleSQLQueryBuilderHelper.isRule(parseNode, "inner_cross_join_clause") && !oracleSQLQueryBuilderHelper.isRule(parseNode, "outer_join_clause")) continue;
            fromObject = this.processJoin(parseNode, fromObject, bl);
        }
        return fromObject;
    }

    private FromObject processJoin(ParseNode parseNode, FromObject fromObject, boolean bl) throws SQLQueryException {
        ExpressionList expressionList;
        ArrayList<String> arrayList = new ArrayList<String>();
        FromObject fromObject2 = new FromObject();
        JoinObject joinObject = new JoinObject();
        joinObject.setLeftExpression(fromObject);
        OracleSQLQueryBuilderHelper oracleSQLQueryBuilderHelper = this.getHelper();
        List<ParseNode> list = oracleSQLQueryBuilderHelper.getOrderedChildren(parseNode);
        int n = 0;
        ExpressionList expressionList2 = null;
        if (oracleSQLQueryBuilderHelper.isRule(list.get(n), "query_partition_clause")) {
            expressionList2 = (ExpressionList)this.createFragment(list.get(n), (SQLFragment)joinObject, fromObject);
            ++n;
            joinObject.setLeftPartitionBy(expressionList2);
        }
        ArrayList<String> arrayList2 = new ArrayList<String>();
        arrayList2.add("outer_join_type");
        n = this.addKeywords(list, n, arrayList, arrayList2);
        FromObject fromObject3 = null;
        if (oracleSQLQueryBuilderHelper.isRule(list.get(n), "join_clause")) {
            expressionList = oracleSQLQueryBuilderHelper.getOrderedChildren(list.get(n));
            fromObject3 = this.createFrom(list.get(n), (List<ParseNode>)expressionList);
        } else {
            fromObject3 = this.createFromx(list.get(n));
        }
        joinObject.setRightExpression(fromObject3);
        expressionList = null;
        if (++n < list.size() && oracleSQLQueryBuilderHelper.isRule(list.get(n), "query_partition_clause")) {
            expressionList = (ExpressionList)this.createFragment(list.get(n), (SQLFragment)joinObject, fromObject3);
            ++n;
            joinObject.setRightPartitionBy(expressionList);
        }
        String string = null;
        if (bl) {
            if (this.hasToken(arrayList, "FULL", null)) {
                string = "FULL";
            } else if (this.hasToken(arrayList, "LEFT", null)) {
                string = "LEFT";
            } else if (this.hasToken(arrayList, "RIGHT", null)) {
                string = "RIGHT";
            }
        } else {
            string = this.hasToken(arrayList, "CROSS", null) ? "CROSS" : "INNER";
        }
        joinObject.setJoinType(string);
        joinObject.setNatural(this.hasToken(arrayList, "NATURAL", null));
        if (string.equals("INNER")) {
            joinObject.setIncludeJoinKeyword(this.hasToken(arrayList, string, "JOIN"));
        } else if (joinObject.isOuterJoin()) {
            joinObject.setIncludeJoinKeyword(this.hasToken(arrayList, "OUTER", "JOIN"));
        }
        fromObject2.setExpression((SQLFragment)joinObject);
        if (n < list.size() && oracleSQLQueryBuilderHelper.isRule(list.get(n), "on_using_condition")) {
            this.processOnUsingCondition(list.get(n), fromObject2);
        }
        return fromObject2;
    }

    private void processOnUsingCondition(ParseNode parseNode, FromObject fromObject) throws SQLQueryException {
        OracleSQLQueryBuilderHelper oracleSQLQueryBuilderHelper = this.getHelper();
        JoinObject joinObject = (JoinObject)fromObject.getExpression();
        List<ParseNode> list = oracleSQLQueryBuilderHelper.getOrderedChildren(parseNode);
        if (oracleSQLQueryBuilderHelper.isKeyword(list.get(0), "ON")) {
            WhereObject whereObject = this.createWhere(list.get(1), (SQLFragment)fromObject);
            if (whereObject != null) {
                OnJoinCondition onJoinCondition = (OnJoinCondition)whereObject.copyTo((Object)new OnJoinCondition());
                joinObject.setCondition((JoinCondition)onJoinCondition);
            }
        } else {
            int n = 1;
            FromObject fromObject2 = joinObject.getLeftExpression();
            FromObject fromObject3 = joinObject.getRightExpression();
            this.processJoinUsingClause(list, n, joinObject, fromObject2, fromObject3, fromObject);
        }
    }

    private void processJoinUsingClause(List<ParseNode> list, int n, JoinObject joinObject, FromObject fromObject, FromObject fromObject2, FromObject fromObject3) throws SQLQueryException {
        int n2 = list.size();
        OracleSQLQueryBuilderHelper oracleSQLQueryBuilderHelper = this.getHelper();
        if (oracleSQLQueryBuilderHelper.isKeyword(list.get(++n), "(")) {
            ++n;
            n2 = oracleSQLQueryBuilderHelper.getKeywordIndex(list, ")");
        }
        List<List<ParseNode>> list2 = oracleSQLQueryBuilderHelper.getCommaSeparatedList(list.subList(n, n2));
        UsingJoinCondition usingJoinCondition = new UsingJoinCondition();
        joinObject.setCondition((JoinCondition)usingJoinCondition);
        for (List<ParseNode> list3 : list2) {
            String string = oracleSQLQueryBuilderHelper.getContent(list3.get(0));
            FromObjectUsage fromObjectUsage = this.findColumnInFromObjects(string, true, new FromObject[]{fromObject, fromObject2}, true, true, (SQLFragment)fromObject3);
            if (fromObjectUsage == null) continue;
            usingJoinCondition.addColumn(fromObjectUsage);
        }
    }

    private int addKeywords(List<ParseNode> list, int n, List<String> list2, List<String> list3) {
        OracleSQLQueryBuilderHelper oracleSQLQueryBuilderHelper = this.getHelper();
        while (n < list.size() && (oracleSQLQueryBuilderHelper.isLeaf(list.get(n)) || oracleSQLQueryBuilderHelper.isRule(list.get(n), list3))) {
            if (oracleSQLQueryBuilderHelper.isLeaf(list.get(n))) {
                String string = oracleSQLQueryBuilderHelper.getContent(list.get(n));
                if (!s_joinKeywords.contains(string.toUpperCase())) break;
                list2.add(string);
            } else {
                if (!oracleSQLQueryBuilderHelper.isRule(list.get(n), list3)) break;
                this.addKeywords(oracleSQLQueryBuilderHelper.getOrderedChildren(list.get(n)), 0, list2, list3);
            }
            ++n;
        }
        return n;
    }

    private boolean hasToken(List<String> list, String string, String string2) {
        boolean bl = false;
        for (String string3 : list) {
            if (string2 != null && string3.equalsIgnoreCase(string2)) break;
            if (!string3.equalsIgnoreCase(string)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private FromObject createFromx(ParseNode parseNode) throws SQLQueryException {
        FromObject fromObject = null;
        OracleSQLQueryBuilderHelper oracleSQLQueryBuilderHelper = this.getHelper();
        List<ParseNode> list = oracleSQLQueryBuilderHelper.getOrderedChildren(parseNode);
        if (oracleSQLQueryBuilderHelper.isRule(parseNode, "query_table_expression", "table_collection_expression")) {
            ParseNode parseNode2 = parseNode;
            if (list.size() == 3 && oracleSQLQueryBuilderHelper.isKeyword(list.get(0), "(")) {
                parseNode2 = list.get(1);
            }
            list = new ArrayList<ParseNode>();
            list.add(parseNode2);
        }
        fromObject = this.createFromx(list);
        fromObject.setStartOffset(Integer.valueOf(oracleSQLQueryBuilderHelper.getNodeStartOffset(parseNode)));
        return fromObject;
    }

    private FromObject createXMLTable(List<ParseNode> list) throws SQLQueryException {
        String string = this.getTableAlias(list);
        SQLFragment sQLFragment = this.createFragment(list.get(0), null, null);
        FromObject fromObject = new FromObject(sQLFragment, string);
        this.checkAlias((AliasFragment)fromObject, string);
        return fromObject;
    }

    public List<AbstractSQLQueryBuilder.QueryColumnInfo> getQueryColumnInfos() throws SQLQueryException {
        String string;
        List<AbstractSQLQueryBuilder.QueryColumnInfo> list = null;
        SQLQuery sQLQuery = this.getQuery();
        if (sQLQuery != null && (string = sQLQuery.getSQLText()) != null) {
            list = this.parseSQL(string, new HelperCallable<List<AbstractSQLQueryBuilder.QueryColumnInfo>, SQLQueryException>(){

                @Override
                public List<AbstractSQLQueryBuilder.QueryColumnInfo> process(OracleSQLQueryBuilderHelper oracleSQLQueryBuilderHelper) throws SQLQueryException {
                    return OracleSQLQueryBuilder.this.getQueryColumnInfosImpl(oracleSQLQueryBuilderHelper);
                }
            });
        }
        return list == null ? Collections.emptyList() : list;
    }

    private List<AbstractSQLQueryBuilder.QueryColumnInfo> getQueryColumnInfosImpl(OracleSQLQueryBuilderHelper oracleSQLQueryBuilderHelper) throws SQLQueryException {
        ArrayList<AbstractSQLQueryBuilder.QueryColumnInfo> arrayList = new ArrayList<AbstractSQLQueryBuilder.QueryColumnInfo>();
        List<ParseNode> list = oracleSQLQueryBuilderHelper.getQueryRootKids();
        List<ParseNode> list2 = oracleSQLQueryBuilderHelper.getSelectItemNodes(list);
        for (int i = 0; i < list2.size(); ++i) {
            Object object;
            ParseNode parseNode = list2.get(i);
            boolean bl = oracleSQLQueryBuilderHelper.isRule(parseNode, "select_term");
            boolean bl2 = oracleSQLQueryBuilderHelper.isRule(parseNode, "expr");
            String string = null;
            int n = 0;
            if (bl) {
                object = oracleSQLQueryBuilderHelper.getOrderedChildren(parseNode);
                n = object.size();
                boolean bl3 = false;
                if (!bl2 && n > 1) {
                    bl3 = true;
                } else if (n % 2 == 1) {
                    bl3 = true;
                    for (int j = 1; j < n; j += 2) {
                        if (oracleSQLQueryBuilderHelper.isKeyword((ParseNode)object.get(j), ".")) continue;
                        bl3 = false;
                        break;
                    }
                }
                if (bl3 && (string = oracleSQLQueryBuilderHelper.getContent((ParseNode)object.get(n - 1))) != null) {
                    string = this.getInternalName(string);
                }
            }
            object = oracleSQLQueryBuilderHelper.isRule(parseNode) ? string : oracleSQLQueryBuilderHelper.getContent(parseNode);
            AbstractSQLQueryBuilder.QueryColumnInfo queryColumnInfo = new AbstractSQLQueryBuilder.QueryColumnInfo((String)object, oracleSQLQueryBuilderHelper.getContent(parseNode));
            arrayList.add(queryColumnInfo);
        }
        return arrayList;
    }

    private String getDblink(ParseNode parseNode) {
        String string = this.getHelper().getContent(parseNode);
        return string;
    }

    private LinkSchemaTableAndAlias getTableAndAlias(List<ParseNode> list) {
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        int n = -1;
        OracleSQLQueryBuilderHelper oracleSQLQueryBuilderHelper = this.getHelper();
        int n2 = oracleSQLQueryBuilderHelper.getKeywordIndex(list, ".");
        if (n2 == 1) {
            string2 = oracleSQLQueryBuilderHelper.getContent(list.get(0));
            string3 = oracleSQLQueryBuilderHelper.getContent(list.get(2));
            n = 3;
        } else {
            string3 = oracleSQLQueryBuilderHelper.getContent(list.get(0));
            n = 1;
        }
        int n3 = oracleSQLQueryBuilderHelper.getKeywordIndex(list, "@");
        if (n3 > 0) {
            string = this.getDblink(list.get(n3 + 1));
            n = n3 + 2;
        }
        if (list.size() == n + 1) {
            string4 = oracleSQLQueryBuilderHelper.getContent(list.get(n));
        }
        return new LinkSchemaTableAndAlias(string, string2, string3, string4);
    }

    private String getTableAlias(List<ParseNode> list) {
        String string = null;
        OracleSQLQueryBuilderHelper oracleSQLQueryBuilderHelper = this.getHelper();
        if (list.size() > 1 && oracleSQLQueryBuilderHelper.isLeaf(list.get(1))) {
            string = oracleSQLQueryBuilderHelper.getContent(list.get(1));
        }
        return string;
    }

    private LinkSchemaTableAndAlias getSchemaAndTable(ParseNode parseNode) {
        return this.getTableAndAlias(this.getHelper().getOrderedChildren(parseNode));
    }

    private FromObject createPivot88(List<ParseNode> list, String string) throws SQLQueryException {
        ParseNode parseNode = list.get(0);
        FromObject fromObject = this.createFromx(parseNode);
        fromObject.setAlias(string);
        List<ParseNode> list2 = this.getHelper().getOrderedChildren(list.get(1));
        this.createPivot(list2, 0, fromObject);
        return fromObject;
    }

    private FromObject createPivot84(ParseNode parseNode, String string) throws SQLQueryException {
        List<ParseNode> list = this.getHelper().getOrderedChildren(parseNode);
        ParseNode parseNode2 = list.get(0);
        FromObject fromObject = this.createFromx(parseNode2);
        fromObject.setAlias(string);
        this.createPivot(list, 1, fromObject);
        return fromObject;
    }

    private void createPivot(List<ParseNode> list, int n, FromObject fromObject) throws SQLQueryException {
        ParseNode parseNode = list.get(n);
        OracleSQLQueryBuilderHelper oracleSQLQueryBuilderHelper = this.getHelper();
        if (!oracleSQLQueryBuilderHelper.isKeyword(parseNode, "PIVOT", "UNPIVOT")) {
            throw new SQLQueryException(APIBundle.get((String)"SQL_UNRECOGNISED_PIVOT_CLAUSE"));
        }
        ParseNode parseNode2 = list.get(list.size() - 1);
        if (!oracleSQLQueryBuilderHelper.isKeyword(parseNode2, ")")) {
            throw new SQLQueryException(APIBundle.get((String)"SQL_PIVOT_CLAUSE_NOT_CLOSED"));
        }
        int n2 = oracleSQLQueryBuilderHelper.getNodeStartOffset(parseNode);
        int n3 = oracleSQLQueryBuilderHelper.getNodeEndOffset(parseNode2);
        String string = oracleSQLQueryBuilderHelper.getSourceFragment(n2, n3);
        SimpleSQLFragment simpleSQLFragment = new SimpleSQLFragment(string);
        fromObject.setPivotExpression((SQLFragment)simpleSQLFragment);
    }

    private FromObject createFromx(List<ParseNode> list) throws SQLQueryException {
        List<Object> list2;
        Object object;
        Object object2;
        ParseNode parseNode = null;
        FromObject fromObject = null;
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        OracleSQLQueryBuilderHelper oracleSQLQueryBuilderHelper = this.getHelper();
        if (list.size() == 2 && oracleSQLQueryBuilderHelper.isLeaf(list.get(1))) {
            string4 = oracleSQLQueryBuilderHelper.getContent(list.get(1));
        }
        ParseNode parseNode2 = list.get(0);
        if (list.size() == 1) {
            if (oracleSQLQueryBuilderHelper.isLeaf(parseNode2)) {
                string3 = oracleSQLQueryBuilderHelper.getContent(parseNode2);
                object2 = this.getFromObject(string3);
                if (object2 != null && object2.isWith()) {
                    fromObject = new FromObject();
                    object = new WithClauseUsage();
                    object.setFromObjectID(object2.getID());
                    fromObject.setExpression((SQLFragment)object);
                }
            } else if (oracleSQLQueryBuilderHelper.isRule(parseNode2, "pivot_clause", "unpivot_clause")) {
                fromObject = this.createPivot84(parseNode2, string4);
            } else if (oracleSQLQueryBuilderHelper.isRule(parseNode2, "xmltable")) {
                fromObject = this.createXMLTable(list);
            } else if (oracleSQLQueryBuilderHelper.isRule(parseNode2, "table_reference")) {
                object2 = new LinkSchemaTableAndAlias();
                object = oracleSQLQueryBuilderHelper.getOrderedChildren(parseNode2);
                if (oracleSQLQueryBuilderHelper.isRule(parseNode2, "table_collection_expression")) {
                    parseNode = parseNode2;
                } else if (oracleSQLQueryBuilderHelper.isRule(parseNode2, "query_table_expression")) {
                    if (object.size() > 2 && oracleSQLQueryBuilderHelper.isKeyword((ParseNode)object.get(0), "(")) {
                        parseNode = (ParseNode)object.get(1);
                    } else {
                        object2 = this.getSchemaAndTable(parseNode2);
                    }
                } else if (oracleSQLQueryBuilderHelper.isRule((ParseNode)object.get(0), "table_collection_expression")) {
                    parseNode = (ParseNode)object.get(0);
                    ((LinkSchemaTableAndAlias)object2).setAlias(this.getTableAlias((List<ParseNode>)object));
                } else if (oracleSQLQueryBuilderHelper.isRule((ParseNode)object.get(0), "xmltable")) {
                    fromObject = this.createXMLTable((List<ParseNode>)object);
                } else if (oracleSQLQueryBuilderHelper.isRule((ParseNode)object.get(0), "query_table_expression") && !oracleSQLQueryBuilderHelper.isLeaf((ParseNode)object.get(0))) {
                    list2 = oracleSQLQueryBuilderHelper.getOrderedChildren((ParseNode)object.get(0));
                    if (oracleSQLQueryBuilderHelper.isKeyword((ParseNode)list2.get(0), "(")) {
                        parseNode = (ParseNode)list2.get(1);
                    } else if (list2.size() == 3 && oracleSQLQueryBuilderHelper.isKeyword((ParseNode)list2.get(1), "@")) {
                        ((LinkSchemaTableAndAlias)object2).setTable(oracleSQLQueryBuilderHelper.getContent((ParseNode)list2.get(0)));
                        string = oracleSQLQueryBuilderHelper.getContent((ParseNode)list2.get(2));
                    } else if (list2.size() == 5 && oracleSQLQueryBuilderHelper.isKeyword((ParseNode)list2.get(1), ".") && oracleSQLQueryBuilderHelper.isKeyword((ParseNode)list2.get(3), "@")) {
                        ((LinkSchemaTableAndAlias)object2).setSchema(oracleSQLQueryBuilderHelper.getContent((ParseNode)list2.get(0)));
                        ((LinkSchemaTableAndAlias)object2).setTable(oracleSQLQueryBuilderHelper.getContent((ParseNode)list2.get(2)));
                        string = oracleSQLQueryBuilderHelper.getContent((ParseNode)list2.get(4));
                    } else {
                        object2 = this.getSchemaAndTable((ParseNode)object.get(0));
                    }
                    ((LinkSchemaTableAndAlias)object2).setAlias(this.getTableAlias((List<ParseNode>)object));
                } else {
                    object2 = this.getTableAndAlias((List<ParseNode>)object);
                }
                string = ((LinkSchemaTableAndAlias)object2).getLink();
                string2 = ((LinkSchemaTableAndAlias)object2).getSchema();
                string3 = ((LinkSchemaTableAndAlias)object2).getTable();
                string4 = ((LinkSchemaTableAndAlias)object2).getAlias();
            } else if (oracleSQLQueryBuilderHelper.isRule(parseNode2, "subquery", "table_collection_expression")) {
                parseNode = parseNode2;
            }
        } else if (list.size() == 2) {
            object2 = parseNode2;
            if (oracleSQLQueryBuilderHelper.isRule(list.get(1), "pivot_clause", "unpivot_clause")) {
                fromObject = this.createPivot88(list, null);
            } else if (oracleSQLQueryBuilderHelper.isRule(parseNode2, "pivot_clause", "unpivot_clause")) {
                string4 = oracleSQLQueryBuilderHelper.getContent(list.get(1));
                fromObject = this.createPivot84(parseNode2, string4);
            }
            if (oracleSQLQueryBuilderHelper.isRule(parseNode2, "table_collection_expression")) {
                parseNode = parseNode2;
            } else if (oracleSQLQueryBuilderHelper.isRule(parseNode2, "xmltable")) {
                fromObject = this.createXMLTable(list);
            } else {
                object = oracleSQLQueryBuilderHelper.getDotSeparatedList((ParseNode)object2);
                list2 = new ArrayList();
                if (object.size() == 1) {
                    list2 = oracleSQLQueryBuilderHelper.getOrderedChildren((ParseNode)object.get(0));
                }
                if (object.size() == 1 && oracleSQLQueryBuilderHelper.isLeaf((ParseNode)object.get(0))) {
                    string3 = oracleSQLQueryBuilderHelper.getContent((ParseNode)object.get(0));
                }
                if (object.size() == 1 && list2.size() == 3 && oracleSQLQueryBuilderHelper.isKeyword((ParseNode)list2.get(1), "@")) {
                    string3 = oracleSQLQueryBuilderHelper.getContent((ParseNode)list2.get(0));
                    string = oracleSQLQueryBuilderHelper.getContent((ParseNode)list2.get(2));
                } else if (object.size() == 4 && oracleSQLQueryBuilderHelper.isKeyword((ParseNode)object.get(2), "@")) {
                    string2 = oracleSQLQueryBuilderHelper.getContent((ParseNode)object.get(0));
                    string3 = oracleSQLQueryBuilderHelper.getContent((ParseNode)object.get(1));
                    string = oracleSQLQueryBuilderHelper.getContent((ParseNode)object.get(3));
                } else if (object.size() == 1 && list2.size() == 3 && oracleSQLQueryBuilderHelper.isKeyword((ParseNode)list2.get(0), "(")) {
                    parseNode = (ParseNode)list2.get(1);
                } else if (object.size() == 2 && oracleSQLQueryBuilderHelper.isLeaf((ParseNode)object.get(0)) && oracleSQLQueryBuilderHelper.isLeaf((ParseNode)object.get(1))) {
                    string2 = oracleSQLQueryBuilderHelper.getContent((ParseNode)object.get(0));
                    string3 = oracleSQLQueryBuilderHelper.getContent((ParseNode)object.get(1));
                } else if (list.size() == 3 && oracleSQLQueryBuilderHelper.isKeyword(parseNode2, "(") && oracleSQLQueryBuilderHelper.isRule(list.get(1), "subquery")) {
                    parseNode = list.get(1);
                }
            }
        } else if (list.size() == 3 && oracleSQLQueryBuilderHelper.isKeyword(parseNode2, "(")) {
            parseNode = list.get(1);
        } else {
            object2 = this.getTableAndAlias(list);
            string = ((LinkSchemaTableAndAlias)object2).getLink();
            string2 = ((LinkSchemaTableAndAlias)object2).getSchema();
            string3 = ((LinkSchemaTableAndAlias)object2).getTable();
            string4 = ((LinkSchemaTableAndAlias)object2).getAlias();
        }
        if (parseNode == null && fromObject == null) {
            fromObject = new FromObject();
            fromObject.setAlias(string4);
            this.checkAlias((AliasFragment)fromObject, string4);
            if (ModelUtil.hasLength((String)string3) && string3.equalsIgnoreCase(DUAL)) {
                fromObject.setExpression((SQLFragment)new SimpleSQLFragment(string3));
            } else {
                object2 = this.getFromObject(string3);
                if (object2 != null && object2.isWith()) {
                    object = new WithClauseUsage();
                    object.setFromObjectID(object2.getID());
                    fromObject.setExpression((SQLFragment)object);
                } else {
                    object = this.createRelationUsage(string2, string3, string);
                    if (object == null) {
                        this.throwException(new SQLQueryException(APIBundle.format((String)"SQL_CANT_FIND_REL", (Object[])new Object[]{string3})));
                    }
                    int n = oracleSQLQueryBuilderHelper.getNodeStartOffset(parseNode2);
                    ((AbstractSQLFragment)object).setStartOffset(Integer.valueOf(n));
                    fromObject.setExpression((SQLFragment)object);
                }
            }
            this.ensureID((DBObject)fromObject);
        } else if (fromObject == null) {
            object2 = oracleSQLQueryBuilderHelper.getOrderedChildren(parseNode);
            if (oracleSQLQueryBuilderHelper.isRule(parseNode, "query_table_expression") && object2.size() == 3 && oracleSQLQueryBuilderHelper.isKeyword((ParseNode)object2.get(0), "(")) {
                parseNode = (ParseNode)object2.get(1);
            }
            if (oracleSQLQueryBuilderHelper.isRule(parseNode, "subquery")) {
                fromObject = this.createSubquery(parseNode, string4);
            } else if (oracleSQLQueryBuilderHelper.isRule(parseNode, "join_clause")) {
                object2 = oracleSQLQueryBuilderHelper.getOrderedChildren(parseNode);
                fromObject = this.createAnsiJoin((List<ParseNode>)object2);
            } else if (oracleSQLQueryBuilderHelper.isRule(parseNode, "table_collection_expression")) {
                object2 = oracleSQLQueryBuilderHelper.getOrderedChildren(parseNode);
                object = new SQLFragment[]{this.createFragment((ParseNode)object2.get(2), (SQLFragment)fromObject, null)};
                list2 = this.createFunction("TABLE", (SQLFragment[])object, "TABLE");
                fromObject = new FromObject(list2, string4);
            } else {
                this.throwException(new SQLQueryException(APIBundle.get((String)"SQL_CANT_BUILD_SUBQUERY")));
            }
        }
        if (fromObject == null) {
            throw new SQLQueryException(APIBundle.get((String)"SQL_CANT_FIND_FROM"));
        }
        fromObject.setStartOffset(Integer.valueOf(oracleSQLQueryBuilderHelper.getNodeStartOffset(parseNode2)));
        return fromObject;
    }

    private void checkAlias(AliasFragment aliasFragment, String string) throws InvalidAliasException {
        if (ModelUtil.hasLength((String)string)) {
            this.validateAlias(aliasFragment, "COLUMN", string);
        }
    }

    private FromObject createSubquery(ParseNode parseNode, String string) throws InvalidAliasException, SQLQueryException {
        OracleSQLQueryBuilder oracleSQLQueryBuilder = new OracleSQLQueryBuilder((DBObjectProvider)this.getProvider(), this.getDefaultSchema(), this.getHelper(), this);
        SQLQuery sQLQuery = new SQLQuery();
        oracleSQLQueryBuilder.buildQuery(parseNode, sQLQuery, (DBObject)this.getSQLQuery());
        FromObject fromObject = new FromObject((SQLFragment)sQLQuery, string);
        this.checkAlias((AliasFragment)fromObject, string);
        return fromObject;
    }

    private DBObjectUsage createRelationUsage(String string, String string2, String string3) throws SQLQueryException {
        RelationUsage relationUsage = null;
        if (ModelUtil.hasLength((String)string2)) {
            AbstractDBObjectProvider abstractDBObjectProvider = this.getProvider();
            string = string == null ? null : this.getInternalName(string);
            string3 = string3 == null ? null : this.getInternalName(string3);
            string2 = this.getInternalName(string2);
            try {
                SchemaObject schemaObject = this.getObjectForFrom(string, string2, string3);
                if (schemaObject instanceof Relation) {
                    relationUsage = new RelationUsage(schemaObject.getID());
                } else if (schemaObject instanceof Synonym) {
                    relationUsage = new SynonymUsage(schemaObject.getID());
                }
                if (relationUsage != null && ModelUtil.hasLength((String)string)) {
                    ((AbstractSchemaObjectUsage)relationUsage).setQualified(true);
                }
            }
            catch (SQLQueryCancelledException sQLQueryCancelledException) {
                throw sQLQueryCancelledException;
            }
            catch (DBException dBException) {
                this.checkCancelled();
                this.getLogger().warning("Could not create usage: " + dBException.getMessage());
            }
            if (relationUsage == null) {
                throw new SQLQueryException(APIBundle.format((String)"SQL_CANT_FIND_REL", (Object[])new Object[]{string2}));
            }
            relationUsage.setProvider((DBObjectProvider)abstractDBObjectProvider);
        }
        return relationUsage;
    }

    public AbstractSQLQueryBuilder getParentBuilder() {
        return this.m_parentBuilder;
    }

    protected void replaceWithAliases(FromObject[] fromObjectArray) {
        SQLQuery sQLQuery = null;
        AbstractSQLQueryBuilder abstractSQLQueryBuilder = this.getParentBuilder();
        if (abstractSQLQueryBuilder != null) {
            sQLQuery = this.getParentBuilder().getSQLQuery();
        }
        if (sQLQuery != null) {
            block0: for (int i = 0; i < fromObjectArray.length; ++i) {
                FromObject[] fromObjectArray2;
                if (fromObjectArray[i] == null || !ModelUtil.hasLength((String)fromObjectArray[i].getAlias()) || fromObjectArray[i].getExpression() != null) continue;
                String string = fromObjectArray[i].getAlias();
                for (FromObject fromObject : fromObjectArray2 = sQLQuery.getFromObjects()) {
                    if (!string.equalsIgnoreCase(fromObject.getAlias())) continue;
                    fromObjectArray[i] = fromObject;
                    continue block0;
                }
            }
        }
    }

    public SQLFragment createFragment(ParseNode parseNode, SQLFragment sQLFragment, Object object) throws SQLQueryException {
        return this.createFragment(parseNode, sQLFragment, object, this.getHelper());
    }

    SQLFragment createFragment(ParseNode parseNode, SQLFragment sQLFragment, Object object, OracleSQLQueryBuilderHelper oracleSQLQueryBuilderHelper) throws SQLQueryException {
        OracleSQLQueryBuilderHelper oracleSQLQueryBuilderHelper2 = (OracleSQLQueryBuilderHelper)this.m_helper.get();
        if (oracleSQLQueryBuilderHelper2 == null) {
            throw new IllegalStateException("Cannot call createFragment outside of a parseSQL operation");
        }
        if (oracleSQLQueryBuilderHelper != oracleSQLQueryBuilderHelper2) {
            throw new IllegalStateException("Must use the current helper");
        }
        ExpressionContext expressionContext = new ExpressionContext(this, this.getSQLQuery(), (DBObjectProvider)this.getProvider(), this.getDefaultSchema(), oracleSQLQueryBuilderHelper, object, sQLFragment);
        SQLFragment sQLFragment2 = null;
        SQLQueryException sQLQueryException = null;
        for (ExpressionFactory object2 : this.m_expressionFactories) {
            this.checkCancelled();
            try {
                sQLFragment2 = object2.createFragment(expressionContext, parseNode);
                if (sQLFragment2 == null) continue;
                break;
            }
            catch (SQLQueryCancelledException level) {
                throw level;
            }
            catch (SQLQueryException sQLQueryCancelledException) {
                if (sQLQueryException == null) {
                    sQLQueryException = sQLQueryCancelledException;
                    continue;
                }
                sQLQueryException.setNextException((DBException)((Object)sQLQueryCancelledException));
            }
        }
        if (sQLFragment2 == null && oracleSQLQueryBuilderHelper.isLeaf(parseNode)) {
            this.checkCancelled();
            sQLFragment2 = this.createFromFactory(sQLFragment, oracleSQLQueryBuilderHelper.getContent(parseNode), oracleSQLQueryBuilderHelper.getNodeStartOffset(parseNode));
        }
        if (sQLFragment2 == null) {
            Level level;
            String string = oracleSQLQueryBuilderHelper.getSourceFragment(parseNode);
            Logger logger = this.getLogger();
            if (logger.isLoggable(level = Level.FINEST)) {
                String string2 = parseNode.toString();
                logger.log(level, "OracleSQLQueryBuilder: Node cannot be built - Unrecognized SQL fragment\n Rules: " + string2 + "\n Source fragment: " + (String)string);
            }
            if (sQLQueryException == null) {
                sQLQueryException = new UnrecognizedFragmentException(string);
            }
            this.throwException(sQLQueryException);
        } else {
            ((AbstractSQLFragment)sQLFragment2).setStartOffset(Integer.valueOf(oracleSQLQueryBuilderHelper.getNodeStartOffset(parseNode)));
        }
        return sQLFragment2;
    }

    protected void checkCancelled() throws SQLQueryCancelledException {
        super.checkCancelled();
        if (this.m_parentBuilder != null) {
            this.m_parentBuilder.checkCancelled();
        }
    }

    public FromObjectUsage findColumnInFromExpression(String string, boolean bl, SQLFragment sQLFragment, boolean bl2, FromObject fromObject, SQLFragment sQLFragment2) throws SQLQueryException {
        FromObjectUsage fromObjectUsage = super.findColumnInFromExpression(string, bl, sQLFragment, bl2, fromObject, sQLFragment2);
        if (fromObjectUsage == null && sQLFragment instanceof XMLFunctionUsage && "XMLTABLE".equals(((XMLFunctionUsage)sQLFragment).getFunction())) {
            String string22;
            OracleSQLQueryBuilderHelper oracleSQLQueryBuilderHelper = this.getHelper();
            ArrayList<String> arrayList = new ArrayList<String>();
            ParseNode parseNode = oracleSQLQueryBuilderHelper.getNodeAtOffset(sQLFragment.getStartOffset());
            if (parseNode != null) {
                for (String string22 : parseNode.descendants()) {
                    Object object;
                    if (!oracleSQLQueryBuilderHelper.isRule((ParseNode)string22, "XML_table_column") || (object = oracleSQLQueryBuilderHelper.getOrderedChildren((ParseNode)string22)) == null || object.size() <= 0) continue;
                    arrayList.add(oracleSQLQueryBuilderHelper.getContent((ParseNode)object.get(0)));
                }
            }
            DatabaseDescriptor databaseDescriptor = this.getProvider().getDescriptor();
            string22 = bl ? string : databaseDescriptor.getExternalName(string, "COLUMN");
            for (String string3 : arrayList) {
                if (!databaseDescriptor.areNamesEqual(string22, string3, "COLUMN", true)) continue;
                fromObjectUsage = new ColumnKeywordUsage(string, fromObject);
                break;
            }
        }
        return fromObjectUsage;
    }

    public FromObjectUsage findColumnInFromObjects(String string, boolean bl, SQLFragment sQLFragment, FromObject ... fromObjectArray) throws SQLQueryException {
        FromObjectUsage fromObjectUsage = super.findColumnInFromObjects(string, bl, sQLFragment, fromObjectArray);
        if (fromObjectUsage == null && this.m_parentBuilder != null) {
            fromObjectUsage = this.m_parentBuilder.findColumnInFromObjects(string, bl, sQLFragment, new FromObject[0]);
        }
        return fromObjectUsage;
    }

    private WhereObject createWhere(ParseNode parseNode) throws SQLQueryException {
        return this.createWhere(parseNode, null);
    }

    private WhereObject createWhere(ParseNode parseNode, SQLFragment sQLFragment) throws SQLQueryException {
        WhereObject whereObject = null;
        OracleSQLQueryBuilderHelper oracleSQLQueryBuilderHelper = this.getHelper();
        if (oracleSQLQueryBuilderHelper.isRule(parseNode, "where_clause")) {
            ParseNode parseNode2 = oracleSQLQueryBuilderHelper.getOrderedChildren(parseNode).get(1);
            whereObject = new WhereObject(this.createFragment(parseNode2, sQLFragment, null));
        } else {
            whereObject = new WhereObject(this.createFragment(parseNode, sQLFragment, null));
        }
        return whereObject;
    }

    private HierarchicalQueryObject createHierarchicalQuery(ParseNode parseNode) throws SQLQueryException {
        HierarchicalQueryObject hierarchicalQueryObject = null;
        OracleSQLQueryBuilderHelper oracleSQLQueryBuilderHelper = this.getHelper();
        List<ParseNode> list = oracleSQLQueryBuilderHelper.getOrderedChildren(parseNode);
        boolean bl = oracleSQLQueryBuilderHelper.getKeywordIndex(list, "START") == 0;
        boolean bl2 = oracleSQLQueryBuilderHelper.getKeywordIndex(list, "NOCYCLE") != -1;
        hierarchicalQueryObject = new HierarchicalQueryObject(null, null, bl, bl2);
        SQLFragment sQLFragment = null;
        SQLFragment sQLFragment2 = null;
        boolean bl3 = false;
        ArrayList<SQLFragment> arrayList = new ArrayList<SQLFragment>();
        for (ParseNode parseNode2 : list) {
            if (oracleSQLQueryBuilderHelper.isKeyword(parseNode2, "CONNECT")) {
                bl3 = true;
            }
            if (oracleSQLQueryBuilderHelper.isKeyword(parseNode2, "START")) {
                bl3 = false;
                continue;
            }
            if (!oracleSQLQueryBuilderHelper.isRule(parseNode2, "condition")) continue;
            if (bl3) {
                arrayList.add(this.createFragment(parseNode2, (SQLFragment)hierarchicalQueryObject, null));
                continue;
            }
            sQLFragment = this.createFragment(parseNode2, (SQLFragment)hierarchicalQueryObject, null);
        }
        if (arrayList.size() > 1) {
            sQLFragment2 = new WhereObject(arrayList.toArray(new SQLFragment[arrayList.size()]), WhereObject.WhereOperator.AND);
        } else if (arrayList.size() == 1) {
            sQLFragment2 = (SQLFragment)arrayList.get(0);
        }
        hierarchicalQueryObject.setConnectBy(sQLFragment2);
        hierarchicalQueryObject.setStartWith(sQLFragment);
        return hierarchicalQueryObject;
    }

    private List<List<ParseNode>> getGroupByCommaSeparatedList(List<ParseNode> list) {
        OracleSQLQueryBuilderHelper oracleSQLQueryBuilderHelper = this.getHelper();
        if (list.size() == 1 && oracleSQLQueryBuilderHelper.isRule(list.get(0), "parenthesized_group_by_list") && !oracleSQLQueryBuilderHelper.isRule(list.get(0), "group_by_col") && (list = oracleSQLQueryBuilderHelper.getOrderedChildren(list.get(0))).size() == 3 && oracleSQLQueryBuilderHelper.isRule(list.get(1), "group_by_list")) {
            list = oracleSQLQueryBuilderHelper.getOrderedChildren(list.get(1));
        }
        List<List<ParseNode>> list2 = oracleSQLQueryBuilderHelper.getCommaSeparatedList(list);
        return list2;
    }

    private GroupByObject createGroupBy(ParseNode parseNode) throws SQLQueryException {
        ParseNode parseNode2 = null;
        OracleSQLQueryBuilderHelper oracleSQLQueryBuilderHelper = this.getHelper();
        List<ParseNode> list = oracleSQLQueryBuilderHelper.getOrderedChildren(parseNode);
        int n = oracleSQLQueryBuilderHelper.getKeywordIndex(list, "HAVING");
        if (n == -1) {
            n = list.size();
        } else {
            parseNode2 = list.get(n + 1);
        }
        List<List<ParseNode>> list2 = this.getGroupByCommaSeparatedList(list.subList(2, n));
        GroupByObject groupByObject = new GroupByObject();
        SQLFragment[] sQLFragmentArray = new SQLFragment[list2.size()];
        for (int i = 0; i < list2.size(); ++i) {
            SQLFragment sQLFragment = this.createFragment(list2.get(i).get(0), (SQLFragment)groupByObject, null);
            if (sQLFragment != null) {
                sQLFragmentArray[i] = sQLFragment;
                continue;
            }
            this.throwException(new SQLQueryException(APIBundle.get((String)"SQL_GROUPBY_EXPRESSION_UNKNOWN")));
        }
        groupByObject.setExpressions(sQLFragmentArray);
        if (parseNode2 != null) {
            WhereObject whereObject = this.createWhere(parseNode2);
            groupByObject.setHaving(whereObject);
        }
        return groupByObject;
    }

    private ModelObject createModel(ParseNode parseNode) throws SQLQueryException {
        ModelObject modelObject = null;
        modelObject = (ModelObject)this.createFragment(parseNode, null, null);
        return modelObject;
    }

    private void checkLength(String string) throws SQLQueryException {
        if (!ModelUtil.hasLength((String)string)) {
            this.throwException(new SQLQueryException(APIBundle.get((String)"SQL_EMPTY_EXP")));
        }
    }

    public FromObjectUsage findColumnInRelation(String string, boolean bl, Relation relation) throws SQLQueryException {
        if (this.getProvider().getDescriptor().areNamesEqual(string, "ROWID", "COLUMN", bl)) {
            ColumnKeywordUsage columnKeywordUsage = new ColumnKeywordUsage();
            columnKeywordUsage.setColumnName(string);
            return columnKeywordUsage;
        }
        return super.findColumnInRelation(string, bl, relation);
    }

    public void ensureQueryNonDeclarative(final SQLQueryOwner sQLQueryOwner) {
        final SQLQuery sQLQuery = sQLQueryOwner.getSQLQuery();
        if (sQLQuery != null) {
            final String string = sQLQuery.getSQLText();
            this.parseSQL(string, new HelperCallable<Object, RuntimeException>(){

                @Override
                public Object process(OracleSQLQueryBuilderHelper oracleSQLQueryBuilderHelper) {
                    String string3 = string;
                    try {
                        if (sQLQueryOwner instanceof Relation) {
                            List<ParseNode> list = oracleSQLQueryBuilderHelper.getQueryRootKids();
                            List<ParseNode> list2 = oracleSQLQueryBuilderHelper.getSelectItemNodes(list);
                            List<AbstractSQLQueryBuilder.QueryColumnInfo> list3 = OracleSQLQueryBuilder.this.getQueryColumnInfosImpl(oracleSQLQueryBuilderHelper);
                            Column[] columnArray = ((Relation)sQLQueryOwner).getColumns();
                            if (columnArray.length == 0) {
                                columnArray = new Column[list2.size()];
                                for (int i = 0; i < list2.size(); ++i) {
                                    columnArray[i] = new Column("COL" + (i + 1));
                                }
                            }
                            StringBuilder stringBuilder = new StringBuilder(string);
                            int n = 0;
                            if (list2 != null && list2.size() == columnArray.length) {
                                for (int i = 0; i < list2.size(); ++i) {
                                    Object object;
                                    Object object2;
                                    boolean bl;
                                    ParseNode parseNode = list2.get(i);
                                    boolean bl2 = bl = list3.get(i).getName() != null;
                                    if (bl) continue;
                                    int n2 = -1;
                                    if (i < list2.size() - 1) {
                                        n2 = oracleSQLQueryBuilderHelper.getNodeStartOffset(list2.get(i + 1));
                                        n2 = string.lastIndexOf(",", n2);
                                    } else {
                                        ParseNode parseNode2 = oracleSQLQueryBuilderHelper.getRuleNode(list, "from_clause");
                                        object2 = oracleSQLQueryBuilderHelper.getOrderedChildren(parseNode2);
                                        object = object2.get(0);
                                        n2 = oracleSQLQueryBuilderHelper.getNodeStartOffset((ParseNode)object);
                                    }
                                    int n3 = oracleSQLQueryBuilderHelper.getNodeStartOffset(parseNode);
                                    object2 = string.substring(n3, n2).trim();
                                    object = columnArray[i].getName();
                                    if (n2 <= 0 || ((String)object2).contains("*") || ((String)object2).toUpperCase().endsWith("." + ((String)object).toUpperCase()) || OracleSQLQueryBuilder.this.getProvider().isValidName("COLUMN", (String)object2)) continue;
                                    String string2 = " " + (String)object + " ";
                                    stringBuilder.insert(n + n2, string2);
                                    OracleSQLQueryBuilder.this.getLogger().log(Level.INFO, APIBundle.format((String)"VIEW_COLUMN_HACK", (Object[])new Object[]{string2, object2, sQLQueryOwner.getType(), sQLQueryOwner.getName()}));
                                    n += string2.length();
                                }
                            }
                            string3 = stringBuilder.toString();
                        }
                    }
                    catch (DBException dBException) {
                        OracleSQLQueryBuilder.this.getLogger().log(Level.WARNING, APIBundle.format((String)"WARNING_ERROR_PROCESSING_VIEW", (Object[])new Object[]{sQLQueryOwner.getType(), sQLQueryOwner.getName(), string, dBException.getMessage()}));
                    }
                    catch (Exception exception) {
                        OracleSQLQueryBuilder.this.getLogger().log(DBLog.getExceptionLogLevel(), "Error processing view", exception);
                    }
                    sQLQuery.setQueryString(string3);
                    sQLQuery.setDeclarative(false);
                    if (sQLQueryOwner instanceof Relation) {
                        OracleSQLQueryBuilder.this.removeViewColumns((Relation)sQLQueryOwner);
                    }
                    return null;
                }
            });
        }
    }

    private void removeViewColumns(Relation relation) {
        Object v = DBUtil.getFrozenProperties((DBObject)relation).get("columns");
        if (v instanceof Column[]) {
            for (Column column : (Column[])v) {
                if (!(column instanceof ViewColumn)) continue;
                relation.setColumns(null);
                break;
            }
        }
    }

    public String buildErrorMessage(ParseNode parseNode, String string) {
        String string2 = this.getHelper().getSourceFragment(parseNode);
        return APIBundle.format((String)"SQL_RQB_ERROR", (Object[])new Object[]{string, string2});
    }

    private void removeTemporaryObjectIDs(SQLFragment sQLFragment) {
        if (sQLFragment != null) {
            DBObject[] dBObjectArray;
            if (sQLFragment.getID() instanceof TemporaryObjectID) {
                sQLFragment.setID(null);
            }
            if ((dBObjectArray = sQLFragment.getOwnedObjects()) != null) {
                for (DBObject dBObject : dBObjectArray) {
                    if (!(dBObject instanceof SQLFragment)) continue;
                    this.removeTemporaryObjectIDs((SQLFragment)dBObject);
                }
            }
        }
    }

    public void addSetOperatorObject(SetOperator setOperator) throws SQLQueryException {
    }

    protected Function createFunction(String string, SQLFragment[] sQLFragmentArray, String string2) throws SQLQueryException {
        if (ModelUtil.hasLength((String)string)) {
            if (string.equals("CAST")) {
                if (sQLFragmentArray.length != 2) {
                    this.throwException((SQLQueryException)new SQLQueryClauseException(sQLFragmentArray[0], "usage: CAST( expr, type )"));
                }
                if (sQLFragmentArray[0] instanceof SQLQuery) {
                    sQLFragmentArray[0] = new Function("MULTISET", new SQLFragment[]{sQLFragmentArray[0]});
                    this.setFunctionReturnTypeID((Function)sQLFragmentArray[0]);
                }
                Function function = new Function(string, sQLFragmentArray, " AS ");
                this.setFunctionReturnTypeID(function);
                return function;
            }
            if (string.equals("CONCAT")) {
                if (string2 != null && string2.equals("||")) {
                    Function function = new Function(string2, sQLFragmentArray);
                    this.setFunctionReturnTypeID(function);
                    return function;
                }
            } else {
                if (string.equals("TRANSLATE") && sQLFragmentArray.length == 2) {
                    Function function = new Function(string, sQLFragmentArray, " USING ");
                    this.setFunctionReturnTypeID(function);
                    return function;
                }
                if (string.equals("LTRIM") && "LEADING".equals(string2) || string.equals("RTRIM") && "TRAILING".equals(string2) || string.equals("TRIM") && "BOTH".equals(string2)) {
                    Object object = string2;
                    if (sQLFragmentArray.length == 2) {
                        this.swapFirstTwoArgs(sQLFragmentArray);
                    } else {
                        object = string2 + " FROM";
                    }
                    Function function = new Function("TRIM", sQLFragmentArray, " FROM ");
                    this.setFunctionReturnTypeID(function);
                    function.setTrimLeader((String)object);
                    return function;
                }
                if (string.equals("TRIM") && sQLFragmentArray.length == 2) {
                    this.swapFirstTwoArgs(sQLFragmentArray);
                    Function function = new Function(string, sQLFragmentArray, " FROM ");
                    this.setFunctionReturnTypeID(function);
                    return function;
                }
            }
            boolean bl = false;
            for (BuiltInFunction builtInFunction : this.getProvider().getDescriptor().listBuiltInFunctions(string)) {
                if (!builtInFunction.isAggregate()) continue;
                bl = true;
                break;
            }
            Function function = new Function(string, sQLFragmentArray, bl);
            this.setFunctionReturnTypeID(function);
            return function;
        }
        return null;
    }

    private void swapFirstTwoArgs(SQLFragment[] sQLFragmentArray) {
        SQLFragment sQLFragment = sQLFragmentArray[1];
        sQLFragmentArray[1] = sQLFragmentArray[0];
        sQLFragmentArray[0] = sQLFragment;
    }

    public static String fixEmptySelectClause(String string) {
        Object object = string;
        try {
            String string2 = ((String)object).toUpperCase();
            int n = string2.indexOf("SELECT");
            int n2 = string2.indexOf("FROM");
            int n3 = "FROM".length();
            while (n2 > 0) {
                char c;
                char c2 = string2.charAt(n2 - 1);
                char c3 = c = n2 < string2.length() - n3 ? string2.charAt(n2 + n3) : (char)'\u0000';
                if (Character.isWhitespace(c2) && Character.isWhitespace(c)) {
                    int n4 = "SELECT".length();
                    String string3 = string2.substring(n + n4, n2);
                    if (string3.trim().length() == 0) {
                        object = ((String)object).substring(0, n + n4) + " *" + ((String)object).substring(n + n4);
                    }
                    break;
                }
                n2 = string2.indexOf("FROM", n2 + 1);
            }
        }
        catch (Exception exception) {
            DBLog.logStackTrace((String)"Could not fix query", (Throwable)exception);
        }
        return object;
    }

    void setFunctionReturnTypeID(Function function) throws SQLQueryException {
        BuiltInFunction builtInFunction;
        Object object;
        AbstractDBObjectProvider abstractDBObjectProvider = this.getProvider();
        DBObjectID dBObjectID = null;
        BuiltInFunction builtInFunction2 = null;
        if (abstractDBObjectProvider != null) {
            object = abstractDBObjectProvider.getDescriptor().listBuiltInFunctions(function.getFunction()).iterator();
            while (object.hasNext()) {
                builtInFunction = (BuiltInFunction)object.next();
                if (builtInFunction2 == null) {
                    builtInFunction2 = builtInFunction;
                    continue;
                }
                if (builtInFunction2.isAggregate() != function.isGrouping() && builtInFunction.isAggregate() == function.isGrouping()) {
                    builtInFunction2 = builtInFunction;
                    continue;
                }
                int n = function.getArgumentCount();
                if (builtInFunction.getMinArgs() > n || builtInFunction.getMaxArgs() < n || builtInFunction2.getMinArgs() <= n && builtInFunction2.getMaxArgs() >= n) continue;
                builtInFunction2 = builtInFunction;
            }
        }
        if (builtInFunction2 != null) {
            object = builtInFunction2.getArgumentDefiningReturnType();
            if (object != null && object.intValue() <= function.getArgumentCount() && function.getArguments()[object.intValue() - 1] instanceof SQLFragmentWithDatatype) {
                builtInFunction = (SQLFragmentWithDatatype)function.getArguments()[object.intValue() - 1];
                if (builtInFunction instanceof ColumnUsage) {
                    DataTypeUsage dataTypeUsage;
                    DBObjectID dBObjectID2 = ((ColumnUsage)builtInFunction).getObjectID();
                    DBObject dBObject = this.resolveID(dBObjectID2);
                    if (dBObject instanceof Column && (dataTypeUsage = ((Column)dBObject).getDataTypeUsage()) != null) {
                        dBObjectID = dataTypeUsage.getDataTypeID();
                    }
                } else {
                    dBObjectID = builtInFunction.getDataTypeID();
                }
            } else {
                dBObjectID = builtInFunction2.getReturnTypeID();
            }
            if (dBObjectID instanceof DataTypeID) {
                ((DataTypeID)dBObjectID).ensureProvider((DBObjectProvider)abstractDBObjectProvider);
            } else if (dBObjectID instanceof BaseObjectID) {
                ((BaseObjectID)dBObjectID).setProvider((DBObjectProvider)abstractDBObjectProvider);
            }
        } else if ("TABLE".equals(function.getFunction()) && ((SQLFragment[])(object = function.getArguments())).length > 0) {
            SQLFragment[] sQLFragmentArray;
            builtInFunction = object[((SQLFragment[])object).length - 1];
            if (builtInFunction instanceof FunctionUsage) {
                DBObjectID dBObjectID3 = ((FunctionUsage)builtInFunction).getObjectID();
                DBObject dBObject = this.resolveID(dBObjectID3);
                if (dBObject instanceof SQLCallable) {
                    dBObjectID = ((SQLCallable)dBObject).getReturnTypeID();
                }
            } else if (builtInFunction instanceof ColumnUsage) {
                DBObjectID dBObjectID4 = ((ColumnUsage)builtInFunction).getObjectID();
                DBObject dBObject = this.resolveID(dBObjectID4);
                if (dBObject instanceof Column) {
                    dBObjectID = ((Column)dBObject).getDataTypeUsage().getDataTypeID();
                }
            } else if (builtInFunction instanceof Function && "CAST".equals(((Function)builtInFunction).getFunction()) && (sQLFragmentArray = ((Function)builtInFunction).getArguments()).length > 0) {
                SQLFragment sQLFragment = sQLFragmentArray[sQLFragmentArray.length - 1];
                dBObjectID = DataTypeHelper.findIDForTypeString((DBObjectProvider)this.getProvider(), (Schema)this.getDefaultSchema(), (String)sQLFragment.getSQLText());
            }
        }
        function.setDataTypeID(dBObjectID);
    }

    private static abstract class HelperCallable<T, E extends Exception> {
        private HelperCallable() {
        }

        public abstract T process(OracleSQLQueryBuilderHelper var1) throws E;
    }

    private class LinkSchemaTableAndAlias {
        private String m_link = null;
        private String m_schema = null;
        private String m_table = null;
        private String m_alias = null;

        LinkSchemaTableAndAlias() {
        }

        LinkSchemaTableAndAlias(String string, String string2, String string3, String string4) {
            this.m_link = string;
            this.m_schema = string2;
            this.m_table = string3;
            this.m_alias = string4;
        }

        private String getLink() {
            return this.m_link;
        }

        private void setSchema(String string) {
            this.m_schema = string;
        }

        private String getSchema() {
            return this.m_schema;
        }

        private void setTable(String string) {
            this.m_table = string;
        }

        private String getTable() {
            return this.m_table;
        }

        private void setAlias(String string) {
            this.m_alias = string;
        }

        private String getAlias() {
            return this.m_alias;
        }
    }
}

