/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.ddl;

import java.util.ArrayList;
import java.util.Collection;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Index;
import oracle.javatools.db.Table;
import oracle.javatools.db.ddl.DDL;
import oracle.javatools.db.ddl.DDLOptions;
import oracle.javatools.db.ddl.DDLType;
import oracle.javatools.db.ora.ddl.OracleDDLGenerator;
import oracle.javatools.db.ora.ddl.OracleDDLType;
import oracle.javatools.db.ora.ddl.OracleStatementType;
import oracle.javatools.db.ora.lite.OracleDatabaseLite;

public class OracleLiteDDLGenerator
extends OracleDDLGenerator {
    public OracleLiteDDLGenerator(Class<? extends OracleDatabaseLite> clazz, DBObjectProvider dBObjectProvider) {
        super(clazz, dBObjectProvider);
    }

    @Override
    public Collection getAllowedPropertyValues(DBObject dBObject, DBObject dBObject2, String string) {
        Collection<Table.TableType> collection = null;
        if (dBObject2 instanceof Table && string.equals("TableType")) {
            collection = new ArrayList<Table.TableType>();
            collection.add(Table.TableType.NORMAL);
            collection.add(Table.TableType.SESSION_TEMP);
            collection.add(Table.TableType.TRANSACTION_TEMP);
        } else if (dBObject2 instanceof Index && "indexType".equals(string)) {
            collection = new ArrayList();
            collection.add((Table.TableType)Index.IndexType.NORMAL);
            collection.add((Table.TableType)Index.IndexType.UNIQUE);
            collection.add((Table.TableType)Index.IndexType.BITMAP);
        } else {
            collection = super.getAllowedPropertyValues(dBObject, dBObject2, string);
        }
        return collection;
    }

    @Override
    protected DDL<OracleDDLType> finish(DDLOptions dDLOptions, DDL<OracleDDLType> dDL) {
        DDL<OracleDDLType> dDL2 = super.finish(dDLOptions, dDL);
        if (dDL2 != null && dDL2.size() > 0) {
            DDL dDL3 = new DDL();
            dDL3.append((DDLType)OracleDDLType.getDDLType((OracleStatementType)OracleStatementType.COMMIT), "COMMIT");
            dDL2.append(dDL3);
        }
        return dDL2;
    }
}

