/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.bigdata;

import java.util.ServiceLoader;
import oracle.dbtools.plugin.api.json.JSONReader;
import oracle.dbtools.plugin.api.json.JSONStreams;
import oracle.dbtools.plugin.api.json.JSONToken;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Relation;
import oracle.javatools.db.ora.bigdata.BigDataAccessParameter;
import oracle.javatools.db.ora.bigdata.BigDataAccessParameterBuilder;
import oracle.javatools.db.ora.bigdata.BigDataAccessParameterMetadata;
import oracle.javatools.db.ora.bigdata.BigDataJsonArray;
import oracle.javatools.db.ora.bigdata.BigDataJsonEntry;
import oracle.javatools.db.ora.bigdata.BigDataJsonObject;
import oracle.javatools.db.sql.ColumnUsage;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.db.sql.SimpleSQLFragment;

public class BigDataJsonValueBuilder
extends BigDataAccessParameterBuilder.ValueBuilder {
    @Override
    public void buildFragment(BigDataAccessParameter bigDataAccessParameter) throws DBException {
        SQLFragment sQLFragment;
        String string = BigDataAccessParameterMetadata.stripLineEscapes((String)bigDataAccessParameter.getParameterValue());
        JSONStreams jSONStreams = null;
        ServiceLoader<JSONStreams> serviceLoader = ServiceLoader.load(JSONStreams.class, this.getClass().getClassLoader());
        if (serviceLoader != null && (sQLFragment = serviceLoader.iterator()) != null && sQLFragment.hasNext()) {
            jSONStreams = sQLFragment.next();
        }
        if (jSONStreams == null) {
            throw new DBException((DBObject)bigDataAccessParameter, (Throwable)new IllegalStateException("No JSON reader available"));
        }
        sQLFragment = null;
        SQLFragment sQLFragment2 = null;
        try (JSONReader jSONReader = jSONStreams.jsonReader((CharSequence)string);){
            while (jSONReader.hasNext()) {
                JSONToken jSONToken = jSONReader.next();
                JSONToken.Type type = jSONToken.type();
                int n = 0;
                switch (type) {
                    case START_OBJECT: {
                        sQLFragment2 = this.addToStack(sQLFragment2, (SQLFragment)new BigDataJsonObject());
                        break;
                    }
                    case START_ARRAY: {
                        sQLFragment2 = this.addToStack(sQLFragment2, (SQLFragment)new BigDataJsonArray());
                        break;
                    }
                    case END_OBJECT: {
                        if (sQLFragment2 instanceof BigDataJsonEntry) {
                            ++n;
                        }
                    }
                    case END_ARRAY: {
                        ++n;
                        break;
                    }
                    case PROPERTY_NAME: {
                        sQLFragment2 = this.addToStack(sQLFragment2, (SQLFragment)new BigDataJsonEntry());
                        sQLFragment2.setName(jSONToken.propertyName());
                        break;
                    }
                    default: {
                        this.addToStack(sQLFragment2, this.buildValue(jSONToken, sQLFragment2));
                        if (!(sQLFragment2 instanceof BigDataJsonEntry)) break;
                        ++n;
                    }
                }
                for (int i = 0; i < n; ++i) {
                    sQLFragment2 = (SQLFragment)sQLFragment2.getParent();
                }
                if (sQLFragment != null) continue;
                sQLFragment = sQLFragment2;
                bigDataAccessParameter.setParameterValueFragment(sQLFragment);
            }
        }
        catch (Exception exception) {
            throw new DBException((DBObject)bigDataAccessParameter, exception.getMessage(), (Throwable)exception);
        }
    }

    private SQLFragment addToStack(SQLFragment sQLFragment, SQLFragment sQLFragment2) {
        if (sQLFragment instanceof BigDataJsonEntry) {
            ((BigDataJsonEntry)sQLFragment).setValueFragment(sQLFragment2);
        } else if (sQLFragment instanceof BigDataJsonArray) {
            ((BigDataJsonArray)sQLFragment).addArgument(sQLFragment2);
        } else if (sQLFragment instanceof BigDataJsonObject && sQLFragment2 instanceof BigDataJsonEntry) {
            ((BigDataJsonObject)sQLFragment).addBigDataEntry((BigDataJsonEntry)sQLFragment2);
        } else if (sQLFragment != null) {
            throw new IllegalStateException("Cannot add " + sQLFragment2.getClass().getSimpleName() + " to " + sQLFragment.getClass().getSimpleName());
        }
        return sQLFragment2;
    }

    protected SQLFragment buildValue(JSONToken jSONToken, SQLFragment sQLFragment) {
        DBObjectID dBObjectID;
        Column column;
        Relation relation;
        JSONToken.Type type = jSONToken.type();
        Object object = switch (type) {
            case JSONToken.Type.BOOLEAN_VALUE -> jSONToken.booleanValue();
            case JSONToken.Type.NUMERIC_VALUE -> jSONToken.numberValue();
            case JSONToken.Type.NULL_VALUE -> "";
            case JSONToken.Type.STRING_VALUE -> jSONToken.stringValue();
            default -> throw new IllegalStateException("unknown value type " + type);
        };
        String string = null;
        BigDataJsonEntry bigDataJsonEntry = (BigDataJsonEntry)DBUtil.findParentOfType((DBObject)sQLFragment, BigDataJsonEntry.class);
        if (bigDataJsonEntry != null) {
            string = bigDataJsonEntry.getName();
        }
        if ("col".equals(string) && (relation = (Relation)DBUtil.findParentOfType((DBObject)bigDataJsonEntry, Relation.class)) != null && (column = relation.getColumn(object.toString())) != null && (dBObjectID = column.getID()) != null) {
            return new ColumnUsage(dBObjectID);
        }
        return new SimpleSQLFragment(object.toString());
    }
}

