/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora;

import java.sql.ResultSet;
import java.sql.SQLException;
import oracle.javatools.db.AbstractDBObjectProvider;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.IdentifierBasedID;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.execute.QueryWrapper;
import oracle.javatools.db.ora.BaseOracleDatabase;
import oracle.javatools.db.ora.OracleDBObjectBuilder;
import oracle.javatools.db.ora.RecycledObject;

class RecycledObjectBuilder
extends OracleDBObjectBuilder<RecycledObject> {
    public static final String YES = "YES";
    private Boolean m_sysDBA;

    public RecycledObjectBuilder(BaseOracleDatabase baseOracleDatabase) {
        super(baseOracleDatabase, "RECYCLEBIN");
    }

    protected void fillInObject(final RecycledObject recycledObject) throws DBException {
        final QueryWrapper queryWrapper = this.getQueryWrapper(recycledObject);
        QueryWrapper.QueryRunnable queryRunnable = new QueryWrapper.QueryRunnable(){

            public void processResultSet(ResultSet resultSet) throws DBException {
                try {
                    if (resultSet.next()) {
                        String string = resultSet.getString(1);
                        recycledObject.setOriginalName(string);
                        String string2 = resultSet.getString(2);
                        recycledObject.setOperation(RecycledObject.Operation.valueOf((String)string2));
                        String string3 = resultSet.getString(3);
                        recycledObject.setOriginalType(string3);
                        String string4 = resultSet.getString(4);
                        recycledObject.setTablespaceName(string4);
                        String string5 = resultSet.getString(5);
                        recycledObject.setCreateTime(string5);
                        String string6 = resultSet.getString(6);
                        recycledObject.setDropTime(string6);
                        Long l = resultSet.getLong(7);
                        recycledObject.setDropSCN(l);
                        String string7 = resultSet.getString(8);
                        recycledObject.setPartitionName(string7);
                        String string8 = resultSet.getString(9);
                        recycledObject.setCanUndrop(RecycledObjectBuilder.YES.equals(string8));
                        String string9 = resultSet.getString(10);
                        recycledObject.setCanPurge(RecycledObjectBuilder.YES.equals(string9));
                        int n = resultSet.getInt(11);
                        recycledObject.setSpace(n);
                        int n2 = resultSet.getInt(12);
                        recycledObject.setRelatedObjectID((DBObjectID)new IdentifierBasedID(string3, (Object)n2, (AbstractDBObjectProvider)RecycledObjectBuilder.this.getDatabase()));
                        int n3 = resultSet.getInt(13);
                        recycledObject.setBaseObjectID((DBObjectID)new IdentifierBasedID(string3, (Object)n3, (AbstractDBObjectProvider)RecycledObjectBuilder.this.getDatabase()));
                        int n4 = resultSet.getInt(14);
                        recycledObject.setPurgeObjectID((DBObjectID)new IdentifierBasedID(string3, (Object)n4, (AbstractDBObjectProvider)RecycledObjectBuilder.this.getDatabase()));
                    }
                }
                catch (SQLException sQLException) {
                    queryWrapper.throwDBException((DBObject)recycledObject, sQLException);
                }
            }
        };
        queryWrapper.executeQuery(queryRunnable);
    }

    private QueryWrapper getQueryWrapper(RecycledObject recycledObject) {
        BaseOracleDatabase baseOracleDatabase = this.getDatabase();
        if (baseOracleDatabase.getDictionaryQueries().useDBAViews()) {
            return baseOracleDatabase.newQueryWrapper((SystemObject)recycledObject, "SELECT /*OracleDictionaryQueries.DBA_RECYCLED_OBJECT_QUERY*/\n       ORIGINAL_NAME, OPERATION, TYPE, TS_NAME, CREATETIME, DROPTIME,  DROPSCN, PARTITION_NAME, CAN_UNDROP, CAN_PURGE, SPACE, RELATED, BASE_OBJECT, PURGE_OBJECT FROM SYS.DBA_RECYCLEBIN WHERE OBJECT_NAME = ? AND OWNER = ? AND NOT(CAN_PURGE = 'NO' AND CAN_UNDROP = 'NO')", recycledObject, recycledObject.getSchema());
        }
        return baseOracleDatabase.newQueryWrapper((SystemObject)recycledObject, "SELECT /*OracleDictionaryQueries.RECYCLED_OBJECT_QUERY*/\n       ORIGINAL_NAME, OPERATION, TYPE, TS_NAME, CREATETIME, DROPTIME,  DROPSCN, PARTITION_NAME, CAN_UNDROP, CAN_PURGE, SPACE, RELATED, BASE_OBJECT, PURGE_OBJECT FROM RECYCLEBIN WHERE OBJECT_NAME = ? AND NOT(CAN_PURGE = 'NO' AND CAN_UNDROP = 'NO')", recycledObject);
    }
}

