/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora;

import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import oracle.javatools.db.AbstractDBObjectBuilder;
import oracle.javatools.db.CheckConstraint;
import oracle.javatools.db.Column;
import oracle.javatools.db.ColumnConstraint;
import oracle.javatools.db.Constraint;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.FKConstraint;
import oracle.javatools.db.IdentityColumnProperties;
import oracle.javatools.db.NameBasedID;
import oracle.javatools.db.PKConstraint;
import oracle.javatools.db.Relation;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.UniqueConstraint;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeHelper;
import oracle.javatools.db.datatypes.DataTypeUsage;
import oracle.javatools.db.execute.QueryWrapper;
import oracle.javatools.db.ora.BaseOracleDatabase;
import oracle.javatools.db.ora.MaterializedView;
import oracle.javatools.db.ora.Oracle10g;
import oracle.javatools.db.ora.OracleDBObjectBuilder;
import oracle.javatools.db.ora.OracleIncrementerBuilder;
import oracle.javatools.util.ModelUtil;

public abstract class OracleRelationBuilder<T extends Relation>
extends OracleDBObjectBuilder<T> {
    private static final String ORACLE8i_NOT_NULL_COND = "\"{0}\" IS NOT NULL";
    private static final String ORACLE7_NOT_NULL_COND = "{0} IS NOT NULL";
    private static final char PK_TYPE = 'P';
    private static final char FK_TYPE = 'R';
    private static final char UNIQUE_TYPE = 'U';
    private static final char CHECK_TYPE = 'C';

    protected OracleRelationBuilder(BaseOracleDatabase baseOracleDatabase, String string) {
        super(baseOracleDatabase, string);
    }

    @AbstractDBObjectBuilder.PropertyBuilder(value={"Comment"})
    public void fillInComment(T t) throws DBException {
        QueryWrapper queryWrapper = t instanceof MaterializedView && this.getProvider() instanceof Oracle10g ? this.getDatabase().newQueryWrapper((SystemObject)t, "SELECT /*OracleDictionaryQueries.ALL_MVIEW_COMMENT_QUERY*/\n       COMMENTS FROM SYS.ALL_MVIEW_COMMENTS WHERE OWNER = ? AND MVIEW_NAME = ?", t.getSchema(), t) : (t instanceof MaterializedView ? this.getDatabase().newQueryWrapper((SystemObject)t, "SELECT /*OracleDictionaryQueries.ALL_TABLE_COMMENT_QUERY*/\n       COMMENTS FROM SYS.ALL_TAB_COMMENTS WHERE OWNER = ? AND TABLE_NAME = ? AND TABLE_TYPE = ?", t.getSchema(), t, "TABLE") : this.getDatabase().newQueryWrapper((SystemObject)t, "SELECT /*OracleDictionaryQueries.ALL_TABLE_COMMENT_QUERY*/\n       COMMENTS FROM SYS.ALL_TAB_COMMENTS WHERE OWNER = ? AND TABLE_NAME = ? AND TABLE_TYPE = ?", t.getSchema(), t, this.getObjectType()));
        QueryWrapper.QueryRunnable queryRunnable = new QueryWrapper.QueryRunnable(){
            final /* synthetic */ Relation val$rel;
            final /* synthetic */ QueryWrapper val$wrap;
            {
                this.val$rel = relation;
                this.val$wrap = queryWrapper;
            }

            public void processResultSet(ResultSet resultSet) throws DBException {
                try {
                    if (resultSet.next()) {
                        String string = resultSet.getString(1);
                        string = ModelUtil.hasLength((String)string) ? string : null;
                        this.val$rel.setProperty("Comment", (Object)string);
                    }
                }
                catch (SQLException sQLException) {
                    this.val$wrap.throwDBException((DBObject)this.val$rel, sQLException);
                }
            }
        };
        queryWrapper.executeQuery(queryRunnable);
    }

    @AbstractDBObjectBuilder.PropertyBuilder(value={"columns"})
    public void fillInColumns(T t) throws DBException {
        final BaseOracleDatabase baseOracleDatabase = this.getDatabase();
        String string = OracleRelationBuilder.getColumnQuery(baseOracleDatabase);
        final ArrayList arrayList = new ArrayList();
        HashMap<Column, String> hashMap = new HashMap<Column, String>();
        QueryWrapper queryWrapper = baseOracleDatabase.newQueryWrapper((SystemObject)t, string, t.getSchema(), t);
        QueryWrapper.QueryRunnable queryRunnable = new QueryWrapper.QueryRunnable(){
            final /* synthetic */ Relation val$relation;
            final /* synthetic */ Map val$complexCols;
            final /* synthetic */ QueryWrapper val$wrap;
            {
                this.val$relation = relation;
                this.val$complexCols = map;
                this.val$wrap = queryWrapper;
            }

            public void processResultSet(ResultSet resultSet) throws DBException {
                try {
                    while (resultSet.next()) {
                        Object object;
                        String string;
                        String string2;
                        String string3;
                        String string4 = resultSet.getString(1);
                        Column column = (Column)OracleRelationBuilder.this.newObject(Column.class, string4);
                        arrayList.add(column);
                        Object object2 = resultSet.getString(2);
                        String string5 = resultSet.getString(3);
                        if (!resultSet.wasNull()) {
                            object2 = string5 + "." + (String)object2;
                        }
                        column.setNotNull(resultSet.getString(7).equals("N"));
                        String string6 = resultSet.getString(10);
                        if (null != string6) {
                            string6 = string6.trim();
                            string3 = resultSet.getString(14);
                            string2 = resultSet.getString(15);
                            string = resultSet.getString(16);
                            if ("YES".equals(string2)) {
                                String[] stringArray = string6.split("\\.");
                                if (stringArray.length == 3) {
                                    String string7 = baseOracleDatabase.getInternalName(stringArray[1]);
                                    object = new IdentityColumnProperties();
                                    object.setName(string7);
                                    baseOracleDatabase.setOracleBuilder(object, new IdentityColumnPropertiesBuilder(baseOracleDatabase));
                                    if ("YES".equals(string)) {
                                        object.setGenerated(IdentityColumnProperties.GeneratedType.BY_DEFAULT_ON_NULL);
                                    }
                                    column.setIdentityProperties(object);
                                }
                            } else if ("YES".equals(string3)) {
                                column.setVirtualExpressionSource(string6);
                            } else {
                                column.setDefault((Object)string6);
                            }
                        }
                        string3 = resultSet.getString(11);
                        column.setProperty("Comment", (Object)string3);
                        column.setID((DBObjectID)new NameBasedID((DBObject)column, this.val$relation.getID()));
                        string2 = resultSet.getString(13);
                        if (!resultSet.wasNull()) {
                            object2 = string2 + " " + (String)object2;
                        }
                        if (object2 != null && ((String)object2).indexOf(46) >= 0) {
                            this.val$complexCols.put(column, object2);
                            continue;
                        }
                        string = baseOracleDatabase.getDataType((String)object2);
                        if (string == null) {
                            column.setDataTypeUsage(DataTypeHelper.getDataTypeUsageForString((DBObjectProvider)baseOracleDatabase, (Schema)this.val$relation.getSchema(), (String)object2));
                            continue;
                        }
                        long l = resultSet.getLong(5);
                        object = resultSet.wasNull() ? null : new Long(l);
                        l = OracleRelationBuilder.this.isCharType((String)object2) ? resultSet.getLong(9) : resultSet.getLong(4);
                        Long l2 = resultSet.wasNull() ? null : new Long(l);
                        Long l3 = new Long(resultSet.getLong(6));
                        l3 = resultSet.wasNull() ? null : l3;
                        HashMap<String, Object> hashMap = new HashMap<String, Object>();
                        hashMap.put("name", object2);
                        hashMap.put("size", DataTypeHelper.getAttributeValue((Object)l2, (DataType)string, (String)"size"));
                        hashMap.put("precision", DataTypeHelper.getAttributeValue((Object)object, (DataType)string, (String)"precision"));
                        hashMap.put("scale", DataTypeHelper.getAttributeValue((Object)l3, (DataType)string, (String)"scale"));
                        hashMap.put("unit", resultSet.getString(12));
                        column.setDataTypeUsage(string.createUsage(hashMap));
                        OracleRelationBuilder.this.setupOracleColumnProperties(this.val$relation, column, (DataType)string);
                    }
                }
                catch (SQLException sQLException) {
                    this.val$wrap.throwDBException((DBObject)this.val$relation, sQLException);
                }
            }
        };
        queryWrapper.executeQuery(100, queryRunnable);
        t.setColumns(arrayList.toArray(new Column[arrayList.size()]));
        if (hashMap.size() > 0) {
            this.populateComplexColumnTypes(t, hashMap);
        }
    }

    private void populateComplexColumnTypes(T t, Map<Column, String> map) throws DBException {
        BaseOracleDatabase baseOracleDatabase = this.getDatabase();
        for (Map.Entry<Column, String> entry : map.entrySet()) {
            Column column = entry.getKey();
            String string = entry.getValue();
            boolean bl = false;
            if (string.startsWith("REF ")) {
                bl = true;
                string = string.substring("REF ".length());
            }
            StringBuilder stringBuilder = new StringBuilder();
            for (String string2 : string.split("\\.")) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(".");
                }
                stringBuilder.append(baseOracleDatabase.getExternalName(string2));
            }
            DBObjectID dBObjectID = DataTypeHelper.createReferenceIDForTypeString((DBObjectProvider)baseOracleDatabase, (Schema)t.getSchema(), (String)stringBuilder.toString());
            DataTypeUsage dataTypeUsage = new DataTypeUsage();
            dataTypeUsage.setDataTypeID(dBObjectID);
            if (bl) {
                String string2;
                final HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
                hashMap.put("ref", Boolean.TRUE);
                string2 = this.getDatabase().newQueryWrapper((SystemObject)t, "SELECT /*OracleDictionaryQueries.ALL_REF_COLUMN_SCOPE*/\n       SCOPE_TABLE_OWNER\n,      SCOPE_TABLE_NAME\nFROM   SYS.ALL_REFS\nWHERE  OWNER = ?\nAND    TABLE_NAME = ?\nAND    COLUMN_NAME = ?\nAND    SCOPE_TABLE_NAME IS NOT NULL\n", t.getSchema(), t, column);
                QueryWrapper.QueryRunnable queryRunnable = new QueryWrapper.QueryRunnable(){
                    final /* synthetic */ QueryWrapper val$scopeWrap;
                    {
                        this.val$scopeWrap = queryWrapper;
                    }

                    public void processResultSet(ResultSet resultSet) throws DBException {
                        try {
                            if (resultSet.next()) {
                                NameBasedID nameBasedID = new NameBasedID("TABLE", resultSet.getString(1), resultSet.getString(2));
                                hashMap.put("ref_scope", nameBasedID);
                            }
                        }
                        catch (SQLException sQLException) {
                            this.val$scopeWrap.throwDBException(sQLException);
                        }
                    }
                };
                string2.executeQuery(queryRunnable);
                dataTypeUsage.setAttributeValues(hashMap);
            }
            column.setDataTypeUsage(dataTypeUsage);
            this.setupOracleColumnProperties(t, column, null);
        }
    }

    protected void setupOracleColumnProperties(T t, Column column, DataType dataType) {
    }

    private boolean isCharType(String string) {
        return string.equals("CHAR") || string.equals("NCHAR") || string.equals("VARCHAR2") || string.equals("NVARCHAR2");
    }

    @AbstractDBObjectBuilder.PropertyBuilder(value={"constraints"}, depends={"columns"})
    public void fillInConstraints(T t) throws DBException {
        Serializable serializable;
        Object object;
        Pattern pattern;
        Object object2;
        boolean bl;
        Object object3;
        BaseOracleDatabase baseOracleDatabase = this.getDatabase();
        Schema schema = t.getSchema();
        if ("Oracle Lite".equals(baseOracleDatabase.getDatabaseType())) {
            object3 = "SELECT /*OracleDictionaryQueries.ALL_CONSTRAINT_OLITE_QUERY*/\n        A.CONSTRAINT_NAME, A.CONSTRAINT_TYPE, A.SEARCH_CONDITION, A.R_OWNER, \n        A.R_CONSTRAINT_NAME, A.DELETE_RULE, A.STATUS, 'GENERATED NAME' GENERATED, \n        NULL INDEX_OWNER, NULL INDEX_NAME, NULL INDEX_OBJECT_ID, \n        ( SELECT 'TABLE#' || AA.TABLE_NAME \n          FROM SYS.ALL_CONSTRAINTS AA \n             , SYS.ALL_TABLES      BB \n          WHERE AA.OWNER = A.R_OWNER  \n          AND   AA.CONSTRAINT_NAME = A.R_CONSTRAINT_NAME \n          AND   AA.OWNER = BB.OWNER  \n          AND   AA.TABLE_NAME = BB.TABLE_NAME \n         UNION\n          SELECT 'VIEW#' || AA.TABLE_NAME \n          FROM SYS.ALL_CONSTRAINTS AA \n             , SYS.ALL_VIEWS       BB \n          WHERE AA.OWNER = A.R_OWNER  \n          AND   AA.CONSTRAINT_NAME = A.R_CONSTRAINT_NAME \n          AND   AA.OWNER = BB.OWNER  \n          AND   AA.TABLE_NAME = BB.VIEW_NAME           ) ref_relation_info,\n        B.COLUMN_NAME, null DEFERRABLE, null DEFERRED \nFROM SYS.ALL_CONSTRAINTS  A,  \n     SYS.ALL_CONS_COLUMNS B  \nWHERE A.OWNER           = ?  \nAND   A.TABLE_NAME      = ?  \nAND   A.OWNER           = B.OWNER  \nAND   A.CONSTRAINT_NAME = B.CONSTRAINT_NAME  \nORDER BY B.POSITION \n";
            bl = false;
        } else {
            if (112 > baseOracleDatabase.getDatabaseVersion()) {
                object2 = "SELECT /*OracleDictionaryQueries.ALL_CONSTRAINT_ENTERPRISE_QUERY*/\n  A.CONSTRAINT_NAME, A.CONSTRAINT_TYPE, A.SEARCH_CONDITION, A.R_OWNER,  \n  A.R_CONSTRAINT_NAME, A.DELETE_RULE, A.STATUS, A.GENERATED, \n  NVL( A.INDEX_OWNER, A.OWNER ) INDEX_OWNER, A.INDEX_NAME, \n  DECODE( A.INDEX_NAME, NULL, NULL, \n    ( SELECT OBJECT_ID FROM SYS.ALL_OBJECTS AO \n      WHERE AO.OBJECT_TYPE = 'INDEX' \n        AND AO.OBJECT_NAME = A.INDEX_NAME \n        AND AO.OWNER = NVL( A.INDEX_OWNER, A.OWNER ) ) ) INDEX_OBJECT_ID, \n  DECODE( A.R_CONSTRAINT_NAME, NULL, NULL, \n    ( SELECT ( SELECT BB.OBJECT_TYPE || BB.OBJECT_ID \n               FROM SYS.ALL_OBJECTS BB \n               WHERE AA.OWNER = BB.OWNER \n               AND   AA.TABLE_NAME = BB.OBJECT_NAME \n               AND   BB.OBJECT_TYPE IN ('TABLE', 'VIEW') ) \n        || '#' || AA.TABLE_NAME \n      FROM SYS.ALL_CONSTRAINTS AA \n      WHERE AA.OWNER = A.R_OWNER \n        AND AA.CONSTRAINT_TYPE IN ( 'P', 'U' ) \n        AND AA.CONSTRAINT_NAME = A.R_CONSTRAINT_NAME ) ) ref_relation_info, \n  B.COLUMN_NAME, A.DEFERRABLE, A.DEFERRED \nFROM SYS.USER_CONSTRAINTS A, SYS.USER_CONS_COLUMNS B \nWHERE A.OWNER = ? \nAND A.TABLE_NAME = ? \nAND A.CONSTRAINT_TYPE IN ( 'P', 'U', 'R', 'C' ) \nAND A.CONSTRAINT_NAME = B.CONSTRAINT_NAME(+) \nAND A.OWNER = B.OWNER(+) \nORDER BY B.POSITION";
                bl = false;
            } else if (1220 > baseOracleDatabase.getDatabaseVersion()) {
                object2 = "SELECT /*OracleDictionaryQueries.ALL_CONSTRAINT_ENTERPRISE_QUERY*/\n  A.CONSTRAINT_NAME, A.CONSTRAINT_TYPE, A.SEARCH_CONDITION, A.R_OWNER,  \n  A.R_CONSTRAINT_NAME, A.DELETE_RULE, A.STATUS, A.GENERATED, \n  NVL( A.INDEX_OWNER, A.OWNER ) INDEX_OWNER, A.INDEX_NAME, \n  DECODE( A.INDEX_NAME, NULL, NULL, \n    ( SELECT OBJECT_ID FROM SYS.ALL_OBJECTS AO \n      WHERE AO.OBJECT_TYPE = 'INDEX' \n        AND AO.OBJECT_NAME = A.INDEX_NAME \n        AND AO.OWNER = NVL( A.INDEX_OWNER, A.OWNER ) ) ) INDEX_OBJECT_ID, \n  DECODE( A.R_CONSTRAINT_NAME, NULL, NULL, \n    ( SELECT ( SELECT BB.OBJECT_TYPE || BB.OBJECT_ID \n               FROM SYS.ALL_OBJECTS BB \n               WHERE AA.OWNER = BB.OWNER \n               AND   AA.TABLE_NAME = BB.OBJECT_NAME \n               AND   BB.OBJECT_TYPE IN ('TABLE', 'VIEW') ) \n        || '#' || AA.TABLE_NAME \n      FROM SYS.ALL_CONSTRAINTS AA \n      WHERE AA.OWNER = A.R_OWNER \n        AND AA.CONSTRAINT_TYPE IN ( 'P', 'U' ) \n        AND AA.CONSTRAINT_NAME = A.R_CONSTRAINT_NAME ) ) ref_relation_info, \n  ( SELECT LISTAGG( REPLACE( B.COLUMN_NAME, ';', ';;' ), ';' ) \n               WITHIN GROUP (ORDER BY B.POSITION) \n      FROM SYS.USER_CONS_COLUMNS B \n      WHERE A.CONSTRAINT_NAME = B.CONSTRAINT_NAME \n        AND A.OWNER = B.OWNER ) concatcols, \n  A.DEFERRABLE, A.DEFERRED \nFROM SYS.USER_CONSTRAINTS A \nWHERE A.OWNER = ? \nAND A.TABLE_NAME = ? \nAND A.CONSTRAINT_TYPE IN ( 'P', 'U', 'R', 'C' ) \n";
                bl = true;
            } else {
                object2 = "SELECT /*OracleDictionaryQueries.ALL_CONSTRAINT_ENTERPRISE_QUERY*/ \n  A.CONSTRAINT_NAME, A.CONSTRAINT_TYPE, A.SEARCH_CONDITION, A.R_OWNER,  \n  A.R_CONSTRAINT_NAME, A.DELETE_RULE, A.STATUS, A.GENERATED, \n  NVL( A.INDEX_OWNER, A.OWNER ) INDEX_OWNER, A.INDEX_NAME, \n  DECODE( A.INDEX_NAME, NULL, NULL, \n    ( SELECT OBJECT_ID FROM SYS.ALL_OBJECTS AO \n      WHERE AO.OBJECT_TYPE = 'INDEX' \n        AND AO.OBJECT_NAME = A.INDEX_NAME \n        AND AO.OWNER = NVL( A.INDEX_OWNER, A.OWNER ) ) ) INDEX_OBJECT_ID, \n  DECODE( A.R_CONSTRAINT_NAME, NULL, NULL, \n    ( SELECT ( SELECT BB.OBJECT_TYPE || BB.OBJECT_ID \n               FROM SYS.ALL_OBJECTS BB \n               WHERE AA.OWNER = BB.OWNER \n               AND   AA.TABLE_NAME = BB.OBJECT_NAME \n               AND   BB.OBJECT_TYPE IN ('TABLE', 'VIEW') ) \n        || '#' || AA.TABLE_NAME \n      FROM SYS.ALL_CONSTRAINTS AA \n      WHERE AA.OWNER = A.R_OWNER \n        AND AA.CONSTRAINT_TYPE IN ( 'P', 'U' ) \n        AND AA.CONSTRAINT_NAME = A.R_CONSTRAINT_NAME ) ) ref_relation_info, \n  ( SELECT LISTAGG( REPLACE( B.COLUMN_NAME, ';', ';;' ), ';' ) \n               WITHIN GROUP (ORDER BY B.POSITION) \n      FROM SYS.USER_CONS_COLUMNS B \n      WHERE A.CONSTRAINT_NAME = B.CONSTRAINT_NAME \n        AND A.OWNER = B.OWNER and B.COLUMN_NAME != 'SYS_HASHVAL' ) concatcols, \n  A.DEFERRABLE, A.DEFERRED \nFROM SYS.USER_CONSTRAINTS A \nWHERE A.OWNER = ? \nAND A.TABLE_NAME = ? \nAND A.CONSTRAINT_TYPE IN ( 'P', 'U', 'R', 'C' ) \n";
                bl = true;
            }
            if (!DBUtil.areNamesAndTypesEqual((DBObject)baseOracleDatabase.getDefaultSchema(), (DBObject)schema)) {
                pattern = Pattern.compile("USER_CONSTRAINTS", 2);
                object = pattern.matcher((CharSequence)object2).replaceAll("ALL_CONSTRAINTS");
                serializable = Pattern.compile("USER_CONS_COLUMNS", 2);
                object3 = ((Pattern)serializable).matcher((CharSequence)object).replaceAll("ALL_CONS_COLUMNS");
            } else {
                object3 = object2;
            }
        }
        object2 = new HashMap();
        pattern = this.getDatabase().newQueryWrapper((SystemObject)t, (String)object3, schema, t);
        object = new QueryWrapper.QueryRunnable(){
            final /* synthetic */ Map val$data;
            final /* synthetic */ boolean val$listagg;
            final /* synthetic */ QueryWrapper val$wrap;
            final /* synthetic */ Relation val$relation;
            {
                this.val$data = map;
                this.val$listagg = bl;
                this.val$wrap = queryWrapper;
                this.val$relation = relation;
            }

            public void processResultSet(ResultSet resultSet) throws DBException {
                try {
                    while (resultSet.next()) {
                        String string;
                        String string2 = resultSet.getString("CONSTRAINT_NAME");
                        ConstraintData constraintData = (ConstraintData)this.val$data.get(string2);
                        if (constraintData == null) {
                            constraintData = new ConstraintData(string2, resultSet);
                            this.val$data.put(string2, constraintData);
                        }
                        if (constraintData.isInvisibleFK()) {
                            constraintData.m_ignore = true;
                        }
                        if (this.val$listagg) {
                            string = resultSet.getString("concatcols");
                            if (resultSet.wasNull() || !ModelUtil.hasLength((String)string)) continue;
                            boolean bl = false;
                            StringBuilder stringBuilder = new StringBuilder();
                            for (int i = 0; i < string.length(); ++i) {
                                boolean bl2;
                                boolean bl3;
                                char c = string.charAt(i);
                                if (c == ';') {
                                    if (bl) {
                                        bl3 = true;
                                        bl2 = false;
                                    } else {
                                        bl3 = false;
                                        bl2 = true;
                                    }
                                } else if (bl) {
                                    bl3 = true;
                                    bl2 = false;
                                    constraintData.addColumn(stringBuilder.toString());
                                    stringBuilder = new StringBuilder();
                                } else {
                                    bl3 = true;
                                    bl2 = false;
                                }
                                if (bl3) {
                                    stringBuilder.append(c);
                                }
                                bl = bl2;
                            }
                            constraintData.addColumn(stringBuilder.toString());
                            continue;
                        }
                        string = resultSet.getString("COLUMN_NAME");
                        if (resultSet.wasNull()) continue;
                        constraintData.addColumn(string);
                    }
                }
                catch (SQLException sQLException) {
                    this.val$wrap.throwDBException((DBObject)this.val$relation, sQLException);
                }
            }
        };
        pattern.executeQuery((QueryWrapper.QueryRunnable)object);
        serializable = new ArrayList(object2.size());
        for (ConstraintData constraintData : object2.values()) {
            Constraint constraint;
            if (constraintData.m_ignore || (constraint = constraintData.createConstraint(t)) == null) continue;
            serializable.add(constraint);
        }
        t.setConstraints(serializable.toArray(new Constraint[serializable.size()]));
    }

    private static FKConstraint.ReferentialAction translateDeleteAction(String string) {
        FKConstraint.ReferentialAction referentialAction = FKConstraint.ReferentialAction.NO_ACTION;
        if ("CASCADE".equals(string)) {
            referentialAction = FKConstraint.ReferentialAction.CASCADE;
        } else if ("SET NULL".equals(string)) {
            referentialAction = FKConstraint.ReferentialAction.SET_NULL;
        }
        return referentialAction;
    }

    private static String getColumnQuery(BaseOracleDatabase baseOracleDatabase) {
        String string = null;
        String string2 = baseOracleDatabase.getDatabaseType();
        if ("Oracle Lite".equals(string2)) {
            string = "SELECT /*OracleDictionaryQueries.ALL_COLUMN_OLITE_QUERY*/\n       C.COLUMN_NAME, DATA_TYPE, null, \n       DATA_LENGTH, DATA_PRECISION, DATA_SCALE, NULLABLE, \n       DEFAULT_LENGTH, DATA_LENGTH, DATA_DEFAULT, COMMENTS, null \n       , null, null, null, null \nFROM SYS.ALL_TAB_COLUMNS C, SYS.ALL_COL_COMMENTS CMT \nWHERE C.OWNER = ? \nAND   C.TABLE_NAME = ? \nAND   C.OWNER = CMT.OWNER(+) \nAND   C.TABLE_NAME = CMT.TABLE_NAME(+) \nAND   C.COLUMN_NAME = CMT.COLUMN_NAME(+) \nORDER BY COLUMN_ID \n";
        } else {
            int n = baseOracleDatabase.getDatabaseVersion();
            if (n == 0) {
                string = "SELECT /*OracleDictionaryQueries.ALL_COLUMN_ORACLE7_QUERY*/\n       C.COLUMN_NAME, DATA_TYPE, null,        DATA_LENGTH, DATA_PRECISION, DATA_SCALE, NULLABLE,        DEFAULT_LENGTH, DATA_LENGTH, DATA_DEFAULT, COMMENTS, null        , null, null, null, null \nFROM SYS.ALL_TAB_COLUMNS C, SYS.ALL_COL_COMMENTS CMT \nWHERE C.OWNER = ? \nAND   C.TABLE_NAME = ? \nAND   C.OWNER = CMT.OWNER \nAND   C.TABLE_NAME = CMT.TABLE_NAME \nAND   C.COLUMN_NAME = CMT.COLUMN_NAME \nORDER BY COLUMN_ID \n";
            } else if (n == 81) {
                string = "SELECT /*OracleDictionaryQueries.ALL_COLUMN_ORACLE8_QUERY*/\n       C.COLUMN_NAME, DATA_TYPE, DATA_TYPE_OWNER, \n       DATA_LENGTH, DATA_PRECISION, DATA_SCALE, NULLABLE, \n       DEFAULT_LENGTH, DATA_LENGTH, DATA_DEFAULT, COMMENTS, null \n       , null, null, null, null \nFROM SYS.ALL_TAB_COLUMNS C, SYS.ALL_COL_COMMENTS CMT \nWHERE C.OWNER = ? \nAND   C.TABLE_NAME = ? \nAND   C.OWNER = CMT.OWNER \nAND   C.TABLE_NAME = CMT.TABLE_NAME \nAND   C.COLUMN_NAME = CMT.COLUMN_NAME \nORDER BY COLUMN_ID \n";
            } else if (n == 82) {
                string = "SELECT /*OracleDictionaryQueries.ALL_COLUMN_ORACLE8i_QUERY*/\n       C.COLUMN_NAME, DATA_TYPE, DATA_TYPE_OWNER, \n       DATA_LENGTH, DATA_PRECISION, DATA_SCALE, NULLABLE, \n       DEFAULT_LENGTH, CHAR_COL_DECL_LENGTH, DATA_DEFAULT, COMMENTS, null \n       , null, null, null, null \nFROM SYS.ALL_TAB_COLUMNS C, SYS.ALL_COL_COMMENTS CMT \nWHERE C.OWNER = ? AND C.TABLE_NAME = ? \nAND   C.OWNER = CMT.OWNER \nAND   C.TABLE_NAME = CMT.TABLE_NAME \nAND   C.COLUMN_NAME = CMT.COLUMN_NAME \nORDER BY COLUMN_ID \n";
            } else if (n > 82 && n < 110) {
                string = "SELECT /*OracleDictionaryQueries.ALL_COLUMN_ORACLE9i_QUERY*/\n       C.COLUMN_NAME, C.DATA_TYPE, C.DATA_TYPE_OWNER, \n       C.DATA_LENGTH, C.DATA_PRECISION, C.DATA_SCALE, C.NULLABLE, \n       C.DEFAULT_LENGTH, C.CHAR_LENGTH, C.DATA_DEFAULT, CMT.COMMENTS \n    , decode(C.CHAR_USED, 'B', 'BYTE', 'C', 'CHAR', null) \n    , C.DATA_TYPE_MOD, null, null, null \nFROM SYS.ALL_TAB_COLS C, SYS.ALL_COL_COMMENTS CMT \nWHERE C.OWNER = ? AND C.TABLE_NAME = ? \nAND   C.OWNER = CMT.OWNER \nAND   C.TABLE_NAME = CMT.TABLE_NAME \nAND   C.COLUMN_NAME = CMT.COLUMN_NAME \nAND   C.HIDDEN_COLUMN = 'NO' \nORDER BY C.COLUMN_ID\n";
            } else if (n >= 110 && n < 120) {
                string = "SELECT /*OracleDictionaryQueries.ALL_COLUMN_ORACLE11g_QUERY*/\n       C.COLUMN_NAME, C.DATA_TYPE, C.DATA_TYPE_OWNER, \n       C.DATA_LENGTH, C.DATA_PRECISION, C.DATA_SCALE, C.NULLABLE, \n       C.DEFAULT_LENGTH, C.CHAR_LENGTH, C.DATA_DEFAULT, \n    ( SELECT CMT.COMMENTS FROM SYS.ALL_COL_COMMENTS CMT \n      WHERE C.OWNER = CMT.OWNER \n        AND C.TABLE_NAME = CMT.TABLE_NAME \n        AND C.COLUMN_NAME = CMT.COLUMN_NAME) COMMENTS \n    , decode(C.CHAR_USED, 'B', 'BYTE', 'C', 'CHAR', null) \n    , C.DATA_TYPE_MOD, C.VIRTUAL_COLUMN, null, null \nFROM SYS.ALL_TAB_COLS C \nWHERE C.OWNER = ? AND C.TABLE_NAME = ? \nAND   C.HIDDEN_COLUMN = 'NO' \nORDER BY C.COLUMN_ID\n";
            } else if (n >= 120) {
                string = "SELECT /*OracleDictionaryQueries.ALL_COLUMN_ORACLE12c_QUERY*/\n       C.COLUMN_NAME, C.DATA_TYPE, C.DATA_TYPE_OWNER,\n       C.DATA_LENGTH, C.DATA_PRECISION, C.DATA_SCALE, C.NULLABLE,\n       C.DEFAULT_LENGTH, C.CHAR_LENGTH, C.DATA_DEFAULT,\n       CMT.COMMENTS\n    , decode(C.CHAR_USED, 'B', 'BYTE', 'C', 'CHAR', null)\n    , C.DATA_TYPE_MOD, C.VIRTUAL_COLUMN, C.IDENTITY_COLUMN, C.DEFAULT_ON_NULL\nFROM\n    sys.all_tab_cols c\n    LEFT JOIN SYS.ALL_COL_COMMENTS cmt ON c.owner = cmt.owner\n                                AND c.table_name = cmt.table_name\n                                    AND c.column_name = cmt.column_name\nWHERE C.OWNER = :1  \nAND C.TABLE_NAME = :2  \nAND C.HIDDEN_COLUMN = 'NO'\nORDER BY C.COLUMN_ID\n";
            }
        }
        return string;
    }

    private static String getNotNullText(BaseOracleDatabase baseOracleDatabase) {
        String string = null;
        String string2 = baseOracleDatabase.getDatabaseType();
        string = "Oracle Lite".equals(string2) || baseOracleDatabase.getDatabaseVersion() <= 81 ? ORACLE7_NOT_NULL_COND : ORACLE8i_NOT_NULL_COND;
        return string;
    }

    private class ConstraintData {
        private String m_cName;
        private char m_cType;
        private String m_cond;
        private String m_rSchemaName;
        private String m_rConstraintName;
        private String m_rRelationType;
        private String m_rRelationName;
        private Object m_rRelationObjectID;
        private FKConstraint.ReferentialAction m_dRule;
        private boolean m_status;
        private boolean m_generated;
        private Constraint.DeferrableState m_deferredState;
        private List<String> m_cols = new ArrayList<String>();
        private boolean m_ignore = false;
        private String m_indexOwner;
        private String m_indexName;
        private BigDecimal m_indexObjectID;

        ConstraintData(String string, ResultSet resultSet) throws SQLException {
            String string2;
            String string3;
            Object object;
            this.m_cName = string;
            String string4 = resultSet.getString("CONSTRAINT_TYPE");
            this.m_cType = ModelUtil.hasLength((String)string4) ? string4.charAt(0) : (char)'\u0000';
            switch (this.m_cType) {
                case 'C': {
                    this.m_cond = resultSet.getString("SEARCH_CONDITION");
                    break;
                }
                case 'P': 
                case 'U': {
                    this.m_indexOwner = resultSet.getString("INDEX_OWNER");
                    this.m_indexName = resultSet.getString("INDEX_NAME");
                    object = resultSet.getBigDecimal("INDEX_OBJECT_ID");
                    this.m_indexObjectID = resultSet.wasNull() ? null : object;
                    break;
                }
                case 'R': {
                    this.m_rSchemaName = resultSet.getString("R_OWNER");
                    this.m_rConstraintName = resultSet.getString("R_CONSTRAINT_NAME");
                    string3 = resultSet.getString("ref_relation_info");
                    if (string3 != null) {
                        if (string3.startsWith("TABLE")) {
                            this.m_rRelationType = "TABLE";
                            string2 = string3.substring(5);
                        } else if (string3.startsWith("VIEW")) {
                            this.m_rRelationType = "VIEW";
                            string2 = string3.substring(4);
                        } else {
                            string2 = "";
                        }
                        int n = string2.indexOf(35);
                        if (n < 0) {
                            OracleRelationBuilder.this.getLogger().severe("Invalid ref details: " + string3);
                        } else {
                            String string5 = string2.substring(0, n);
                            if (string5.length() > 0) {
                                try {
                                    this.m_rRelationObjectID = BigDecimal.valueOf(Long.parseLong(string5));
                                }
                                catch (NumberFormatException numberFormatException) {
                                    OracleRelationBuilder.this.getLogger().severe(numberFormatException.getMessage());
                                }
                            }
                            this.m_rRelationName = string2.substring(n + 1);
                        }
                    }
                    this.m_dRule = OracleRelationBuilder.translateDeleteAction(resultSet.getString("DELETE_RULE"));
                    break;
                }
                default: {
                    this.m_cType = '\u0000';
                }
            }
            object = resultSet.getString("STATUS");
            this.m_status = "ENABLED".equals(object);
            string3 = resultSet.getString("GENERATED");
            this.m_generated = "GENERATED NAME".equals(string3);
            string2 = resultSet.getString("DEFERRABLE");
            String string6 = resultSet.getString("DEFERRED");
            this.m_deferredState = string2 == null || string2.equals("NOT DEFERRABLE") ? null : (string6.equals("DEFERRED") ? Constraint.DeferrableState.DEFER_INIT_DEFERRED : Constraint.DeferrableState.DEFER_INIT_IMMEDIATE);
        }

        private boolean isInvisibleFK() {
            return this.m_cType == 'R' && !this.isVisibleFK();
        }

        private boolean isVisibleFK() {
            return this.m_rSchemaName != null && this.m_rRelationName != null && this.m_rRelationType != null;
        }

        private void addColumn(String string) {
            if (ModelUtil.hasLength((String)string)) {
                if (string.startsWith("SYS_NC")) {
                    this.m_ignore = true;
                } else if (DBUtil.isCompoundName((String)string, (String)OracleRelationBuilder.this.getDatabase().getIdentifierQuoteString())) {
                    OracleRelationBuilder.this.getLogger().warning("Constraint " + this.m_cName + " ignored; compound column name " + string + " not supported.");
                    this.m_ignore = true;
                } else {
                    this.m_cols.add(string);
                }
            }
        }

        private Constraint createConstraint(T t) throws DBException {
            CheckConstraint checkConstraint = null;
            switch (this.m_cType) {
                case 'C': {
                    checkConstraint = this.createCheckConstraint(t);
                    break;
                }
                case 'P': 
                case 'U': {
                    checkConstraint = this.createUniqueConstraint(t);
                    break;
                }
                case 'R': {
                    checkConstraint = this.createFK(t);
                    break;
                }
                default: {
                    checkConstraint = null;
                }
            }
            if (checkConstraint != null) {
                checkConstraint.setID((DBObjectID)new NameBasedID((DBObject)checkConstraint, t.getID()));
                checkConstraint.setEnabled(this.m_status);
                checkConstraint.setDeferrableState(this.m_deferredState);
            }
            return checkConstraint;
        }

        private CheckConstraint createCheckConstraint(T t) {
            Object object;
            Column column;
            if (this.m_cond == null) {
                return null;
            }
            this.m_cond = this.m_cond.trim();
            if (this.m_generated && this.m_cols.size() == 1 && (column = t.getColumn((String)(object = this.m_cols.get(0)))) != null && column.isNotNull() && MessageFormat.format(OracleRelationBuilder.getNotNullText(OracleRelationBuilder.this.getDatabase()), object).equals(this.m_cond)) {
                return null;
            }
            object = (CheckConstraint)OracleRelationBuilder.this.newObject(CheckConstraint.class, this.m_cName);
            object.setRelation(t);
            object.setCheckCondition(this.m_cond);
            return object;
        }

        private void setConstraintColumns(ColumnConstraint columnConstraint, T t) {
            DBObjectID dBObjectID = t.getID();
            if (dBObjectID == null) {
                String[] stringArray = this.m_cols.toArray(new String[this.m_cols.size()]);
                int n = 0;
                Column[] columnArray = new Column[stringArray.length];
                for (int i = 0; i < stringArray.length; ++i) {
                    Column column = t.getColumn(stringArray[i]);
                    if (column == null) continue;
                    columnArray[n++] = column;
                }
                if (n < columnArray.length) {
                    Column[] columnArray2 = columnArray;
                    columnArray = new Column[n];
                    System.arraycopy(columnArray2, 0, columnArray, 0, n);
                }
                columnConstraint.setColumns(columnArray);
            } else {
                DBObjectID[] dBObjectIDArray = new DBObjectID[this.m_cols.size()];
                for (int i = 0; i < dBObjectIDArray.length; ++i) {
                    dBObjectIDArray[i] = new NameBasedID("COLUMN", this.m_cols.get(i), dBObjectID);
                }
                columnConstraint.setColumnIDs(dBObjectIDArray);
            }
        }

        private UniqueConstraint createUniqueConstraint(T t) throws DBException {
            Class clazz = this.m_cType == 'P' ? PKConstraint.class : UniqueConstraint.class;
            UniqueConstraint uniqueConstraint = (UniqueConstraint)OracleRelationBuilder.this.newObject(clazz, this.m_cName);
            uniqueConstraint.setRelation(t);
            this.setConstraintColumns((ColumnConstraint)uniqueConstraint, t);
            if (this.m_indexName != null) {
                BaseOracleDatabase baseOracleDatabase = OracleRelationBuilder.this.getDatabase();
                Schema schema = null;
                if (ModelUtil.hasLength((String)this.m_indexOwner)) {
                    schema = baseOracleDatabase.getSchema(this.m_indexOwner);
                }
                if (schema == null) {
                    schema = t.getSchema();
                }
                DBObjectID dBObjectID = baseOracleDatabase.createID(null, schema, this.m_indexName, "INDEX", this.m_indexObjectID);
                uniqueConstraint.setIndexID(dBObjectID);
            }
            return uniqueConstraint;
        }

        private FKConstraint createFK(T t) throws DBException {
            FKConstraint fKConstraint = (FKConstraint)OracleRelationBuilder.this.newObject(FKConstraint.class, this.m_cName);
            fKConstraint.setRelation(t);
            this.setConstraintColumns((ColumnConstraint)fKConstraint, t);
            fKConstraint.setOnDeleteAction(this.m_dRule);
            if (this.isVisibleFK()) {
                Schema schema = OracleRelationBuilder.this.getSchema(this.m_rSchemaName);
                DBObjectID dBObjectID = OracleRelationBuilder.this.getDatabase().createID(null, schema, this.m_rRelationName, this.m_rRelationType, this.m_rRelationObjectID);
                NameBasedID nameBasedID = new NameBasedID("CONSTRAINT", this.m_rConstraintName, dBObjectID);
                fKConstraint.setReferenceID((DBObjectID)nameBasedID);
            }
            return fKConstraint;
        }
    }

    public class IdentityColumnPropertiesBuilder
    extends OracleIncrementerBuilder<IdentityColumnProperties> {
        IdentityColumnPropertiesBuilder(BaseOracleDatabase baseOracleDatabase) {
            super(baseOracleDatabase, "IdentityColumnProperties");
        }

        public IdentityColumnProperties createObject(String string, Schema schema, DBObjectID dBObjectID) {
            return null;
        }

        @AbstractDBObjectBuilder.PropertyBuilder(value={"generated"})
        public void fillInGenerated(final IdentityColumnProperties identityColumnProperties) throws DBException {
            Relation relation;
            Column column = (Column)identityColumnProperties.getParent();
            Relation relation2 = relation = column == null ? null : column.getRelation();
            if (relation == null) {
                throw new DBException((DBObject)identityColumnProperties, "IdentityColumnProperties instance has no parent Relation");
            }
            final QueryWrapper queryWrapper = this.getDatabase().newQueryWrapper((SystemObject)relation, "SELECT /*OracleDictionaryQueries.ALL_IDENTITY_COLUMN_PROPERTIES_QUERY*/ \n       GENERATION_TYPE FROM SYS.ALL_TAB_IDENTITY_COLS \nWHERE  OWNER = ? AND TABLE_NAME = ? AND COLUMN_NAME = ?", relation.getSchema(), relation, column);
            QueryWrapper.QueryRunnable queryRunnable = new QueryWrapper.QueryRunnable(){

                public void processResultSet(ResultSet resultSet) throws DBException {
                    block4: {
                        try {
                            if (!resultSet.next()) break block4;
                            String string = resultSet.getString(1);
                            IdentityColumnProperties.GeneratedType generatedType = null;
                            try {
                                generatedType = IdentityColumnProperties.GeneratedType.valueOf((String)string.replaceAll(" ", "_"));
                            }
                            catch (Exception exception) {
                                DBLog.getLogger((Object)this).warning(exception.getMessage());
                            }
                            identityColumnProperties.setGenerated(generatedType);
                        }
                        catch (SQLException sQLException) {
                            queryWrapper.throwDBException(sQLException);
                        }
                    }
                }
            };
            queryWrapper.executeQuery(queryRunnable);
        }
    }
}

