/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import oracle.javatools.db.AbstractBuildableObject;
import oracle.javatools.db.AbstractDBObjectBuilder;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.execute.QueryWrapper;
import oracle.javatools.db.ora.BaseOracleDatabase;
import oracle.javatools.db.ora.MaterializedView;
import oracle.javatools.db.ora.OracleIndexBuilder;
import oracle.javatools.db.ora.OracleStorageProperties;
import oracle.javatools.db.ora.OracleTableBuilder;
import oracle.javatools.db.resource.APIBundle;
import oracle.javatools.db.sql.SQLQuery;
import oracle.javatools.util.Holder;
import oracle.javatools.util.ModelUtil;

public class MaterializedViewBuilder
extends OracleTableBuilder<MaterializedView> {
    private static String TENG_REPLACE_COL = "A.UNKNOWN_TRUSTED_FD";
    private static String NON_TENG_REPLACE_COL = "'NULL'";

    MaterializedViewBuilder(BaseOracleDatabase baseOracleDatabase) {
        super(baseOracleDatabase, "MATERIALIZED VIEW");
    }

    @Override
    public void fillInConstraints(MaterializedView materializedView) throws DBException {
    }

    @Override
    public void fillInColumnSequenceColumns(MaterializedView materializedView) throws DBException {
    }

    @AbstractDBObjectBuilder.PropertyBuilder(value={"updatable", "queryRewrite", "rewriteType", "refreshMode", "refreshMethod", "fastRefresh", "lastRefreshType", "lastRefreshDate", "staleness", "buildType", "onPrebuilt", "defaultIndex", "rollbackSegmentName", "rollbackSegmentType", "usingConstraints", "keyType", "nextRefreshDate", "interval"})
    public void fillInMViewProperties(final MaterializedView materializedView) throws DBException {
        final QueryWrapper queryWrapper = this.getDatabase().newQueryWrapper((SystemObject)materializedView, this.getQuery(this.getDatabase().getDatabaseVersion()), materializedView.getSchema(), materializedView);
        QueryWrapper.QueryRunnable queryRunnable = new QueryWrapper.QueryRunnable(){

            public void processResultSet(ResultSet resultSet) throws DBException {
                try {
                    if (resultSet.next()) {
                        int n = 1;
                        materializedView.setUpdatable(MaterializedViewBuilder.this.parseYNBoolean(resultSet.getString(n++)));
                        materializedView.setQueryRewrite(Boolean.valueOf(MaterializedViewBuilder.this.parseYNBoolean(resultSet.getString(n++))));
                        materializedView.setRewriteType(MaterializedViewBuilder.this.parseRewriteCapability(resultSet.getString(n++)));
                        materializedView.setRefreshMode(MaterializedViewBuilder.this.parseRefreshMode(resultSet.getString(n++)));
                        materializedView.setRefreshMethod(MaterializedViewBuilder.this.parseRefreshMethod(resultSet.getString(n++)));
                        materializedView.setFastRefresh(MaterializedViewBuilder.this.parseFastRefreshable(resultSet.getString(n++)));
                        materializedView.setLastRefreshType(MaterializedViewBuilder.this.parseRefreshMethod(resultSet.getString(n++)));
                        Timestamp timestamp = resultSet.getTimestamp(n++);
                        Date date = timestamp == null ? null : new Date(timestamp.getTime());
                        materializedView.setLastRefreshDate(date);
                        materializedView.setStaleness(MaterializedViewBuilder.this.parseStaleness(resultSet.getString(n++)));
                        materializedView.setBuildType(MaterializedViewBuilder.this.parseBuildType(resultSet.getString(n++)));
                        materializedView.setOnPrebuilt(MaterializedViewBuilder.this.parsePrebuilt(resultSet.getString(n++)));
                        materializedView.setDefaultIndex(Boolean.valueOf(!MaterializedViewBuilder.this.parseYNBoolean(resultSet.getString(n++))));
                        materializedView.setRollbackSegmentName(resultSet.getString(n++));
                        if (ModelUtil.hasLength((String)materializedView.getRollbackSegmentName())) {
                            materializedView.setRollbackSegmentType(MaterializedView.RollbackSegmentType.MASTER);
                        } else {
                            materializedView.setRollbackSegmentType(MaterializedView.RollbackSegmentType.LOCAL);
                            materializedView.setRollbackSegmentName(null);
                        }
                        materializedView.setUsingConstraints(MaterializedViewBuilder.this.parseUsingConstraints(resultSet.getString(n++)));
                        materializedView.setKeyType(MaterializedViewBuilder.this.parseKeyType(resultSet.getString(n++)));
                        timestamp = resultSet.getTimestamp(n++);
                        date = timestamp == null ? null : new Date(timestamp.getTime());
                        materializedView.setNextRefreshDate(date);
                        materializedView.setInterval(resultSet.getString(n++));
                        if (ModelUtil.hasLength((String)materializedView.getInterval())) {
                            materializedView.setRefreshMode(MaterializedView.RefreshMode.SPECIFY);
                        }
                    }
                }
                catch (SQLException sQLException) {
                    queryWrapper.throwDBException((DBObject)materializedView, sQLException);
                }
            }
        };
        queryWrapper.executeQuery(queryRunnable);
    }

    @Override
    @AbstractDBObjectBuilder.PropertyBuilder(value={"OracleStorageProperties", "OracleTableProperties", "OracleInMemoryProperties", "cache"}, depends={"TableType", "PARTITIONED TABLE"})
    public void fillInBaseProperties(MaterializedView materializedView) throws DBException {
        super.fillInBaseProperties(materializedView);
    }

    @Override
    protected void setBasePropertiesFromRS(MaterializedView materializedView, ResultSet resultSet) throws SQLException, DBException {
        super.setBasePropertiesFromRS(materializedView, resultSet);
        materializedView.setCache(Boolean.valueOf(this.parseYNBoolean(resultSet.getString("CACHE"))));
    }

    @AbstractDBObjectBuilder.PropertyBuilder(value={"SQLQuery"})
    public void fillInQuery(final MaterializedView materializedView) throws DBException {
        final QueryWrapper queryWrapper = this.getDatabase().newQueryWrapper((SystemObject)materializedView, "SELECT /*OracleDictionaryQueries.ALL_MVIEW_QUERY_QUERY*/\n       A.QUERY_LEN, A.QUERY\nFROM SYS.ALL_MVIEWS A\nWHERE A.OWNER = ? AND A.MVIEW_NAME = ? \n", materializedView.getSchema(), materializedView);
        QueryWrapper.QueryRunnable queryRunnable = new QueryWrapper.QueryRunnable(){

            public void processResultSet(ResultSet resultSet) throws DBException {
                try {
                    if (resultSet.next()) {
                        int n = resultSet.getInt(1);
                        if (n > Short.MAX_VALUE) {
                            throw new DBException((DBObject)materializedView, APIBundle.format((String)"VIEW_SOURCE_LIMIT_ERROR", (Object[])new Object[]{"MATERIALIZED VIEW"}));
                        }
                        SQLQuery sQLQuery = (SQLQuery)MaterializedViewBuilder.this.newObject(SQLQuery.class, null);
                        sQLQuery.setQueryString(resultSet.getString(2));
                        materializedView.setSQLQuery(sQLQuery);
                    }
                }
                catch (SQLException sQLException) {
                    queryWrapper.throwDBException(sQLException);
                }
            }
        };
        queryWrapper.executeQuery(queryRunnable);
    }

    @Override
    @AbstractDBObjectBuilder.PropertyBuilder(value={"indexes", "MatViewIndexStorageProperties"}, depends={"columns"})
    public void fillInIndexes(final MaterializedView materializedView) throws DBException {
        final Holder holder = new Holder();
        final QueryWrapper queryWrapper = this.getDatabase().newQueryWrapper((SystemObject)materializedView, "SELECT /*OracleDictionaryQueries.ALL_MVIEW_INDEX_QUERY*/\n       I.INDEX_NAME \n,      I.TABLESPACE_NAME \n,      I.PCT_FREE \n,      NULL PCT_USED \n,      I.INI_TRANS \n,      I.MAX_TRANS \n,      I.INITIAL_EXTENT \n,      I.NEXT_EXTENT \n,      I.MIN_EXTENTS \n,      I.MAX_EXTENTS \n,      I.PCT_INCREASE \n,      I.FREELISTS \n,      I.FREELIST_GROUPS \n,      I.LOGGING \n,      I.BUFFER_POOL \nFROM  SYS.ALL_INDEXES I \nWHERE I.TABLE_NAME = ? \n AND I.OWNER = ? \n AND I.INDEX_NAME = \n ( SELECT C.INDEX_NAME FROM SYS.ALL_CONSTRAINTS C \n   WHERE C.TABLE_NAME = I.TABLE_NAME \n     AND C.CONSTRAINT_TYPE = 'P' \n     AND I.OWNER = NVL( C.INDEX_OWNER, C.OWNER ) ) ", materializedView, materializedView.getSchema());
        QueryWrapper.QueryRunnable queryRunnable = new QueryWrapper.QueryRunnable(){

            public void processResultSet(ResultSet resultSet) throws DBException {
                try {
                    if (resultSet.next()) {
                        holder.set((Object)resultSet.getString(1));
                        OracleStorageProperties oracleStorageProperties = OracleTableBuilder.getSegmentAttributeProperties(resultSet, MaterializedViewBuilder.this.getDatabase());
                        materializedView.setProperty("MatViewIndexStorageProperties", (Object)oracleStorageProperties);
                    }
                }
                catch (SQLException sQLException) {
                    queryWrapper.throwDBException((DBObject)materializedView, sQLException);
                }
            }
        };
        queryWrapper.executeQuery(queryRunnable);
        OracleIndexBuilder oracleIndexBuilder = (OracleIndexBuilder)this.getDatabase().getBuilderForType("INDEX");
        oracleIndexBuilder.fillInIndexes(materializedView, (String)holder.get());
        this.updateTimestamp((AbstractBuildableObject)materializedView, true);
    }

    private String getQuery(int n) {
        String string = n >= 100 ? String.format("SELECT /*OracleDictionaryQueries.ALL_MVIEW_PROPERTIES_QUERY*/\n  A.UPDATABLE, A.REWRITE_ENABLED, A.REWRITE_CAPABILITY, \n  A.REFRESH_MODE, A.REFRESH_METHOD, A.FAST_REFRESHABLE, \n  A.LAST_REFRESH_TYPE, A.LAST_REFRESH_DATE, A.STALENESS, A.BUILD_MODE, \n  A.UNKNOWN_PREBUILT, A.USE_NO_INDEX, A.MASTER_ROLLBACK_SEG, %1$S, \n  ( SELECT E.REFRESH_METHOD FROM SYS.ALL_SNAPSHOTS E \n    WHERE A.OWNER = E.OWNER AND A.MVIEW_NAME = E.NAME ) KEY_TYPE, \n  ( SELECT D.NEXT_DATE FROM SYS.ALL_REFRESH D \n    WHERE A.OWNER = D.ROWNER AND A.MVIEW_NAME = D.RNAME ) NEXT_DATE, \n  ( SELECT D.INTERVAL FROM SYS.ALL_REFRESH D \n    WHERE A.OWNER = D.ROWNER AND A.MVIEW_NAME = D.RNAME ) INTERVAL \nFROM SYS.ALL_MVIEWS A \nWHERE A.OWNER = ? AND A.MVIEW_NAME = ? \n", TENG_REPLACE_COL) : String.format("SELECT /*OracleDictionaryQueries.ALL_MVIEW_PROPERTIES_QUERY*/\n  A.UPDATABLE, A.REWRITE_ENABLED, A.REWRITE_CAPABILITY, \n  A.REFRESH_MODE, A.REFRESH_METHOD, A.FAST_REFRESHABLE, \n  A.LAST_REFRESH_TYPE, A.LAST_REFRESH_DATE, A.STALENESS, A.BUILD_MODE, \n  A.UNKNOWN_PREBUILT, A.USE_NO_INDEX, A.MASTER_ROLLBACK_SEG, %1$S, \n  ( SELECT E.REFRESH_METHOD FROM SYS.ALL_SNAPSHOTS E \n    WHERE A.OWNER = E.OWNER AND A.MVIEW_NAME = E.NAME ) KEY_TYPE, \n  ( SELECT D.NEXT_DATE FROM SYS.ALL_REFRESH D \n    WHERE A.OWNER = D.ROWNER AND A.MVIEW_NAME = D.RNAME ) NEXT_DATE, \n  ( SELECT D.INTERVAL FROM SYS.ALL_REFRESH D \n    WHERE A.OWNER = D.ROWNER AND A.MVIEW_NAME = D.RNAME ) INTERVAL \nFROM SYS.ALL_MVIEWS A \nWHERE A.OWNER = ? AND A.MVIEW_NAME = ? \n", NON_TENG_REPLACE_COL);
        return string;
    }

    private boolean parseYNBoolean(String string) {
        return "Y".equals(string.trim());
    }

    private MaterializedView.UsingConstraints parseUsingConstraints(String string) {
        Boolean bl = this.parseYNNullBoolean(string);
        if (bl != null) {
            return bl != false ? MaterializedView.UsingConstraints.TRUSTED : MaterializedView.UsingConstraints.ENFORCED;
        }
        return null;
    }

    private MaterializedView.RefreshWith parseKeyType(String string) {
        MaterializedView.RefreshWith refreshWith = null;
        if (string != null) {
            string = string.trim();
            string = string.replace(" ", "_");
            try {
                refreshWith = MaterializedView.RefreshWith.valueOf((String)string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                refreshWith = null;
            }
        }
        return refreshWith;
    }

    private Boolean parseYNNullBoolean(String string) {
        String string2 = string.trim();
        if ("Y".equals(string2) || "YES".equals(string2)) {
            return Boolean.TRUE;
        }
        if ("N".equals(string2) || "NO".equals(string2)) {
            return Boolean.FALSE;
        }
        return null;
    }

    private int parseParallel(String string) {
        int n;
        try {
            n = Integer.parseInt(string.trim());
        }
        catch (NumberFormatException numberFormatException) {
            n = 0;
        }
        return n;
    }

    private MaterializedView.RewriteCapability parseRewriteCapability(String string) {
        MaterializedView.RewriteCapability rewriteCapability;
        if (ModelUtil.hasLength((String)string) && !DBUtil.isDeprecated((Enum)(rewriteCapability = MaterializedView.RewriteCapability.valueOf((String)string)))) {
            return rewriteCapability;
        }
        return null;
    }

    private MaterializedView.RefreshMode parseRefreshMode(String string) {
        return ModelUtil.hasLength((String)string) ? MaterializedView.RefreshMode.valueOf((String)string) : null;
    }

    private MaterializedView.RefreshMethod parseRefreshMethod(String string) {
        MaterializedView.RefreshMethod refreshMethod;
        MaterializedView.RefreshMethod refreshMethod2 = refreshMethod = ModelUtil.hasLength((String)string) ? MaterializedView.RefreshMethod.valueOf((String)string) : null;
        if (refreshMethod == MaterializedView.RefreshMethod.NEVER) {
            refreshMethod = null;
        } else if (refreshMethod == MaterializedView.RefreshMethod.NA) {
            refreshMethod = null;
        }
        return refreshMethod;
    }

    private MaterializedView.FastRefreshable parseFastRefreshable(String string) {
        return ModelUtil.hasLength((String)string) ? MaterializedView.FastRefreshable.valueOf((String)string) : null;
    }

    private MaterializedView.PrebuiltType parsePrebuilt(String string) {
        MaterializedView.PrebuiltType prebuiltType = MaterializedView.PrebuiltType.NONE;
        if ("Y".equals(string)) {
            prebuiltType = MaterializedView.PrebuiltType.UNSPECIFIED_PRECISION;
        }
        return prebuiltType;
    }

    private MaterializedView.Staleness parseStaleness(String string) {
        return ModelUtil.hasLength((String)string) ? MaterializedView.Staleness.valueOf((String)string) : null;
    }

    private MaterializedView.BuildType parseBuildType(String string) {
        return ModelUtil.hasLength((String)string) ? MaterializedView.BuildType.valueOf((String)string) : null;
    }

    private String parseMasterName(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer(64);
        if (ModelUtil.hasLength((String)string)) {
            stringBuffer.append(string);
        }
        if (ModelUtil.hasLength((String)string2)) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append('.');
            }
            stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }
}

