/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.mysql;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import oracle.javatools.db.AbstractDBObjectBuilder;
import oracle.javatools.db.Column;
import oracle.javatools.db.ColumnConstraint;
import oracle.javatools.db.Constraint;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Database;
import oracle.javatools.db.Index;
import oracle.javatools.db.JdbcDatabase;
import oracle.javatools.db.NameBasedID;
import oracle.javatools.db.PKConstraint;
import oracle.javatools.db.Table;
import oracle.javatools.db.UniqueConstraint;
import oracle.javatools.db.execute.QueryWrapper;
import oracle.javatools.db.jdbc.JdbcTableBuilder;
import oracle.javatools.db.mysql.MySQLDatabaseImpl;
import oracle.javatools.db.sql.ColumnUsage;
import oracle.javatools.db.sql.IndexObject;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.util.Holder;
import oracle.javatools.util.ModelUtil;

public class MySQLTableBuilder
extends JdbcTableBuilder<Table> {
    MySQLTableBuilder(MySQLDatabaseImpl mySQLDatabaseImpl, String string) {
        super(mySQLDatabaseImpl, string);
    }

    @Override
    protected void addExtraDataTypeAttributeValues(final Map<String, Object> map, String string, Table table) {
        String string2;
        String string3 = (String)map.get("name");
        String string4 = string2 = table.getSchema() == null ? table.getName() : table.getSchema() + "." + table.getName();
        if ("ENUM".equalsIgnoreCase(string3) || "SET".equalsIgnoreCase(string3)) {
            String string5 = table.getSchema() == null ? table.getName() : table.getSchema() + "." + table.getName();
            String string6 = "show columns from " + string2 + " like '" + string + "'";
            final QueryWrapper queryWrapper = new QueryWrapper((Database)this.getDatabase(), string6);
            QueryWrapper.QueryRunnable queryRunnable = new QueryWrapper.QueryRunnable(){

                public void processResultSet(ResultSet resultSet) throws DBException {
                    try {
                        while (resultSet.next()) {
                            String[] stringArray = resultSet.getString(2).split("\\(|\\)");
                            if (stringArray.length <= 1) continue;
                            map.put("value_list", stringArray[1]);
                        }
                    }
                    catch (SQLException sQLException) {
                        queryWrapper.throwDBException(sQLException);
                    }
                }
            };
            try {
                queryWrapper.executeQuery(queryRunnable);
            }
            catch (DBException dBException) {
                String string7 = MessageFormat.format("Error getting props for col {0} on {1}", string, string2);
                DBLog.getLogger((Object)((Object)this)).log(Level.FINE, string7, dBException);
                DBLog.getLogger((Object)((Object)this)).warning(string7);
            }
        }
    }

    @Override
    protected void loadAndBuildIndexes(final Table table) throws DBException {
        String string = this.getNameForDriver(table.getName());
        String string2 = this.isUseSchema() && table.getSchema() != null ? table.getSchema().getName() : null;
        String string3 = "show indexes from " + string2 + ".`" + string + "`";
        QueryWrapper queryWrapper = new QueryWrapper((Database)this.getDatabase(), string3);
        QueryWrapper.QueryRunnable queryRunnable = new QueryWrapper.QueryRunnable(){

            public void processResultSet(ResultSet resultSet) throws DBException {
                MySQLTableBuilder.this.processIndexes(resultSet, table);
            }
        };
        queryWrapper.executeQuery(queryRunnable);
    }

    @Override
    protected void processIndexes(ResultSet resultSet, Table table) throws DBException {
        Object object;
        TreeMap<String, Index> treeMap = new TreeMap<String, Index>();
        try {
            object = this.getNameForDriver(table.getName());
            while (resultSet != null && resultSet.next()) {
                boolean bl;
                if (object == null && !resultSet.getString(1).equals(table.getName())) continue;
                boolean bl2 = bl = !resultSet.getBoolean(2);
                String string = resultSet.getString(3);
                if (table.getConstraint(string) != null) continue;
                String string2 = resultSet.getString(5);
                String string3 = resultSet.getString(6);
                Index index = (Index)treeMap.get(string);
                if (index == null) {
                    index = new Index(string, table);
                    treeMap.put(string, index);
                }
                index.setIndexType(bl ? Index.IndexType.UNIQUE : Index.IndexType.NORMAL);
                Column column = table.getColumn(string2);
                if (column == null) continue;
                IndexObject.OrderType orderType = null;
                if (string3 != null) {
                    orderType = string3.equals("A") ? IndexObject.OrderType.ASC : IndexObject.OrderType.DESC;
                }
                ColumnUsage columnUsage = new ColumnUsage(column.getID());
                columnUsage.setProvider((DBObjectProvider)this.getProvider());
                IndexObject indexObject = new IndexObject((SQLFragment)columnUsage, orderType);
                index.addColumnExpression(indexObject);
            }
        }
        catch (SQLException sQLException) {
            this.checkUnsupportedOperation((DBObject)table, sQLException);
        }
        object = treeMap.values();
        Index[] indexArray = object.toArray(new Index[object.size()]);
        table.setIndexes(indexArray);
    }

    @AbstractDBObjectBuilder.PropertyBuilder(value={"Comment"})
    public void buildComment(final Table table) throws DBException {
        final Holder holder = new Holder();
        final boolean bl = this.getDatabase().getDatabaseVersion() < 50;
        String string = bl ? "show create table `{0}`.`{1}`" : "select table_name, table_comment from information_schema.tables  where table_schema = ''{0}'' and table_name = ''{1}''";
        final QueryWrapper queryWrapper = new QueryWrapper((Database)this.getDatabase(), string, new Object[]{table.getSchema(), table});
        queryWrapper.executeQuery(new QueryWrapper.QueryRunnable(){

            public void processResultSet(ResultSet resultSet) throws DBException {
                try {
                    while (resultSet.next()) {
                        String string = resultSet.getString(1);
                        if (!table.getName().equals(string)) continue;
                        String string2 = resultSet.getString(2);
                        if (bl) {
                            int n = string2.indexOf("COMMENT='");
                            if (n > 0) {
                                StringBuilder stringBuilder = new StringBuilder();
                                int n2 = n + 9;
                                while (n2 < string2.length()) {
                                    char c;
                                    boolean bl5;
                                    boolean bl2 = bl5 = (c = string2.charAt(n2++)) == '\'';
                                    if (bl5) {
                                        boolean bl3 = false;
                                        if (string2.length() > n2) {
                                            char c2 = string2.charAt(n2);
                                            boolean bl4 = bl3 = c2 == '\'';
                                        }
                                        if (!bl3) break;
                                        ++n2;
                                    }
                                    stringBuilder.append(c);
                                }
                                string2 = stringBuilder.toString();
                            } else {
                                string2 = null;
                            }
                        }
                        if (!ModelUtil.hasLength((String)string2)) {
                            string2 = null;
                        }
                        holder.set((Object)string2);
                        break;
                    }
                }
                catch (SQLException sQLException) {
                    queryWrapper.throwDBException((DBObject)table, sQLException);
                }
            }
        });
        table.setProperty("Comment", holder.get());
    }

    private boolean canBuildKeysFromDictionary() {
        return this.getDatabase().getDatabaseVersion() > 40;
    }

    @Override
    protected void buildPK(Table table) throws DBException {
        if (!this.canBuildKeysFromDictionary()) {
            super.buildPK(table);
        }
    }

    @Override
    protected String makePKName(String string, String string2) {
        return "PRIMARY";
    }

    @Override
    protected void buildUKs(Table table) throws DBException {
        if (this.canBuildKeysFromDictionary()) {
            this.buildKeysFromDictionary(table);
        }
    }

    private void buildKeysFromDictionary(final Table table) throws DBException {
        final HashMap hashMap = new HashMap();
        JdbcDatabase jdbcDatabase = this.getDatabase();
        final QueryWrapper queryWrapper = new QueryWrapper((Database)jdbcDatabase, "select CONSTRAINT_NAME, con.CONSTRAINT_TYPE, col.COLUMN_NAME, col.ORDINAL_POSITION\nfrom INFORMATION_SCHEMA.TABLE_CONSTRAINTS con\njoin INFORMATION_SCHEMA.KEY_COLUMN_USAGE col\nusing( CONSTRAINT_SCHEMA, CONSTRAINT_NAME, TABLE_SCHEMA, TABLE_NAME )\nwhere binary TABLE_SCHEMA = ? and binary TABLE_NAME = ?\norder by col.ORDINAL_POSITION", new Object[]{table.getSchema(), table});
        queryWrapper.executeQuery(new QueryWrapper.QueryRunnable(){

            public void processResultSet(ResultSet resultSet) throws DBException {
                try {
                    while (resultSet.next()) {
                        Column column;
                        String string = resultSet.getString("CONSTRAINT_NAME");
                        String string2 = resultSet.getString("CONSTRAINT_TYPE");
                        String string3 = resultSet.getString("COLUMN_NAME");
                        ColumnConstraint columnConstraint = (ColumnConstraint)hashMap.get(string);
                        if (columnConstraint == null) {
                            column = null;
                            if (string2.equals("UNIQUE")) {
                                column = UniqueConstraint.class;
                            } else if (string2.equals("PRIMARY KEY")) {
                                column = PKConstraint.class;
                            }
                            if (column != null) {
                                columnConstraint = (ColumnConstraint)MySQLTableBuilder.this.newObject((Class)column, (DBObject)table, string);
                                columnConstraint.setID((DBObjectID)new NameBasedID("CONSTRAINT", string, table.getID()));
                            }
                        }
                        if (columnConstraint == null) continue;
                        hashMap.put(string, columnConstraint);
                        column = table.getColumn(string3);
                        if (column == null) continue;
                        boolean bl = false;
                        for (DBObjectID dBObjectID : columnConstraint.getColumnIDs()) {
                            if (!dBObjectID.equals(column.getID(), true)) continue;
                            bl = true;
                            break;
                        }
                        if (bl) continue;
                        columnConstraint.addColumn(column);
                    }
                }
                catch (SQLException sQLException) {
                    queryWrapper.throwDBException((DBObject)table, sQLException);
                }
            }
        });
        for (ColumnConstraint columnConstraint : hashMap.values()) {
            if (columnConstraint.getColumnIDs().length <= 0) continue;
            table.addConstraint((Constraint)columnConstraint);
        }
    }
}

