/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.marshal;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.db.internal.DBCore;
import oracle.javatools.db.marshal.DBObjectXMLHandler;
import oracle.javatools.db.marshal.SingleElementHandler;
import oracle.javatools.util.ModelUtil;

public class DBObjectXMLSupport {
    private final Map<String, DBObjectXMLHandler> m_handlers = new HashMap<String, DBObjectXMLHandler>();

    private DBObjectXMLSupport() {
    }

    public void registerHandler(DBObjectXMLHandler dBObjectXMLHandler) {
        String string = dBObjectXMLHandler.getNamespace();
        if (ModelUtil.hasLength((String)string)) {
            if (this.m_handlers.containsKey(string)) {
                throw new IllegalStateException("DBObjectXMLHandler for \"" + string + "\" already registered.");
            }
        } else {
            throw new IllegalArgumentException("DBObjectXMLHandler has no namespace defined");
        }
        this.m_handlers.put(string, dBObjectXMLHandler);
    }

    public DBObjectXMLHandler getHandler(URL uRL) {
        return this.getHandler(DBObjectXMLSupport.getNamespace(uRL));
    }

    public DBObjectXMLHandler getHandler(String string) {
        DBObjectXMLHandler dBObjectXMLHandler = null;
        if (ModelUtil.hasLength((String)string) && (dBObjectXMLHandler = (DBObjectXMLHandler)((Object)DBCore.getInstance().getRegisteredFactory(DBObjectXMLHandler.class, string))) == null) {
            dBObjectXMLHandler = this.m_handlers.get(string);
        }
        return dBObjectXMLHandler;
    }

    public ClassLoader getClassLoader(String string) {
        DBObjectXMLHandler dBObjectXMLHandler;
        ClassLoader classLoader = null;
        if (ModelUtil.hasLength((String)string) && (dBObjectXMLHandler = this.getHandler(string)) != null) {
            classLoader = ((Object)((Object)dBObjectXMLHandler)).getClass().getClassLoader();
        }
        if (classLoader == null) {
            classLoader = DBCore.getImplClassLoader();
        }
        return classLoader;
    }

    public static DBObjectXMLSupport getInstance() {
        DBCore dBCore = DBCore.getInstance();
        DBObjectXMLSupport dBObjectXMLSupport = (DBObjectXMLSupport)dBCore.get(DBObjectXMLSupport.class);
        if (dBObjectXMLSupport == null) {
            dBObjectXMLSupport = new DBObjectXMLSupport();
            dBCore.put((Object)dBObjectXMLSupport);
        }
        return dBObjectXMLSupport;
    }

    public static String getNamespace(URL uRL) {
        try {
            InputStreamReader inputStreamReader = new InputStreamReader(URLFileSystem.openInputStream((URL)uRL));
            return DBObjectXMLSupport.getNamespace(inputStreamReader);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static String getNamespace(Reader reader) {
        try {
            SingleElementHandler singleElementHandler = new SingleElementHandler(null);
            DBObjectXMLHandler.read(reader, singleElementHandler, true);
            return singleElementHandler.getNamespace();
        }
        catch (IOException iOException) {
            return null;
        }
    }
}

