/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.informix;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBException;
import oracle.javatools.db.Database;
import oracle.javatools.db.FKConstraint;
import oracle.javatools.db.JdbcDatabase;
import oracle.javatools.db.Table;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeUsage;
import oracle.javatools.db.execute.QueryWrapper;
import oracle.javatools.db.informix.InformixDataTypeUsageValidator;
import oracle.javatools.db.jdbc.JdbcTableBuilder;
import oracle.javatools.util.ModelUtil;

public class InformixTableBuilder
extends JdbcTableBuilder<Table> {
    public InformixTableBuilder(JdbcDatabase jdbcDatabase, String string) {
        super(jdbcDatabase, string);
    }

    @Override
    protected Map<String, Object> createDataTypeAttributes(Table table, Column column, DataType dataType, Long l, Long l2, String string) {
        Map<String, Object> map = super.createDataTypeAttributes(table, column, dataType, l, l2, string);
        if (dataType != null) {
            String string2 = dataType.getName();
            if ("VARCHAR".equals(string2) || "NVARCHAR".equals(string2)) {
                if (l != null) {
                    long l3 = l < 0L ? l + 65536L : l;
                    long l4 = l3 / 256L;
                    map.put("size", l3 - l4 * 256L);
                    map.put("reserve", l4);
                }
            } else if ("INTERVAL".equals(string2) || "DATETIME".equals(string2)) {
                if (l != null) {
                    int n = l.intValue() / 256;
                    int n2 = (l.intValue() - n * 256) / 16;
                    int n3 = l.intValue() - n * 256 - n2 * 16;
                    map.put("from", InformixTableBuilder.getTimeTypeName(n2));
                    map.put("to", InformixTableBuilder.getTimeTypeName(n3));
                    map.put("precision", n);
                    if (n3 > 10) {
                        map.put("scale", n3 - 10);
                    } else {
                        map.remove("scale");
                    }
                }
            } else if ("DECIMAL".equals(string2) && l2 != null && l2.equals(255L)) {
                map.remove("scale");
            }
        }
        return map;
    }

    public static String getTimeTypeName(int n) {
        return n > 10 ? InformixDataTypeUsageValidator.TIME_UNITS[6] : InformixDataTypeUsageValidator.TIME_UNITS[n / 2];
    }

    @Override
    protected void addExtraColumnAttributes(Table table) {
        Map<String, ColumnAttributes> map = this.getColAttributes(table.getName());
        for (Column column : table.getColumns()) {
            DataTypeUsage dataTypeUsage;
            ColumnAttributes columnAttributes = map.get(column.getName());
            if (columnAttributes == null) continue;
            if (ModelUtil.hasLength((String)columnAttributes.getDefault())) {
                column.setDefault((Object)columnAttributes.getDefault());
            }
            if (columnAttributes.isNull()) {
                column.setNotNull(columnAttributes.isNull());
            }
            if ((dataTypeUsage = columnAttributes.getDataTypeUsage()) == null) continue;
            column.setDataTypeUsage(dataTypeUsage);
        }
    }

    @Override
    protected FKConstraint.ReferentialAction getFkOnDeleteAction(short s) {
        FKConstraint.ReferentialAction referentialAction = s == 0 ? FKConstraint.ReferentialAction.CASCADE : FKConstraint.ReferentialAction.NO_ACTION;
        return referentialAction;
    }

    private Map<String, ColumnAttributes> getColAttributes(String string) {
        Object var2_2 = null;
        final HashMap<String, ColumnAttributes> hashMap = new HashMap<String, ColumnAttributes>();
        final JdbcDatabase jdbcDatabase = this.getDatabase();
        final QueryWrapper queryWrapper = new QueryWrapper((Database)jdbcDatabase, "SELECT     sc.colname, coltype, sd.default FROM (syscolumns sc LEFT OUTER JOIN sysdefaults sd on (sd.tabid = sc.tabid and sc.colno = sd.colno)) join systables st on (st.tabid = sc.tabid) where st.tabname = ?", new Object[]{string});
        QueryWrapper.QueryRunnable queryRunnable = new QueryWrapper.QueryRunnable(){

            public void processResultSet(ResultSet resultSet) throws DBException {
                try {
                    while (resultSet.next()) {
                        Object object;
                        String string;
                        ColumnAttributes columnAttributes = new ColumnAttributes();
                        String string2 = resultSet.getString(1);
                        if (ModelUtil.hasLength((String)string2)) {
                            columnAttributes.setName(string2);
                        }
                        if (ModelUtil.hasLength((String)(string = resultSet.getString(2))) && (Integer)(object = new Integer(string)) > 256) {
                            String string3;
                            DataType dataType;
                            if ((Integer)object != 3118 || (Integer)object != 2061) {
                                columnAttributes.setNotNull(true);
                            }
                            if ((Integer)object == 4118 && (dataType = jdbcDatabase.getOrCreateDataType(string3 = jdbcDatabase.normaliseDataTypeName("ROW"))) != null) {
                                columnAttributes.setDataTypeUsage(dataType.createUsage(Collections.singletonMap("name", string3)));
                            }
                        }
                        if (ModelUtil.hasLength((String)(object = resultSet.getString(3)))) {
                            columnAttributes.setDefault((String)object);
                        }
                        hashMap.put(string2, columnAttributes);
                    }
                }
                catch (SQLException sQLException) {
                    queryWrapper.throwDBException(sQLException);
                }
            }
        };
        try {
            queryWrapper.executeQuery(queryRunnable);
        }
        catch (DBException dBException) {
            this.getLogger().log(Level.WARNING, "Couldn't build extra column attributes for {0}: {1}", new String[]{string, dBException.getMessage()});
        }
        return hashMap;
    }

    private class ColumnAttributes {
        private String m_name;
        private String m_default;
        private boolean m_notNull;
        private DataTypeUsage m_dtu;

        private ColumnAttributes() {
        }

        public void setName(String string) {
            this.m_name = string;
        }

        public String getName() {
            return this.m_name;
        }

        public void setDefault(String object) {
            boolean bl = false;
            for (int i = 0; i < ((String)object).length(); ++i) {
                char c = ((String)object).charAt(i);
                if (c != '\u0000') continue;
                bl = true;
                break;
            }
            if (!bl) {
                if (((String)object).indexOf(32) != -1) {
                    object = ((String)object).substring(((String)object).indexOf(32) + 1, ((String)object).length() - 1);
                }
                try {
                    BigDecimal bigDecimal = new BigDecimal(((String)object).trim());
                }
                catch (NumberFormatException numberFormatException) {
                    object = "'" + ((String)object).trim() + "'";
                }
            } else {
                object = "'" + ((String)object).trim() + "'";
            }
            this.m_default = ((String)object).trim();
        }

        public String getDefault() {
            return this.m_default;
        }

        public void setNotNull(boolean bl) {
            this.m_notNull = bl;
        }

        public boolean isNull() {
            return this.m_notNull;
        }

        public void setDataTypeUsage(DataTypeUsage dataTypeUsage) {
            this.m_dtu = dataTypeUsage;
        }

        public DataTypeUsage getDataTypeUsage() {
            return this.m_dtu;
        }
    }
}

