/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.informix;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.InvalidNameException;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeCache;
import oracle.javatools.db.ddl.DDLGenerator;
import oracle.javatools.db.informix.InformixConstraintValidator;
import oracle.javatools.db.informix.InformixDDLGenerator;
import oracle.javatools.db.informix.InformixDatabase;
import oracle.javatools.db.informix.InformixDynamicServer11;
import oracle.javatools.db.informix.InformixDynamicServerImpl;
import oracle.javatools.db.informix.InformixIndexValidator;
import oracle.javatools.db.jdbc.JdbcDatabaseDescriptor;
import oracle.javatools.db.resource.APIBundle;
import oracle.javatools.db.validators.DBObjectValidator;
import oracle.javatools.db.validators.SynonymValidator;

public class InformixDynamicServerDescriptor
extends JdbcDatabaseDescriptor {
    public static final int MAX_NAME_LENGTH = 128;
    public static final char QUOTE_IDENTIFIER = '\"';
    private static final Set RESERVED_WORDS = new HashSet<String>(Arrays.asList("ABSOLUTE", "ACCESS", "ACCESS_METHOD", "ACTIVE", "ADD", "AFTER", "AGGREGATE", "ALIGNMENT", "ALL", "ALL_ROWS", "ALLOCATE", "ALTER", "AND", "ANSI", "ANY", "APPEND", "AS", "ASC", "AT", "ATTACH", "ATTACH", "AUDIT", "AUTHORIZATION", "BEFORE", "BEGIN", "BETWEEN", "BINARY", "BOOLEAN", "BOTH", "BUFFERED", "BUILTIN", "BY", "BYTE", "CACHE", "CALL", "CANNOTHASH", "CARDINALITY", "CASCADE", "CASE", "CAST", "CHAR", "CHAR_LENGTH", "CHARACTER", "CHARACTER_LENGTH", "CHECK", "CLASS", "CLIENT", "CLOSE", "CLUSTER", "CLUSTERSIZE", "COARSE", "COBOL", "CODESET", "COLLATION", "COLLECTION", "COLUMN", "COMMIT", "COMMITTED", "COMMUTATOR", "CONCURRENT", "CONNECT", "CONNECTION", "CONST", "CONSTRAINTS", "CONSTRUCTOR", "CONTINUE", "COPY", "COSTFUNC", "COUNT", "CRCOLS", "CREATE", "CROSS", "CURRENT", "CURSOR", "CYCLE", "DATABASE", "DATAFILES", "DATASKIP", "DATASOURCE", "DATE", "DATETIME", "DAY", "DBA", "DBDATE", "DBMONEY", "DBPASSWORD", "DEALLOCATE", "DEBUG", "DEC", "DEC_T", "DECIMAL", "DECLARE", "DECODE", "DEFAULT", "DEFERRED", "DEFERRED_PREPARE", "DEFINE", "DELAY", "DELETE", "DELIMITER", "DELUXE", "DEREF", "DESC", "DESCRIBE", "DESCRIPTOR", "DETACH", "DIAGNOSTICS", "DIRECTIVES", "DIRTY", "DISABLED", "DISCONNECT", "DISTINCT", "DISTRIBUTEBINARY", "DISTRIBUTESREFERENCES", "DISTRIBUTIONS", "DOCUMENT", "DOMAIN", "DONOTDISTRIBUTE", "DORMANT", "DOUBLE", "DROP", "DTIME_T", "EACH", "ELIF", "ELSE", "ENABLED", "ENCRYPTION", "END", "ENUM", "ENVIRONMENT", "ERROR", "ESCAPE", "EXCEPTION", "EXCLUSIVE", "EXEC", "EXECUTE", "EXECUTEANYWHERE", "EXISTS", "EXIT", "EXPLAIN", "EXPLICIT", "EXPRESS", "EXPRESSION", "EXTEND", "EXTENT", "EXTERNAL", "FALSE", "FAR", "FETCH", "FILE", "FILLFACTOR", "FILTERING", "FIRST", "FIRST_ROWS", "FIXCHAR", "FIXED", "FLOAT", "FLUSH", "FOR", "FOREACH", "FOREIGN", "FORMAT", "FORTRAN", "FOUND", "FRACTION", "FRAGMENT", "FREE", "FROM", "FULL", "FUNCTION", "GENERAL", "GET", "GK", "GLOBAL", "GO", "GOTO", "GRANT", "GROUP", "HANDLESNULLS ", "HASH", "HAVING", "HIGH", "HINT", "HOLD", "HOUR", "HYBRID", "IF", "IFX_INT8_T", "IFX_LO_CREATE_SPEC_T", "IFX_LO_STAT_T", "IMMEDIATE", "IMPLICIT", "IN", "INACTIVE", "INCREMENT", "INDEX", "INDEXES", "INDICATOR", "INFORMIX", "INIT", "INLINE", "INNER", "INOUT", "INSERT", "INSTEAD", "INT", "INT8", "INTEG", "INTEGER", "INTERNAL", "INTERNALLENGTH", "INTERVAL", "INTO", "INTRVL_T", "IS", "ISCANONICAL", "ISOLATION", "ITEM", "ITERATOR", "JOIN", "KEEP", "KEY", "LABELEQ", "LABELGE", "LABELGLB", "LABELGT", "LABELLE", "LABELLT", "LABELLUB", "LABELTOSTRING", "LANGUAGE", "LAST", "LEADING", "LEFT", "LET", "LEVEL", "LIKE", "LIST", "LISTING", "LOAD", "LOC_T", "LOCAL", "LOCATOR", "LOCK", "LOCKS", "LOG", "LONG", "LOW", "LOWER", "LVARCHAR", "MATCHES", "MAX", "MAXERRORS", "MAXLEN", "MAXVALUE", "MDY", "MEDIAN", "MEDIUM", "MEMORY_RESIDENT", "MIDDLE", "MIN", "MINUTE", "MINVALUE", "MODE", "MODERATE", "MODIFY", "MODULE", "MONEY", "MONTH", "MOUNTING", "MULTISET", "NAME", "NCHAR", "NEGATOR", "NEW", "NEXT", "NO", "NOCACHE", "NOCYCLE", "NOMAXVALUE", "NOMIGRATE", "NOMINVALUE", "NON_RESIDENT", "NONE", "NOORDER", "NORMAL", "NOT", "NOTEMPLATEARG", "NULL", "NUMERIC", "NVARCHAR", "NVL", "OCTET_LENGTH", "OF", "OFF", "OLD", "ON", "ONLINE", "ONLY", "OPAQUE", "OPCLASS", "OPEN", "OPERATIONAL", "OPTCOMPIND", "OPTICAL", "OPTIMIZATION", "OPTION", "OR", "ORDER", "OUT", "OUTPUT", "OUTER", "PAGE", "PARALLELIZABLE", "PARAMETER", "PARTITION", "PASCAL", "PASSEDBYVALUE", "PASSWORD", "PDQPRIORITY", "PERCALL_COST", "PLI", "PLOAD", "PRECISION", "PREPARE", "PREVIOUS", "PRIMARY", "PRIOR", "PRIVATE", "PRIVILEGES", "PROCEDURE", "PUBLIC", "PUT", "RAISE", "RANGE", "RAW", "READ", "REAL", "RECORDEND", "REF", "REFERENCES", "REFERENCING", "REGISTER", "REJECTFILE", "RELATIVE", "RELEASE", "REMAINDER", "RENAME", "REOPTIMIZATION", "REPEATABLE", "REPLICATION", "RESERVE", "RESOLUTION", "RESOURCE", "RESTART", "RESTRICT", "RESUME", "RETAIN", "RETURN", "RETURNING", "RETURNS", "REUSE", "REVOKE", "RIGHT", "ROBIN", "ROLE", "ROLLBACK", "ROLLFORWARD", "ROUND", "ROUTINE", "ROW", "ROWID", "ROWIDS", "ROWS", "SAMEAS", "SAMPLES", "SAVE", "SCHEDULE", "SCHEMA", "SCRATCH", "SCROLL", "SECOND", "SECONDARY", "SECTION", "SELCONST", "SELECT", "SELFUNC", "SEQUENCE", "SERIAL", "SERIAL8", "SERIALIZABLE", "SERVERUUID", "SESSION", "SET", "SHARE", "SHORT", "SIGNED", "SIZE", "SKALL", "SKINHIBIT", "SKSHOW", "SMALLFLOAT", "SMALLINT", "SOME", "SPECIFIC", "SQL", "SQLCODE", "SQLCONTEXT", "SQLERROR", "SQLSTATE", "SQLWARNING", "STABILITY", "STACK", "STANDARD", "START", "STATIC", "STATISTICS", "STDEV", "STEP", "STOP", "STORAGE", "STRATEGIES", "STRING", "STRINGTOLABEL", "STRUCT", "STYLE", "SUBSTR", "SUBSTRING", "SUM", "SUPPORT", "SYNC", "SYNONYM", "SYSTEM", "TABLE", "TEMP", "TEMPLATE", "TEST", "TEXT", "THEN", "TIME", "TIMEOUT", "TO", "TODAY", "TRACE", "TRAILING", "TRANSACTION", "TRIGGER", "TRIGGERS", "TRIM", "TRUE", "TRUNCATE", "TYPE", "TYPEDEF", "TYPEID", "TYPENAME", "TYPEOF", "UNCOMMITTED", "UNDER", "UNION", "UNIQUE", "UNITS", "UNKNOWN", "UNLOAD", "UNLOCK", "UNSIGNED", "UPDATE", "UPPER", "USAGE", "USE_SUBQF", "USER", "USING", "VALUE", "VALUES", "VAR", "VARCHAR", "VARIABLE", "VARIANCE", "VARIANT", "VARYING", "VIEW", "VIOLATIONS", "VOID", "VOLATILE", "WAIT", "WARNING", "WHEN", "WHENEVER", "WHERE", "WHILE", "WITH", "WITHOUT", "WORK", "WRITE", "XADATASOURCE", "XID", "XLOAD", "XUNLOAD", "YEAR"));
    private static HashMap s_compatibleTypesMap;

    public InformixDynamicServerDescriptor(Class<? extends InformixDatabase> clazz) {
        super(clazz);
    }

    @Override
    public DDLGenerator getDDLGenerator(DBObjectProvider dBObjectProvider) {
        return new InformixDDLGenerator(this.getDatabaseClass(), dBObjectProvider);
    }

    @Override
    public int getCasePolicy() {
        return 1;
    }

    @Override
    public String getIdentifierQuoteString() {
        return String.valueOf('\"');
    }

    @Override
    public int getMaxNameLength(String string) {
        return 128;
    }

    @Override
    public void validateName(String string, String string2) throws InvalidNameException {
        this.checkInformixDatabaseIdentifier(string2, "_$", RESERVED_WORDS);
    }

    protected void checkInformixDatabaseIdentifier(String string, String string2, Set set) throws InvalidNameException {
        InformixDynamicServerDescriptor.validateIdentifier((String)string, (char)'\"', (int)128, (String)string2, (boolean)false, (Set)set, (int)this.getCasePolicy(), (boolean)this.allowSurrogatesInIdentifierValidation());
        char c = string.charAt(0);
        if (c != '\"' && !Character.isAlphabetic(string.codePointAt(0)) && c != '_') {
            throw new InvalidNameException(null, APIBundle.get((String)"INVALID_IDENTIFIER_ILLEGAL_CHARACTER"));
        }
    }

    @Override
    public Map<String, DBObjectValidator> getValidators(DBObjectProvider dBObjectProvider) {
        Map<String, DBObjectValidator> map = super.getValidators(dBObjectProvider);
        map.put("INDEX", (DBObjectValidator)new InformixIndexValidator(dBObjectProvider));
        map.put("CONSTRAINT", new InformixConstraintValidator(dBObjectProvider));
        map.put("SYNONYM", (DBObjectValidator)new SynonymValidator(dBObjectProvider));
        return map;
    }

    protected boolean isValidFKDataTypeImpl(DataType dataType, DataType dataType2) {
        boolean bl = super.isValidFKDataTypeImpl(dataType, dataType2);
        if (!bl) {
            ArrayList arrayList;
            if (s_compatibleTypesMap == null) {
                InformixDynamicServerDescriptor.initialiseCompatibleTypesMap();
            }
            if ((arrayList = (ArrayList)s_compatibleTypesMap.get(dataType.getName())) != null && arrayList.contains(dataType2.getName())) {
                bl = true;
            }
        }
        return bl;
    }

    private static void initialiseCompatibleTypesMap() {
        s_compatibleTypesMap = new HashMap();
        String[] stringArray = new String[]{"INTEGER", "SERIAL"};
        String[] stringArray2 = new String[]{"INT", "SERIAL"};
        String[] stringArray3 = new String[]{"INT", "INTEGER"};
        String[] stringArray4 = new String[]{"SERIAL8"};
        String[] stringArray5 = new String[]{"INT8"};
        s_compatibleTypesMap.put("INT", new ArrayList<String>(Arrays.asList(stringArray)));
        s_compatibleTypesMap.put("INTEGER", new ArrayList<String>(Arrays.asList(stringArray2)));
        s_compatibleTypesMap.put("SERIAL", new ArrayList<String>(Arrays.asList(stringArray3)));
        s_compatibleTypesMap.put("INT8", new ArrayList<String>(Arrays.asList(stringArray4)));
        s_compatibleTypesMap.put("SERIAL8", new ArrayList<String>(Arrays.asList(stringArray5)));
    }

    @Override
    public String getDatabaseType() {
        return "Informix";
    }

    @Override
    public int getDatabaseVersion() {
        Class clazz = this.getDatabaseClass();
        int n = InformixDynamicServer11.class.isAssignableFrom(clazz) ? 115 : (InformixDynamicServerImpl.class.isAssignableFrom(clazz) ? 100 : 0);
        return n;
    }

    @Override
    public Collection<String> getReservedWords() {
        return RESERVED_WORDS;
    }

    @Override
    protected void registerDataTypes(DataTypeCache dataTypeCache) {
        int n = this.getDatabaseVersion();
        if (n == 0) {
            dataTypeCache.registerDataType("BYTE");
            dataTypeCache.registerDataType("CHAR");
            dataTypeCache.registerDataType("DATE");
            dataTypeCache.registerDataType("DATETIME");
            dataTypeCache.registerDataType("DECIMAL");
            dataTypeCache.registerDataType("DOUBLE PRECISION");
            dataTypeCache.registerDataType("FLOAT");
            dataTypeCache.registerDataType("INT8");
            dataTypeCache.registerDataType("INTEGER");
            dataTypeCache.registerDataType("INTERVAL");
            dataTypeCache.registerDataType("MONEY");
            dataTypeCache.registerDataType("NCHAR");
            dataTypeCache.registerDataType("NVARCHAR");
            dataTypeCache.registerDataType("SERIAL");
            dataTypeCache.registerDataType("SERIAL8");
            dataTypeCache.registerDataType("SMALLFLOAT");
            dataTypeCache.registerDataType("SMALLINT");
            dataTypeCache.registerDataType("TEXT");
            dataTypeCache.registerDataType("VARCHAR");
            dataTypeCache.registerDataTypeSynonym("CHARACTER", "CHAR");
            dataTypeCache.registerDataTypeSynonym("CHARACTER VARYING", "VARCHAR");
            dataTypeCache.registerDataTypeSynonym("DEC", "DECIMAL");
            dataTypeCache.registerDataTypeSynonym("INT", "INTEGER");
            dataTypeCache.registerDataTypeSynonym("NUMERIC", "DECIMAL");
            dataTypeCache.registerDataTypeSynonym("REAL", "SMALLFLOAT");
        } else if (n == 100) {
            dataTypeCache.registerDataType("BLOB");
            dataTypeCache.registerDataType("BOOLEAN");
            dataTypeCache.registerDataType("CLOB");
            dataTypeCache.registerDataType("LVARCHAR");
            dataTypeCache.registerDataType("NVARCHAR");
            dataTypeCache.registerDataType("VARCHAR");
        }
    }
}

