/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.db2;

import oracle.javatools.db.Column;
import oracle.javatools.db.Constraint;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Relation;
import oracle.javatools.db.UniqueConstraint;
import oracle.javatools.db.resource.APIBundle;
import oracle.javatools.db.validators.ColumnValidator;
import oracle.javatools.db.validators.DBObjectValidator;
import oracle.javatools.db.validators.ValidationException;
import oracle.javatools.db.validators.ValidationLevel;

public class DB2ColumnValidator
extends ColumnValidator {
    public DB2ColumnValidator(DBObjectProvider dBObjectProvider) {
        super(dBObjectProvider, true);
    }

    @Override
    @DBObjectValidator.PropertyValidator(value={"notNull"}, level=ValidationLevel.FULL)
    public void validateNotNull(Column column, Column column2) throws ValidationException {
        super.validateNotNull(column, column2);
        if (!column2.isNotNull()) {
            Relation relation = column2.getRelation();
            DBObjectID dBObjectID = column2.getID();
            if (relation != null) {
                for (Constraint constraint : relation.getConstraints()) {
                    UniqueConstraint uniqueConstraint;
                    if (!(constraint instanceof UniqueConstraint) || !(uniqueConstraint = (UniqueConstraint)constraint).isEnabled()) continue;
                    for (DBObjectID dBObjectID2 : uniqueConstraint.getColumnIDs()) {
                        if (!dBObjectID2.equals(dBObjectID)) continue;
                        throw new ValidationException((DBObject)column2, APIBundle.format((String)"UK_ERROR_NOT_NULL_COL", (Object[])new Object[]{column2.getName()}));
                    }
                }
            }
        }
    }
}

