/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.SQLServer;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DatabaseDescriptor;
import oracle.javatools.db.InvalidNameException;
import oracle.javatools.db.SQLServer.SQLServer2005;
import oracle.javatools.db.SQLServer.SQLServer2008;
import oracle.javatools.db.SQLServer.SQLServer2012;
import oracle.javatools.db.SQLServer.SQLServerDDLGenerator;
import oracle.javatools.db.SQLServer.SQLServerDatabase;
import oracle.javatools.db.datatypes.DataTypeCache;
import oracle.javatools.db.ddl.DDLGenerator;
import oracle.javatools.db.jdbc.JdbcDatabaseDescriptor;
import oracle.javatools.db.resource.APIBundle;
import oracle.javatools.db.validators.ColumnValidator;
import oracle.javatools.db.validators.DBObjectValidator;
import oracle.javatools.db.validators.SynonymValidator;

public class SQLServerDatabaseDescriptor
extends JdbcDatabaseDescriptor {
    public static final int MAX_NAME_LENGTH = 128;
    public static final int MAX_TEMP_NAME_LENGTH = 116;
    public static final char QUOTE_IDENTIFIER = '\"';
    public static final char OPEN_QUOTE_IDENTIFIER = '[';
    public static final char CLOSE_QUOTE_IDENTIFIER = ']';
    private static final Set RESERVED_WORDS = new HashSet<String>(Arrays.asList("ADD", "ALL", "ALTER", "AND", "ANY", "AS", "ASC", "AUTHORIZATION", "BACKUP", "BEGIN", "BETWEEN", "BREAK", "BROWSE", "BULK", "BY", "CASCADE", "CASE", "CHECK", "CHECKPOINT", "CLOSE", "CLUSTERED", "COALESCE", "COLLATE", "COLUMN", "COMMIT", "COMPUTE", "CONSTRAINT", "CONTAINS", "CONTAINSTABLE", "CONTINUE", "CONVERT", "CREATE", "CROSS", "CURRENT", "CURRENT_DATE", "CURRENT_TIME", "CURRENT_TIMESTAMP", "CURRENT_USER", "CURSOR", "DATABASE", "DBCC", "DEALLOCATE", "DECLARE", "DEFAULT", "DELETE", "DENY", "DESC", "DISK", "DISTINCT", "DISTRIBUTED", "DOUBLE", "DROP", "DUMMY", "DUMP", "ELSE", "END", "ERRLVL", "ESCAPE", "EXCEPT", "EXEC", "EXECUTE", "EXISTS", "EXIT", "FETCH", "FILE", "FILLFACTOR", "FOR", "FOREIGN", "FREETEXT", "FREETEXTTABLE", "FROM", "FULL", "FUNCTION", "GOTO", "GRANT", "GROUP", "HAVING", "HOLDLOCK", "IDENTITY", "IDENTITY_INSERT", "IDENTITYCOL", "IF", "IN", "INDEX", "INNER", "INSERT", "INTERSECT", "INTO", "IS", "JOIN", "KEY", "KILL", "LEFT", "LIKE", "LINENO", "LOAD", "NATIONAL", "NOCHECK", "NONCLUSTERED", "NOT", "NULL", "NULLIF", "OF", "OFF", "OFFSETS", "ON", "OPEN", "OPENDATASOURCE", "OPENQUERY", "OPENROWSET", "OPENXML", "OPTION", "OR", "ORDER", "OUTER", "OVER", "PERCENT", "PLAN", "PRECISION", "PRIMARY", "PRINT", "PROC", "PROCEDURE", "PUBLIC", "RAISERROR", "READ", "READTEXT", "RECONFIGURE", "REFERENCES", "REPLICATION", "RESTORE", "RESTRICT", "RETURN", "REVOKE", "RIGHT", "ROLLBACK", "ROWCOUNT", "ROWGUIDCOL", "RULE", "SAVE", "SCHEMA", "SELECT", "SESION_USER", "SET", "SETUSER", "SHUTDOWN", "SOME", "STATISTICS", "SYSTEM_USER", "TABLE", "TEXTSIZE", "THEN", "TO", "TOP", "TRAN", "TRANSACTION", "TRIGGER", "TRUNCATE", "TSEQUAL", "UNION", "UNIQUE", "UPDATE", "UPDATETEXT", "USE", "USER", "VALUES", "VARYING", "VIEW", "WAITFOR", "WHEN", "WHERE", "WHILE", "WITH", "WRITETEXT"));

    public SQLServerDatabaseDescriptor(Class<? extends SQLServerDatabase> clazz) {
        super(clazz);
    }

    @Override
    public boolean isCompatibleWith(DatabaseDescriptor databaseDescriptor) {
        if (databaseDescriptor instanceof SQLServerDatabaseDescriptor) {
            int n = databaseDescriptor.getDatabaseVersion();
            int n2 = this.getDatabaseVersion();
            if (n == 100 && n2 == 110 || n == 110 && n2 == 100) {
                return true;
            }
        }
        return super.isCompatibleWith(databaseDescriptor);
    }

    @Override
    public int getCasePolicy() {
        return 0;
    }

    @Override
    public String getIdentifierQuoteString() {
        return String.valueOf('\"');
    }

    @Override
    public int getMaxNameLength(String string) {
        return 128;
    }

    @Override
    public void validateName(String string, String string2) throws InvalidNameException {
        boolean bl = true;
        String string3 = "";
        try {
            SQLServerDatabaseDescriptor.validateIdentifier((String)string2, (char)'\"', (int)128, (String)"_$#@", (boolean)false, (Set)RESERVED_WORDS, (int)this.getCasePolicy(), (boolean)this.allowSurrogatesInIdentifierValidation());
        }
        catch (InvalidNameException invalidNameException) {
            bl = false;
            string3 = invalidNameException.getMessage();
        }
        int n = bl ? (int)string2.charAt(0) : 48;
        int n2 = string2.codePointCount(0, string2.length());
        if (bl && n != 34 && !Character.isAlphabetic(string2.codePointAt(0)) && n != 95 && n != 35 && n != 64) {
            throw new InvalidNameException(null, APIBundle.get((String)"INVALID_IDENTIFIER_ILLEGAL_CHARACTER"));
        }
        if (!bl && n == 91 && string2.indexOf(91, 1) == -1 && string2.indexOf(93, 1) == string2.length() - 1 && n2 > 2 && n2 < 131) {
            bl = true;
        }
        if (!bl) {
            throw new InvalidNameException(null, string3);
        }
    }

    @Override
    public Map<String, DBObjectValidator> getValidators(DBObjectProvider dBObjectProvider) {
        Map<String, DBObjectValidator> map = super.getValidators(dBObjectProvider);
        map.put("COLUMN", new ColumnValidator(dBObjectProvider, true));
        map.put("SYNONYM", (DBObjectValidator)new SynonymValidator(dBObjectProvider));
        return map;
    }

    @Override
    public DDLGenerator getDDLGenerator(DBObjectProvider dBObjectProvider) {
        return new SQLServerDDLGenerator(this.getDatabaseClass(), dBObjectProvider);
    }

    @Override
    public String getDatabaseType() {
        return "SQLServer";
    }

    @Override
    public int getDatabaseVersion() {
        int n = 80;
        Class clazz = this.getDatabaseClass();
        if (SQLServer2012.class.isAssignableFrom(clazz)) {
            n = 110;
        } else if (SQLServer2008.class.isAssignableFrom(clazz)) {
            n = 100;
        } else if (SQLServer2005.class.isAssignableFrom(clazz)) {
            n = 90;
        }
        return n;
    }

    @Override
    public Collection<String> getReservedWords() {
        return RESERVED_WORDS;
    }

    @Override
    protected void registerDataTypes(DataTypeCache dataTypeCache) {
        int n = this.getDatabaseVersion();
        if (n == 100) {
            dataTypeCache.registerDataType("DATE");
            dataTypeCache.registerDataType("DATETIME2");
            dataTypeCache.registerDataType("DATETIMEOFFSET");
            dataTypeCache.registerDataType("GEOGRAPHY");
            dataTypeCache.registerDataType("GEOMETRY");
            dataTypeCache.registerDataType("HIERARCHYID");
            dataTypeCache.registerDataType("TIME");
        } else if (n == 90) {
            dataTypeCache.registerDataType("XML");
        } else if (n == 80) {
            dataTypeCache.registerDataType("BIGINT");
            dataTypeCache.registerDataType("BINARY");
            dataTypeCache.registerDataType("BIT");
            dataTypeCache.registerDataType("CHAR");
            dataTypeCache.registerDataType("DATETIME");
            dataTypeCache.registerDataType("DECIMAL");
            dataTypeCache.registerDataType("FLOAT");
            dataTypeCache.registerDataType("IMAGE");
            dataTypeCache.registerDataType("INT");
            dataTypeCache.registerDataType("MONEY");
            dataTypeCache.registerDataType("NCHAR");
            dataTypeCache.registerDataType("NTEXT");
            dataTypeCache.registerDataType("NUMERIC");
            dataTypeCache.registerDataType("NVARCHAR");
            dataTypeCache.registerDataType("REAL");
            dataTypeCache.registerDataType("SMALLDATETIME");
            dataTypeCache.registerDataType("SMALLINT");
            dataTypeCache.registerDataType("SMALLMONEY");
            dataTypeCache.registerDataType("SQL_VARIANT");
            dataTypeCache.registerDataType("SYSNAME");
            dataTypeCache.registerDataType("TEXT");
            dataTypeCache.registerDataType("TIMESTAMP");
            dataTypeCache.registerDataType("TINYINT");
            dataTypeCache.registerDataType("UNIQUEIDENTIFIER");
            dataTypeCache.registerDataType("VARBINARY");
            dataTypeCache.registerDataType("VARCHAR");
            dataTypeCache.registerDataTypeSynonym("BINARY VARYING", "VARBINARY");
            dataTypeCache.registerDataTypeSynonym("CHAR VARYING", "VARCHAR");
            dataTypeCache.registerDataTypeSynonym("CHARACTER", "CHAR");
            dataTypeCache.registerDataTypeSynonym("CHARACTER VARYING", "VARCHAR");
            dataTypeCache.registerDataTypeSynonym("DEC", "DECIMAL");
            dataTypeCache.registerDataTypeSynonym("INTEGER", "INT");
            dataTypeCache.registerDataTypeSynonym("NATIONAL CHAR", "NCHAR");
            dataTypeCache.registerDataTypeSynonym("NATIONAL CHARACTER", "NCHAR");
            dataTypeCache.registerDataTypeSynonym("NATIONAL CHAR VARYING", "NVARCHAR");
            dataTypeCache.registerDataTypeSynonym("NATIONAL CHARACTER VARYING", "NVARCHAR");
            dataTypeCache.registerDataTypeSynonym("NATIONAL TEXT", "NTEXT");
            dataTypeCache.registerDataTypeSynonym("ROWVERSION", "TIMESTAMP");
        }
    }
}

