/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.graphlayout.uniformlengthedges;

import ilog.views.graphlayout.IlvGraphLayoutException;
import ilog.views.graphlayout.IlvGraphLayoutReport;
import ilog.views.graphlayout.internalutil.LogResUtil;
import ilog.views.graphlayout.internalutil.genericgrapher.IlvAbstractGraph;
import ilog.views.graphlayout.internalutil.genericgrapher.IlvAbstractLink;
import ilog.views.graphlayout.internalutil.genericgrapher.IlvAbstractNode;
import ilog.views.graphlayout.uniformlengthedges.IlvGraphCoarseningAlgo;
import ilog.views.graphlayout.uniformlengthedges.IlvSolarSystemNode;
import ilog.views.graphlayout.uniformlengthedges.IlvULEAlgorithm;
import ilog.views.graphlayout.uniformlengthedges.IlvUniformLengthEdgesLayout;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Random;

final class IlvMultipoleULELayout
extends IlvUniformLengthEdgesLayout {
    private IlvUniformLengthEdgesLayout a;
    private IlvAbstractGraph b;
    private IlvMultipoleULEAlgorithm c;
    private static final int d = 1;
    private static final float e = 1.5f;
    private static final boolean f = false;

    IlvMultipoleULELayout(IlvUniformLengthEdgesLayout ilvUniformLengthEdgesLayout) {
        if (ilvUniformLengthEdgesLayout == null) {
            LogResUtil.logAndThrowIllegalArgExc(IlvUniformLengthEdgesLayout.class, "graphlayout.expert.message.6762E");
        }
        this.a = ilvUniformLengthEdgesLayout;
    }

    @Override
    IlvULEAlgorithm c() {
        this.c = new IlvMultipoleULEAlgorithm(this);
        return this.c;
    }

    void b(boolean bl) {
        this.c.d = bl;
    }

    @Override
    public boolean isFixed(Object object) {
        if (object instanceof IlvAbstractNode) {
            object = ((IlvAbstractNode)object).getOriginalObject();
        }
        return this.a.isFixed(object);
    }

    @Override
    public float getPreferredLength(Object object) {
        if (object instanceof IlvAbstractLink && (object = ((IlvAbstractLink)object).getOriginalObject()) == null) {
            return -1.0f;
        }
        return this.a.getPreferredLength(object);
    }

    public IlvGraphLayoutReport performLayout(IlvAbstractGraph ilvAbstractGraph, boolean bl, boolean bl2) throws IlvGraphLayoutException {
        this.b = ilvAbstractGraph;
        return super.performLayout(true, bl2);
    }

    private static class IlvMultipoleULEAlgorithm
    extends IlvULEAlgorithm {
        private ArrayList[] a;
        private float[] b;
        private float[] c;
        private boolean d = false;

        public IlvMultipoleULEAlgorithm(IlvMultipoleULELayout ilvMultipoleULELayout) {
            super(ilvMultipoleULELayout);
        }

        @Override
        public void detach() {
            this.b = null;
            this.c = null;
            super.detach();
        }

        @Override
        protected void initializeDataStructures() throws IlvGraphLayoutException {
            super.initializeDataStructures();
            if (!this.d) {
                int n = this._topologicalData.getNumberOfNodes();
                if (this.b == null || n != this.b.length) {
                    this.b = new float[n];
                    this.c = new float[n];
                } else {
                    for (int i = 0; i < n; ++i) {
                        this.b[i] = 0.0f;
                        this.c[i] = 0.0f;
                    }
                }
            }
        }

        @Override
        public void init() throws IlvGraphLayoutException {
            IlvMultipoleULELayout ilvMultipoleULELayout;
            IlvAbstractGraph ilvAbstractGraph;
            super.init();
            if (!this.d && (ilvAbstractGraph = (ilvMultipoleULELayout = (IlvMultipoleULELayout)this.getOriginalUle()).b) != null) {
                this.a(ilvAbstractGraph);
            }
        }

        @Override
        protected void clean() {
            super.clean();
            this.a = null;
        }

        @Override
        protected int getPreprocessingMode() {
            return 12;
        }

        @Override
        protected void doLayout(boolean bl) throws IlvGraphLayoutException {
            if (!this.d) {
                this._positionData.rescale(1.5f);
            }
            try {
                super.doLayout(bl);
            }
            finally {
                this.d = false;
            }
        }

        private void a(IlvAbstractGraph ilvAbstractGraph) {
            int n = ilvAbstractGraph.getNodesCount();
            int n2 = ilvAbstractGraph.getLinksCount();
            int n3 = this._ule.getGraphModel().getNodesCount();
            if (n2 < 3 || n < 3) {
                this.a = null;
                return;
            }
            ArrayList arrayList = null;
            this.a = new ArrayList[n2];
            int n4 = 0;
            Enumeration enumeration = ilvAbstractGraph.getLinks();
            while (enumeration.hasMoreElements()) {
                IlvAbstractLink ilvAbstractLink = (IlvAbstractLink)enumeration.nextElement();
                arrayList = new ArrayList();
                this.a[n4++] = arrayList;
                this.a(arrayList, ilvAbstractGraph.getFrom(ilvAbstractLink));
                this.a(arrayList, ilvAbstractGraph.getTo(ilvAbstractLink));
                if (!((double)arrayList.size() > (double)n3 * 0.3)) continue;
                this.a = null;
                return;
            }
        }

        private void a(ArrayList arrayList, IlvAbstractNode ilvAbstractNode) {
            IlvAbstractNode ilvAbstractNode2 = (IlvAbstractNode)ilvAbstractNode.getTargetObject();
            int n = this._layoutData.getIntIdentifier(ilvAbstractNode2);
            arrayList.add(n);
            ArrayList arrayList2 = IlvGraphCoarseningAlgo.getPlanets(ilvAbstractNode2);
            if (arrayList2 != null) {
                for (Object e : arrayList2) {
                    IlvSolarSystemNode ilvSolarSystemNode = (IlvSolarSystemNode)e;
                    n = this._layoutData.getIntIdentifier(ilvSolarSystemNode);
                    arrayList.add(n);
                    ArrayList arrayList3 = IlvGraphCoarseningAlgo.getMoons(ilvSolarSystemNode);
                    if (arrayList3 == null) continue;
                    for (Object e2 : arrayList3) {
                        IlvSolarSystemNode ilvSolarSystemNode2 = (IlvSolarSystemNode)e2;
                        n = this._layoutData.getIntIdentifier(ilvSolarSystemNode2);
                        arrayList.add(n);
                    }
                }
            }
        }

        @Override
        protected void computeNodeForces(float f, float f2, float f3, boolean bl, Random random) {
            int n;
            if (this.a == null || this.d) {
                super.computeNodeForces(f, f2, f3, bl, random);
                return;
            }
            float f4 = 0.0f;
            float f5 = 0.0f;
            float f6 = 0.0f;
            float f7 = 0.0f;
            float f8 = 0.0f;
            float f9 = 0.0f;
            float f10 = f2 / 3.0f;
            float f11 = f;
            float f12 = f3 * 2.0f;
            int n2 = this._topologicalData.getNumberOfNodes();
            for (n = 0; n < n2; ++n) {
                this.b[n] = 0.0f;
                this.c[n] = 0.0f;
            }
            float[] fArray = this._positionData.getVectNodesPositionX();
            float[] fArray2 = this._positionData.getVectNodesPositionY();
            for (ArrayList arrayList : this.a) {
                int n3 = arrayList != null ? arrayList.size() : 0;
                for (int i = 0; i < n3; ++i) {
                    n = (Integer)arrayList.get(i);
                    f6 = this.b[n];
                    f7 = this.c[n];
                    for (int j = 0; j < n3; ++j) {
                        int n4 = (Integer)arrayList.get(j);
                        if (n == n4) continue;
                        f4 = fArray[n] - fArray[n4];
                        f5 = fArray2[n] - fArray2[n4];
                        double d = f4 * f4 + f5 * f5;
                        if (f10 > 0.0f) {
                            double d2 = Math.sqrt(d);
                            double d3 = d2 = d2 == 0.0 ? 1.0E-4 : d2;
                            if (bl) {
                                f11 = f + this._vectHalfNodeDiag[n] + this._vectHalfNodeDiag[n4];
                            }
                            if (d2 < (double)f11) {
                                float f13 = (float)((double)f10 * (((double)f11 - d2) / d2));
                                f8 = f13 * f4;
                                f9 = f13 * f5;
                                int n5 = n;
                                this._vectNodesDx[n5] = this._vectNodesDx[n5] + f8;
                                int n6 = n;
                                this._vectNodesDy[n6] = this._vectNodesDy[n6] + f9;
                                int n7 = n4;
                                this._vectNodesDx[n7] = this._vectNodesDx[n7] - f8;
                                int n8 = n4;
                                this._vectNodesDy[n8] = this._vectNodesDy[n8] - f9;
                            }
                        }
                        if (d <= (double)1.0E-20f) {
                            f6 += this.getRandomValue(f12, random);
                            f7 += this.getRandomValue(f12, random);
                            f6 += f4 / 3.0f;
                            f7 += f5 / 3.0f;
                        } else {
                            f6 = (float)((double)f6 + (double)f4 / d);
                            f7 = (float)((double)f7 + (double)f5 / d);
                        }
                        this.b[n] = f6;
                        this.c[n] = f7;
                    }
                }
            }
            for (n = 0; n < n2; ++n) {
                f6 = this.b[n];
                f7 = this.c[n];
                double d = f6 * f6 + f7 * f7;
                if (d <= (double)1.0E-20f) {
                    int n9 = n;
                    this._vectNodesDx[n9] = this._vectNodesDx[n9] + this.getRandomValue(f12, random);
                    int n10 = n;
                    this._vectNodesDy[n10] = this._vectNodesDy[n10] + this.getRandomValue(f12, random);
                    continue;
                }
                if (!((d = Math.sqrt(d) / 2.0) > (double)1.0E-20f)) continue;
                int n11 = n;
                this._vectNodesDx[n11] = (float)((double)this._vectNodesDx[n11] + (double)f6 / d);
                int n12 = n;
                this._vectNodesDy[n12] = (float)((double)this._vectNodesDy[n12] + (double)f7 / d);
            }
            this._ule.callLayoutStepPerformedIfNeeded();
        }
    }
}

