/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.graphlayout.hierarchical;

import ilog.views.graphlayout.hierarchical.AnchorPointOptimization;
import ilog.views.graphlayout.hierarchical.HGraph;
import ilog.views.graphlayout.hierarchical.HGraphAlgorithm;
import ilog.views.graphlayout.hierarchical.HLevel;
import ilog.views.graphlayout.hierarchical.HLink;
import ilog.views.graphlayout.hierarchical.HNode;
import ilog.views.graphlayout.hierarchical.HNodeIterator;
import ilog.views.graphlayout.hierarchical.HNodeSelfLinkInfo;
import ilog.views.graphlayout.hierarchical.HSegment;
import ilog.views.graphlayout.hierarchical.HSegmentIterator;
import ilog.views.graphlayout.hierarchical.IlvHierarchicalLayout;
import ilog.views.graphlayout.internalutil.LayoutUtil;
import ilog.views.graphlayout.internalutil.LogResUtil;
import java.util.ArrayList;

final class CalcConnectors
extends HGraphAlgorithm {
    private AnchorPointOptimization a;
    private int b;
    private int c;
    private int d;
    private float e;
    private HNode f;
    private HSegment g;

    CalcConnectors(HGraph hGraph) {
        super.init(hGraph);
        this.a = new AnchorPointOptimization(hGraph);
        this.b = hGraph.a3();
        this.c = hGraph.a4();
        this.d = hGraph.a6();
    }

    @Override
    void a() {
        super.a();
        if (this.a != null) {
            this.a.a();
        }
        this.a = null;
    }

    @Override
    public void run() {
        HGraph hGraph = this.getGraph();
        float f = this.e().ac[12];
        int n = 2 * hGraph.getNumberOfNodes();
        this.d().startStep(f, n, false);
        switch (this.d) {
            case 99: {
                this.calcCenteredConnectors();
                break;
            }
            case 100: {
                this.calcClippedConnectors();
                break;
            }
            case 101: {
                this.calcEvenSpacedConnectors();
                break;
            }
            default: {
                LogResUtil.logAndThrowRuntimeExc(IlvHierarchicalLayout.class, "graphlayout.expert.message.6402E");
            }
        }
    }

    public void fixEastWestPorts() {
        HGraph hGraph = this.getGraph();
        int n = hGraph.getNumberOfNodes();
        float f = this.e().ac[19];
        this.d().startStep(f, 2 * n, false);
        HNodeIterator hNodeIterator = hGraph.aa();
        while (hNodeIterator.hasNext()) {
            HNode hNode = hNodeIterator.next();
            HNode hNode2 = hNode.ax();
            if (hNode2 != null) {
                this.a(hNode, hNode2);
            }
            if ((hNode2 = hNode.az()) != null) {
                this.a(hNode, hNode2);
            }
            this.d().addPoints(1);
            this.f();
        }
    }

    private void a(HNode hNode, HNode hNode2) {
        switch (this.d) {
            case 99: {
                this.b(hNode, hNode2);
                break;
            }
            case 100: {
                this.c(hNode, hNode2);
                break;
            }
            case 101: {
                this.c(hNode, hNode2);
                break;
            }
            default: {
                LogResUtil.logAndThrowRuntimeExc(IlvHierarchicalLayout.class, "graphlayout.expert.message.6402E");
            }
        }
    }

    public final void calcCenteredConnectors() {
        this.calcNorthSouthPortConnectors();
        this.calcEastWestAuxPortNodeConnectors();
        HNodeIterator hNodeIterator = this.getGraph().aa();
        while (hNodeIterator.hasNext()) {
            this.b(hNodeIterator.next());
            this.d().addPoints(1);
            this.f();
        }
    }

    private final void b(HNode hNode) {
        HSegmentIterator hSegmentIterator = hNode.c(true, true, false, false);
        while (hSegmentIterator.hasNext()) {
            HLink hLink = hSegmentIterator.next().e();
            if (hLink.ac() == hNode) {
                this.calcCenteredConnectorsFromSide(hLink);
            }
            if (hLink.ad() != hNode) continue;
            this.calcCenteredConnectorsToSide(hLink);
        }
    }

    public final void calcCenteredConnectorsFromSide(HLink hLink) {
        if (!hLink.ac().a0()) {
            if (hLink.as()) {
                hLink.aw();
            } else if (!hLink.ag()) {
                this.a(hLink, hLink.am());
            }
        }
    }

    public final void calcCenteredConnectorsToSide(HLink hLink) {
        if (!hLink.ad().a0()) {
            if (hLink.at()) {
                hLink.ax();
            } else if (!hLink.ah()) {
                this.b(hLink, hLink.an());
            }
        }
    }

    private final void a(HLink hLink, int n) {
        HNode hNode;
        float f;
        float f2;
        HSegment hSegment = hLink.u();
        HNode hNode2 = hSegment.a();
        HNode hNode3 = hSegment.b();
        int n2 = this.a(hSegment, n);
        int n3 = 1 - n2;
        if (hSegment.ac()) {
            f2 = hNode3.a(n2);
            f = hNode2.a(n2);
            hNode = hNode3;
        } else {
            f2 = hNode2.a(n2);
            f = hNode3.a(n2);
            hNode = hNode2;
        }
        if (n == 1 || n == 0) {
            hLink.a(n2, f2);
        } else if (n == 3 || n == 2) {
            hLink.a(n2, f2 + hNode.c(n2));
        } else if (f2 > f) {
            hLink.a(n2, f2);
        } else {
            hLink.a(n2, f2 + hNode.c(n2));
        }
        hLink.a(n3, hNode.b(n3));
    }

    private final void b(HLink hLink, int n) {
        HNode hNode;
        float f;
        float f2;
        HSegment hSegment = hLink.v();
        HNode hNode2 = hSegment.b();
        HNode hNode3 = hSegment.a();
        int n2 = this.a(hSegment, n);
        int n3 = 1 - n2;
        if (hSegment.ac()) {
            f2 = hNode3.a(n2);
            f = hNode2.a(n2);
            hNode = hNode3;
        } else {
            f2 = hNode2.a(n2);
            f = hNode3.a(n2);
            hNode = hNode2;
        }
        if (n == 1 || n == 0) {
            hLink.b(n2, f2);
        } else if (n == 3 || n == 2) {
            hLink.b(n2, f2 + hNode.c(n2));
        } else if (f2 > f) {
            hLink.b(n2, f2);
        } else {
            hLink.b(n2, f2 + hNode.c(n2));
        }
        hLink.b(n3, hNode.b(n3));
    }

    private final void b(HNode hNode, HNode hNode2) {
        if (hNode.a6() == null) {
            return;
        }
        if (hNode.u()) {
            return;
        }
        hNode2.a8();
        boolean bl = hNode.an() < hNode2.an();
        float f = hNode.a(this.b);
        float f2 = hNode.b(this.c);
        float f3 = hNode.a(this.c);
        if (bl) {
            f += hNode.c(this.b);
        }
        float[] fArray = bl ? hNode.a6().b(1) : hNode.a6().b(3);
        this.g(hNode2);
        HSegmentIterator hSegmentIterator = hNode2.b(true, true, false, false);
        while (hSegmentIterator.hasNext()) {
            this.b(hSegmentIterator.next(), f, f2, f3, fArray);
        }
        hSegmentIterator = hNode2.a(true, true, false, false);
        while (hSegmentIterator.hasNext()) {
            this.a(hSegmentIterator.next(), f, f2, f3, fArray);
        }
    }

    private final int a(HSegment hSegment, int n) {
        if (n == 1 || n == 3 || n == -3) {
            return this.b;
        }
        if (n == 0 || n == 2 || n == -2) {
            return this.c;
        }
        if (hSegment.s() == 0) {
            return this.b;
        }
        return this.c;
    }

    public final void calcClippedConnectors() {
        this.calcNorthSouthPortConnectors();
        this.calcEastWestAuxPortNodeConnectors();
        HNodeIterator hNodeIterator = this.getGraph().aa();
        while (hNodeIterator.hasNext()) {
            this.calcClippedConnectors(hNodeIterator.next());
            this.d().addPoints(1);
            this.f();
        }
    }

    public final void calcClippedConnectors(HNode hNode) {
        HLink hLink;
        HSegment hSegment;
        if (hNode.u()) {
            return;
        }
        if (hNode.a0()) {
            return;
        }
        HSegmentIterator hSegmentIterator = hNode.a(true, true, false, false);
        while (hSegmentIterator.hasNext()) {
            hSegment = hSegmentIterator.next();
            hLink = hSegment.e();
            if (hLink.ac() == hNode) {
                this.calcFromClippedConnector(hLink);
            }
            if (hLink.ad() != hNode) continue;
            this.calcToClippedConnector(hLink);
        }
        hSegmentIterator = hNode.b(true, true, false, false);
        while (hSegmentIterator.hasNext()) {
            hSegment = hSegmentIterator.next();
            hLink = hSegment.e();
            if (hLink.ac() == hNode) {
                this.calcFromClippedConnector(hLink);
            }
            if (hLink.ad() != hNode) continue;
            this.calcToClippedConnector(hLink);
        }
    }

    public final void calcClippedConnectors(HLink hLink) {
        this.calcFromClippedConnector(hLink);
        this.calcToClippedConnector(hLink);
    }

    public final void calcClippedConnectorAtNode(HLink hLink, HNode hNode) {
        if (hLink.ac() == hNode) {
            this.calcFromClippedConnector(hLink);
        }
        if (hLink.ad() == hNode) {
            this.calcToClippedConnector(hLink);
        }
    }

    public final void calcFromClippedConnector(HLink hLink) {
        if (!hLink.ac().a0()) {
            if (hLink.as()) {
                hLink.aw();
            } else if (!hLink.ag()) {
                this.a(hLink);
            }
        }
    }

    public final void calcToClippedConnector(HLink hLink) {
        if (!hLink.ad().a0()) {
            if (hLink.at()) {
                hLink.ax();
            } else if (!hLink.ah()) {
                this.b(hLink);
            }
        }
    }

    private final void a(HLink hLink) {
        float[] fArray;
        int n;
        HNode hNode;
        HNode hNode2;
        HGraph hGraph = this.getGraph();
        double[] dArray = new double[2];
        double[] dArray2 = new double[2];
        double[] dArray3 = new double[4];
        HSegment hSegment = hLink.u();
        if (hSegment.ac()) {
            hNode2 = hSegment.b();
            hNode = hSegment.a();
        } else {
            hNode2 = hSegment.a();
            hNode = hSegment.b();
        }
        if (hNode2.ah()) {
            return;
        }
        while (hNode.ah()) {
            hSegment = hNode.d(hSegment);
            hNode = hSegment.a(hNode);
        }
        if (hSegment.a() == hNode) {
            n = hSegment.x();
            fArray = hSegment.f();
        } else {
            n = hSegment.y();
            fArray = hSegment.g();
        }
        if (n == -1) {
            dArray2[0] = hNode.b(0);
            dArray2[1] = hNode.b(1);
        } else {
            dArray2[0] = fArray[0];
            dArray2[1] = fArray[1];
        }
        if (hNode.getOwnerGraph() != hGraph) {
            dArray2[0] = hGraph.a(hNode, (float)dArray2[0], 0);
            dArray2[1] = hGraph.a(hNode, (float)dArray2[1], 1);
        }
        dArray[0] = hNode2.b(0);
        dArray[1] = hNode2.b(1);
        dArray3[0] = hNode2.x();
        dArray3[1] = hNode2.x() + hNode2.z();
        dArray3[2] = hNode2.y();
        dArray3[3] = hNode2.y() + hNode2.aa();
        LayoutUtil.Clip(dArray, dArray2, dArray3);
        hLink.a(0, (float)dArray[0]);
        hLink.a(1, (float)dArray[1]);
    }

    private final void b(HLink hLink) {
        float[] fArray;
        int n;
        HNode hNode;
        HNode hNode2;
        HGraph hGraph = this.getGraph();
        double[] dArray = new double[2];
        double[] dArray2 = new double[2];
        double[] dArray3 = new double[4];
        HSegment hSegment = hLink.v();
        if (hSegment.ac()) {
            hNode2 = hSegment.a();
            hNode = hSegment.b();
        } else {
            hNode2 = hSegment.b();
            hNode = hSegment.a();
        }
        if (hNode2.ah()) {
            return;
        }
        while (hNode.ah()) {
            hSegment = hNode.d(hSegment);
            hNode = hSegment.a(hNode);
        }
        if (hSegment.a() == hNode) {
            n = hSegment.x();
            fArray = hSegment.f();
        } else {
            n = hSegment.y();
            fArray = hSegment.g();
        }
        if (n == -1) {
            dArray2[0] = hNode.b(0);
            dArray2[1] = hNode.b(1);
        } else {
            dArray2[0] = fArray[0];
            dArray2[1] = fArray[1];
        }
        if (hNode.getOwnerGraph() != hGraph) {
            dArray2[0] = hGraph.a(hNode, (float)dArray2[0], 0);
            dArray2[1] = hGraph.a(hNode, (float)dArray2[1], 1);
        }
        dArray[0] = hNode2.b(0);
        dArray[1] = hNode2.b(1);
        dArray3[0] = hNode2.x();
        dArray3[1] = hNode2.x() + hNode2.z();
        dArray3[2] = hNode2.y();
        dArray3[3] = hNode2.y() + hNode2.aa();
        LayoutUtil.Clip(dArray, dArray2, dArray3);
        hLink.b(0, (float)dArray[0]);
        hLink.b(1, (float)dArray[1]);
    }

    public final void calcEvenSpacedConnectors() {
        this.calcNorthSouthPortConnectors();
        HNodeIterator hNodeIterator = this.getGraph().aa();
        while (hNodeIterator.hasNext()) {
            HNode hNode = hNodeIterator.next();
            if (hNode.a0()) {
                this.e(hNode);
            } else {
                this.c(hNode);
            }
            this.d().addPoints(1);
            this.f();
        }
    }

    public final void calcEastWestAuxPortNodeConnectors() {
        if (!this.getGraph().bf()) {
            return;
        }
        HNodeIterator hNodeIterator = this.getGraph().aa();
        while (hNodeIterator.hasNext()) {
            HNode hNode = hNodeIterator.next();
            if (!hNode.a0()) continue;
            this.e(hNode);
        }
    }

    private final void c(HNode hNode) {
        float[] fArray;
        float f;
        HSegment hSegment;
        float f2;
        float f3;
        if (hNode.u()) {
            return;
        }
        boolean bl = !hNode.a0();
        float f4 = hNode.c(this.b);
        float f5 = hNode.a(this.b);
        HNodeSelfLinkInfo hNodeSelfLinkInfo = hNode.a4();
        if (hNode.a0()) {
            f3 = this.a(hNode, f4, true, false, false);
            f2 = f5 + f3;
        } else if (hNodeSelfLinkInfo.g(2)) {
            f3 = hNodeSelfLinkInfo.c(2);
            f2 = f5 + hNodeSelfLinkInfo.e(2);
            this.e = hNodeSelfLinkInfo.d(2);
        } else {
            f3 = this.a(hNode, f4, true, false, false);
            f2 = f5 + f3;
        }
        HSegmentIterator hSegmentIterator = hNode.n();
        float f6 = hNode.a(this.c) + hNode.c(this.c);
        while (hSegmentIterator.hasNext()) {
            hSegment = hSegmentIterator.next();
            if (hSegment.j() && bl) {
                hSegment.l();
                continue;
            }
            if (hSegment.x() != -1) continue;
            f = this.e * hSegment.e().x();
            fArray = hSegment.f();
            fArray[this.b] = f2 + 0.5f * f;
            fArray[this.c] = f6;
            f2 += f3 + f;
        }
        if (hNode.a0()) {
            f3 = this.a(hNode, f4, false, true, false);
            f2 = f5 + f3;
        } else if (hNodeSelfLinkInfo.g(0)) {
            f3 = hNodeSelfLinkInfo.c(0);
            f2 = f5 + hNodeSelfLinkInfo.e(0);
            this.e = hNodeSelfLinkInfo.d(0);
        } else {
            f3 = this.a(hNode, f4, false, true, false);
            f2 = f5 + f3;
        }
        hSegmentIterator = hNode.o();
        f6 = hNode.a(this.c);
        while (hSegmentIterator.hasNext()) {
            hSegment = hSegmentIterator.next();
            if (hSegment.k() && bl) {
                hSegment.m();
                continue;
            }
            if (hSegment.y() != -1) continue;
            f = this.e * hSegment.e().x();
            fArray = hSegment.g();
            fArray[this.b] = f2 + 0.5f * f;
            fArray[this.c] = f6;
            f2 += f3 + f;
        }
    }

    private final void c(HNode hNode, HNode hNode2) {
        float f;
        HSegment hSegment;
        HSegmentIterator hSegmentIterator;
        float f2;
        float f3;
        float f4;
        if (hNode.u()) {
            return;
        }
        hNode2.a8();
        boolean bl = hNode.an() < hNode2.an();
        int n = bl ? 1 : 3;
        HNodeSelfLinkInfo hNodeSelfLinkInfo = hNode.a4();
        float f5 = hNode.a(this.c);
        if (hNode.a0()) {
            f4 = hNode.c(this.c);
            f3 = this.a(hNode2, f4, true, true, false);
            f2 = f5 + f3;
        } else if (hNodeSelfLinkInfo.g(n)) {
            f3 = hNodeSelfLinkInfo.c(n);
            f2 = f5 + hNodeSelfLinkInfo.e(n);
            this.e = hNodeSelfLinkInfo.d(n);
        } else {
            f4 = hNode.c(this.c);
            f3 = this.a(hNode2, f4, true, true, false);
            f2 = f5 + f3;
        }
        float f6 = hNode.a(this.b);
        if (bl) {
            f6 += hNode.c(this.b);
        }
        float[] fArray = bl ? hNode.a6().b(1) : hNode.a6().b(3);
        this.g(hNode2);
        HSegmentIterator hSegmentIterator2 = hSegmentIterator = bl ? hNode2.o() : hNode2.r();
        while (hSegmentIterator.hasNext()) {
            hSegment = hSegmentIterator.next();
            f = this.e * hSegment.e().x();
            if (!this.b(hSegment, f6, f2 + 0.5f * f, f5, fArray)) continue;
            f2 += f3 + f;
        }
        HSegmentIterator hSegmentIterator3 = hSegmentIterator = bl ? hNode2.q() : hNode2.n();
        while (hSegmentIterator.hasNext()) {
            hSegment = hSegmentIterator.next();
            f = this.e * hSegment.e().x();
            if (!this.a(hSegment, f6, f2 + 0.5f * f, f5, fArray)) continue;
            f2 += f3 + f;
        }
    }

    float a(HNode hNode, float f, final HSegment[] hSegmentArray) {
        HSegmentIterator hSegmentIterator = new HSegmentIterator(){
            int a = 0;

            @Override
            public boolean hasNext() {
                return this.a < hSegmentArray.length;
            }

            @Override
            public HSegment next() {
                return hSegmentArray[this.a++];
            }
        };
        return this.a(hNode, f, hSegmentIterator, false);
    }

    float a(HNode hNode, float f, boolean bl, boolean bl2, boolean bl3) {
        HSegmentIterator hSegmentIterator = bl ? (bl2 ? hNode.p() : hNode.n()) : hNode.o();
        return this.a(hNode, f, hSegmentIterator, bl3);
    }

    float a(HNode hNode, float f, HSegmentIterator hSegmentIterator, boolean bl) {
        boolean bl2;
        int n = 0;
        float f2 = 0.0f;
        boolean bl3 = bl2 = !hNode.a0();
        while (hSegmentIterator.hasNext()) {
            boolean bl4;
            int n2;
            HSegment hSegment = hSegmentIterator.next();
            if (hSegment.a() == hNode) {
                n2 = hSegment.x();
                bl4 = bl2 && hSegment.j();
            } else {
                n2 = hSegment.y();
                boolean bl5 = bl4 = bl2 && hSegment.k();
            }
            if (bl4 || n2 != -1 && !bl) continue;
            ++n;
            f2 += hSegment.e().x();
        }
        this.e = 1.0f;
        float f3 = (f - f2) / (float)(n + 1);
        if ((double)f3 < 0.0) {
            f3 = 0.0f;
            this.e = f / f2;
        }
        return f3;
    }

    private boolean a(HSegment hSegment, float f, float f2, float f3, float[] fArray) {
        float f4;
        int n = hSegment.x();
        boolean bl = false;
        boolean bl2 = false;
        float f5 = hSegment.c(this.c);
        float f6 = hSegment.p();
        if (hSegment.j()) {
            hSegment.l();
            f4 = hSegment.c(this.c);
            bl = true;
        } else if (n == -1) {
            f4 = f2;
            bl2 = true;
        } else {
            f4 = f3 + fArray[n];
        }
        this.a(hSegment, true, f, f4, f6, f5, bl);
        return bl2;
    }

    private boolean b(HSegment hSegment, float f, float f2, float f3, float[] fArray) {
        float f4;
        int n = hSegment.y();
        boolean bl = false;
        boolean bl2 = false;
        float f5 = hSegment.d(this.c);
        float f6 = hSegment.p();
        if (hSegment.k()) {
            hSegment.m();
            f4 = hSegment.d(this.c);
            bl = true;
        } else if (n == -1) {
            f4 = f2;
            bl2 = true;
        } else {
            f4 = f3 + fArray[n];
        }
        this.a(hSegment, false, f, f4, f6, f5, bl);
        return bl2;
    }

    private void a(HSegment hSegment, boolean bl, float f, float f2, float f3, float f4, boolean bl2) {
        HNode hNode;
        HNode hNode2;
        float[] fArray;
        HGraph hGraph = this.getGraph();
        HLink hLink = hSegment.e();
        if (bl) {
            fArray = hSegment.f();
            hNode2 = hSegment.a();
        } else {
            fArray = hSegment.g();
            hNode2 = hSegment.b();
        }
        if (hLink.af()) {
            HNode hNode3 = this.a(hNode2, hSegment);
            if (!hNode3.ah() && hNode3.u() && hNode3.ak() == -1) {
                hNode3.a(this.b, f3);
            }
            hNode = hLink.a(hSegment, hGraph);
            HNode hNode4 = hLink.a(hSegment, hGraph);
            if (hSegment.ac() == bl) {
                HNode hNode5 = hNode;
                hNode = hNode4;
                hNode4 = hNode5;
            }
            hNode4.a(this.b, f3);
            hNode4.a(this.c, f2);
        } else {
            hNode = hLink.a(hSegment, hGraph);
        }
        hNode.a(this.b, f3);
        hNode.a(this.c, f4);
        if (!bl2) {
            fArray[this.b] = f;
            fArray[this.c] = f2;
        }
    }

    public final void calcNorthSouthPortConnectors() {
        HNodeIterator hNodeIterator = this.getGraph().aa();
        while (hNodeIterator.hasNext()) {
            this.d(hNodeIterator.next());
            this.d().addPoints(1);
            this.f();
        }
    }

    private final void d(HNode hNode) {
        float[] fArray;
        int n;
        HSegment hSegment;
        HSegmentIterator hSegmentIterator;
        float f;
        if (hNode.a6() == null) {
            return;
        }
        if (hNode.u()) {
            return;
        }
        if (hNode.a0()) {
            return;
        }
        float f2 = hNode.a(this.b);
        float[] fArray2 = hNode.a6().b(2);
        if (fArray2 != null) {
            f = hNode.a(this.c) + hNode.c(this.c);
            hSegmentIterator = hNode.a(true, true, false, false);
            while (hSegmentIterator.hasNext()) {
                hSegment = hSegmentIterator.next();
                n = hSegment.x();
                if (n == -1) continue;
                fArray = hSegment.f();
                fArray[this.b] = f2 + fArray2[n];
                fArray[this.c] = f;
            }
        }
        if ((fArray2 = hNode.a6().b(0)) != null) {
            f = hNode.a(this.c);
            hSegmentIterator = hNode.b(true, true, false, false);
            while (hSegmentIterator.hasNext()) {
                hSegment = hSegmentIterator.next();
                n = hSegment.y();
                if (n == -1) continue;
                fArray = hSegment.g();
                fArray[this.b] = f2 + fArray2[n];
                fArray[this.c] = f;
            }
            fArray2 = null;
        }
    }

    private final void e(HNode hNode) {
        hNode.a8();
        if (hNode.u(2) == 0 && hNode.u(0) == 0) {
            this.c(hNode);
            return;
        }
        float f = hNode.c(this.b);
        float f2 = hNode.a(this.b);
        float f3 = this.a(hNode, f, true, true, true);
        HSegmentIterator hSegmentIterator = hNode.n();
        HSegmentIterator hSegmentIterator2 = hNode.o();
        float f4 = f2 + f3;
        float f5 = hNode.a(this.c);
        float f6 = f5 + hNode.c(this.c);
        while (hSegmentIterator.hasNext() || hSegmentIterator2.hasNext()) {
            float[] fArray;
            float f7;
            HSegment hSegment;
            if (hSegmentIterator.hasNext()) {
                hSegment = hSegmentIterator.next();
                f7 = hSegment.e().x();
                fArray = hSegment.f();
                fArray[this.b] = f4 + 0.5f * f7;
                fArray[this.c] = f6;
                f4 += f3 + f7;
            }
            if (!hSegmentIterator2.hasNext()) continue;
            hSegment = hSegmentIterator2.next();
            f7 = hSegment.e().x();
            fArray = hSegment.g();
            fArray[this.b] = f4 + 0.5f * f7;
            fArray[this.c] = f5;
            f4 += f3 + f7;
        }
    }

    final void b() {
        HNodeIterator hNodeIterator = this.getGraph().aa();
        while (hNodeIterator.hasNext()) {
            this.f(hNodeIterator.next());
        }
    }

    private void f(HNode hNode) {
        HNode hNode2;
        float[] fArray;
        if (hNode.a6() == null) {
            return;
        }
        if (hNode.u()) {
            return;
        }
        if (hNode.a0()) {
            return;
        }
        hNode.a8();
        float f = hNode.c(this.b);
        float f2 = hNode.c(this.c);
        int n = hNode.u(0);
        if (n >= 0) {
            fArray = new float[n];
            this.a(hNode, fArray, 0.0f, f, false, true);
            hNode.a6().a(0, fArray);
        }
        if ((n = hNode.u(2)) >= 0) {
            fArray = new float[n];
            this.a(hNode, fArray, 0.0f, f, true, false);
            hNode.a6().a(2, fArray);
        }
        if ((hNode2 = hNode.ax()) != null) {
            hNode2.a8();
            n = hNode2.u(2);
            if (hNode2.u(0) > n) {
                n = hNode2.u(0);
            }
            if (hNode.u(1) > n) {
                n = hNode.u(1);
            }
            if (n > 0) {
                fArray = new float[n];
                this.a(hNode2, fArray, 0.0f, f2, true, true);
                hNode.a6().a(1, fArray);
            }
        }
        if ((hNode2 = hNode.az()) != null) {
            hNode2.a8();
            n = hNode2.u(2);
            if (hNode2.u(0) > n) {
                n = hNode2.u(0);
            }
            if (hNode.u(3) > n) {
                n = hNode.u(3);
            }
            if (n > 0) {
                fArray = new float[n];
                this.a(hNode2, fArray, 0.0f, f2, true, true);
                hNode.a6().a(3, fArray);
            }
        }
    }

    private final void a(HNode hNode, float[] fArray, float f, float f2, boolean bl, boolean bl2) {
        int n;
        HSegmentIterator hSegmentIterator = bl ? (bl2 ? hNode.c(true, true, false, false) : hNode.a(true, true, false, false)) : hNode.b(true, true, false, false);
        int n2 = fArray.length;
        for (n = 0; n < n2; ++n) {
            fArray[n] = 0.0f;
        }
        while (hSegmentIterator.hasNext()) {
            HSegment hSegment = hSegmentIterator.next();
            int n3 = hSegment.a() == hNode ? hSegment.x() : hSegment.y();
            if (n3 == -1) continue;
            fArray[n3] = Math.max(hSegment.e().x(), fArray[n3]);
        }
        float f3 = 0.0f;
        for (n = 0; n < fArray.length; ++n) {
            f3 += fArray[n];
        }
        float f4 = Float.MAX_VALUE;
        float f5 = (f2 - f3) / (float)(n2 + 1);
        if ((double)f5 < 0.0) {
            f5 = f2 / (float)(n2 + 1);
            f4 = 0.0f;
        }
        float f6 = f + f5;
        for (n = 0; n < n2; ++n) {
            float f7 = fArray[n];
            if (f7 > f4) {
                f7 = f4;
            }
            fArray[n] = f6 + 0.5f * f7;
            f6 += f5 + f7;
        }
    }

    private void g(HNode hNode) {
        float f;
        HSegment hSegment;
        float[] fArray = new float[2];
        this.a(hNode, fArray);
        HSegmentIterator hSegmentIterator = hNode.a(true, true, false, false);
        int n = 0;
        int n2 = 0;
        boolean bl = false;
        while (hSegmentIterator.hasNext()) {
            hSegment = hSegmentIterator.next();
            if (hSegment.x() != -1) {
                bl = true;
            }
            f = this.a(hSegment, fArray, true);
            hSegment.e(f);
            ++n;
        }
        hSegmentIterator = hNode.b(true, true, false, false);
        while (hSegmentIterator.hasNext()) {
            hSegment = hSegmentIterator.next();
            if (hSegment.y() != -1) {
                bl = true;
            }
            f = this.a(hSegment, fArray, false);
            hSegment.e(f);
            ++n2;
        }
        if (bl) {
            this.a.a(hNode.a(true, true, false, false), hNode.b(true, true, false, false), n + n2, true);
            this.a.run();
            this.a.a(hNode.a(true, true, false, false), hNode.b(true, true, false, false), n + n2, false);
            this.a.run();
        } else {
            hSegmentIterator = hNode.a(true, true, false, false);
            this.a.a(hSegmentIterator, n, true);
            this.a.run();
            hSegmentIterator = hNode.b(true, true, false, false);
            this.a.a(hSegmentIterator, n2, false);
            this.a.run();
        }
    }

    private float a(HSegment hSegment, float[] fArray, boolean bl) {
        HNode hNode;
        float f;
        int n = this.b;
        if (bl) {
            f = hSegment.c(n);
            hNode = hSegment.a();
        } else {
            f = hSegment.d(n);
            hNode = hSegment.b();
        }
        HLink hLink = hSegment.e();
        if (hLink.ac().getOwnerGraph() == hLink.ad().getOwnerGraph() && hLink.ac().ak() == hLink.ad().ak()) {
            return f;
        }
        HNode hNode2 = this.a(hNode, hSegment);
        if (hNode2.ah()) {
            return f;
        }
        float f2 = this.c();
        if (hLink.af() && hNode2.u() && hNode2.ak() == -1) {
            if ((hNode2 = this.a(hNode2, hNode2.d(this.g))).ah()) {
                return f;
            }
            f2 = this.c();
        }
        if (f2 >= fArray[0] && f2 <= fArray[1]) {
            return f2;
        }
        return f;
    }

    private final void a(HNode hNode, float[] fArray) {
        float f;
        float f2;
        HNode hNode2;
        int n = this.b;
        HGraph hGraph = this.getGraph();
        fArray[0] = -3.4028235E38f;
        fArray[1] = Float.MAX_VALUE;
        int n2 = hNode.an();
        HLevel hLevel = hNode.al();
        if (n2 > 0) {
            hNode2 = hLevel.b(n2 - 1);
            if (hNode2.a0()) {
                fArray[0] = 0.5f * (hNode2.a(n) + hNode2.c(n) + hNode.a(n) + hGraph.m(n));
            } else if (hNode2.u()) {
                fArray[0] = hNode2.ah() ? hNode2.m(n) + hGraph.m(n) : hNode2.a(n) + hNode2.c(n) + hGraph.m(n);
            } else {
                f = f2 + ((f2 = hNode2.a4().b(1)) > 0.0f ? hGraph.m(n) : hGraph.l(n));
                fArray[0] = hNode2.a(n) + hNode2.c(n) + f;
            }
        }
        if (n2 < hLevel.h() - 1) {
            hNode2 = hLevel.b(n2 + 1);
            if (hNode2.a0()) {
                fArray[1] = 0.5f * (hNode.a(n) + hNode.c(n) + hNode2.a(n) - hGraph.m(n));
            } else if (hNode2.u()) {
                fArray[1] = hNode2.ah() ? hNode2.m(n) - hGraph.m(n) : hNode2.a(n) - hGraph.m(n);
            } else {
                f = f2 + ((f2 = hNode2.a4().b(3)) > 0.0f ? hGraph.m(n) : hGraph.l(n));
                fArray[1] = hNode2.a(n) - f;
            }
        }
    }

    HNode a(HNode hNode, HSegment hSegment) {
        hNode = hSegment.a(hNode);
        while (hNode.ah() && hNode.ak() == -1) {
            hSegment = hNode.d(hSegment);
            hNode = hSegment.a(hNode);
        }
        this.f = hNode;
        this.g = hSegment;
        return hNode;
    }

    float c() {
        float f = this.g.a() == this.f ? this.g.c(this.b) : this.g.d(this.b);
        HGraph hGraph = this.getGraph();
        return hGraph.a(this.f, f, this.b);
    }

    void a(HNode hNode) {
        if (hNode.u()) {
            return;
        }
        if (hNode.a0()) {
            return;
        }
        if (hNode.a4().c() == 0) {
            return;
        }
        this.h(hNode);
    }

    private void h(HNode hNode) {
        this.a(hNode, 1, 0);
        this.a(hNode, 1, 1);
        this.a(hNode, 3, 0);
        this.a(hNode, 3, 1);
        this.a(hNode, 0, 0);
        this.a(hNode, 0, 1);
        this.a(hNode, 2, 0);
        this.a(hNode, 2, 1);
    }

    private void a(HNode hNode, int n, int n2) {
        float f;
        float f2;
        HNodeSelfLinkInfo hNodeSelfLinkInfo;
        HLink[] hLinkArray;
        HGraph hGraph = hNode.getOwnerGraph();
        int n3 = n == 1 || n == 3 ? hGraph.a4() : hGraph.a3();
        int n4 = 1 - n3;
        float f3 = hNode.a(n3);
        float f4 = hNode.a(n4);
        if (n == 1 || n == 2) {
            f4 += hNode.c(n4);
        }
        if ((hLinkArray = (hNodeSelfLinkInfo = hNode.a4()).a(n, n2)) == null || hLinkArray.length == 0) {
            return;
        }
        HSegment[] hSegmentArray = this.a(hNode, n, hLinkArray);
        if (this.d == 101 && hNodeSelfLinkInfo.g(n)) {
            f2 = hNodeSelfLinkInfo.c(n);
            this.e = hNodeSelfLinkInfo.d(n);
            f = hNode.a(n3);
            if (n2 == 1) {
                f += hNode.c(n3) - hNodeSelfLinkInfo.f(n);
            }
        } else {
            float f5 = hNode.c(n3) / 3.0f;
            f2 = this.a(hNode, f5, hSegmentArray);
            f = hNode.a(n3);
            if (n2 == 1) {
                f += 2.0f * f5;
            }
        }
        float[] fArray = hNode.a6().b(n);
        float f6 = f + f2;
        for (int i = 0; i < hSegmentArray.length; ++i) {
            float f7;
            float[] fArray2;
            int n5;
            HSegment hSegment = hSegmentArray[i];
            if (hSegment.a() == hNode) {
                n5 = hSegment.x();
                fArray2 = hSegment.f();
                if (hSegment.j()) {
                    hSegment.l();
                    continue;
                }
                if (n5 == -1) {
                    f7 = this.e * hSegment.e().x();
                    fArray2[n3] = f6 + 0.5f * f7;
                    fArray2[n4] = f4;
                    f6 += f2 + f7;
                    continue;
                }
                fArray2[n3] = f3 + fArray[n5];
                fArray2[n4] = f4;
                continue;
            }
            if (hSegment.b() != hNode) continue;
            n5 = hSegment.y();
            fArray2 = hSegment.g();
            if (hSegment.k()) {
                hSegment.m();
                continue;
            }
            if (n5 == -1) {
                f7 = this.e * hSegment.e().x();
                fArray2[n3] = f6 + 0.5f * f7;
                fArray2[n4] = f4;
                f6 += f2 + f7;
                continue;
            }
            fArray2[n3] = f3 + fArray[n5];
            fArray2[n4] = f4;
        }
    }

    private HSegment[] a(HNode hNode, int n, HLink[] hLinkArray) {
        HSegment hSegment;
        HLink hLink;
        int n2;
        HNodeSelfLinkInfo hNodeSelfLinkInfo = hNode.a4();
        boolean bl = hNodeSelfLinkInfo.f();
        ArrayList<HSegment> arrayList = new ArrayList<HSegment>();
        for (n2 = 0; n2 < hLinkArray.length; ++n2) {
            hLink = hLinkArray[n2];
            if (hLink.am() == n) {
                hSegment = hLink.u();
                arrayList.add(hSegment);
            }
            if (hLink.an() != n || hLink.am() == n && bl) continue;
            hSegment = hLink.v();
            arrayList.add(hSegment);
        }
        if (bl) {
            for (n2 = hLinkArray.length - 1; n2 >= 0; --n2) {
                hLink = hLinkArray[n2];
                if (hLink.an() != n || hLink.am() != n) continue;
                hSegment = hLink.v();
                arrayList.add(hSegment);
            }
        }
        return arrayList.toArray(new HSegment[arrayList.size()]);
    }

    void a(HNode hNode, int n) {
        float f;
        HSegment hSegment;
        int n2;
        if (hNode.a0()) {
            return;
        }
        if (hNode.u()) {
            return;
        }
        HNodeSelfLinkInfo hNodeSelfLinkInfo = hNode.a4();
        HGraph hGraph = hNode.getOwnerGraph();
        int n3 = n == 1 || n == 3 ? hGraph.a4() : hGraph.a3();
        float f2 = hNode.c(n3);
        HLink[] hLinkArray = hNodeSelfLinkInfo.a(n, 0);
        HLink[] hLinkArray2 = hNodeSelfLinkInfo.a(n, 1);
        if (!(hLinkArray != null && hLinkArray.length != 0 || hLinkArray2 != null && hLinkArray2.length != 0)) {
            return;
        }
        HSegment[] hSegmentArray = this.a(hNode, n, hLinkArray);
        HSegment[] hSegmentArray2 = this.a(hNode, n, hLinkArray2);
        ArrayList<HSegment> arrayList = new ArrayList<HSegment>();
        for (n2 = 0; n2 < hSegmentArray.length; ++n2) {
            arrayList.add(hSegmentArray[n2]);
        }
        HSegmentIterator hSegmentIterator = null;
        switch (n) {
            case 1: {
                HNode hNode2 = hNode.ax();
                if (hNode2 == null) break;
                hSegmentIterator = hNode2.c(true, true, false, false);
                break;
            }
            case 3: {
                HNode hNode2 = hNode.az();
                if (hNode2 == null) break;
                hSegmentIterator = hNode2.c(true, true, false, false);
                break;
            }
            case 0: {
                hSegmentIterator = hNode.b(true, true, false, false);
                break;
            }
            case 2: {
                hSegmentIterator = hNode.a(true, true, false, false);
            }
        }
        if (hSegmentIterator != null) {
            while (hSegmentIterator.hasNext()) {
                arrayList.add(hSegmentIterator.next());
            }
        }
        for (n2 = 0; n2 < hSegmentArray2.length; ++n2) {
            arrayList.add(hSegmentArray2[n2]);
        }
        HSegment[] hSegmentArray3 = arrayList.toArray(new HSegment[arrayList.size()]);
        float f3 = this.a(hNode, f2, hSegmentArray3);
        hNodeSelfLinkInfo.b(n, f3);
        hNodeSelfLinkInfo.c(n, this.e);
        float f4 = f3;
        for (n2 = 0; n2 < hSegmentArray.length; ++n2) {
            hSegment = hSegmentArray[n2];
            if (hSegment.x() != -1 || hSegment.j()) continue;
            f = this.e * hSegment.e().x();
            f4 += f3 + f;
        }
        float f5 = f3;
        for (n2 = 0; n2 < hSegmentArray2.length; ++n2) {
            hSegment = hSegmentArray2[n2];
            if (hSegment.x() != -1 || hSegment.j()) continue;
            f = this.e * hSegment.e().x();
            f5 += f3 + f;
        }
        hNodeSelfLinkInfo.d(n, f4);
        hNodeSelfLinkInfo.e(n, f5);
    }
}

