/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.dbTarget.db.changemgr.emo.docaccess;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.StringTokenizer;
import oracle.jdbc.OracleConnection;

public class CMConnection {
    private OracleConnection m_conn;
    private String m_realDBVersion = null;
    private String m_compatibleDBVersion = null;
    private boolean m_canAccessDbaViews = false;
    private boolean m_cadbavSet = false;
    private static final String s_getVersionInfo = "begin dbms_utility.db_version( ?, ? ); end;";
    private static final String s_checkDbaViews = "select 1 from dba_objects where 1=0";

    public CMConnection(OracleConnection conn) {
        this.m_conn = conn;
    }

    public OracleConnection getUnWrappedConnection() {
        return this.m_conn;
    }

    public void close() throws SQLException {
        if (this.m_conn != null) {
            this.m_conn.close();
        }
    }

    public void setAutoCommit(boolean ac) throws SQLException {
        if (this.m_conn != null) {
            this.m_conn.setAutoCommit(ac);
        }
    }

    public boolean getAutoCommit() throws SQLException {
        if (this.m_conn != null) {
            return this.m_conn.getAutoCommit();
        }
        return false;
    }

    public void commit() throws SQLException {
        if (this.m_conn != null) {
            this.m_conn.commit();
        }
    }

    public void rollback() throws SQLException {
        if (this.m_conn != null) {
            this.m_conn.rollback();
        }
    }

    public Statement createStatement() throws SQLException {
        Statement stmt = null;
        if (this.m_conn != null) {
            stmt = this.m_conn.createStatement();
        }
        return stmt;
    }

    public PreparedStatement prepareStatement(String sql) throws SQLException {
        PreparedStatement stmt = null;
        if (this.m_conn != null) {
            stmt = this.m_conn.prepareStatement(sql);
        }
        return stmt;
    }

    public CallableStatement prepareCall(String sql) throws SQLException {
        CallableStatement stmt = null;
        if (this.m_conn != null) {
            stmt = this.m_conn.prepareCall(sql);
        }
        return stmt;
    }

    public String getDBVersion() {
        try {
            this.getVersionInfo();
        }
        catch (SQLException se) {
            return null;
        }
        return this.m_realDBVersion;
    }

    public String getCompatibleVersion() {
        try {
            this.getVersionInfo();
        }
        catch (SQLException se) {
            return null;
        }
        return this.m_compatibleDBVersion;
    }

    public boolean isVersionEqualOrHigher(String v2) {
        String version = this.getDBVersion();
        return CMConnection.compareVersion(version, v2) != -1;
    }

    public static int compareVersion(String v1, String v2) {
        int compareValue = 0;
        String separator = new String(".");
        StringTokenizer version1 = new StringTokenizer(v1.trim(), separator);
        StringTokenizer version2 = new StringTokenizer(v2.trim(), separator);
        while (version1.hasMoreTokens() && version2.hasMoreTokens()) {
            int value2;
            int value1 = Integer.parseInt(version1.nextToken());
            if (value1 < (value2 = Integer.parseInt(version2.nextToken()))) {
                compareValue = -1;
                break;
            }
            if (value1 <= value2) continue;
            compareValue = 1;
            break;
        }
        return compareValue;
    }

    public static void close(Statement stmt, ResultSet rs) {
        try {
            if (rs != null) {
                rs.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canAccessDbaViews() throws SQLException {
        block5: {
            if (this.m_cadbavSet) break block5;
            Statement stmt = null;
            ResultSet rs = null;
            try {
                stmt = this.createStatement();
                rs = stmt.executeQuery(s_checkDbaViews);
                this.m_canAccessDbaViews = true;
            }
            catch (SQLException se) {
                block4: {
                    try {
                        if (se.getErrorCode() == 942) break block4;
                        throw se;
                    }
                    catch (Throwable throwable) {
                        CMConnection.close(stmt, rs);
                        throw throwable;
                    }
                }
                CMConnection.close(stmt, rs);
            }
            CMConnection.close(stmt, rs);
            this.m_cadbavSet = true;
        }
        return this.m_canAccessDbaViews;
    }

    public static void close(Statement stmt) {
        CMConnection.close(stmt, null);
    }

    public static void close(ResultSet rs) {
        CMConnection.close(null, rs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getVersionInfo() throws SQLException {
        if (this.m_realDBVersion == null) {
            CallableStatement stmt = null;
            try {
                stmt = this.prepareCall(s_getVersionInfo);
                stmt.registerOutParameter(1, 12);
                stmt.registerOutParameter(2, 12);
                stmt.execute();
                this.m_realDBVersion = stmt.getString(1);
                this.m_compatibleDBVersion = stmt.getString(2);
                if (this.m_compatibleDBVersion == null) {
                    this.m_compatibleDBVersion = this.m_realDBVersion;
                }
            }
            finally {
                if (stmt != null) {
                    stmt.close();
                }
            }
        }
    }
}

