/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.swing.xmlComponent;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyEditor;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.CellEditor;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import oracle.bali.xml.dom.traversal.TreeTraversal;
import oracle.bali.xml.dom.util.DomUtils;
import oracle.bali.xml.gui.base.inspector.editors.StringEditor;
import oracle.bali.xml.gui.base.xmlComponent.AbstractXmlPropertyEditorDecorator;
import oracle.bali.xml.gui.base.xmlComponent.XmlComponentLayoutOption;
import oracle.bali.xml.gui.base.xmlComponent.XmlComponentModel;
import oracle.bali.xml.gui.base.xmlComponent.XmlComponentSelectionChanged;
import oracle.bali.xml.gui.base.xmlComponent.XmlComponentWrapper;
import oracle.bali.xml.gui.swing.xmlComponent.AbstractXmlTableAdapter;
import oracle.bali.xml.gui.swing.xmlComponent.XmlContextualActionButton;
import oracle.bali.xml.gui.swing.xmlComponent.XmlLayoutOption;
import oracle.bali.xml.gui.swing.xmlComponent.XmlTableCellEditor;
import oracle.bali.xml.gui.swing.xmlComponent.XmlTableCellRenderer;
import oracle.bali.xml.metadata.ImmutableXmlKey;
import oracle.bali.xml.metadata.XmlKey;
import oracle.bali.xml.model.AbstractModel;
import oracle.bali.xml.model.XmlContext;
import oracle.bali.xml.model.XmlModelEvent;
import oracle.bali.xml.model.XmlModelListener;
import oracle.bali.xml.model.event.XmlModelAdapter;
import oracle.bali.xml.model.task.NonDomMutationTransactionTask;
import oracle.bali.xml.model.task.ReadOnlyTask;
import oracle.bali.xml.share.FastMessageFormat;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.table.GenericTable;
import org.w3c.dom.Node;

public abstract class AbstractXmlTableEditor
extends AbstractXmlPropertyEditorDecorator<String>
implements XmlComponentSelectionChanged {
    private final XmlSelectionListener _xmlSelectionListener = new XmlSelectionListener();
    private JTable _table;
    private DefaultTableModel _tableModel;
    private ArrayList<XmlComponentWrapper> _columnXmlComponentWrapperList = new ArrayList();
    private int _columnCount = 0;
    private int _selectedIndex = -1;
    private int _prevSelectedIndex = -1;
    private JPanel _tablePanel;
    private boolean _safeDelete = false;
    private boolean _showReorderableRowButtons = false;
    private boolean _changingSelectionFlag = false;
    private Component _currentTableCellEditorComponent;
    private Set<Component> _focusLostFalsePositiveSet;
    private boolean _focusLostStopCellEditingFlag = false;
    private boolean _queuedSelectionChangeFlag = false;
    private boolean _xmlComponentFlag = false;
    private int _queuedSelectionChange = -1;
    private boolean _queuedXmlComponentFlag = false;
    private boolean _queuedChangingSelectionFlag = false;

    public AbstractXmlTableEditor() {
        super((PropertyEditor)new StringEditor());
    }

    public Component getXmlComponent() {
        if (this._tablePanel != null) {
            this.setXmlComponentFlag(true);
            this.getTableModel().fireTableDataChanged();
            this.updateAddDeleteButtons();
            if (this.updateTableSelection()) {
                if (this.getSelectedIndex() < 0 && this.getPrevSelectedIndex() > -1) {
                    this.setSelectedIndex(this.getPrevSelectedIndex());
                }
                if (this.getSelectedIndex() > -1) {
                    this.setChangingSelectionFlag(true);
                    int row = this.getTable().convertRowIndexToView(this.getSelectedIndex());
                    if (row >= this.getTable().getRowCount()) {
                        this.getTable().changeSelection(this.getTable().getRowCount() - 1, 0, false, false);
                    } else if (row != -1) {
                        this.getTable().changeSelection(row, 0, false, false);
                    }
                    this.setChangingSelectionFlag(false);
                }
                this.setXmlComponentFlag(false);
            }
            return this._tablePanel;
        }
        this.getXmlComponentWrapper().setAddFocusTracker(false);
        this._tableModel = this.createTableModel();
        this._table = this.createTable();
        this.setupTable();
        this.setTableCellEditors();
        this.setupTableCellEditorFocusLostDecorator();
        this._tablePanel = this.createTablePanel();
        if (this.getXmlComponentWrapper().getParent() != null) {
            this.setEnabled(false);
        }
        return this._tablePanel;
    }

    public abstract AbstractXmlTableAdapter getXmlTableAdapter();

    protected boolean updateTableSelection() {
        return true;
    }

    protected abstract JPanel createTablePanel();

    public JPanel getTablePanel() {
        return this._tablePanel;
    }

    public JTable getTable() {
        return this._table;
    }

    public DefaultTableModel getTableModel() {
        return this._tableModel;
    }

    public void updateXmlComponentFromPropertyValue() {
    }

    public void updatePropertyValueFromXmlComponent() {
    }

    public boolean updatePropertyValue() {
        return false;
    }

    protected abstract DefaultTableModel createTableModel();

    protected abstract JTable createTable();

    protected void setupTable() {
        this.getTable().setSelectionMode(0);
        this.getTable().setShowGrid(true);
        this.getTable().setGridColor(Color.LIGHT_GRAY);
        this.getTable().setIntercellSpacing(new Dimension(1, 1));
        this.getXmlComponentWrapper().getXmlComponentModel().getXmlGui().addModelListener((XmlModelListener)this._xmlSelectionListener);
        this.getTable().getSelectionModel().addListSelectionListener(this.createListSelectionListener());
    }

    public ListSelectionListener createListSelectionListener() {
        return new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent event) {
                if (event.getValueIsAdjusting()) {
                    return;
                }
                int newSelectedIndex = -1;
                newSelectedIndex = AbstractXmlTableEditor.this.getTable() instanceof GenericTable ? ((GenericTable)AbstractXmlTableEditor.this.getTable()).getSelectedRowInModel() : AbstractXmlTableEditor.this.getTable().getSelectedRow();
                final int currSelectedIndex = AbstractXmlTableEditor.this.getSelectedIndex();
                if (AbstractXmlTableEditor.this.getQueuedSelectionChangeFlag()) {
                    AbstractXmlTableEditor.this.setQueuedSelectionChange(newSelectedIndex);
                    AbstractXmlTableEditor.this._queuedXmlComponentFlag = AbstractXmlTableEditor.this.getXmlComponentFlag();
                    AbstractXmlTableEditor.this._queuedChangingSelectionFlag = AbstractXmlTableEditor.this.getChangingSelectionFlag();
                    return;
                }
                AbstractXmlTableEditor.this.setQueuedSelectionChangeFlag(true);
                AbstractXmlTableEditor.this.setQueuedSelectionChange(newSelectedIndex);
                AbstractXmlTableEditor.this._queuedXmlComponentFlag = AbstractXmlTableEditor.this.getXmlComponentFlag();
                AbstractXmlTableEditor.this._queuedChangingSelectionFlag = AbstractXmlTableEditor.this.getChangingSelectionFlag();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (!AbstractXmlTableEditor.this.getXmlComponentModel().getView().getContext().isDisposed() && AbstractXmlTableEditor.this.getQueuedSelectionChangeFlag()) {
                            AbstractXmlTableEditor.this.setPrevSelectedIndex(currSelectedIndex);
                            int queuedSelectionChange = AbstractXmlTableEditor.this.getQueuedSelectionChange();
                            boolean queuedChangingSelectionFlag = AbstractXmlTableEditor.this._queuedChangingSelectionFlag;
                            boolean queuedXmlComponentFlag = AbstractXmlTableEditor.this._queuedXmlComponentFlag;
                            AbstractXmlTableEditor.this.setQueuedSelectionChangeFlag(false);
                            AbstractXmlTableEditor.this.setQueuedSelectionChange(-1);
                            AbstractXmlTableEditor.this._queuedChangingSelectionFlag = false;
                            AbstractXmlTableEditor.this._queuedXmlComponentFlag = false;
                            AbstractXmlTableEditor.this.setSelectedIndex(queuedSelectionChange);
                            if (queuedSelectionChange < 0) {
                                AbstractXmlTableEditor.this.clearTableSelection();
                            } else {
                                AbstractXmlTableEditor.this.selectTableRow(queuedChangingSelectionFlag, queuedXmlComponentFlag);
                            }
                        }
                    }
                });
            }
        };
    }

    public void clearTableSelection() {
        this.getXmlComponentModel().invalidateNode();
        this.getXmlComponentModel().setSelectedIndex(-1);
        this.updateAddDeleteButtons();
        this.getXmlComponentWrapper().updateChildXmlComponents();
        if (this.getXmlComponentWrapper().getChildHeaderComponent() != null) {
            this.getXmlComponentWrapper().getChildHeaderComponent().setEnabled(false);
        }
    }

    public void selectTableRow(boolean changingSelectionFlag, final boolean getXmlComponentFlag) {
        if (!changingSelectionFlag) {
            this.setChangingSelectionFlag(true);
            new NonDomMutationTransactionTask(){

                protected void performTask(AbstractModel model) {
                    Node selection = (Node)AbstractXmlTableEditor.this.getXmlComponentModel().getChild((Object)AbstractXmlTableEditor.this.getXmlComponentModel().getParentNode(), AbstractXmlTableEditor.this.getSelectedIndex());
                    if (selection != null) {
                        Node currSelection;
                        if (!getXmlComponentFlag && (currSelection = model.getSelection().getFirstSelectedNode()) != selection) {
                            model.getSelection().set(selection);
                        }
                        AbstractXmlTableEditor.this.getXmlComponentModel().setNode(selection);
                        AbstractXmlTableEditor.this.getXmlComponentModel().setSelectedIndex(AbstractXmlTableEditor.this.getSelectedIndex());
                        AbstractXmlTableEditor.this.updateAddDeleteButtons();
                        AbstractXmlTableEditor.this.getXmlComponentWrapper().updateChildXmlComponents();
                    }
                }
            }.run((AbstractModel)this.getXmlComponentModel().getView());
            this.setChangingSelectionFlag(false);
        }
        this.updateAddDeleteButtons();
        if (this.getXmlComponentWrapper().getChildHeaderComponent() != null) {
            this.getXmlComponentWrapper().getChildHeaderComponent().setEnabled(true);
        }
    }

    public void dispose() {
        this.getXmlComponentWrapper().getXmlComponentModel().getXmlGui().removeModelListener((XmlModelListener)this._xmlSelectionListener);
    }

    public AbstractXmlTableEditor add(XmlComponentWrapper xmlComponentWrapper) {
        xmlComponentWrapper.setAddFocusTracker(false);
        this._columnXmlComponentWrapperList.add(xmlComponentWrapper);
        ++this._columnCount;
        return this;
    }

    public String getTableColumnName(int columnIndex) {
        return this._columnXmlComponentWrapperList.get(columnIndex).getXmlComponentModel().getXmlKey().getLocalName();
    }

    public XmlComponentWrapper getTableColumnComponentWrapper(int columnIndex) {
        return this._columnXmlComponentWrapperList.get(columnIndex);
    }

    public String getTableColumnTitle(int columnIndex) {
        XmlComponentWrapper columnXmlComponentWrapper = this._columnXmlComponentWrapperList.get(columnIndex);
        Object columnTitle = columnXmlComponentWrapper.getXmlComponentModel().getShortDisplayName();
        if (columnXmlComponentWrapper.getXmlComponentModel().isRequired().booleanValue()) {
            columnTitle = (String)columnTitle + "*";
        }
        return columnTitle;
    }

    protected abstract void updateAddDeleteButtons();

    public Action createAddAction() {
        AbstractAction addAction = new AbstractAction("", OracleIcons.getIcon((String)"add.png")){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractXmlTableEditor.this.getXmlComponentModel().insertChildNode();
                AbstractXmlTableEditor.this.getTableModel().newRowsAdded(new TableModelEvent(AbstractXmlTableEditor.this.getTableModel()));
                AbstractXmlTableEditor.this._tableModel.fireTableDataChanged();
                AbstractXmlTableEditor.this.updateAddDeleteButtons();
                int row = AbstractXmlTableEditor.this.getTable().getRowCount() - 1;
                AbstractXmlTableEditor.this.getTable().changeSelection(row, 0, false, false);
                AbstractXmlTableEditor.this.getTable().requestFocusInWindow();
                AbstractXmlTableEditor.this.getTable().scrollRectToVisible(AbstractXmlTableEditor.this.getTable().getCellRect(row, 0, true));
            }
        };
        String msg = this.getXmlComponentWrapper().getXmlComponentModel().getXmlGui().getTranslatedString("XMLCOMPONENTMODEL_UNDO_INSERT");
        String insertTooltip = FastMessageFormat.formatMessage((String)msg, (String)this.getXmlComponentWrapper().getXmlComponentModel().getShortDisplayName());
        addAction.putValue("ShortDescription", insertTooltip);
        return addAction;
    }

    public Action createDeleteAction() {
        final AbstractAction instantDeleteAction = new AbstractAction("", OracleIcons.getIcon((String)"delete.png")){

            @Override
            public void actionPerformed(ActionEvent e) {
                Node selectedNode;
                int row = AbstractXmlTableEditor.this.getTable().getSelectedRow();
                if (row != -1 && (selectedNode = (Node)AbstractXmlTableEditor.this.getXmlComponentModel().getChild((Object)AbstractXmlTableEditor.this.getXmlComponentModel().getParentNode(), row)) != null) {
                    AbstractXmlTableEditor.this.getXmlComponentModel().deleteNode(selectedNode);
                    AbstractXmlTableEditor.this.getXmlComponentModel().invalidateNode();
                    AbstractXmlTableEditor.this._tableModel.fireTableDataChanged();
                    AbstractXmlTableEditor.this.updateAddDeleteButtons();
                    if (row >= AbstractXmlTableEditor.this.getTable().getRowCount()) {
                        AbstractXmlTableEditor.this.getTable().changeSelection(AbstractXmlTableEditor.this.getTable().getRowCount() - 1, 0, false, false);
                    } else {
                        AbstractXmlTableEditor.this.getTable().changeSelection(row, 0, false, false);
                    }
                }
            }
        };
        XmlContext xmlContext = this.getXmlComponentModel().getView().getContext();
        final Action safeDeleteAction = xmlContext.getAction("clear");
        AbstractAction parentDeleteAction = new AbstractAction("", OracleIcons.getIcon((String)"delete.png")){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (AbstractXmlTableEditor.this.getTable().getCellEditor() != null) {
                    AbstractXmlTableEditor.this.getTable().getCellEditor().cancelCellEditing();
                }
                if (AbstractXmlTableEditor.this.getSafeDelete()) {
                    safeDeleteAction.actionPerformed(e);
                } else {
                    instantDeleteAction.actionPerformed(e);
                }
            }
        };
        String msg = this.getXmlComponentWrapper().getXmlComponentModel().getXmlGui().getTranslatedString("XMLCOMPONENTMODEL_UNDO_DELETE");
        String deleteTooltip = FastMessageFormat.formatMessage((String)msg, (String)this.getXmlComponentWrapper().getXmlComponentModel().getShortDisplayName());
        parentDeleteAction.putValue("ShortDescription", deleteTooltip);
        return parentDeleteAction;
    }

    public Object getCellValueAt(int rowIndex, int columnIndex) {
        XmlComponentWrapper columnXmlComponentWrapper = this.getColumnXmlComponentWrapperList().get(columnIndex);
        XmlComponentModel cellXmlComponentModel = AbstractXmlTableEditor.getCellXmlComponentModel(this.getXmlComponentModel(), columnXmlComponentWrapper, rowIndex);
        if (cellXmlComponentModel == null) {
            return null;
        }
        return cellXmlComponentModel.getModelValue();
    }

    public void setCellValueAt(Object value, int rowIndex, int columnIndex) {
        XmlComponentWrapper columnXmlComponentWrapper = this.getColumnXmlComponentWrapperList().get(columnIndex);
        XmlComponentModel cellXmlComponentModel = AbstractXmlTableEditor.getCellXmlComponentModel(this.getXmlComponentModel(), columnXmlComponentWrapper, rowIndex);
        if (cellXmlComponentModel == null) {
            return;
        }
        cellXmlComponentModel.updateModelValue((String)value);
    }

    public ArrayList<XmlComponentWrapper> getColumnXmlComponentWrapperList() {
        return this._columnXmlComponentWrapperList;
    }

    public int getTableColumnCount() {
        return this._columnCount;
    }

    public void onPermanentFocusOwnerChange(PropertyChangeEvent ev, KeyboardFocusManager focusManager) {
        XmlTableCellEditor xmlTableCellEditor;
        TableCellEditorFocusLostDecorator focusLostDecorator;
        Component componentWithFocus = focusManager.getPermanentFocusOwner();
        if (!this.getTable().isEditing()) {
            return;
        }
        if (componentWithFocus == null) {
            return;
        }
        if (this.getTable().getCellEditor() instanceof TableCellEditorFocusLostDecorator && (focusLostDecorator = (TableCellEditorFocusLostDecorator)this.getTable().getCellEditor()).getBaseTableCellEditor() instanceof XmlTableCellEditor && (xmlTableCellEditor = (XmlTableCellEditor)focusLostDecorator.getBaseTableCellEditor()).isActiveCustomEditor()) {
            return;
        }
        JComponent currentTableCellEditorComponent = (JComponent)this.getCurrentTableCellEditorComponent();
        if (ev.getNewValue() instanceof XmlContextualActionButton && currentTableCellEditorComponent.isAncestorOf((Component)ev.getNewValue())) {
            return;
        }
        if (((JComponent)this.getCurrentTableCellEditorComponent()).isAncestorOf((Component)ev.getOldValue()) || this.getCurrentTableCellEditorComponent() != ev.getOldValue()) {
            HashSet<Component> focusRemainsInsideTableSet = new HashSet<Component>();
            this.loadFocusRemainsInsideTableSet(focusRemainsInsideTableSet);
            if (this.focusRemainsInsideTable(componentWithFocus, focusRemainsInsideTableSet, null, ev)) {
                return;
            }
            if (!this._focusLostStopCellEditingFlag) {
                this._focusLostStopCellEditingFlag = true;
                this.handleFocusLeavesTable(this.getTable().getCellEditor());
            }
        }
    }

    public void onTableCellFocusLost(FocusEvent focusEvent) {
        Component c;
        this._focusLostFalsePositiveSet = new HashSet<Component>();
        KeyboardFocusManager fm = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        Component componentWithFocus = fm.getPermanentFocusOwner();
        Component oppositeComponent = focusEvent.getOppositeComponent();
        boolean oppositeComponentIsFocusOwner = false;
        if (oppositeComponent != null) {
            oppositeComponentIsFocusOwner = oppositeComponent.isFocusOwner();
        }
        if ((c = componentWithFocus) == null) {
            c = oppositeComponent;
        }
        if (c == null) {
            return;
        }
        Component sourceComponent = (Component)focusEvent.getSource();
        if (sourceComponent == null) {
            return;
        }
        if (((JComponent)this.getCurrentTableCellEditorComponent()).isAncestorOf(sourceComponent) || this.getCurrentTableCellEditorComponent() != sourceComponent) {
            HashSet<Component> focusRemainsInsideTableSet = new HashSet<Component>();
            this.loadFocusRemainsInsideTableSet(focusRemainsInsideTableSet);
            if (this.focusRemainsInsideTable(c, focusRemainsInsideTableSet, focusEvent, null)) {
                return;
            }
            this.handleFocusLeavesTable(this.getTable().getCellEditor());
        }
    }

    public boolean focusRemainsInsideTable(Component componentWithFocus, HashSet<Component> focusRemainsInsideTableSet, FocusEvent focusEvent, PropertyChangeEvent propertyChangeEvent) {
        boolean focusRemainsInsideTable = false;
        if (focusRemainsInsideTableSet.contains(componentWithFocus)) {
            return true;
        }
        boolean componentWithFocusIsFocusOwner = false;
        if (componentWithFocus != null && componentWithFocus instanceof Component) {
            componentWithFocusIsFocusOwner = componentWithFocus.isFocusOwner();
        }
        JComponent currentTableCellEditorComponent = (JComponent)this.getCurrentTableCellEditorComponent();
        if (componentWithFocus != null && currentTableCellEditorComponent != null && currentTableCellEditorComponent.isAncestorOf(componentWithFocus)) {
            focusRemainsInsideTable = true;
        } else if (componentWithFocus != null && this.getTable().isAncestorOf(componentWithFocus)) {
            focusRemainsInsideTable = true;
        } else if (componentWithFocus != null) {
            if (focusEvent != null) {
                if (focusEvent.toString().indexOf("cause=TRAVERSAL_FORWARD") > 0) {
                    focusRemainsInsideTable = true;
                    if (focusEvent.getOppositeComponent() != null) {
                        this._focusLostFalsePositiveSet.add(focusEvent.getOppositeComponent());
                    }
                }
            } else if (propertyChangeEvent != null && propertyChangeEvent.getOldValue() == null && this._focusLostFalsePositiveSet != null && this._focusLostFalsePositiveSet.contains(componentWithFocus)) {
                focusRemainsInsideTable = true;
            }
        }
        return focusRemainsInsideTable;
    }

    public void loadFocusRemainsInsideTableSet(HashSet<Component> focusRemainsInsideTableComponentSet) {
        focusRemainsInsideTableComponentSet.add(this.getTable());
        focusRemainsInsideTableComponentSet.add(this.getTablePanel());
        if (this.getCurrentTableCellEditorComponent() != null) {
            focusRemainsInsideTableComponentSet.add(this.getCurrentTableCellEditorComponent());
        }
    }

    public void handleFocusLeavesTable(CellEditor cellEditor) {
        if (cellEditor != null && !cellEditor.stopCellEditing()) {
            cellEditor.cancelCellEditing();
        }
    }

    protected void setTableCellEditors() {
        for (int i = 0; i < this._columnCount; ++i) {
            TableColumn tc = this.getTable().getColumnModel().getColumn(i);
            Node node = this.getXmlComponentModel().getNode();
            XmlKey xmlKey = this.getXmlComponentModel().getXmlKey();
            Node ownerNode = node != null && xmlKey.getNodeType() == 2 ? this.getXmlComponentModel().getParentAttrNode() : node;
            tc.setCellEditor(this.createXmlTableCellEditor(this.getXmlComponentModel().getView().getContext(), ImmutableXmlKey.createAttributeKey((List)xmlKey.getElementQNamePath(), (String)this.getTableColumnName(i)), node, ownerNode, FocusLostBehavior.DO_NOTHING, this.getTableColumnComponentWrapper(i)));
            tc.setCellRenderer(this.createXmlTableCellRenderer(this.getXmlComponentWrapper(), i));
        }
    }

    protected XmlTableCellEditor createXmlTableCellEditor(XmlContext xmlContext, XmlKey xmlKey, Node node, Node ownerNode, FocusLostBehavior focusLostBehaviour, XmlComponentWrapper xmlComponentWrapper) {
        return new XmlTableCellEditor(xmlContext, xmlKey, node, ownerNode, focusLostBehaviour, xmlComponentWrapper);
    }

    protected XmlTableCellRenderer createXmlTableCellRenderer(XmlComponentWrapper xmlComponentWrapper, int column) {
        return new XmlTableCellRenderer(xmlComponentWrapper, column, this.getColumnXmlComponentWrapperList());
    }

    public XmlComponentLayoutOption getXmlComponentLayoutOption() {
        XmlLayoutOption elementTableLayoutOption = new XmlLayoutOption().setAddLabel(false).setSpanEntireRow(true).setShowContextualActionButton(false).setLeftMargin(0);
        return elementTableLayoutOption;
    }

    public AbstractXmlTableEditor setEnabled(boolean enabled) {
        if (this.getTablePanel() != null) {
            this.getTablePanel().setEnabled(enabled);
            this.getXmlTableAdapter().setEnabled(enabled);
        }
        return this;
    }

    public boolean getSafeDelete() {
        return this._safeDelete;
    }

    public AbstractXmlTableEditor setSafeDelete(boolean safeDelete) {
        this._safeDelete = safeDelete;
        return this;
    }

    public boolean getShowReorderableRowButtons() {
        return this._showReorderableRowButtons;
    }

    public AbstractXmlTableEditor setShowReorderableRowButtons(boolean showReorderableRowButtons) {
        this._showReorderableRowButtons = showReorderableRowButtons;
        return this;
    }

    static XmlComponentModel getCellXmlComponentModel(XmlComponentModel tableXmlComponentModel, XmlComponentWrapper columnXmlComponentWrapper, int rowIndex) {
        XmlComponentModel xmlComponentModel = null;
        Node parentNode = tableXmlComponentModel.getParentNode();
        Node foundNode = (Node)tableXmlComponentModel.getChild((Object)parentNode, rowIndex);
        if (foundNode != null) {
            XmlComponentWrapper parentXmlComponentWrapper = columnXmlComponentWrapper.getParent();
            xmlComponentModel = columnXmlComponentWrapper.getXmlComponentModel();
            if (parentXmlComponentWrapper == null) {
                xmlComponentModel.setParentXmlComponentModel(null);
            } else {
                xmlComponentModel.setParentXmlComponentModel(parentXmlComponentWrapper.getXmlComponentModel());
            }
            xmlComponentModel.setStartNode(foundNode);
            xmlComponentModel.invalidateNode();
        }
        return xmlComponentModel;
    }

    protected void setupTableCellEditorFocusLostDecorator() {
        for (int i = 0; i < this.getTable().getColumnCount(); ++i) {
            this.getTable().getColumnModel().getColumn(i).setCellEditor(new TableCellEditorFocusLostDecorator(this.getTable().getColumnModel().getColumn(i).getCellEditor(), this.getTableColumnComponentWrapper(i)){

                @Override
                public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
                    AbstractXmlTableEditor.this.setCurrentTableCellEditorComponent(super.getTableCellEditorComponent(table, value, isSelected, row, column));
                    return AbstractXmlTableEditor.this.getCurrentTableCellEditorComponent();
                }
            });
        }
    }

    public Component getCurrentTableCellEditorComponent() {
        return this._currentTableCellEditorComponent;
    }

    public void setCurrentTableCellEditorComponent(Component component) {
        this._currentTableCellEditorComponent = component;
    }

    public boolean handleSelectionChanged(final Object selectedObject) {
        if (!(selectedObject instanceof Node)) {
            return false;
        }
        return (Boolean)new ReadOnlyTask<Boolean>(){

            protected Boolean runImpl(AbstractModel model) {
                AbstractXmlTableEditor.this.setupSelectionListener();
                Node parentNode = AbstractXmlTableEditor.this.getXmlComponentModel().getParentNode();
                for (int i = 0; i < AbstractXmlTableEditor.this.getXmlComponentModel().getChildCount((Object)parentNode); ++i) {
                    Node currNode = (Node)AbstractXmlTableEditor.this.getXmlComponentModel().getChild((Object)parentNode, i);
                    boolean isNodeOrDescendant = DomUtils.isNodeOrDescendant((TreeTraversal)AbstractXmlTableEditor.this.getXmlComponentModel().getView().getTreeTraversal(), (Node)((Node)selectedObject), (Node)currNode);
                    if (!isNodeOrDescendant) continue;
                    if (AbstractXmlTableEditor.this.getSelectedIndex() != i) {
                        AbstractXmlTableEditor.this.setSelectedIndex(i);
                        AbstractXmlTableEditor.this.getXmlComponentModel().setNode(currNode);
                        AbstractXmlTableEditor.this.getXmlComponentModel().setSelectedIndex(i);
                        AbstractXmlTableEditor.this.setChangingSelectionFlag(true);
                        int row = AbstractXmlTableEditor.this.getTable().convertRowIndexToView(i);
                        if (row != -1) {
                            if (AbstractXmlTableEditor.this.getTable() instanceof GenericTable) {
                                ((GenericTable)AbstractXmlTableEditor.this.getTable()).setSelectedRowInModel(row);
                            } else {
                                AbstractXmlTableEditor.this.getTable().getSelectionModel().setSelectionInterval(row, row);
                            }
                        }
                        AbstractXmlTableEditor.this.updateAddDeleteButtons();
                        AbstractXmlTableEditor.this.getXmlComponentWrapper().updateChildXmlComponents();
                        AbstractXmlTableEditor.this.setChangingSelectionFlag(false);
                    }
                    return true;
                }
                return false;
            }
        }.run((AbstractModel)this.getXmlComponentModel().getView());
    }

    public boolean getXmlComponentFlag() {
        return this._xmlComponentFlag;
    }

    public void setXmlComponentFlag(boolean xmlComponentFlag) {
        this._xmlComponentFlag = xmlComponentFlag;
    }

    protected boolean getChangingSelectionFlag() {
        return this._changingSelectionFlag;
    }

    protected void setChangingSelectionFlag(boolean changingSelectionFlag) {
        this._changingSelectionFlag = changingSelectionFlag;
    }

    protected int getSelectedIndex() {
        return this._selectedIndex;
    }

    protected void setSelectedIndex(int selectedIndex) {
        this._selectedIndex = selectedIndex;
    }

    protected int getPrevSelectedIndex() {
        return this._prevSelectedIndex;
    }

    protected void setPrevSelectedIndex(int prevSelectedIndex) {
        this._prevSelectedIndex = prevSelectedIndex;
    }

    protected boolean getQueuedSelectionChangeFlag() {
        return this._queuedSelectionChangeFlag;
    }

    protected void setQueuedSelectionChangeFlag(boolean queuedSelectionChangeFlag) {
        this._queuedSelectionChangeFlag = queuedSelectionChangeFlag;
    }

    protected int getQueuedSelectionChange() {
        return this._queuedSelectionChange;
    }

    protected void setQueuedSelectionChange(int queuedSelectionChange) {
        this._queuedSelectionChange = queuedSelectionChange;
    }

    protected void setupSelectionListener() {
    }

    public class XmlSelectionListener
    extends XmlModelAdapter {
        public void modelChanged(XmlModelEvent event) {
            if (event.getIssueListPropertyChange() != null) {
                AbstractXmlTableEditor.this.getTable().repaint();
            }
            if (!AbstractXmlTableEditor.this.getChangingSelectionFlag() && event.isSelectionChanged()) {
                AbstractXmlTableEditor.this.setupSelectionListener();
                Set selectionsAdded = event.getSelectionsAdded();
                for (Node selectedNode : selectionsAdded) {
                    Node parentNode = AbstractXmlTableEditor.this.getXmlComponentModel().getParentNode();
                    for (int i = 0; i < AbstractXmlTableEditor.this.getXmlComponentModel().getChildCount((Object)parentNode); ++i) {
                        Node currNode = (Node)AbstractXmlTableEditor.this.getXmlComponentModel().getChild((Object)parentNode, i);
                        boolean isNodeOrDescendant = DomUtils.isNodeOrDescendant((TreeTraversal)AbstractXmlTableEditor.this.getXmlComponentModel().getView().getTreeTraversal(), (Node)selectedNode, (Node)currNode);
                        if (!isNodeOrDescendant || AbstractXmlTableEditor.this.getSelectedIndex() == i) continue;
                        AbstractXmlTableEditor.this.setSelectedIndex(i);
                        AbstractXmlTableEditor.this.getXmlComponentModel().setNode(currNode);
                        AbstractXmlTableEditor.this.getXmlComponentModel().setSelectedIndex(i);
                        AbstractXmlTableEditor.this.setChangingSelectionFlag(true);
                        int row = AbstractXmlTableEditor.this.getTable().convertRowIndexToView(i);
                        if (row != -1) {
                            if (AbstractXmlTableEditor.this.getTable() instanceof GenericTable) {
                                ((GenericTable)AbstractXmlTableEditor.this.getTable()).setSelectedRowInModel(row);
                            } else {
                                AbstractXmlTableEditor.this.getTable().getSelectionModel().setSelectionInterval(row, row);
                            }
                        }
                        AbstractXmlTableEditor.this.updateAddDeleteButtons();
                        AbstractXmlTableEditor.this.getXmlComponentWrapper().updateChildXmlComponents();
                        AbstractXmlTableEditor.this.setChangingSelectionFlag(false);
                    }
                }
            }
        }
    }

    public class TableCellEditorFocusLostDecorator
    extends AbstractTableCellEditorDecorator {
        private Component _tableCellEditorComponent;
        private FocusListener _focusListener;

        public TableCellEditorFocusLostDecorator(TableCellEditor baseTableCellEditor, XmlComponentWrapper tableCelllComponentWrapper) {
            super(baseTableCellEditor, tableCelllComponentWrapper);
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this._tableCellEditorComponent = this.getBaseTableCellEditor().getTableCellEditorComponent(table, value, isSelected, row, column);
            this._focusListener = new TableCellEditorFocusLostListener();
            this._tableCellEditorComponent.addFocusListener(this._focusListener);
            if (this._tableCellEditorComponent instanceof Container) {
                this.addFocusListener((Container)this._tableCellEditorComponent, this._focusListener);
            }
            AbstractXmlTableEditor.this._focusLostStopCellEditingFlag = false;
            return this._tableCellEditorComponent;
        }

        public void addFocusListener(Container container, FocusListener focusListener) {
            for (int i = 0; i < container.getComponentCount(); ++i) {
                Component component = container.getComponent(i);
                component.addFocusListener(focusListener);
                if (!(component instanceof Container)) continue;
                this.addFocusListener((Container)component, focusListener);
            }
        }

        @Override
        public boolean stopCellEditing() {
            if (this._tableCellEditorComponent != null && this._focusListener != null) {
                this._tableCellEditorComponent.removeFocusListener(this._focusListener);
            }
            boolean result = this.getBaseTableCellEditor().stopCellEditing();
            return result;
        }

        @Override
        public void cancelCellEditing() {
            if (this._tableCellEditorComponent != null && this._focusListener != null) {
                this._tableCellEditorComponent.removeFocusListener(this._focusListener);
            }
            this.getBaseTableCellEditor().cancelCellEditing();
        }

        public class TableCellEditorFocusLostListener
        implements FocusListener {
            @Override
            public void focusGained(FocusEvent focusEvent) {
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                AbstractXmlTableEditor.this.onTableCellFocusLost(focusEvent);
            }
        }
    }

    public static enum FocusLostBehavior {
        DO_NOTHING,
        STOP_CELL_EDITING,
        CANCEL_CELL_EDITING;

    }

    public abstract class AbstractTableCellEditorDecorator
    implements TableCellEditor {
        TableCellEditor _baseTableCellEditor;
        XmlComponentWrapper _tableCellComponentWrapper;

        public AbstractTableCellEditorDecorator(TableCellEditor baseTableCellEditor, XmlComponentWrapper tableCelllComponentWrapper) {
            this._baseTableCellEditor = baseTableCellEditor;
            this._tableCellComponentWrapper = tableCelllComponentWrapper;
        }

        public TableCellEditor getBaseTableCellEditor() {
            return this._baseTableCellEditor;
        }

        public XmlComponentWrapper getTableCellComponentWrapper() {
            return this._tableCellComponentWrapper;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            return this.getBaseTableCellEditor().getTableCellEditorComponent(table, value, isSelected, row, column);
        }

        @Override
        public Object getCellEditorValue() {
            return this.getBaseTableCellEditor().getCellEditorValue();
        }

        @Override
        public boolean isCellEditable(EventObject anEvent) {
            return this.getBaseTableCellEditor().isCellEditable(anEvent);
        }

        @Override
        public boolean shouldSelectCell(EventObject anEvent) {
            return this.getBaseTableCellEditor().shouldSelectCell(anEvent);
        }

        @Override
        public boolean stopCellEditing() {
            return this.getBaseTableCellEditor().stopCellEditing();
        }

        @Override
        public void cancelCellEditing() {
            this.getBaseTableCellEditor().cancelCellEditing();
        }

        @Override
        public void addCellEditorListener(CellEditorListener l) {
            this.getBaseTableCellEditor().addCellEditorListener(l);
        }

        @Override
        public void removeCellEditorListener(CellEditorListener l) {
            this.getBaseTableCellEditor().removeCellEditorListener(l);
        }
    }
}

