/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.swing.util;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Level;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import oracle.bali.share.nls.StringUtils;
import oracle.bali.xml.dom.position.DomPosition;
import oracle.bali.xml.gui.swing.SwingXmlContext;
import oracle.bali.xml.gui.swing.util.Pickable;
import oracle.bali.xml.gui.swing.util.PickablePicker;
import oracle.bali.xml.metadata.XmlKey;
import oracle.bali.xml.model.AbstractModel;
import oracle.bali.xml.model.XmlCommitException;
import oracle.bali.xml.model.XmlContext;
import oracle.bali.xml.model.XmlMetadataResolver;
import oracle.bali.xml.model.XmlView;
import oracle.bali.xml.model.category.CategoryDefinition;
import oracle.bali.xml.model.creatable.XmlCreatable;
import oracle.bali.xml.model.creatable.XmlCreationContext;
import oracle.bali.xml.util.XmlCreatableAction;
import org.w3c.dom.Node;

public class InsertionMenuGenerator {
    private static final int _MAX_NAMESPACES_IN_MENU = 15;
    private static final int _MAX_ITEMS_IN_NAMESPACE_MENU = 20;
    private static final int _MAX_ITEMS_PROMOTED_TO_ROOT_MENU = 20;

    private InsertionMenuGenerator() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List generateInsertionMenus(XmlView view, DomPosition position) {
        if (position == null) {
            return Collections.EMPTY_LIST;
        }
        LinkedList<Component> insertionSubmenus = new LinkedList<Component>();
        XmlMetadataResolver resolver = view.getXmlMetadataResolver();
        view.acquireReadLock();
        try {
            Collection insertionPositions = resolver.getPotentialInsertionPositions(position);
            for (DomPosition insertionPosition : insertionPositions) {
                Component subMenu;
                if (!resolver.canAddChild(insertionPosition) || (subMenu = InsertionMenuGenerator._generateInsertionSubmenu(view, insertionPosition)) == null) continue;
                insertionSubmenus.add(subMenu);
            }
            LinkedList<Component> linkedList = insertionSubmenus;
            return linkedList;
        }
        finally {
            view.releaseReadLock();
        }
    }

    private static Component _generateInsertionSubmenu(XmlView view, DomPosition insertionPosition) {
        String titleKey;
        Node containerNode = insertionPosition.getContainerNode(view.getTreeTraversal());
        XmlKey containerKey = view.getNodeXmlKey(containerNode);
        final XmlCreationContext context = XmlCreationContext.create((AbstractModel)view, (String)"xmlef-insertion-menu", (DomPosition)insertionPosition, (XmlKey)containerKey);
        XmlMetadataResolver resolver = context.getMetadataResolver();
        Iterator creatableIter = resolver.getXmlCreatables(context);
        boolean hasMenu = false;
        while (creatableIter.hasNext()) {
            if (((XmlCreatable)creatableIter.next()).isHidden(context)) continue;
            hasMenu = true;
            break;
        }
        if (!hasMenu) {
            return null;
        }
        float weight = switch (insertionPosition.getRelativePosition()) {
            case 2 -> {
                titleKey = "InsertAfter";
                yield 3.0f;
            }
            case 1 -> {
                titleKey = "InsertBefore";
                yield 1.0f;
            }
            case 0 -> {
                titleKey = "InsertInside";
                yield 2.0f;
            }
            default -> throw new IllegalStateException("invalid position: " + insertionPosition);
        };
        Node targetNode = insertionPosition.getTargetNode();
        String menuTitle = view.getTranslatedString(titleKey, resolver.getShortDisplayName(targetNode));
        int mnemonic = StringUtils.getMnemonicKeyCode((String)menuTitle);
        menuTitle = StringUtils.stripMnemonic((String)menuTitle);
        Iterator lazyItor = new Iterator(){
            private Iterator _realItor;

            @Override
            public boolean hasNext() {
                this._populate();
                return this._realItor.hasNext();
            }

            public Object next() {
                this._populate();
                return this._realItor.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            private void _populate() {
                if (this._realItor == null) {
                    LinkedList list = new LinkedList();
                    InsertionMenuGenerator._populateInsertionMenusForPosition(context, list);
                    this._realItor = list.iterator();
                }
            }
        };
        JMenu menu = InsertionMenuGenerator._createMenu((AbstractModel)view, menuTitle, lazyItor);
        menu.setMnemonic(mnemonic);
        menu.putClientProperty("XmlContext.CONTEXT_SECTION_ID_ACTION_PROPERTY", XmlContext.INSERTION_SECTION_ID_VALUE);
        menu.putClientProperty("XmlContext.CONTEXT_SECTION_WEIGHT", Float.valueOf(weight));
        return menu;
    }

    private static JMenu _createMenu(AbstractModel view, String menuTitle, Iterator items) {
        JMenu menu = ((SwingXmlContext)view.getContext()).createMenu(menuTitle, items);
        menu.putClientProperty(SwingXmlContext.MENU_PROPERTY_REQUEST_AUTO_MNEUMONICS, Boolean.TRUE);
        return menu;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void _populateInsertionMenusForPosition(XmlCreationContext context, Collection topLevelItems) {
        AbstractModel model = context.getModel();
        model.acquireReadLock();
        try {
            XmlMetadataResolver resolver = model.getXmlMetadataResolver();
            Collator collator = Collator.getInstance(model.getContext().getLocale());
            Iterator preferredChildrenItr = resolver.getPreferredXmlCreatables(context);
            ArrayList<XmlCreatable> preferredChildren = new ArrayList<XmlCreatable>();
            while (preferredChildrenItr.hasNext()) {
                preferredChildren.add((XmlCreatable)preferredChildrenItr.next());
            }
            XmlCreatableComparator convertComparator = new XmlCreatableComparator(context, collator);
            Collections.sort(preferredChildren, convertComparator);
            topLevelItems.addAll(XmlCreatableAction.createLazyActionCollectionFromCollection((XmlCreationContext)context, preferredChildren));
            TreeMap<CategoryDefinition, List<XmlCreatable>> creatableMap = new TreeMap<CategoryDefinition, List<XmlCreatable>>();
            int creatablesSize = InsertionMenuGenerator._groupCreatablesByCategory(context, collator, creatableMap);
            if (creatableMap.isEmpty()) {
                return;
            }
            int creationMapSize = creatableMap.size();
            if (creationMapSize + creatablesSize - preferredChildren.size() < 20) {
                boolean noSeparatorBefore = preferredChildren.isEmpty();
                for (Map.Entry entry : creatableMap.entrySet()) {
                    boolean firstInCurGroup = true;
                    for (XmlCreatable creatable : (List)entry.getValue()) {
                        if (preferredChildren.contains(creatable)) continue;
                        if (firstInCurGroup) {
                            firstInCurGroup = false;
                            if (noSeparatorBefore) {
                                noSeparatorBefore = false;
                            } else {
                                topLevelItems.add(new JPopupMenu.Separator());
                            }
                        }
                        topLevelItems.add(new XmlCreatableAction(context, creatable));
                    }
                }
            } else if (creationMapSize <= 15) {
                if (!topLevelItems.isEmpty()) {
                    topLevelItems.add(new JPopupMenu.Separator());
                }
                for (Map.Entry<CategoryDefinition, List<XmlCreatable>> entry : creatableMap.entrySet()) {
                    InsertionMenuGenerator._addSubmenuForKeys(context, topLevelItems, entry);
                }
            }
            if (!creatableMap.isEmpty()) {
                if (!topLevelItems.isEmpty()) {
                    topLevelItems.add(new JPopupMenu.Separator());
                }
                String browseString = model.getTranslatedString("BROWSE");
                topLevelItems.add(new ShowDialogAction(browseString, creatableMap, context));
            }
        }
        finally {
            model.releaseReadLock();
        }
    }

    private static void _addSubmenuForKeys(XmlCreationContext context, Collection baseCreationCollection, Map.Entry<CategoryDefinition, List<XmlCreatable>> entry) {
        AbstractModel view = context.getModel();
        List<XmlCreatable> creatables = entry.getValue();
        CategoryDefinition category = entry.getKey();
        String categoryName = category.getDisplayName();
        if (creatables.size() <= 20) {
            Collection actions = XmlCreatableAction.createLazyActionCollectionFromCollection((XmlCreationContext)context, creatables);
            baseCreationCollection.add(InsertionMenuGenerator._createMenu(view, categoryName, actions.iterator()));
        } else {
            String actionName = view.getTranslatedString("INSERT_MENU.OVERFLOW_FORMAT", categoryName);
            baseCreationCollection.add(new ShowDialogAction(actionName, Collections.singletonMap(category, creatables), context));
        }
    }

    private static Component _getParentComponent(AbstractModel model) {
        if (model.getContext() instanceof SwingXmlContext) {
            return ((SwingXmlContext)model.getContext()).getRootDocumentUIComponent();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int _groupCreatablesByCategory(XmlCreationContext context, Collator collator, Map<CategoryDefinition, List<XmlCreatable>> map) {
        AbstractModel model = context.getModel();
        model.acquireReadLock();
        try {
            XmlMetadataResolver res = model.getXmlMetadataResolver();
            Iterator creatables = res.getXmlCreatables(context);
            if (creatables == null) {
                int n = 0;
                return n;
            }
            int count = 0;
            HashMap<CategoryDefinition, ArrayList<XmlCreatable>> firstMap = new HashMap<CategoryDefinition, ArrayList<XmlCreatable>>();
            while (creatables.hasNext()) {
                XmlCreatable creatable = (XmlCreatable)creatables.next();
                if (creatable.isHidden(context)) continue;
                List categories = creatable.getCategoryDefinition(context);
                CategoryDefinition category = (CategoryDefinition)categories.iterator().next();
                ArrayList<XmlCreatable> collectionForCategory = (ArrayList<XmlCreatable>)firstMap.get(category);
                if (collectionForCategory == null) {
                    collectionForCategory = new ArrayList<XmlCreatable>();
                    firstMap.put(category, collectionForCategory);
                }
                collectionForCategory.add(creatable);
                ++count;
            }
            if (firstMap.isEmpty()) {
                int creatable = 0;
                return creatable;
            }
            XmlCreatableComparator convertComparator = new XmlCreatableComparator(context, collator);
            for (Map.Entry entry : firstMap.entrySet()) {
                CategoryDefinition category = (CategoryDefinition)entry.getKey();
                List creatableList = (List)entry.getValue();
                if (map.containsKey(category)) {
                    List<XmlCreatable> eList = map.get(category);
                    creatableList.addAll(eList);
                }
                Collections.sort(creatableList, convertComparator);
                map.put(category, creatableList);
            }
            int n = count;
            return n;
        }
        finally {
            model.releaseReadLock();
        }
    }

    private static class XmlCreatableComparator
    implements Comparator<XmlCreatable> {
        private XmlCreationContext _context;
        private Collator _collator;

        public XmlCreatableComparator(XmlCreationContext context, Collator collator) {
            this._context = context;
            this._collator = collator;
        }

        @Override
        public int compare(XmlCreatable o1, XmlCreatable o2) {
            return this._collator.compare(o1.getShortDisplayName(this._context), o2.getShortDisplayName(this._context));
        }
    }

    private static class ShowDialogAction
    extends AbstractAction {
        private final XmlCreationContext _context;
        private final Map<CategoryDefinition, List<XmlCreatable>> _creatableMap;

        public ShowDialogAction(String name, Map<CategoryDefinition, List<XmlCreatable>> creatableMap, XmlCreationContext context) {
            if (creatableMap.isEmpty()) {
                throw new IllegalArgumentException("empty map");
            }
            this.putValue("Name", name);
            this._creatableMap = creatableMap;
            this._context = context;
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            Set<CategoryDefinition> categoriesSet;
            XmlMetadataResolver resolver = this._context.getMetadataResolver();
            XmlKey parentKey = this._context.getParentKey();
            AbstractModel view = this._context.getModel();
            DomPosition pos = this._context.getDomPosition();
            CategoryDefinition initialSelection = null;
            List catDefs = resolver.getCategoryDefinition(parentKey);
            if (catDefs != null && !catDefs.isEmpty()) {
                initialSelection = (CategoryDefinition)catDefs.get(0);
            }
            String strTitle = (categoriesSet = this._creatableMap.keySet()).size() == 1 ? view.getTranslatedString("XML_INSERT_ITEM_FORMAT_KEY", categoriesSet.iterator().next().getDisplayName()) : view.getTranslatedString("XML_INSERT_ITEM_KEY");
            Component parentComponent = InsertionMenuGenerator._getParentComponent(view);
            Pickable selected = PickablePicker.runDialog(parentComponent, strTitle, "f1_editorcreate_html", this.convertCreatablesToPickables(this._creatableMap), view, initialSelection);
            if (selected != null) {
                try {
                    ((XmlCreatablePickable)selected).getCreatable().createAtPosition(this._context, pos, null);
                }
                catch (XmlCommitException e) {
                    view.getLogger().log(Level.SEVERE, "unable to create " + selected + " at position " + pos, e);
                }
            }
        }

        private Map<CategoryDefinition, List<Pickable>> convertCreatablesToPickables(Map<CategoryDefinition, List<XmlCreatable>> creatableMap) {
            HashMap<CategoryDefinition, List<Pickable>> pickableMap = new HashMap<CategoryDefinition, List<Pickable>>();
            for (Map.Entry<CategoryDefinition, List<XmlCreatable>> entry : creatableMap.entrySet()) {
                List<XmlCreatable> creatables = entry.getValue();
                ArrayList<XmlCreatablePickable> pickables = new ArrayList<XmlCreatablePickable>(creatables.size());
                for (XmlCreatable creatable : creatables) {
                    pickables.add(new XmlCreatablePickable(this._context, creatable));
                }
                pickableMap.put(entry.getKey(), pickables);
            }
            return pickableMap;
        }
    }

    private static class XmlCreatablePickable
    implements Pickable {
        private XmlCreationContext _context;
        private XmlCreatable _creatable;

        public XmlCreatablePickable(XmlCreationContext context, XmlCreatable creatable) {
            this._context = context;
            this._creatable = creatable;
        }

        @Override
        public String getDisplayName() {
            return this._creatable.getShortDisplayName(this._context);
        }

        @Override
        public String getShortDescription() {
            return this._creatable.getShortDescription(this._context);
        }

        @Override
        public Icon getIcon() {
            return this._creatable.getSmallIcon(this._context);
        }

        public XmlCreatable getCreatable() {
            return this._creatable;
        }
    }
}

