/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.swing.util;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.ewt.help.HelpUtils;
import oracle.bali.share.nls.StringUtils;
import oracle.bali.xml.dom.util.DomUtils;
import oracle.bali.xml.gui.swing.SwingXmlContext;
import oracle.bali.xml.metadata.XmlKey;
import oracle.bali.xml.model.AbstractModel;
import oracle.bali.xml.model.XmlCommitException;
import oracle.bali.xml.model.XmlContext;
import oracle.bali.xml.model.task.FixedNameTransactionTask;
import oracle.bali.xml.share.FastMessageFormat;
import oracle.javatools.dialogs.MessageDialog;
import org.w3c.dom.Element;

public abstract class AbstractAddAttributeAction
extends AbstractAction {
    private XmlContext _context;
    private XmlKey _key;
    private Element _element;

    public AbstractAddAttributeAction(XmlContext context, XmlKey key, Element element) {
        this._context = context;
        this._key = key;
        this._element = element;
        String attributeName = this.getContext().getTranslatedString("ADDATTRIBUTE.NAME");
        this.putValue("Name", StringUtils.stripMnemonic((String)attributeName));
        this.putValue("MnemonicKey", StringUtils.getMnemonicKeyCode((String)attributeName));
        this.setEnabled(true);
    }

    @Override
    public final void actionPerformed(ActionEvent e) {
        int buttonMask = 3;
        String helpID = this.getHelpID();
        if (helpID != null) {
            buttonMask |= 4;
        }
        String title = this.getContext().getTranslatedString("ADDATTRIBUTE.TITLE");
        final JEWTDialog dialog = JEWTDialog.createDialog((Component)this.getParentFrame(), (String)title, (int)buttonMask);
        dialog.addVetoableChangeListener(new VetoableChangeListener(){

            @Override
            public void vetoableChange(PropertyChangeEvent pce) throws PropertyVetoException {
                if ("closed".equals(pce.getPropertyName()) && Boolean.TRUE.equals(pce.getNewValue())) {
                    try {
                        AbstractAddAttributeAction.this.validateContent();
                    }
                    catch (Exception x) {
                        MessageDialog.error((Component)dialog, (Object)x.getLocalizedMessage(), (String)AbstractAddAttributeAction.this.getContext().getTranslatedString("ERROR_DIALOG_TITLE"), null);
                        throw new PropertyVetoException(x.getLocalizedMessage(), pce);
                    }
                }
            }
        });
        dialog.setContent(this.createContent());
        HelpUtils.setHelpID((JComponent)((JComponent)dialog.getContent()), (String)helpID);
        if (dialog.runDialog()) {
            this.addAttribute(this.getNamespace(), this.getPrefix(), this.getLocalName(), this.getValue());
        }
    }

    protected abstract Component createContent();

    protected abstract String getNamespace();

    protected abstract String getPrefix();

    protected abstract String getLocalName();

    protected abstract String getValue();

    protected abstract void validateContent() throws Exception;

    protected String getHelpID() {
        return null;
    }

    protected Component getParentFrame() {
        return ((SwingXmlContext)this.getContext()).getRootDocumentUIComponent();
    }

    protected final void addAttribute(final String namespace, final String prefix, final String localName, String origValue) {
        final String value = origValue == null ? "" : origValue;
        String format = this.getContext().getTranslatedString("ADDATTRIBUTE.TRANS_NAME");
        FastMessageFormat fmf = new FastMessageFormat(format);
        String txnName = fmf.format((Object)localName);
        new FixedNameTransactionTask(txnName){

            protected void performTask(AbstractModel model) throws XmlCommitException {
                if (prefix != null && !"".equals(prefix)) {
                    DomUtils.setAttribute((Element)AbstractAddAttributeAction.this.getElement(), (String)namespace, (String)localName, (String)value, (String)prefix);
                } else {
                    DomUtils.setAttribute((Element)AbstractAddAttributeAction.this.getElement(), (String)namespace, (String)localName, (String)value);
                }
            }
        }.run((AbstractModel)this.getContext().getModel());
    }

    protected final XmlContext getContext() {
        return this._context;
    }

    protected final XmlKey getKey() {
        return this._key;
    }

    protected final Element getElement() {
        return this._element;
    }
}

