/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.swing.inspector;

import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.font.TextAttribute;
import java.text.AttributedString;
import javax.swing.table.DefaultTableCellRenderer;
import oracle.bali.inspector.PropertyModel;
import oracle.bali.xml.gui.base.inspector.XmlDomPropertyModel;

public class XmlInspectorCellRenderer
extends DefaultTableCellRenderer {
    private boolean _isDeprecated;

    @Override
    public void paintComponent(Graphics g) {
        if (!this.isDeprecated()) {
            super.paintComponent(g);
            return;
        }
        String text = this.getText();
        this.setText("");
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g;
        AttributedString as = new AttributedString(text);
        as.addAttribute(TextAttribute.STRIKETHROUGH, TextAttribute.STRIKETHROUGH_ON, 0, text.length());
        as.addAttribute(TextAttribute.FONT, this.getFont());
        FontMetrics fm = this.getFontMetrics(this.getFont());
        g2d.drawString(as.getIterator(), fm.getMaxAdvance(), fm.getAscent());
    }

    protected void setDeprecatedStatus(int row, PropertyModel pm) {
        Object deprecated = XmlInspectorCellRenderer._getValue(pm, row, XmlDomPropertyModel.COLUMN_IS_DEPRECATED);
        this.setDeprecated(Boolean.TRUE.equals(deprecated));
    }

    protected void setToolTip(int row, PropertyModel pm) {
        Object text = XmlInspectorCellRenderer._getValue(pm, row, XmlDomPropertyModel.COLUMN_TOOLTIP);
        if (text instanceof String && !"".equals(text)) {
            this.setToolTipText((String)text);
        } else {
            this.setToolTipText(null);
        }
    }

    private static Object _getValue(PropertyModel pm, int row, Object columnID) {
        if (pm == null) {
            return null;
        }
        int columnIndex = pm.getColumnIndex(columnID);
        if (columnIndex == -1) {
            return null;
        }
        return pm.getValueAt(row, columnIndex);
    }

    private boolean isDeprecated() {
        return this._isDeprecated;
    }

    private void setDeprecated(boolean isDeprecated) {
        this._isDeprecated = isDeprecated;
    }
}

