/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.swing.inspector;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.ListSelectionModel;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import oracle.bali.inspector.PropertyInspector;
import oracle.bali.inspector.PropertyModel;
import oracle.bali.xml.gui.base.inspector.XmlDomPropertyModel;
import oracle.bali.xml.gui.swing.inspector.SwingInspectorGui;
import oracle.bali.xml.model.AbstractModel;
import oracle.bali.xml.model.XmlView;
import oracle.bali.xml.model.task.FixedNameTransactionTask;
import oracle.bali.xml.share.FastMessageFormat;

class ResetAction
extends AbstractAction
implements ListSelectionListener,
PropertyChangeListener,
TableModelListener,
AncestorListener {
    private boolean _attached = false;
    private final PropertyInspector _inspector;
    private final SwingInspectorGui _gui;
    private final JButton _button;
    private static final String _BUTTON_PROPERTY = ResetAction.class.getName() + " button";

    public static Component getResetButton(PropertyInspector inspector) {
        return (Component)inspector.getClientProperty((Object)_BUTTON_PROPERTY);
    }

    public static JButton createResetButton(PropertyInspector pi, SwingInspectorGui gui) {
        JButton button = gui.createResetButton();
        ResetAction action = new ResetAction(button, pi, gui);
        button.setAction(action);
        button.addAncestorListener(action);
        return button;
    }

    private ResetAction(JButton button, PropertyInspector pi, SwingInspectorGui gui) {
        this._button = button;
        this._gui = gui;
        this._inspector = pi;
        this.setEnabled(false);
        this.putValue("SmallIcon", this._gui.getResetToolbarIcon());
        this.putValue("ShortDescription", this.getTranslatedString("INSPECTOR.RESET_ACTION"));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        final PropertyInspector inspector = this._inspector;
        if (inspector != null) {
            final PropertyModel propModel = inspector.getPropertyModel();
            final int row = inspector.getPropertyTable().getSelectionModel().getLeadSelectionIndex();
            if (row < 0 || row >= propModel.getRowCount()) {
                return;
            }
            XmlView view = this._gui.getView();
            String attrDisplayName = (String)propModel.getData(PropertyModel.COLUMN_DISPLAY_NAME, row);
            String formatText = this.getTranslatedString("INSPECTOR.SET_TO_DEFAULT_FORMAT");
            String transactionText = FastMessageFormat.formatMessage((String)formatText, (String)attrDisplayName);
            new FixedNameTransactionTask(transactionText){

                protected void performTask(AbstractModel model) {
                    if (inspector.getPropertyTable().getCellEditor() != null) {
                        inspector.getPropertyTable().getCellEditor().cancelCellEditing();
                    }
                    propModel.setValueAt((Object)Boolean.FALSE, row, propModel.getColumnIndex(XmlDomPropertyModel.COLUMN_IS_SET));
                }
            }.run((AbstractModel)view);
            this._updateEnabledState(inspector);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        PropertyInspector inspector = this._inspector;
        if (inspector != null) {
            this._updateEnabledState(inspector);
        }
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        PropertyInspector inspector = this._inspector;
        if (inspector != null) {
            this._updateEnabledState(inspector);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent pe) {
        String name = pe.getPropertyName();
        if ("selectionModel".equals(name)) {
            ListSelectionModel newModel;
            ListSelectionModel old = (ListSelectionModel)pe.getOldValue();
            if (old != null) {
                old.removeListSelectionListener(this);
            }
            if (this._inspector != null && (newModel = (ListSelectionModel)pe.getNewValue()) != null) {
                newModel.addListSelectionListener(this);
            }
        } else if ("model".equals(name)) {
            TableModel newModel;
            TableModel old = (TableModel)pe.getOldValue();
            if (old != null) {
                old.removeTableModelListener(this);
            }
            if (this._inspector != null && (newModel = (TableModel)pe.getNewValue()) != null) {
                newModel.addTableModelListener(this);
            }
        } else if (("categorized".equals(name) || "intersection".equals(name)) && this._inspector != null) {
            this._updateEnabledState(this._inspector);
        }
    }

    @Override
    public void ancestorAdded(AncestorEvent event) {
        this._attachListeners();
    }

    @Override
    public void ancestorMoved(AncestorEvent event) {
    }

    @Override
    public void ancestorRemoved(AncestorEvent event) {
        this._detachListeners();
    }

    private synchronized void _attachListeners() {
        if (!this._attached) {
            this._attached = true;
            this._inspector.putClientProperty((Object)_BUTTON_PROPERTY, (Object)this._button);
            this._inspector.addPropertyChangeListener((PropertyChangeListener)this);
            this._inspector.getPropertyTable().addPropertyChangeListener(this);
            this._inspector.getPropertyTable().getModel().addTableModelListener(this);
            this._inspector.getPropertyTable().getSelectionModel().addListSelectionListener(this);
        }
        this._updateEnabledState(this._inspector);
    }

    private synchronized void _detachListeners() {
        if (this._attached) {
            this._inspector.putClientProperty((Object)_BUTTON_PROPERTY, null);
            this._inspector.removePropertyChangeListener((PropertyChangeListener)this);
            this._inspector.getPropertyTable().removePropertyChangeListener(this);
            this._inspector.getPropertyTable().getModel().removeTableModelListener(this);
            this._inspector.getPropertyTable().getSelectionModel().removeListSelectionListener(this);
            this._attached = false;
        }
    }

    private void _updateEnabledState(PropertyInspector inspector) {
        ListSelectionModel selection = inspector.getPropertyTable().getSelectionModel();
        boolean multi = selection.getLeadSelectionIndex() != selection.getAnchorSelectionIndex();
        PropertyModel model = inspector.getPropertyModel();
        int row = selection.getLeadSelectionIndex();
        boolean enabled = false;
        if (!multi && row >= 0 && row < model.getRowCount()) {
            boolean required = Boolean.TRUE.equals(model.getData(XmlDomPropertyModel.COLUMN_IS_REQUIRED, row));
            Object isSet = model.getData(XmlDomPropertyModel.COLUMN_IS_SET, row);
            enabled = Boolean.TRUE.equals(isSet) && !required && model.getBooleanData(XmlDomPropertyModel.COLUMN_IS_WRITABLE, row) && model.isCellEditable(row, model.getColumnIndex(XmlDomPropertyModel.COLUMN_VALUE));
        }
        this.setEnabled(enabled);
    }

    private String getTranslatedString(String key) {
        return this._gui.getTranslatedString(key);
    }
}

