/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.swing.explorer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.InputEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.event.MouseInputListener;
import oracle.bali.xml.dom.position.DomPosition;
import oracle.bali.xml.dom.position.DomPositionFactory;
import oracle.bali.xml.dom.traversal.TreeTraversal;
import oracle.bali.xml.gui.GuiUtils;
import oracle.bali.xml.gui.XmlGui;
import oracle.bali.xml.gui.swing.explorer.SwingExplorerGui;
import oracle.bali.xml.gui.swing.explorer.SwingTreeListDragHandler;
import oracle.bali.xml.gui.swing.util.PointToModelFinder;
import oracle.bali.xml.model.AbstractModel;
import oracle.bali.xml.model.Selection;
import oracle.bali.xml.model.XmlMetadataResolver;
import oracle.bali.xml.model.XmlView;
import oracle.bali.xml.model.task.NonDomMutationTransactionTask;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public abstract class SwingTreeListHelper<GuiType extends XmlGui, ComponentType extends JComponent> {
    private static final int[] _ARROW_X = new int[]{-5, 0, 5};
    private static final int[] _BEFORE_ARROW_Y = new int[]{2, -3, 3};
    private static final int[] _AFTER_ARROW_Y = new int[]{-2, 3, -2};
    private GuiType _gui;
    private PMF _pmf = new PMF();
    private KeyListener _enterKeyListener = new EnterKeyListener();
    private boolean _ignoreXmlCursorChange;

    protected SwingTreeListHelper(GuiType gui) {
        this._gui = gui;
    }

    public final GuiType getGui() {
        return this._gui;
    }

    public void paintCursorOrDropPosition(ComponentType component, Graphics g) {
        Selection selection = this.getGui().getView().getSelection();
        DomPosition dropPos = selection.getDropLocation();
        if (dropPos != null) {
            this._drawInsertionCursor(component, g, selection.getDropLocation(), Color.black, true);
        } else {
            this._drawInsertionCursor(component, g, selection.getCursorLocation(), UIManager.getColor("textHighlight"), false);
        }
    }

    public Rectangle getDamagePositionBounds(ComponentType component, DomPosition position) {
        Rectangle bounds = null;
        if (position != null && (bounds = this._getInsertionPositionBounds(component, position)) != null) {
            if (bounds.height == 0) {
                bounds.y -= 3;
                bounds.height += 5;
            }
            ++bounds.width;
            ++bounds.height;
        }
        return bounds;
    }

    public PointToModelFinder<ComponentType> getPointToModelFinder() {
        return this._pmf;
    }

    public final void processMouseMotionEvent(ComponentType component, MouseEvent e) {
        this._handleMouse(component, e);
    }

    public final void processMouseEvent(ComponentType component, MouseEvent e) {
        if (((Component)component).isEnabled() && e.getID() == 501 && SwingUtilities.isRightMouseButton(e)) {
            if (this.getGui() instanceof SwingExplorerGui) {
                ((SwingExplorerGui)this.getGui()).setDisableAutoscroll(true);
            }
            new NonDomMutationTransactionTask((JComponent)component, e){
                final /* synthetic */ JComponent val$component;
                final /* synthetic */ MouseEvent val$e;
                {
                    this.val$component = jComponent;
                    this.val$e = mouseEvent;
                }

                protected void performTask(AbstractModel model) {
                    Node clickedNode = SwingTreeListHelper.this.getNodeAt(this.val$component, this.val$e.getX(), this.val$e.getY());
                    if (clickedNode != null) {
                        if (!model.getSelection().contains(clickedNode)) {
                            model.getSelection().set(clickedNode);
                        }
                        SwingTreeListHelper.this._setXmlCursor(this.val$component, this.val$e, clickedNode);
                    }
                }
            }.run((AbstractModel)this.getGui().getView());
            if (this.getGui() instanceof SwingExplorerGui) {
                ((SwingExplorerGui)this.getGui()).setDisableAutoscroll(false);
            }
        }
        if (SwingUtilities.isLeftMouseButton(e) && e.getID() == 500 && e.getClickCount() == 1) {
            Node node = this.getNodeAt(component, e.getX(), e.getY());
            if (this.getGui() instanceof SwingExplorerGui) {
                ((SwingExplorerGui)this.getGui()).setDisableAutoscroll(true);
            }
            this._setXmlCursor(component, e, node);
            if (this.getGui() instanceof SwingExplorerGui) {
                ((SwingExplorerGui)this.getGui()).setDisableAutoscroll(false);
            }
        }
        this._handleMouse(component, e);
    }

    public void handleLeadSelectionRowChanged(ComponentType component, int leadSelectionRow) {
        Node cursorNode = this.getNodeForRow(component, leadSelectionRow);
        DomPosition cursor = cursorNode == null ? null : DomPositionFactory.createInsideOrAfterPosition((Node)cursorNode);
        ((SwingExplorerGui)this.getGui()).setDisableAutoscroll(true);
        this._setXmlCursor(cursor);
        ((SwingExplorerGui)this.getGui()).setDisableAutoscroll(false);
    }

    public void attachMouseAndKeyboardSupport(ComponentType component) {
        ToolTipManager.sharedInstance().registerComponent((JComponent)component);
        ((Component)component).addMouseListener(new ExtraMouseListener());
        KeyStroke enterStroke = KeyStroke.getKeyStroke(10, 0);
        ((JComponent)component).getInputMap().remove(enterStroke);
        ((Component)component).addKeyListener(this._enterKeyListener);
    }

    public void dispose() {
        this._gui = null;
        this._pmf = null;
        this._enterKeyListener = null;
    }

    public void disposeComponent(ComponentType component) {
        ((JComponent)component).getActionMap().clear();
        ((Component)component).removeKeyListener(this._enterKeyListener);
        ToolTipManager.sharedInstance().unregisterComponent((JComponent)component);
        ((JComponent)component).putClientProperty(SwingTreeListDragHandler.class, null);
    }

    DomPosition __getNearestSiblingPosition(ComponentType component, Node nearNode, int y) {
        Rectangle nodeBounds = this.getBoundsIfVisible(component, nearNode);
        if (nodeBounds == null) {
            return null;
        }
        if (nearNode.getNodeType() == 9) {
            return null;
        }
        int middleY = nodeBounds.y + nodeBounds.height / 2;
        if (y < middleY) {
            return DomPositionFactory.before((Node)nearNode);
        }
        return DomPositionFactory.after((Node)nearNode);
    }

    protected abstract int getRowAt(ComponentType var1, int var2, int var3);

    protected abstract Node getNodeAt(ComponentType var1, int var2, int var3);

    protected abstract int getRowIfVisible(ComponentType var1, Node var2);

    protected abstract Rectangle getBoundsIfVisible(ComponentType var1, int var2);

    protected abstract int getRowCount(ComponentType var1);

    protected abstract Node getNodeForRow(ComponentType var1, int var2);

    protected abstract void regularProcessMouseEvent(MouseEvent var1);

    protected abstract void regularProcessMouseMotionEvent(MouseEvent var1);

    protected abstract boolean invokeDefaultAction(InputEvent var1, int var2);

    protected abstract void showPopupMenu(MouseEvent var1, int var2);

    protected abstract int getLeadSelectionRow(ComponentType var1);

    protected boolean allowAfterPosition(ComponentType component, int x, int y) {
        return true;
    }

    protected final Rectangle getBoundsIfVisible(ComponentType component, Node node) {
        int row = this.getRowIfVisible(component, node);
        if (row >= 0) {
            return this.getBoundsIfVisible(component, row);
        }
        return null;
    }

    private Rectangle _getInsertionPositionBounds(ComponentType component, DomPosition position) {
        Node targetNode = position.getTargetNode();
        int targetRow = this.getRowIfVisible(component, targetNode);
        if (targetRow < 0) {
            return null;
        }
        Rectangle boundsRect = this.getBoundsIfVisible(component, targetRow);
        if (boundsRect == null) {
            return null;
        }
        if (!position.isInside()) {
            targetRow = position.isBefore() ? --targetRow : ++targetRow;
            Rectangle otherBounds = this.getBoundsIfVisible(component, targetRow);
            if (position.isBefore()) {
                if (otherBounds != null) {
                    boundsRect.y -= (boundsRect.y - (otherBounds.y + otherBounds.height)) / 2;
                }
            } else {
                boundsRect.y += boundsRect.height;
                if (otherBounds != null) {
                    boundsRect.y += (otherBounds.y - boundsRect.y) / 2;
                }
            }
            boundsRect.height = 0;
        }
        return boundsRect;
    }

    private void _drawInsertionCursor(ComponentType component, Graphics g, DomPosition cursorLocation, Color cursorColor, boolean isBoxOK) {
        if (cursorLocation == null) {
            return;
        }
        Rectangle cursorBounds = this._getInsertionPositionBounds(component, cursorLocation);
        if (cursorBounds != null) {
            int boundsHeight = cursorBounds.height;
            if (boundsHeight != 0 && !isBoxOK) {
                return;
            }
            Color savedColor = g.getColor();
            g.setColor(cursorColor);
            if (boundsHeight != 0) {
                g.drawRect(cursorBounds.x, cursorBounds.y, cursorBounds.width, boundsHeight);
            } else {
                g.drawLine(cursorBounds.x, cursorBounds.y, cursorBounds.x + cursorBounds.width, cursorBounds.y);
            }
            XmlView view = this.getGui().getView();
            boolean noArrows = GuiUtils.visiblePositionEquivalentToModelPosition((XmlView)view, (TreeTraversal)view.getTreeTraversal(), (DomPosition)cursorLocation);
            if (boundsHeight == 0 && !noArrows) {
                int[] yCoords;
                int cursorPosition = cursorLocation.getRelativePosition();
                Object object = cursorPosition == 1 ? _BEFORE_ARROW_Y : (yCoords = (Object)(cursorPosition == 2 ? _AFTER_ARROW_Y : null));
                if (yCoords != null) {
                    int transX = cursorBounds.x + cursorBounds.width / 2;
                    g.translate(transX, cursorBounds.y);
                    g.fillPolygon(_ARROW_X, yCoords, 3);
                    g.translate(-transX, -cursorBounds.y);
                }
            }
            g.setColor(savedColor);
        }
    }

    private void _handleMouse(ComponentType component, MouseEvent e) {
        MouseInputListener l = this._dragListener(component);
        if (l == null) {
            return;
        }
        switch (e.getID()) {
            case 506: {
                l.mouseDragged(e);
                break;
            }
            case 501: {
                l.mousePressed(e);
                break;
            }
            case 502: {
                l.mouseReleased(e);
                break;
            }
            case 503: {
                l.mouseMoved(e);
                break;
            }
            case 500: {
                l.mouseClicked(e);
                break;
            }
            case 505: {
                l.mouseExited(e);
                break;
            }
            case 504: {
                l.mouseEntered(e);
            }
        }
    }

    private MouseInputListener _dragListener(ComponentType component) {
        SwingTreeListDragHandler<ComponentType> dragHandler = (SwingTreeListDragHandler<ComponentType>)((JComponent)component).getClientProperty(SwingTreeListDragHandler.class);
        if (dragHandler == null) {
            dragHandler = new SwingTreeListDragHandler<ComponentType>(this, component);
            dragHandler.setDelegatee(new MouseDelegate());
            ((JComponent)component).putClientProperty(SwingTreeListDragHandler.class, dragHandler);
        }
        return dragHandler.getMouseInputListener();
    }

    private boolean _invokeCustomizer(InputEvent e, int row) {
        Action action;
        Node node = this.getNodeForRow((JComponent)e.getComponent(), row);
        if (node != null && (action = this.getGui().getAction("customizeNode")) != null && action.isEnabled()) {
            ActionEvent ae = new ActionEvent(node, 1001, "customizeNode", e.getWhen(), e.getModifiers());
            action.actionPerformed(ae);
            return true;
        }
        return false;
    }

    private void _setXmlCursor(ComponentType component, MouseEvent e, Node node) {
        if (node != null) {
            DomPosition pos = this.getPointToModelFinder().getClosestPosition(component, node, e.getX(), e.getY());
            this._setXmlCursor(pos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _setXmlCursor(final DomPosition position) {
        XmlView view = this.getGui().getView();
        view.acquireReadLock();
        try {
            if (view.getDocument() == null) {
                return;
            }
        }
        finally {
            view.releaseReadLock();
        }
        this._ignoreXmlCursorChange = true;
        try {
            new NonDomMutationTransactionTask(){

                protected void performTask(AbstractModel model) {
                    model.getSelection().setCursorLocation(position);
                }
            }.run((AbstractModel)view);
        }
        finally {
            this._ignoreXmlCursorChange = false;
        }
    }

    private boolean _invokeDefaultAction(InputEvent e, int clickedRow) {
        boolean done = this.invokeDefaultAction(e, clickedRow);
        if (!done) {
            done = this._invokeCustomizer(e, clickedRow);
        }
        return done;
    }

    private class PMF
    implements PointToModelFinder<ComponentType> {
        private PMF() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Node getNodeAt(ComponentType component, int x, int y) {
            Node node = SwingTreeListHelper.this.getNodeAt(component, x, y);
            if (node == null) {
                XmlView view = SwingTreeListHelper.this.getGui().getView();
                view.acquireReadLock();
                try {
                    node = view.getDocument();
                }
                finally {
                    view.releaseReadLock();
                }
            }
            return node;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public DomPosition getClosestPosition(ComponentType component, Node nearNode, int x, int y) {
            XmlView view = SwingTreeListHelper.this.getGui().getView();
            XmlMetadataResolver viewResolver = view.getXmlMetadataResolver();
            view.acquireReadLock();
            try {
                DomPosition pos;
                if (nearNode == null) {
                    Document doc = view.getDocument();
                    if (doc != null) {
                        DomPosition domPosition = DomPositionFactory.inside((Node)doc);
                        return domPosition;
                    }
                    DomPosition domPosition = null;
                    return domPosition;
                }
                if (viewResolver.allowsChildren(nearNode) && viewResolver.canAddChild(DomPositionFactory.inside((Node)nearNode))) {
                    int relPos = 0;
                    Rectangle cellBounds = SwingTreeListHelper.this.getBoundsIfVisible(component, nearNode);
                    if (cellBounds != null) {
                        int betweenSize = cellBounds.height / 2;
                        cellBounds.y += betweenSize / 2;
                        cellBounds.height -= betweenSize;
                        if (!cellBounds.contains(x, y)) {
                            if (y < cellBounds.y) {
                                relPos = 1;
                            } else if (SwingTreeListHelper.this.allowAfterPosition(component, x, y)) {
                                relPos = 2;
                            }
                        }
                    }
                    pos = relPos == 0 ? DomPositionFactory.createInsideOrAfterPosition((Node)nearNode) : DomPositionFactory.createDomPosition((Node)nearNode, (int)relPos);
                } else {
                    pos = SwingTreeListHelper.this.__getNearestSiblingPosition(component, nearNode, y);
                }
                DomPosition domPosition = view.convertInsertionPosition(pos);
                return domPosition;
            }
            finally {
                view.releaseReadLock();
            }
        }
    }

    private class EnterKeyListener
    extends KeyAdapter {
        private EnterKeyListener() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            boolean consume;
            JComponent component = (JComponent)e.getComponent();
            if (e.getKeyCode() == 10 && (consume = SwingTreeListHelper.this._invokeDefaultAction(e, SwingTreeListHelper.this.getLeadSelectionRow(component)))) {
                e.consume();
            }
        }
    }

    private class ExtraMouseListener
    extends MouseAdapter {
        private ExtraMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this._considerPopup(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this._considerPopup(e);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            int clickedRow;
            boolean done;
            if (SwingUtilities.isLeftMouseButton(e) && e.getClickCount() == 2 && !e.isConsumed() && (done = SwingTreeListHelper.this._invokeDefaultAction(e, clickedRow = SwingTreeListHelper.this.getRowAt((JComponent)e.getComponent(), e.getX(), e.getY())))) {
                e.consume();
            }
        }

        private void _considerPopup(MouseEvent e) {
            if (e.isPopupTrigger() && !e.isConsumed()) {
                int clickedRow = SwingTreeListHelper.this.getRowAt((JComponent)e.getComponent(), e.getX(), e.getY());
                SwingTreeListHelper.this.showPopupMenu(e, clickedRow);
            }
        }
    }

    private class MouseDelegate
    implements MouseInputListener {
        private MouseDelegate() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            SwingTreeListHelper.this.regularProcessMouseEvent(e);
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            SwingTreeListHelper.this.regularProcessMouseEvent(e);
        }

        @Override
        public void mouseExited(MouseEvent e) {
            SwingTreeListHelper.this.regularProcessMouseEvent(e);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            SwingTreeListHelper.this.regularProcessMouseEvent(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            SwingTreeListHelper.this.regularProcessMouseEvent(e);
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            SwingTreeListHelper.this.regularProcessMouseMotionEvent(e);
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            SwingTreeListHelper.this.regularProcessMouseMotionEvent(e);
        }
    }
}

