/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.editor.parser;

import java.util.ArrayList;
import java.util.Collection;
import oracle.bali.xml.editor.parser.AttributeNode;
import oracle.bali.xml.editor.parser.NamespaceDeclaration;

public class DocumentNode {
    private AttributeNode[] _attributes;
    private String _elementName = null;
    private String _elementNamespacePrefix = null;
    private ArrayList _namespaceDecls = null;
    private int _startOffset = 0;
    private int _endOffset = 0;
    private int _tagType = -1;
    private boolean _isIncomplete = false;
    private boolean _isEmpty = false;
    public static final int NODE_TYPE_UNKNOWN = -1;
    public static final int NODE_TYPE_ELEMENT_START = 11;
    public static final int NODE_TYPE_ELEMENT_END = 12;
    public static final int NODE_TYPE_ELEMENT_EMPTY = 13;
    public static final DocumentNode UNKNOWN = new DocumentNode("DOCUMENT_NODE_UNKNOWN", 0, 0);

    public DocumentNode(String namespacePrefix, String elementName, int startOffset, int endOffset) {
        this._elementName = elementName;
        this._elementNamespacePrefix = namespacePrefix;
        this._namespaceDecls = new ArrayList();
        this._startOffset = startOffset;
        this._endOffset = endOffset;
    }

    public DocumentNode(String elementName, int startOffset, int endOffset) {
        this._elementName = elementName;
        this._elementNamespacePrefix = null;
        this._namespaceDecls = new ArrayList();
        this._startOffset = startOffset;
        this._endOffset = endOffset;
    }

    public String getNamespacePrefix() {
        return this._elementNamespacePrefix;
    }

    public String getElementName() {
        return this._elementName;
    }

    public int getStartOffset() {
        return this._startOffset;
    }

    public int getEndOffset() {
        return this._endOffset;
    }

    public void setStartOffset(int startOffset) {
        this._startOffset = startOffset;
    }

    public void setEndOffset(int endOffset) {
        this._endOffset = endOffset;
    }

    public void setTagType(int type) {
        this._tagType = type;
    }

    public int getTagType() {
        return this._tagType;
    }

    public boolean isIncomplete() {
        return this._isIncomplete;
    }

    public void setIncomplete(boolean incomplete) {
        this._isIncomplete = incomplete;
    }

    public boolean isEmpty() {
        return this._isEmpty;
    }

    public void setEmpty(boolean empty) {
        this._isEmpty = empty;
    }

    public ArrayList getLocalNamespaceDecls() {
        return this._namespaceDecls;
    }

    public void addNamespaceDecl(NamespaceDeclaration aDecl) {
        this._namespaceDecls.add(aDecl);
    }

    public void addNamespaceDecls(Collection declarations) {
        this._namespaceDecls.addAll(declarations);
    }

    public void setAttributes(AttributeNode[] nodes) {
        this._attributes = nodes;
    }

    public AttributeNode[] getAttributes() {
        return this._attributes;
    }

    public boolean hasAttributes() {
        return this._attributes != null && this._attributes.length != 0;
    }

    public String toString() {
        String theString = "DocumentNode:  " + this._elementName + "\n";
        theString = theString + "Prefix:  " + this._elementNamespacePrefix + "\n";
        for (int i = 0; i < this._namespaceDecls.size(); ++i) {
            NamespaceDeclaration aDecl = (NamespaceDeclaration)this._namespaceDecls.get(i);
            theString = theString + aDecl.getNamespace() + " " + aDecl.getPrefix() + "\n";
        }
        return theString;
    }
}

